/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.WebBrowserXmlService;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserAction;
import com.intellij.ide.browsers.actions.OpenFileInDefaultBrowserAction;
import com.intellij.ide.browsers.actions.OpenHtmlInEmbeddedBrowserAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ComputableActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.ui.jcef.JBCefApp;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class OpenInBrowserBaseGroupAction
extends ComputableActionGroup {
    private OpenFileInDefaultBrowserAction myDefaultBrowserAction;

    protected OpenInBrowserBaseGroupAction(boolean popup2) {
        super(popup2);
        Presentation p = this.getTemplatePresentation();
        p.setText(IdeBundle.message((String)"open.in.browser", (Object[])new Object[0]));
        p.setDescription(IdeBundle.message((String)"open.selected.file.in.browser", (Object[])new Object[0]));
        p.setIcon(AllIcons.Nodes.PpWeb);
    }

    @Override
    @NotNull
    protected final CachedValueProvider<AnAction[]> createChildrenProvider(@NotNull ActionManager actionManager) {
        if (actionManager == null) {
            OpenInBrowserBaseGroupAction.$$$reportNull$$$0(0);
        }
        CachedValueProvider cachedValueProvider = () -> {
            List<WebBrowser> browsers = WebBrowserManager.getInstance().getBrowsers();
            boolean addDefaultBrowser = this.isPopup();
            boolean hasLocalBrowser = OpenInBrowserBaseGroupAction.hasLocalBrowser();
            int offset = 0;
            if (addDefaultBrowser) {
                ++offset;
            }
            if (hasLocalBrowser) {
                ++offset;
            }
            AnAction[] actions2 = new AnAction[browsers.size() + offset];
            if (hasLocalBrowser) {
                actions2[0] = new OpenHtmlInEmbeddedBrowserAction();
            }
            if (addDefaultBrowser) {
                if (this.myDefaultBrowserAction == null) {
                    this.myDefaultBrowserAction = new OpenFileInDefaultBrowserAction();
                    this.myDefaultBrowserAction.getTemplatePresentation().setText(IdeBundle.message((String)"default", (Object[])new Object[0]));
                    this.myDefaultBrowserAction.getTemplatePresentation().setIcon(AllIcons.Nodes.PpWeb);
                }
                actions2[hasLocalBrowser ? 1 : 0] = this.myDefaultBrowserAction;
            }
            int size = browsers.size();
            for (int i2 = 0; i2 < size; ++i2) {
                actions2[i2 + offset] = new BaseOpenInBrowserAction(browsers.get(i2));
            }
            return CachedValueProvider.Result.create((Object)actions2, (Object[])new Object[]{WebBrowserManager.getInstance()});
        };
        if (cachedValueProvider == null) {
            OpenInBrowserBaseGroupAction.$$$reportNull$$$0(1);
        }
        return cachedValueProvider;
    }

    private static boolean hasLocalBrowser() {
        return JBCefApp.isSupported() && Registry.is((String)"ide.web.preview.enabled");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/browsers/actions/OpenInBrowserBaseGroupAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/browsers/actions/OpenInBrowserBaseGroupAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildrenProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createChildrenProvider";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class OpenInBrowserEditorContextBarGroupAction
    extends OpenInBrowserBaseGroupAction {
        public OpenInBrowserEditorContextBarGroupAction() {
            super(false);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenInBrowserEditorContextBarGroupAction.$$$reportNull$$$0(0);
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            WebBrowserManager browserManager = WebBrowserManager.getInstance();
            PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            boolean needShowOnHover = psiFile != null && WebBrowserXmlService.getInstance().isXmlLanguage(psiFile.getViewProvider().getBaseLanguage()) ? browserManager.isShowBrowserHoverXml() : browserManager.isShowBrowserHover();
            e.getPresentation().setVisible(needShowOnHover && (!browserManager.getActiveBrowsers().isEmpty() || OpenInBrowserBaseGroupAction.hasLocalBrowser()) && editor != null && !DiffUtil.isDiffEditor(editor));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/browsers/actions/OpenInBrowserBaseGroupAction$OpenInBrowserEditorContextBarGroupAction", "update"));
        }
    }

    public static final class OpenInBrowserGroupAction
    extends OpenInBrowserBaseGroupAction {
        public OpenInBrowserGroupAction() {
            super(true);
        }
    }
}

