/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actionsOnSave.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class ActionsOnSaveFileDocumentManagerListener
implements FileDocumentManagerListener {
    private static final ExtensionPointName<ActionOnSave> EP_NAME = new ExtensionPointName("com.intellij.actionOnSave");
    private final Set<Document> myDocumentsToProcess = new HashSet<Document>();

    public void beforeAllDocumentsSaving() {
        Document[] documents = FileDocumentManager.getInstance().getUnsavedDocuments();
        if (documents.length == 0) {
            return;
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            for (ActionOnSave saveAction : EP_NAME.getExtensionList()) {
                if (!saveAction.isEnabledForProject(project)) continue;
                this.scheduleDocumentsProcessing(documents);
                return;
            }
        }
    }

    private void scheduleDocumentsProcessing(Document[] documents) {
        boolean processingAlreadyScheduled = !this.myDocumentsToProcess.isEmpty();
        this.myDocumentsToProcess.addAll(Arrays.asList(documents));
        if (!processingAlreadyScheduled) {
            ApplicationManager.getApplication().invokeLater(() -> this.processSavedDocuments(), ModalityState.NON_MODAL);
        }
    }

    private void processSavedDocuments() {
        Object[] documents = this.myDocumentsToProcess.toArray(Document.EMPTY_ARRAY);
        this.myDocumentsToProcess.clear();
        if (ModalityState.current() != ModalityState.NON_MODAL) {
            return;
        }
        FileDocumentManager manager2 = FileDocumentManager.getInstance();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            ProjectFileIndex index2 = ProjectFileIndex.getInstance((Project)project);
            List projectDocuments = ContainerUtil.filter((Object[])documents, document -> {
                VirtualFile file2 = manager2.getFile(document);
                return file2 != null && index2.isInContent(file2);
            });
            if (projectDocuments.isEmpty()) continue;
            for (ActionOnSave saveAction : EP_NAME.getExtensionList()) {
                if (!saveAction.isEnabledForProject(project)) continue;
                saveAction.processDocuments(project, projectDocuments.toArray(Document.EMPTY_ARRAY));
            }
        }
        for (Project project : documents) {
            manager2.saveDocument((Document)project);
        }
    }

    public static abstract class ActionOnSave {
        public boolean isEnabledForProject(@NotNull Project project) {
            if (project == null) {
                ActionOnSave.$$$reportNull$$$0(0);
            }
            return false;
        }

        public void processDocuments(@NotNull Project project, @NotNull @NotNull Document @NotNull [] documents) {
            if (project == null) {
                ActionOnSave.$$$reportNull$$$0(1);
            }
            if (documents == null) {
                ActionOnSave.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "documents";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actionsOnSave/impl/ActionsOnSaveFileDocumentManagerListener$ActionOnSave";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForProject";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processDocuments";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

