/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.google.common.collect.Lists;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.searcheverywhere.AbstractGotoSEContributor;
import com.intellij.ide.actions.searcheverywhere.CheckBoxSearchEverywhereToggleAction;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.ScopeSupporting;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFiltersAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFiltersStatisticsCollector;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManagerImpl;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereTabDescriptor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereToggleAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereUI;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchEverywhereUsageTriggerCollector;
import com.intellij.ide.util.gotoByName.SearchEverywhereConfiguration;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchEverywhereHeader {
    @NotNull
    private final Runnable myScopeChangedCallback;
    private final Function<? super String, String> myShortcutSupplier;
    private final List<SETab> myTabs;
    private SETab mySelectedTab;
    @Nullable
    private final Project myProject;
    @NotNull
    private final JPanel myTabsPanel;
    @NotNull
    private final JPanel myToolbarPanel;
    @NotNull
    private final ActionToolbar myToolbar;
    private boolean myEverywhereAutoSet;

    public SearchEverywhereHeader(@Nullable Project project, Map<SearchEverywhereContributor<?>, SearchEverywhereTabDescriptor> contributors, @NotNull Runnable scopeChangedCallback, Function<? super String, String> shortcutSupplier, @Nullable AnAction showInFindToolWindowAction, SearchEverywhereUI ui2) {
        if (scopeChangedCallback == null) {
            SearchEverywhereHeader.$$$reportNull$$$0(0);
        }
        this.myEverywhereAutoSet = true;
        this.myScopeChangedCallback = scopeChangedCallback;
        this.myProject = project;
        this.myShortcutSupplier = shortcutSupplier;
        this.myTabs = this.createTabs(contributors);
        this.mySelectedTab = this.myTabs.get(0);
        this.myTabsPanel = SearchEverywhereHeader.createTabsPanel(this.myTabs);
        this.myToolbar = this.createToolbar(showInFindToolWindowAction);
        this.myToolbar.setTargetComponent((JComponent)this.myTabsPanel);
        this.myToolbarPanel = (JPanel)this.myToolbar.getComponent();
        MessageBusConnection busConnection = this.myProject != null ? this.myProject.getMessageBus().connect((Disposable)ui2) : ApplicationManager.getApplication().getMessageBus().connect((Disposable)ui2);
        busConnection.subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (action2 == SearchEverywhereHeader.this.mySelectedTab.everywhereAction && event.getInputEvent() != null) {
                    SearchEverywhereHeader.this.myEverywhereAutoSet = false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereHeader$1";
                objectArray[2] = "afterActionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        scopeChangedCallback.run();
    }

    @NotNull
    public JPanel getTabsPanel() {
        JPanel jPanel2 = this.myTabsPanel;
        if (jPanel2 == null) {
            SearchEverywhereHeader.$$$reportNull$$$0(1);
        }
        return jPanel2;
    }

    @NotNull
    public JPanel getToolbarPanel() {
        JPanel jPanel2 = this.myToolbarPanel;
        if (jPanel2 == null) {
            SearchEverywhereHeader.$$$reportNull$$$0(2);
        }
        return jPanel2;
    }

    public void toggleEverywhere() {
        this.myEverywhereAutoSet = false;
        if (this.mySelectedTab.everywhereAction == null) {
            return;
        }
        if (!this.mySelectedTab.everywhereAction.canToggleEverywhere()) {
            return;
        }
        this.mySelectedTab.everywhereAction.setEverywhere(!this.mySelectedTab.everywhereAction.isEverywhere());
        this.myToolbar.updateActionsImmediately();
    }

    @NotNull
    private ActionToolbar createToolbar(@Nullable AnAction showInFindToolWindowAction) {
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        actionGroup2.addAction((AnAction)new ActionGroup(){

            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                if (e == null || SearchEverywhereHeader.this.mySelectedTab == null) {
                    if (EMPTY_ARRAY == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return EMPTY_ARRAY;
                }
                AnAction[] anActionArray = SearchEverywhereHeader.this.mySelectedTab.actions.toArray(EMPTY_ARRAY);
                if (anActionArray == null) {
                    2.$$$reportNull$$$0(1);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereHeader$2", "getChildren"));
            }
        });
        if (showInFindToolWindowAction != null) {
            actionGroup2.addAction(showInFindToolWindowAction);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("search.everywhere.toolbar", (ActionGroup)actionGroup2, true);
        toolbar.setLayoutPolicy(0);
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setOpaque(false);
        toolbarComponent.setBorder((Border)JBUI.Borders.empty((int)2, (int)18, (int)2, (int)9));
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            SearchEverywhereHeader.$$$reportNull$$$0(3);
        }
        return actionToolbar;
    }

    @NotNull
    private static JPanel createTabsPanel(List<? extends SETab> tabs) {
        JPanel contributorsPanel = new JPanel(new FlowLayout(0, 0, 0));
        contributorsPanel.setOpaque(false);
        tabs.forEach(tab -> contributorsPanel.add((Component)tab));
        JPanel jPanel2 = contributorsPanel;
        if (jPanel2 == null) {
            SearchEverywhereHeader.$$$reportNull$$$0(4);
        }
        return jPanel2;
    }

    private List<SETab> createTabs(Map<SearchEverywhereContributor<?>, SearchEverywhereTabDescriptor> contributors) {
        if (Registry.is((String)"search.everywhere.group.contributors.by.type")) {
            return this.createGroupedTabs(contributors);
        }
        ArrayList contributorsList = new ArrayList(contributors.keySet());
        contributorsList.sort(Comparator.comparingInt(SearchEverywhereContributor::getSortWeight));
        return this.createSeparateTabs(contributorsList);
    }

    private List<SETab> createGroupedTabs(Map<SearchEverywhereContributor<?>, SearchEverywhereTabDescriptor> contributors) {
        ArrayList projectContributors = new ArrayList();
        final ArrayList ideContributors = new ArrayList();
        contributors.forEach((contributor, tab) -> {
            if (tab == SearchEverywhereTabDescriptor.PROJECT) {
                projectContributors.add((SearchEverywhereContributor<?>)contributor);
            } else if (tab == SearchEverywhereTabDescriptor.IDE) {
                ideContributors.add(contributor);
            } else {
                throw new IllegalArgumentException("Unsupported tab - " + tab.getId());
            }
        });
        ArrayList<SETab> res2 = new ArrayList<SETab>();
        SearchEverywhereFiltersStatisticsCollector.ContributorFilterCollector filterStatisticsCollector = new SearchEverywhereFiltersStatisticsCollector.ContributorFilterCollector();
        if (this.myProject != null && !projectContributors.isEmpty()) {
            PersistentSearchEverywhereContributorFilter<String> projectContributorsFilter = SearchEverywhereHeader.createContributorsFilter(projectContributors);
            List<AnAction> projectActions = Arrays.asList(new AnAction[]{new MyScopeChooserAction(this.myProject, projectContributors, this.myScopeChangedCallback), new SearchEverywhereFiltersAction<String>(projectContributorsFilter, this.myScopeChangedCallback, filterStatisticsCollector)});
            res2.add(this.createTab(SearchEverywhereTabDescriptor.PROJECT.getId(), IdeBundle.message((String)"searcheverywhere.project.search.tab.name", (Object[])new Object[0]), projectContributors, projectActions, projectContributorsFilter));
        }
        if (!ideContributors.isEmpty()) {
            PersistentSearchEverywhereContributorFilter<String> ideContributorsFilter = SearchEverywhereHeader.createContributorsFilter(ideContributors);
            List<AnAction> ideActions = Arrays.asList(new AnAction[]{new CheckBoxSearchEverywhereToggleAction(IdeBundle.message((String)"checkbox.disabled.included", (Object[])new Object[0])){
                private boolean everywhere;

                public boolean isEverywhere() {
                    return this.everywhere;
                }

                public void setEverywhere(boolean val) {
                    this.everywhere = val;
                    ideContributors.stream().flatMap(contributor -> contributor.getActions(SearchEverywhereHeader.this.myScopeChangedCallback).stream()).filter(action2 -> action2 instanceof SearchEverywhereToggleAction).forEach(action2 -> ((SearchEverywhereToggleAction)action2).setEverywhere(val));
                    SearchEverywhereHeader.this.myScopeChangedCallback.run();
                }
            }, new SearchEverywhereFiltersAction<String>(ideContributorsFilter, this.myScopeChangedCallback, filterStatisticsCollector)});
            res2.add(this.createTab(SearchEverywhereTabDescriptor.IDE.getId(), IdeBundle.message((String)"searcheverywhere.ide.search.tab.name", (Object[])new Object[0]), ideContributors, ideActions, ideContributorsFilter));
        }
        return res2;
    }

    private List<SETab> createSeparateTabs(List<? extends SearchEverywhereContributor<?>> contributors) {
        ArrayList<SETab> res2 = new ArrayList<SETab>();
        if (contributors.size() > 1) {
            final Runnable onChanged = () -> {
                this.myToolbar.updateActionsImmediately();
                this.myScopeChangedCallback.run();
            };
            String actionText = IdeUICustomization.getInstance().projectMessage("checkbox.include.non.project.items", new Object[0]);
            PersistentSearchEverywhereContributorFilter<String> filter = SearchEverywhereHeader.createContributorsFilter(contributors);
            List<AnAction> actions2 = Arrays.asList(new AnAction[]{new CheckBoxSearchEverywhereToggleAction(actionText){
                final SearchEverywhereManagerImpl seManager;
                {
                    super(text2);
                    this.seManager = (SearchEverywhereManagerImpl)SearchEverywhereManager.getInstance(SearchEverywhereHeader.this.myProject);
                }

                public boolean isEverywhere() {
                    return this.seManager.isEverywhere();
                }

                public void setEverywhere(boolean state) {
                    if (this.isEverywhere() == state) {
                        return;
                    }
                    this.seManager.setEverywhere(state);
                    SearchEverywhereHeader.this.myTabs.forEach(tab -> {
                        if (tab.everywhereAction != null) {
                            tab.everywhereAction.setEverywhere(state);
                        }
                    });
                    onChanged.run();
                }
            }, new SearchEverywhereFiltersAction<String>(filter, onChanged, new SearchEverywhereFiltersStatisticsCollector.ContributorFilterCollector())});
            SETab allTab = this.createTab("SearchEverywhereContributor.All", IdeBundle.message((String)"searcheverywhere.allelements.tab.name", (Object[])new Object[0]), contributors, actions2, filter);
            res2.add(allTab);
        }
        contributors.stream().filter(SearchEverywhereContributor::isShownInSeparateTab).forEach(contributor -> {
            SETab tab = this.createTab((SearchEverywhereContributor<?>)contributor, () -> {
                this.myToolbar.updateActionsImmediately();
                this.myScopeChangedCallback.run();
            });
            res2.add(tab);
        });
        return res2;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static PersistentSearchEverywhereContributorFilter<String> createContributorsFilter(List<? extends SearchEverywhereContributor<?>> contributors) {
        @Nls Map namesMap = ContainerUtil.map2Map(contributors, c -> Pair.create((Object)c.getSearchProviderId(), (Object)c.getFullGroupName()));
        return new PersistentSearchEverywhereContributorFilter<String>(ContainerUtil.map(contributors, c -> c.getSearchProviderId()), SearchEverywhereConfiguration.getInstance(), namesMap::get, c -> null);
    }

    public List<SETab> getTabs() {
        return this.myTabs;
    }

    @NotNull
    public SETab getSelectedTab() {
        SETab sETab = this.mySelectedTab;
        if (sETab == null) {
            SearchEverywhereHeader.$$$reportNull$$$0(5);
        }
        return sETab;
    }

    public void switchToTab(SETab tab) {
        if (!this.myTabs.contains(tab)) {
            throw new IllegalArgumentException(String.format("Tab %s is not found in tabs list", tab.toString()));
        }
        this.mySelectedTab.setSelected(false);
        this.mySelectedTab = tab;
        this.mySelectedTab.setSelected(true);
        if (this.myEverywhereAutoSet && this.isEverywhere() && this.canToggleEverywhere()) {
            this.autoSetEverywhere(false);
        }
        if (this.myToolbar != null) {
            this.myToolbar.updateActionsImmediately();
        }
        this.myTabsPanel.repaint();
        this.myScopeChangedCallback.run();
    }

    public void switchToNextTab() {
        int index2 = this.myTabs.indexOf(this.mySelectedTab);
        if (++index2 >= this.myTabs.size()) {
            index2 = 0;
        }
        this.switchToTab(this.myTabs.get(index2));
    }

    public void switchToPrevTab() {
        int index2 = this.myTabs.indexOf(this.mySelectedTab);
        if (--index2 < 0) {
            index2 = this.myTabs.size() - 1;
        }
        this.switchToTab(this.myTabs.get(index2));
    }

    public void autoSetEverywhere(boolean everywhere) {
        if (everywhere == this.isEverywhere()) {
            return;
        }
        this.myEverywhereAutoSet = true;
        if (this.mySelectedTab.everywhereAction == null) {
            return;
        }
        if (!this.mySelectedTab.everywhereAction.canToggleEverywhere()) {
            return;
        }
        this.mySelectedTab.everywhereAction.setEverywhere(everywhere);
        this.myToolbar.updateActionsImmediately();
    }

    public boolean canSetEverywhere() {
        return this.myEverywhereAutoSet && this.canToggleEverywhere();
    }

    public boolean canResetScope() {
        return Boolean.TRUE.equals(ObjectUtils.doIfNotNull((Object)this.mySelectedTab.everywhereAction, action2 -> !action2.isEverywhere()));
    }

    public void resetScope() {
        ObjectUtils.consumeIfNotNull((Object)this.mySelectedTab.everywhereAction, action2 -> action2.setEverywhere(true));
    }

    public boolean isEverywhere() {
        if (this.mySelectedTab.everywhereAction == null) {
            return true;
        }
        return this.mySelectedTab.everywhereAction.isEverywhere();
    }

    private boolean canToggleEverywhere() {
        if (this.mySelectedTab.everywhereAction == null) {
            return false;
        }
        return this.mySelectedTab.everywhereAction.canToggleEverywhere();
    }

    private SETab createTab(@NonNls @NotNull String id2, @NlsContexts.Label @NotNull String name, @NotNull List<? extends SearchEverywhereContributor<?>> contributors, List<AnAction> actions2, @Nullable PersistentSearchEverywhereContributorFilter<String> filter) {
        SETab tab;
        String shortcut;
        if (id2 == null) {
            SearchEverywhereHeader.$$$reportNull$$$0(6);
        }
        if (name == null) {
            SearchEverywhereHeader.$$$reportNull$$$0(7);
        }
        if (contributors == null) {
            SearchEverywhereHeader.$$$reportNull$$$0(8);
        }
        if ((shortcut = this.myShortcutSupplier.apply((tab = new SETab(id2, name, contributors, actions2, filter)).getID())) != null) {
            tab.setToolTipText(shortcut);
        }
        tab.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SearchEverywhereHeader.this.switchToTab(tab);
                SearchEverywhereUsageTriggerCollector.TAB_SWITCHED.log(SearchEverywhereHeader.this.myProject, new EventPair[]{SearchEverywhereUsageTriggerCollector.CONTRIBUTOR_ID_FIELD.with((Object)tab.getReportableID()), EventFields.InputEventByMouseEvent.with((Object)e)});
            }
        });
        return tab;
    }

    private SETab createTab(@NotNull SearchEverywhereContributor<?> contributor, Runnable onChanged) {
        if (contributor == null) {
            SearchEverywhereHeader.$$$reportNull$$$0(9);
        }
        return this.createTab(contributor.getSearchProviderId(), contributor.getGroupName(), Collections.singletonList(contributor), contributor.getActions(onChanged), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeChangedCallback";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereHeader";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributors";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereHeader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTabsPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTab";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyScopeChooserAction
    extends AbstractGotoSEContributor.ScopeChooserAction {
        private ScopeDescriptor myScope;
        private final Collection<SearchEverywhereContributor<?>> myContributors;
        private final Runnable onChange;
        private final GlobalSearchScope myEverywhereScope;
        private final GlobalSearchScope myProjectScope;

        private MyScopeChooserAction(@NotNull Project project, Collection<SearchEverywhereContributor<?>> contributors, Runnable onChange) {
            if (project == null) {
                MyScopeChooserAction.$$$reportNull$$$0(0);
            }
            this.myContributors = contributors;
            this.onChange = onChange;
            this.myEverywhereScope = GlobalSearchScope.everythingScope((Project)project);
            this.myProjectScope = GlobalSearchScope.projectScope((Project)project);
            this.myScope = new ScopeDescriptor((SearchScope)this.myProjectScope);
            this.doSetScope(this.myScope);
        }

        private void doSetScope(@NotNull ScopeDescriptor sd) {
            if (sd == null) {
                MyScopeChooserAction.$$$reportNull$$$0(1);
            }
            this.myScope = sd;
            this.myContributors.stream().filter(c -> c instanceof ScopeSupporting).forEach(c -> ((ScopeSupporting)c).setScope(sd));
        }

        @Override
        void onScopeSelected(@NotNull ScopeDescriptor sd) {
            if (sd == null) {
                MyScopeChooserAction.$$$reportNull$$$0(2);
            }
            this.doSetScope(sd);
            this.onChange.run();
        }

        @Override
        @NotNull
        ScopeDescriptor getSelectedScope() {
            ScopeDescriptor scopeDescriptor = this.myScope;
            if (scopeDescriptor == null) {
                MyScopeChooserAction.$$$reportNull$$$0(3);
            }
            return scopeDescriptor;
        }

        @Override
        void onProjectScopeToggled() {
            this.setEverywhere(!this.myScope.scopeEquals((SearchScope)this.myEverywhereScope));
        }

        @Override
        boolean processScopes(@NotNull Processor<? super ScopeDescriptor> processor2) {
            if (processor2 == null) {
                MyScopeChooserAction.$$$reportNull$$$0(4);
            }
            return ContainerUtil.process(this.extractScopes(), processor2);
        }

        public boolean isEverywhere() {
            return this.myScope.scopeEquals((SearchScope)this.myEverywhereScope);
        }

        public void setEverywhere(boolean everywhere) {
            this.doSetScope(new ScopeDescriptor((SearchScope)(everywhere ? this.myEverywhereScope : this.myProjectScope)));
            this.onChange.run();
        }

        public boolean canToggleEverywhere() {
            return this.myScope.scopeEquals((SearchScope)this.myEverywhereScope) || this.myScope.scopeEquals((SearchScope)this.myProjectScope);
        }

        private List<ScopeDescriptor> extractScopes() {
            BinaryOperator intersection = (descriptors1, descriptors2) -> {
                ArrayList res2 = new ArrayList(descriptors1);
                List scopes = Lists.transform(res2, descriptor2 -> descriptor2.getDisplayName());
                scopes.retainAll(Lists.transform((List)descriptors2, descriptor2 -> descriptor2.getDisplayName()));
                return res2;
            };
            Optional<List> maybeScopes = this.myContributors.stream().filter(c -> c instanceof ScopeSupporting).map(c -> ((ScopeSupporting)c).getSupportedScopes()).reduce(intersection);
            return maybeScopes.orElse(Collections.emptyList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sd";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereHeader$MyScopeChooserAction";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereHeader$MyScopeChooserAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "doSetScope";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "onScopeSelected";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processScopes";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class SETab
    extends JLabel {
        @NotNull
        @NonNls
        private final String id;
        @NotNull
        private final List<SearchEverywhereContributor<?>> contributors;
        private final List<AnAction> actions;
        @Nullable
        private final SearchEverywhereToggleAction everywhereAction;
        @Nullable
        private final PersistentSearchEverywhereContributorFilter<String> myContributorsFilter;
        @Nullable
        private final PersistentSearchEverywhereContributorFilter<?> myFilterToReset;
        private boolean isSelected;

        public SETab(@NonNls @NotNull String id2, @NlsContexts.Label @NotNull String name, @NotNull List<? extends SearchEverywhereContributor<?>> contributors, List<AnAction> actions2, @Nullable PersistentSearchEverywhereContributorFilter<String> filter) {
            if (id2 == null) {
                SETab.$$$reportNull$$$0(0);
            }
            if (name == null) {
                SETab.$$$reportNull$$$0(1);
            }
            if (contributors == null) {
                SETab.$$$reportNull$$$0(2);
            }
            super(name);
            this.isSelected = false;
            this.myContributorsFilter = filter;
            Insets insets = JBUI.CurrentTheme.BigPopup.tabInsets();
            this.setBorder((Border)JBUI.Borders.empty((int)insets.top, (int)insets.left, (int)insets.bottom, (int)insets.right));
            assert (contributors.size() > 0) : "Contributors list cannot be empty";
            this.id = id2;
            this.contributors = new ArrayList(contributors);
            this.actions = actions2;
            this.everywhereAction = (SearchEverywhereToggleAction)ContainerUtil.find(actions2, o -> o instanceof SearchEverywhereToggleAction);
            this.myFilterToReset = actions2.stream().filter(a -> a instanceof SearchEverywhereFiltersAction).findAny().map(a -> ((SearchEverywhereFiltersAction)((Object)a)).getFilter()).orElse(null);
        }

        public void setSelected(boolean selected2) {
            this.isSelected = selected2;
        }

        public String getID() {
            return this.id;
        }

        public String getReportableID() {
            if (!this.isSingleContributor()) {
                return this.getID();
            }
            return SearchEverywhereUsageTriggerCollector.getReportableContributorID(this.contributors.get(0));
        }

        public boolean isSingleContributor() {
            return this.contributors.size() == 1;
        }

        @NotNull
        public List<SearchEverywhereContributor<?>> getContributors() {
            if (this.myContributorsFilter == null) {
                List<SearchEverywhereContributor<?>> list2 = this.contributors;
                if (list2 == null) {
                    SETab.$$$reportNull$$$0(3);
                }
                return list2;
            }
            List list3 = ContainerUtil.filter(this.contributors, contributor -> this.myContributorsFilter.isSelected(contributor.getSearchProviderId()));
            if (list3 == null) {
                SETab.$$$reportNull$$$0(4);
            }
            return list3;
        }

        public boolean canClearFilter() {
            return this.myFilterToReset != null && SETab.canClearFilter(this.myFilterToReset);
        }

        private static <T> boolean canClearFilter(@NotNull PersistentSearchEverywhereContributorFilter<T> filter) {
            if (filter == null) {
                SETab.$$$reportNull$$$0(5);
            }
            return filter.getAllElements().stream().anyMatch(o -> !filter.isSelected(o));
        }

        public void clearFilter() {
            if (this.myFilterToReset != null) {
                SETab.doClearFilter(this.myFilterToReset);
            }
        }

        private static <T> void doClearFilter(@NotNull PersistentSearchEverywhereContributorFilter<T> filter) {
            if (filter == null) {
                SETab.$$$reportNull$$$0(6);
            }
            filter.getAllElements().forEach(s -> filter.setSelected(s, true));
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = JBUIScale.scale((int)29);
            return size;
        }

        @Override
        public boolean isOpaque() {
            return this.isSelected;
        }

        @Override
        public Color getBackground() {
            return this.isSelected ? JBUI.CurrentTheme.BigPopup.selectedTabColor() : super.getBackground();
        }

        @Override
        public Color getForeground() {
            return this.isSelected ? JBUI.CurrentTheme.BigPopup.selectedTabTextColor() : super.getForeground();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributors";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereHeader$SETab";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereHeader$SETab";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContributors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "canClearFilter";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "doClearFilter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

