/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.SearchEverywhereClassifier;
import com.intellij.ide.actions.searcheverywhere.GroupedSearchListModel;
import com.intellij.ide.actions.searcheverywhere.SEResultsListFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereHeader;
import com.intellij.ide.actions.searcheverywhere.SearchListModel;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;

class GroupedListFactory
extends SEResultsListFactory {
    private final GroupTitleRenderer myGroupTitleRenderer = new GroupTitleRenderer();

    GroupedListFactory() {
    }

    @Override
    public SearchListModel createModel() {
        return new GroupedSearchListModel();
    }

    @Override
    public JBList<Object> createList(SearchListModel model2) {
        return new JBList((ListModel)model2);
    }

    @Override
    ListCellRenderer<Object> createListRenderer(SearchListModel model2, final SearchEverywhereHeader header2) {
        final GroupedSearchListModel groupedModel = (GroupedSearchListModel)model2;
        return new ListCellRenderer<Object>(){
            private final Map<String, ListCellRenderer<? super Object>> myRenderersCache = new HashMap<String, ListCellRenderer<? super Object>>();

            @Override
            public Component getListCellRendererComponent(JList<?> list2, Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
                Border border;
                if (value2 == SearchListModel.MORE_ELEMENT) {
                    Component component2 = SEResultsListFactory.myMoreRenderer.getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
                    component2.setPreferredSize(UIUtil.updateListRowHeight((Dimension)component2.getPreferredSize()));
                    return component2;
                }
                SearchEverywhereContributor contributor = groupedModel.getContributorForIndex(index2);
                Object component3 = SearchEverywhereClassifier.EP_Manager.getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
                if (component3 == null) {
                    assert (contributor != null) : "Null contributor is not allowed here";
                    ListCellRenderer renderer = this.myRenderersCache.computeIfAbsent(contributor.getSearchProviderId(), s -> contributor.getElementsRenderer());
                    component3 = renderer.getListCellRendererComponent(list2, value2, index2, isSelected, true);
                }
                if (component3 instanceof JComponent && (border = ((JComponent)component3).getBorder()) != GotoActionModel.GotoActionListCellRenderer.TOGGLE_BUTTON_BORDER) {
                    ((JComponent)component3).setBorder((Border)JBUI.Borders.empty((int)1, (int)2));
                }
                AppUIUtil.targetToDevice(component3, list2);
                component3.setPreferredSize(UIUtil.updateListRowHeight((Dimension)component3.getPreferredSize()));
                if (!header2.getSelectedTab().isSingleContributor() && groupedModel.isGroupFirstItem(index2)) {
                    component3 = GroupedListFactory.this.myGroupTitleRenderer.withDisplayedData(contributor.getFullGroupName(), (Component)component3);
                }
                return component3;
            }
        };
    }

    private static class GroupTitleRenderer
    extends CellRendererPanel {
        final SimpleColoredComponent titleLabel = new SimpleColoredComponent();

        GroupTitleRenderer() {
            this.setLayout(new BorderLayout());
            SeparatorComponent separatorComponent = new SeparatorComponent(this.titleLabel.getPreferredSize().height / 2, JBUI.CurrentTheme.BigPopup.listSeparatorColor(), null);
            JBPanel topPanel = ((BorderLayoutPanel)JBUI.Panels.simplePanel((int)5, (int)0).addToCenter((Component)separatorComponent).addToLeft((Component)this.titleLabel).withBorder((Border)JBUI.Borders.empty((int)1, (int)7))).withBackground(UIUtil.getListBackground());
            this.add((Component)topPanel, "North");
        }

        public GroupTitleRenderer withDisplayedData(@Nls String title2, Component itemContent) {
            this.titleLabel.clear();
            this.titleLabel.append(title2, SEResultsListFactory.SMALL_LABEL_ATTRS);
            Component prevContent = ((BorderLayout)this.getLayout()).getLayoutComponent("Center");
            if (prevContent != null) {
                this.remove(prevContent);
            }
            this.add(itemContent, "Center");
            this.accessibleContext = itemContent.getAccessibleContext();
            return this;
        }
    }
}

