/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0019H\u0016R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/actions/SwitcherListFocusAction;", "Ljava/awt/event/FocusListener;", "Ljavax/swing/AbstractAction;", "fromList", "Ljavax/swing/JList;", "toList", "listActionIds", "", "", "(Ljavax/swing/JList;Ljavax/swing/JList;[Ljava/lang/String;)V", "getFromList", "()Ljavax/swing/JList;", "index", "", "toIndex", "getToIndex", "()I", "setToIndex", "(I)V", "getToList", "actionPerformed", "", "event", "Ljava/awt/event/ActionEvent;", "focusGained", "Ljava/awt/event/FocusEvent;", "focusLost", "intellij.platform.ide.impl"})
public final class SwitcherListFocusAction
extends AbstractAction
implements FocusListener {
    @NotNull
    private final JList<?> fromList;
    @NotNull
    private final JList<?> toList;

    @Override
    public void actionPerformed(@NotNull ActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.toList.isShowing()) {
            this.toList.requestFocusInWindow();
        }
    }

    @Override
    public void focusLost(@NotNull FocusEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Override
    public void focusGained(@NotNull FocusEvent event) {
        block0: {
            block1: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ListModel<?> listModel = this.toList.getModel();
                Intrinsics.checkNotNullExpressionValue(listModel, (String)"toList.model");
                int size = listModel.getSize();
                if (size <= 0) break block0;
                int fromIndex = this.fromList.getSelectedIndex();
                if (fromIndex < 0) break block1;
                this.setToIndex(RangesKt.coerceAtMost((int)fromIndex, (int)(size - 1)));
                break block0;
            }
            if (this.getToIndex() >= 0) break block0;
            this.setToIndex(0);
        }
    }

    private final int getToIndex() {
        return this.toList.getSelectedIndex();
    }

    private final void setToIndex(int index2) {
        this.fromList.clearSelection();
        this.toList.setSelectedIndex(index2);
        this.toList.ensureIndexIsVisible(index2);
    }

    @NotNull
    public final JList<?> getFromList() {
        return this.fromList;
    }

    @NotNull
    public final JList<?> getToList() {
        return this.toList;
    }

    public SwitcherListFocusAction(@NotNull JList<?> fromList, @NotNull JList<?> toList, String ... listActionIds) {
        Intrinsics.checkNotNullParameter(fromList, (String)"fromList");
        Intrinsics.checkNotNullParameter(toList, (String)"toList");
        Intrinsics.checkNotNullParameter((Object)listActionIds, (String)"listActionIds");
        this.fromList = fromList;
        this.toList = toList;
        String[] $this$forEach$iv = listActionIds;
        boolean $i$f$forEach = false;
        String[] stringArray = $this$forEach$iv;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String element$iv;
            String it = element$iv = stringArray[j];
            boolean bl = false;
            this.fromList.getActionMap().put(it, this);
        }
        this.toList.addFocusListener(this);
        this.toList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent it) {
                if (!this.getFromList().isSelectionEmpty() && !this.getToList().isSelectionEmpty()) {
                    this.getFromList().getSelectionModel().clearSelection();
                }
            }
        });
    }
}

