/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.io.File;
import java.util.LinkedList;
import java.util.Optional;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchEverywherePsiRenderer
extends PsiElementListCellRenderer<PsiElement> {
    private EditorColorsScheme scheme = EditorColorsManager.getInstance().getSchemeForCurrentUITheme();

    public SearchEverywherePsiRenderer(Disposable parent) {
        this.setLayout(new SELayout());
        ApplicationManager.getApplication().getMessageBus().connect(parent).subscribe(LafManagerListener.TOPIC, __ -> {
            this.scheme = EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
        });
    }

    @Override
    @NotNull
    protected SimpleTextAttributes getErrorAttributes() {
        SimpleTextAttributes schemeAttributes = SimpleTextAttributes.fromTextAttributes(this.scheme.getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES));
        return new SimpleTextAttributes(schemeAttributes.getBgColor(), UIUtil.getInactiveTextColor(), schemeAttributes.getWaveColor(), schemeAttributes.getStyle() | 0x2000);
    }

    @Override
    public String getElementText(PsiElement element2) {
        String name;
        VirtualFile file2;
        Object object = element2 instanceof PsiFile ? PsiUtilCore.getVirtualFile((PsiElement)element2) : (file2 = element2 instanceof VirtualFile ? (VirtualFile)element2 : null);
        if (file2 != null) {
            return VfsPresentationUtil.getPresentableNameForUI(element2.getProject(), file2);
        }
        if (element2 instanceof NavigationItem && (name = (String)Optional.ofNullable(((NavigationItem)element2).getPresentation()).map(presentation2 -> presentation2.getPresentableText()).orElse(null)) != null) {
            return name;
        }
        name = element2 instanceof PsiNamedElement ? ((PsiNamedElement)element2).getName() : null;
        return StringUtil.notNullize((String)name, (String)"<unnamed>");
    }

    @Override
    @Nullable
    protected String getContainerText(PsiElement element2, String name) {
        return this.getContainerTextForLeftComponent(element2, name, -1, (FontMetrics)null);
    }

    @Override
    @Nullable
    protected String getContainerTextForLeftComponent(PsiElement element2, String name, int maxWidth, FontMetrics fm) {
        boolean in;
        String presentablePath = SearchEverywherePsiRenderer.extractPresentablePath(element2);
        String text2 = (String)ObjectUtils.chooseNotNull((Object)presentablePath, (Object)SymbolPresentationUtil.getSymbolContainerText(element2));
        if (text2 == null || text2.equals(name)) {
            return null;
        }
        if (text2.startsWith("(") && text2.endsWith(")")) {
            text2 = text2.substring(1, text2.length() - 1);
        }
        if (presentablePath == null && (text2.contains("/") || text2.contains(File.separator)) && element2 instanceof PsiFileSystemItem) {
            Project project = element2.getProject();
            String basePath = Optional.ofNullable(project.getBasePath()).map(FileUtil::toSystemDependentName).orElse(null);
            VirtualFile file2 = ((PsiFileSystemItem)element2).getVirtualFile();
            if (file2 != null) {
                text2 = FileUtil.toSystemDependentName((String)text2);
                String filePath = FileUtil.toSystemDependentName((String)file2.getPath());
                if (basePath != null && FileUtil.isAncestor((String)basePath, (String)filePath, (boolean)true)) {
                    text2 = (String)ObjectUtils.notNull((Object)FileUtil.getRelativePath((String)basePath, (String)text2, (char)File.separatorChar), (Object)text2);
                } else {
                    String rootPath = Optional.ofNullable(GotoFileCellRenderer.getAnyRoot(file2, project)).map(root -> FileUtil.toSystemDependentName((String)root.getPath())).filter(root -> basePath != null && FileUtil.isAncestor((String)basePath, (String)root, (boolean)true)).orElse(null);
                    String string = text2 = rootPath != null ? (String)ObjectUtils.notNull((Object)FileUtil.getRelativePath((String)rootPath, (String)text2, (char)File.separatorChar), (Object)text2) : FileUtil.getLocationRelativeToUserHome((String)text2);
                }
            }
        }
        if (in = text2.startsWith("in ")) {
            text2 = text2.substring(3);
        }
        String left = in ? "in " : "";
        String adjustedText = left + text2;
        if (maxWidth < 0) {
            return adjustedText;
        }
        int fullWidth = fm.stringWidth(adjustedText);
        if (fullWidth < maxWidth) {
            return adjustedText;
        }
        String separator = text2.contains("/") ? "/" : (SystemInfo.isWindows && text2.contains("\\") ? "\\" : (text2.contains(".") ? "." : (text2.contains("-") ? "-" : " ")));
        LinkedList<String> parts = new LinkedList<String>(StringUtil.split((String)text2, (String)separator));
        while (parts.size() > 1) {
            int index2 = parts.size() / 2 - 1;
            parts.remove(index2);
            if (fm.stringWidth(left + StringUtil.join(parts, (String)separator) + "...") >= maxWidth) continue;
            parts.add(index2, "...");
            return left + StringUtil.join(parts, (String)separator);
        }
        int adjustedWidth = Math.max(adjustedText.length() * maxWidth / fullWidth - 1, left.length() + 3);
        return StringUtil.trimMiddle((String)adjustedText, (int)adjustedWidth);
    }

    @Nullable
    private static String extractPresentablePath(@Nullable PsiElement element2) {
        VirtualFile virtualFile2;
        if (element2 == null) {
            return null;
        }
        PsiFile file2 = element2.getContainingFile();
        if (file2 != null && (virtualFile2 = file2.getVirtualFile()) instanceof VirtualFilePathWrapper) {
            return ((VirtualFilePathWrapper)virtualFile2).getPresentablePath();
        }
        return null;
    }

    @Override
    protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list2, Object value2, int index2, boolean selected2, boolean hasFocus) {
        return GotoFileCellRenderer.doCustomizeNonPsiElementLeftRenderer(renderer, list2, value2, this.getNavigationItemAttributes(value2));
    }

    @Override
    protected int getIconFlags() {
        return 2;
    }

    public static class SELayout
    extends BorderLayout {
        @Override
        public void layoutContainer(Container target2) {
            super.layoutContainer(target2);
            Component right = this.getLayoutComponent("East");
            Component left = this.getLayoutComponent("West");
            if (right != null && left != null && left.getBounds().x + left.getBounds().width > right.getBounds().x) {
                Rectangle bounds2 = right.getBounds();
                int newX = left.getBounds().x + left.getBounds().width;
                right.setBounds(newX, bounds2.y, bounds2.width - (newX - bounds2.x), bounds2.height);
            }
        }
    }
}

