/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.CliResult;
import com.intellij.ide.CommandLineProcessorResult;
import com.intellij.ide.CommandLineWaitingManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.idea.CommandLineArgs;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.platform.CommandLineProjectOpenProcessor;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.pom.Navigatable;
import com.intellij.util.PlatformUtils;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandLineProcessor {
    private static final Logger LOG = Logger.getInstance(CommandLineProcessor.class);
    private static final String OPTION_WAIT = "--wait";
    public static final Future<CliResult> OK_FUTURE = CompletableFuture.completedFuture(CliResult.OK);

    private CommandLineProcessor() {
    }

    @ApiStatus.Internal
    @NotNull
    public static CommandLineProcessorResult doOpenFileOrProject(@NotNull Path file2, boolean shouldWait) {
        if (file2 == null) {
            CommandLineProcessor.$$$reportNull$$$0(0);
        }
        OpenProjectTask openProjectOptions = PlatformProjectOpenProcessor.createOptionsToOpenDotIdeaOrCreateNewIfNotExists(file2, null);
        openProjectOptions.checkDirectoryForFileBasedProjects = false;
        Project project = null;
        if (!LightEditUtil.isForceOpenInLightEditMode()) {
            project = ProjectUtil.openOrImport(file2, openProjectOptions);
        }
        if (project == null) {
            return CommandLineProcessor.doOpenFile(file2, -1, -1, false, shouldWait);
        }
        return new CommandLineProcessorResult(project, shouldWait ? CommandLineWaitingManager.getInstance().addHookForProject(project) : OK_FUTURE);
    }

    @NotNull
    private static CommandLineProcessorResult doOpenFile(@NotNull Path ioFile, int line, int column2, boolean tempProject, boolean shouldWait) {
        Project project;
        VirtualFile file2;
        RecentProjectsManager recentProjectManager;
        Project[] projects;
        if (ioFile == null) {
            CommandLineProcessor.$$$reportNull$$$0(1);
        }
        Project[] projectArray = projects = tempProject ? new Project[]{} : ProjectUtil.getOpenProjects();
        if (!tempProject && projects.length == 0 && PlatformUtils.isDataGrip() && (recentProjectManager = RecentProjectsManager.getInstance()).willReopenProjectOnStart() && ((Boolean)recentProjectManager.reopenLastProjectsOnStart().join()).booleanValue()) {
            projects = ProjectUtil.getOpenProjects();
        }
        if ((file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtilRt.toSystemIndependentName((String)ioFile.toString()))) == null) {
            Project lightEditProject;
            if (LightEditUtil.isLightEditEnabled() && (lightEditProject = LightEditUtil.openFile(ioFile, true)) != null) {
                Future<CliResult> future2 = shouldWait ? CommandLineWaitingManager.getInstance().addHookForPath(ioFile) : OK_FUTURE;
                return new CommandLineProcessorResult(lightEditProject, future2);
            }
            CommandLineProcessorResult commandLineProcessorResult = CommandLineProcessorResult.createError(IdeBundle.message((String)"dialog.message.can.not.open.file", (Object[])new Object[]{ioFile.toString()}));
            if (commandLineProcessorResult == null) {
                CommandLineProcessor.$$$reportNull$$$0(2);
            }
            return commandLineProcessorResult;
        }
        if (projects.length == 0) {
            Project project2 = CommandLineProjectOpenProcessor.getInstance().openProjectAndFile(ioFile, line, column2, tempProject);
            if (project2 == null) {
                CommandLineProcessorResult commandLineProcessorResult = CommandLineProcessorResult.createError(IdeBundle.message((String)"dialog.message.no.project.found.to.open.file.in", (Object[])new Object[0]));
                if (commandLineProcessorResult == null) {
                    CommandLineProcessor.$$$reportNull$$$0(3);
                }
                return commandLineProcessorResult;
            }
            return new CommandLineProcessorResult(project2, shouldWait ? CommandLineWaitingManager.getInstance().addHookForFile(file2) : OK_FUTURE);
        }
        NonProjectFileWritingAccessProvider.allowWriting(Collections.singletonList(file2));
        if (LightEditUtil.isForceOpenInLightEditMode()) {
            project = LightEditService.getInstance().openFile(file2);
            LightEditFeatureUsagesUtil.logFileOpen(project, LightEditFeatureUsagesUtil.OpenPlace.CommandLine);
        } else {
            project = CommandLineProcessor.findBestProject(file2, projects);
            OpenFileDescriptor navigatable = line > 0 ? new OpenFileDescriptor(project, file2, line - 1, Math.max(column2, 0)) : PsiNavigationSupport.getInstance().createNavigatable(project, file2, -1);
            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)project)).execute(() -> CommandLineProcessor.lambda$doOpenFile$0((Navigatable)navigatable));
        }
        return new CommandLineProcessorResult(project, shouldWait ? CommandLineWaitingManager.getInstance().addHookForFile(file2) : OK_FUTURE);
    }

    @NotNull
    private static Project findBestProject(@NotNull VirtualFile file2, @NotNull @NotNull Project @NotNull [] projects) {
        Project project;
        if (file2 == null) {
            CommandLineProcessor.$$$reportNull$$$0(4);
        }
        if (projects == null) {
            CommandLineProcessor.$$$reportNull$$$0(5);
        }
        for (Project project2 : projects) {
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project2);
            if (!((Boolean)ReadAction.compute(() -> fileIndex.isInContent(file2))).booleanValue()) continue;
            Project project3 = project2;
            if (project3 == null) {
                CommandLineProcessor.$$$reportNull$$$0(6);
            }
            return project3;
        }
        IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (frame != null && (project = frame.getProject()) != null && !LightEdit.owns((Project)project)) {
            Project project4 = project;
            if (project4 == null) {
                CommandLineProcessor.$$$reportNull$$$0(7);
            }
            return project4;
        }
        Project project5 = projects[0];
        if (project5 == null) {
            CommandLineProcessor.$$$reportNull$$$0(8);
        }
        return project5;
    }

    @NotNull
    public static CommandLineProcessorResult processExternalCommandLine(@NotNull List<String> args, @Nullable String currentDirectory) {
        if (args == null) {
            CommandLineProcessor.$$$reportNull$$$0(9);
        }
        StringBuilder logMessage = new StringBuilder();
        logMessage.append("External command line:").append('\n');
        logMessage.append("Dir: ").append(currentDirectory).append('\n');
        for (String arg : args) {
            logMessage.append(arg).append('\n');
        }
        logMessage.append("-----");
        LOG.info(logMessage.toString());
        if (args.isEmpty()) {
            return new CommandLineProcessorResult(null, OK_FUTURE);
        }
        CommandLineProcessorResult result2 = CommandLineProcessor.processApplicationStarters(args, currentDirectory);
        if (result2 != null) {
            CommandLineProcessorResult commandLineProcessorResult = result2;
            if (commandLineProcessorResult == null) {
                CommandLineProcessor.$$$reportNull$$$0(10);
            }
            return commandLineProcessorResult;
        }
        result2 = CommandLineProcessor.processJetBrainsProtocol(args);
        if (result2 != null) {
            CommandLineProcessorResult commandLineProcessorResult = result2;
            if (commandLineProcessorResult == null) {
                CommandLineProcessor.$$$reportNull$$$0(11);
            }
            return commandLineProcessorResult;
        }
        return CommandLineProcessor.processOpenFile(args, currentDirectory);
    }

    @Nullable
    private static CommandLineProcessorResult processApplicationStarters(@NotNull List<String> args, @Nullable String currentDirectory) {
        if (args == null) {
            CommandLineProcessor.$$$reportNull$$$0(12);
        }
        String command = args.get(0);
        return (CommandLineProcessorResult)ApplicationStarter.EP_NAME.computeSafeIfAny(starter2 -> {
            if (!command.equals(starter2.getCommandName())) {
                return null;
            }
            if (!starter2.canProcessExternalCommandLine()) {
                return CommandLineProcessorResult.createError(IdeBundle.message((String)"dialog.message.only.one.instance.can.be.run.at.time", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}));
            }
            LOG.info("Processing command with " + starter2);
            int requiredModality = starter2.getRequiredModality();
            if (requiredModality == 3) {
                return new CommandLineProcessorResult(null, starter2.processExternalCommandLineAsync(args, currentDirectory));
            }
            ModalityState modalityState = requiredModality == 2 ? ModalityState.any() : ModalityState.defaultModalityState();
            AtomicReference ref = new AtomicReference();
            ApplicationManager.getApplication().invokeAndWait(() -> ref.set(new CommandLineProcessorResult(null, starter2.processExternalCommandLineAsync(args, currentDirectory))), modalityState);
            return (CommandLineProcessorResult)ref.get();
        });
    }

    @Nullable
    private static CommandLineProcessorResult processJetBrainsProtocol(@NotNull List<String> args) {
        String command;
        if (args == null) {
            CommandLineProcessor.$$$reportNull$$$0(13);
        }
        if ((command = args.get(0)).startsWith("jetbrains://")) {
            JetBrainsProtocolHandler.processJetBrainsLauncherParameters((String)command);
            ApplicationManager.getApplication().invokeLater(() -> JBProtocolCommand.handleCurrentCommand());
            return new CommandLineProcessorResult(null, OK_FUTURE);
        }
        return null;
    }

    @NotNull
    private static CommandLineProcessorResult processOpenFile(@NotNull List<String> args, @Nullable String currentDirectory) {
        if (args == null) {
            CommandLineProcessor.$$$reportNull$$$0(14);
        }
        CommandLineProcessorResult projectAndCallback = null;
        int line = -1;
        int column2 = -1;
        boolean tempProject = false;
        boolean shouldWait = args.contains(OPTION_WAIT);
        boolean lightEditMode = false;
        for (int i2 = 0; i2 < args.size(); ++i2) {
            Path file2;
            String arg = args.get(i2);
            if (CommandLineArgs.isKnownArgument(arg) || OPTION_WAIT.equals(arg)) continue;
            if (arg.equals("-l") || arg.equals("--line")) {
                if (++i2 == args.size()) break;
                line = StringUtilRt.parseInt((String)args.get(i2), (int)-1);
                continue;
            }
            if (arg.equals("-c") || arg.equals("--column")) {
                if (++i2 == args.size()) break;
                column2 = StringUtilRt.parseInt((String)args.get(i2), (int)-1);
                continue;
            }
            if (arg.equals("--temp-project")) {
                tempProject = true;
                continue;
            }
            if (arg.equals("-e") || arg.equals("--edit")) {
                lightEditMode = true;
                continue;
            }
            if (arg.equals("-p") || arg.equals("--project")) continue;
            if (StringUtilRt.isQuotedString((String)arg)) {
                arg = StringUtilRt.unquoteString((String)arg);
            }
            if ((file2 = CommandLineProcessor.parseFilePath(arg, currentDirectory)) == null) {
                CommandLineProcessorResult commandLineProcessorResult = CommandLineProcessorResult.createError(IdeBundle.message((String)"dialog.message.invalid.path", (Object[])new Object[]{arg}));
                if (commandLineProcessorResult == null) {
                    CommandLineProcessor.$$$reportNull$$$0(15);
                }
                return commandLineProcessorResult;
            }
            projectAndCallback = CommandLineProcessor.openFileOrProject(file2, line, column2, tempProject, shouldWait, lightEditMode);
            if (shouldWait) break;
            column2 = -1;
            line = -1;
            tempProject = false;
        }
        if (projectAndCallback != null) {
            CommandLineProcessorResult commandLineProcessorResult = projectAndCallback;
            if (commandLineProcessorResult == null) {
                CommandLineProcessor.$$$reportNull$$$0(16);
            }
            return commandLineProcessorResult;
        }
        if (shouldWait) {
            return new CommandLineProcessorResult(null, CliResult.error((int)1, (String)IdeBundle.message((String)"dialog.message.wait.must.be.supplied.with.file.or.project.to.wait.for", (Object[])new Object[0])));
        }
        if (lightEditMode) {
            LightEditService.getInstance().showEditorWindow();
            return new CommandLineProcessorResult(LightEditService.getInstance().getProject(), OK_FUTURE);
        }
        return new CommandLineProcessorResult(null, OK_FUTURE);
    }

    @Nullable
    private static Path parseFilePath(@NotNull String path2, @Nullable String currentDirectory) {
        if (path2 == null) {
            CommandLineProcessor.$$$reportNull$$$0(17);
        }
        try {
            Path file2 = Paths.get(FileUtilRt.toSystemDependentName((String)path2), new String[0]);
            if (!file2.isAbsolute()) {
                file2 = currentDirectory == null ? file2.toAbsolutePath() : Paths.get(currentDirectory, new String[0]).resolve(file2);
            }
            return file2.normalize();
        }
        catch (InvalidPathException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @NotNull
    private static CommandLineProcessorResult openFileOrProject(@NotNull Path file2, int line, int column2, boolean tempProject, boolean shouldWait, boolean lightEditMode) {
        if (file2 == null) {
            CommandLineProcessor.$$$reportNull$$$0(18);
        }
        CommandLineProcessorResult commandLineProcessorResult = (CommandLineProcessorResult)LightEditUtil.computeWithCommandLineOptions(shouldWait, lightEditMode, () -> {
            if (line != -1 || tempProject) {
                return CommandLineProcessor.doOpenFile(file2, line, column2, tempProject, shouldWait);
            }
            return CommandLineProcessor.doOpenFileOrProject(file2, shouldWait);
        });
        if (commandLineProcessorResult == null) {
            CommandLineProcessor.$$$reportNull$$$0(19);
        }
        return commandLineProcessorResult;
    }

    private static /* synthetic */ void lambda$doOpenFile$0(Navigatable navigatable) {
        navigatable.navigate(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/CommandLineProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/CommandLineProcessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doOpenFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findBestProject";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "processExternalCommandLine";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "processOpenFile";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileOrProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doOpenFileOrProject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doOpenFile";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBestProject";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processExternalCommandLine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processApplicationStarters";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processJetBrainsProtocol";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processOpenFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseFilePath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "openFileOrProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

