/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.tree;

import com.intellij.history.core.DataStreamUtil;
import com.intellij.history.core.Paths;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.io.DataInputOutputUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DirectoryEntry
extends Entry {
    private final ArrayList<Entry> myChildren;

    public DirectoryEntry(String name) {
        this(DirectoryEntry.toNameId(name));
    }

    public DirectoryEntry(int nameId) {
        super(nameId);
        this.myChildren = new ArrayList(3);
    }

    public DirectoryEntry(DataInput in, boolean dummy) throws IOException {
        super(in);
        int count = DataInputOutputUtil.readINT((DataInput)in);
        this.myChildren = new ArrayList(count);
        while (count-- > 0) {
            this.unsafeAddChild(DataStreamUtil.readEntry(in));
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myChildren.size());
        for (Entry child2 : this.myChildren) {
            DataStreamUtil.writeEntry(out, child2);
        }
    }

    @Override
    public long getTimestamp() {
        return -1L;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public void addChild(Entry child2) {
        if (!this.checkDoesNotExist(child2, child2.getName())) {
            return;
        }
        this.unsafeAddChild(child2);
    }

    @Override
    public void addChildren(Collection<? extends Entry> children2) {
        this.myChildren.ensureCapacity(this.myChildren.size() + children2.size());
        for (Entry entry2 : children2) {
            this.unsafeAddChild(entry2);
        }
    }

    private void unsafeAddChild(Entry child2) {
        this.myChildren.add(child2);
        child2.setParent(this);
    }

    protected boolean checkDoesNotExist(Entry e, String name) {
        Entry found = this.findChild(name);
        if (found == null) {
            return true;
        }
        if (found == e) {
            return false;
        }
        this.removeChild(found);
        LocalHistoryLog.LOG.warn(String.format("entry '%s' already exists in '%s'", name, this.getPath()));
        return true;
    }

    @Override
    public void removeChild(Entry child2) {
        this.myChildren.remove(child2);
        child2.setParent(null);
    }

    @Override
    public List<Entry> getChildren() {
        return this.myChildren;
    }

    @Override
    public boolean hasUnavailableContent(List<? super Entry> entriesWithUnavailableContent) {
        for (Entry e : this.myChildren) {
            e.hasUnavailableContent(entriesWithUnavailableContent);
        }
        return !entriesWithUnavailableContent.isEmpty();
    }

    @Override
    @NotNull
    public DirectoryEntry copy() {
        DirectoryEntry result2 = this.copyEntry();
        result2.myChildren.ensureCapacity(this.myChildren.size());
        for (Entry child2 : this.myChildren) {
            result2.unsafeAddChild(child2.copy());
        }
        DirectoryEntry directoryEntry = result2;
        if (directoryEntry == null) {
            DirectoryEntry.$$$reportNull$$$0(0);
        }
        return directoryEntry;
    }

    protected DirectoryEntry copyEntry() {
        return new DirectoryEntry(this.getNameId());
    }

    @Override
    public void collectDifferencesWith(@NotNull Entry right, @NotNull List<? super Difference> result2, boolean isRightContentCurrent) {
        Entry myChildEntry;
        int commonIndex;
        if (right == null) {
            DirectoryEntry.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            DirectoryEntry.$$$reportNull$$$0(2);
        }
        DirectoryEntry e = (DirectoryEntry)right;
        if (!this.getPath().equals(e.getPath())) {
            result2.add(new Difference(false, this, e, isRightContentCurrent));
        }
        int myChildrenSize = this.myChildren.size();
        int rightChildrenSize = e.myChildren.size();
        int minChildrenSize = Math.min(myChildrenSize, rightChildrenSize);
        for (commonIndex = 0; commonIndex < minChildrenSize; ++commonIndex) {
            Entry childEntry = this.myChildren.get(commonIndex);
            Entry rightChildEntry = e.myChildren.get(commonIndex);
            if (childEntry.getNameId() != rightChildEntry.getNameId() || childEntry.isDirectory() != rightChildEntry.isDirectory()) break;
            childEntry.collectDifferencesWith(rightChildEntry, result2, isRightContentCurrent);
        }
        if (commonIndex == myChildrenSize && commonIndex == rightChildrenSize) {
            return;
        }
        Int2ObjectOpenHashMap uniqueNameIdToMyChildEntries = new Int2ObjectOpenHashMap(myChildrenSize - commonIndex);
        for (int i2 = commonIndex; i2 < myChildrenSize; ++i2) {
            Entry childEntry = this.myChildren.get(i2);
            uniqueNameIdToMyChildEntries.put(childEntry.getNameId(), (Object)childEntry);
        }
        Int2ObjectOpenHashMap uniqueNameIdToRightChildEntries = new Int2ObjectOpenHashMap(rightChildrenSize - commonIndex);
        Int2ObjectOpenHashMap myNameIdToRightChildEntries = new Int2ObjectOpenHashMap(rightChildrenSize - commonIndex);
        for (int i3 = commonIndex; i3 < rightChildrenSize; ++i3) {
            Entry rightChildEntry = e.myChildren.get(i3);
            int rightChildEntryNameId = rightChildEntry.getNameId();
            myChildEntry = (Entry)uniqueNameIdToMyChildEntries.get(rightChildEntryNameId);
            if (myChildEntry != null && myChildEntry.isDirectory() == rightChildEntry.isDirectory()) {
                uniqueNameIdToMyChildEntries.remove(rightChildEntryNameId);
                myNameIdToRightChildEntries.put(rightChildEntryNameId, (Object)rightChildEntry);
                continue;
            }
            uniqueNameIdToRightChildEntries.put(rightChildEntryNameId, (Object)rightChildEntry);
        }
        if (!Paths.isCaseSensitive() && uniqueNameIdToMyChildEntries.size() > 0 && uniqueNameIdToRightChildEntries.size() > 0) {
            Map nameToEntryMap = CollectionFactory.createCaseInsensitiveStringMap((int)uniqueNameIdToMyChildEntries.size());
            for (Entry entry2 : uniqueNameIdToMyChildEntries.values()) {
                nameToEntryMap.put(entry2.getName(), entry2);
            }
            for (Entry rightChildEntry : uniqueNameIdToRightChildEntries.values()) {
                myChildEntry = (Entry)nameToEntryMap.get(rightChildEntry.getName());
                if (myChildEntry == null || rightChildEntry.isDirectory() != myChildEntry.isDirectory()) continue;
                myNameIdToRightChildEntries.put(myChildEntry.getNameId(), (Object)rightChildEntry);
                uniqueNameIdToMyChildEntries.remove(myChildEntry.getNameId());
                uniqueNameIdToRightChildEntries.remove(rightChildEntry.getNameId());
            }
        }
        for (Entry child2 : e.myChildren) {
            if (!uniqueNameIdToRightChildEntries.containsKey(child2.getNameId())) continue;
            child2.collectCreatedDifferences(result2, isRightContentCurrent);
        }
        for (Entry child2 : this.myChildren) {
            if (uniqueNameIdToMyChildEntries.containsKey(child2.getNameId())) {
                child2.collectDeletedDifferences(result2, isRightContentCurrent);
                continue;
            }
            Entry itsChild = (Entry)myNameIdToRightChildEntries.get(child2.getNameId());
            if (itsChild == null) continue;
            child2.collectDifferencesWith(itsChild, result2, isRightContentCurrent);
        }
    }

    Entry findDirectChild(String name, boolean isDirectory) {
        int nameHash = DirectoryEntry.calcNameHash(name);
        for (Entry child2 : this.getChildren()) {
            if (child2.isDirectory() != isDirectory || nameHash != child2.getNameHash() || !child2.nameEquals(name)) continue;
            return child2;
        }
        return null;
    }

    @Override
    protected void collectCreatedDifferences(@NotNull List<? super Difference> result2, boolean isRightContentCurrent) {
        if (result2 == null) {
            DirectoryEntry.$$$reportNull$$$0(3);
        }
        result2.add(new Difference(false, null, this, isRightContentCurrent));
        for (Entry child2 : this.myChildren) {
            child2.collectCreatedDifferences(result2, isRightContentCurrent);
        }
    }

    @Override
    protected void collectDeletedDifferences(@NotNull List<? super Difference> result2, boolean isRightContentCurrent) {
        if (result2 == null) {
            DirectoryEntry.$$$reportNull$$$0(4);
        }
        result2.add(new Difference(false, this, null, isRightContentCurrent));
        for (Entry child2 : this.myChildren) {
            child2.collectDeletedDifferences(result2, isRightContentCurrent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/core/tree/DirectoryEntry";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/core/tree/DirectoryEntry";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectDifferencesWith";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectCreatedDifferences";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectDeletedDifferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

