/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.DataStreamUtil;
import com.intellij.history.core.Paths;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RenameChange
extends StructuralChange {
    private final String myOldName;

    public RenameChange(long id2, String path2, String oldName) {
        super(id2, path2);
        this.myOldName = oldName;
    }

    public RenameChange(DataInput in) throws IOException {
        super(in);
        this.myOldName = DataStreamUtil.readString(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        DataStreamUtil.writeString(out, this.myOldName);
    }

    @Override
    public String getOldPath() {
        return Paths.renamed(this.myPath, this.myOldName);
    }

    public String getOldName() {
        return this.myOldName;
    }

    @Override
    public void revertOn(RootEntry root, boolean warnOnFileNotFound) {
        Entry e = root.findEntry(this.myPath);
        if (e == null) {
            this.cannotRevert(this.myPath, warnOnFileNotFound);
            return;
        }
        e.setName(this.myOldName);
    }

    @Override
    protected String[] getAffectedPaths() {
        return new String[]{this.myPath, this.getOldPath()};
    }

    @Override
    public void accept(ChangeVisitor v) throws ChangeVisitor.StopVisitingException {
        v.visit(this);
    }
}

