/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.help.impl;

import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerImpl;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.TimeoutUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class IntentionDump
implements ApplicationStarter {
    IntentionDump() {
    }

    public String getCommandName() {
        return "intentions";
    }

    public void main(@NotNull List<String> args) {
        if (args == null) {
            IntentionDump.$$$reportNull$$$0(0);
        }
        DocumentBuilderFactory factory2 = DocumentBuilderFactory.newDefaultInstance();
        try {
            DocumentBuilder builder2 = factory2.newDocumentBuilder();
            Document document = builder2.newDocument();
            Element intentions = document.createElement("Intentions");
            document.appendChild(intentions);
            while (((IntentionManagerImpl)IntentionManager.getInstance()).hasActiveRequests()) {
                TimeoutUtil.sleep((long)100L);
            }
            for (IntentionActionMetaData actionMetaData : IntentionManagerSettings.getInstance().getMetaData()) {
                TextDescriptor[] afterDescriptors;
                Element intention = document.createElement("Intention");
                intention.setAttribute("categories", StringUtil.join((String[])actionMetaData.myCategory, (String)","));
                intention.setAttribute("name", actionMetaData.getFamily());
                Element description = document.createElement("description");
                CDATASection descriptionSection = document.createCDATASection(IntentionDump.escapeCDATA(actionMetaData.getDescription().getText()));
                description.appendChild(descriptionSection);
                intention.appendChild(description);
                TextDescriptor[] beforeDescriptors = actionMetaData.getExampleUsagesBefore();
                if (beforeDescriptors.length > 0) {
                    Element before = document.createElement("before");
                    CDATASection beforeSection = document.createCDATASection(IntentionDump.escapeCDATA(beforeDescriptors[0].getText()));
                    before.appendChild(beforeSection);
                    intention.appendChild(before);
                }
                if ((afterDescriptors = actionMetaData.getExampleUsagesAfter()).length > 0) {
                    Element after2 = document.createElement("after");
                    CDATASection afterSection = document.createCDATASection(IntentionDump.escapeCDATA(afterDescriptors[0].getText()));
                    after2.appendChild(afterSection);
                    intention.appendChild(after2);
                }
                intentions.appendChild(intention);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            Object path2 = args.size() == 2 ? args.get(1) : PathManager.getHomePath() + File.separator + "AllIntentions.xml";
            StreamResult console2 = new StreamResult(new File((String)path2));
            transformer.transform(source, console2);
            System.exit(0);
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static String escapeCDATA(String cData) {
        return cData.replaceAll("]", "&#x005D;").replaceAll("\\[", "&#x005B;");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/help/impl/IntentionDump", "main"));
    }
}

