/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.ui;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.impl.FrameworkDetectionUtil;
import com.intellij.framework.detection.impl.ui.DetectedFrameworkNode;
import com.intellij.framework.detection.impl.ui.DetectedFrameworkTreeNodeBase;
import com.intellij.framework.detection.impl.ui.DetectedFrameworksComponent;
import com.intellij.framework.detection.impl.ui.FrameworkDirectoryNode;
import com.intellij.framework.detection.impl.ui.FrameworkTypeNode;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.util.Consumer;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class DetectedFrameworksTree
extends CheckboxTree {
    private List<? extends DetectedFrameworkDescription> myDetectedFrameworks;
    private final FrameworkDetectionContext myContext;
    private DetectedFrameworksComponent.GroupByOption myGroupByOption;

    public DetectedFrameworksTree(FrameworkDetectionContext context2, DetectedFrameworksComponent.GroupByOption groupByOption) {
        super(new DetectedFrameworksTreeRenderer(), new CheckedTreeNode(null), new CheckboxTreeBase.CheckPolicy(true, true, true, false));
        this.myContext = context2;
        this.myGroupByOption = groupByOption;
        this.setShowsRootHandles(false);
        this.setRootVisible(false);
    }

    private void createNodesGroupedByDirectory(CheckedTreeNode root, List<? extends DetectedFrameworkDescription> frameworks) {
        HashMap<VirtualFile, FrameworkDirectoryNode> nodes = new HashMap<VirtualFile, FrameworkDirectoryNode>();
        ArrayList<DetectedFrameworkNode> externalNodes = new ArrayList<DetectedFrameworkNode>();
        for (DetectedFrameworkDescription detectedFrameworkDescription : frameworks) {
            VirtualFile parent = VfsUtil.getCommonAncestor((Collection)detectedFrameworkDescription.getRelatedFiles());
            if (parent != null && !parent.isDirectory()) {
                parent = parent.getParent();
            }
            DetectedFrameworkNode frameworkNode = new DetectedFrameworkNode(detectedFrameworkDescription, this.myContext);
            if (parent != null) {
                DetectedFrameworksTree.createDirectoryNodes(parent, nodes).add((MutableTreeNode)((Object)frameworkNode));
                continue;
            }
            externalNodes.add(frameworkNode);
        }
        ArrayList<FrameworkDirectoryNode> rootDirs = new ArrayList<FrameworkDirectoryNode>();
        for (FrameworkDirectoryNode directoryNode : nodes.values()) {
            if (directoryNode.getParent() != null) continue;
            rootDirs.add(directoryNode);
        }
        for (FrameworkDirectoryNode dir : rootDirs) {
            root.add((MutableTreeNode)((Object)DetectedFrameworksTree.collapseDirectoryNode(dir)));
        }
        for (DetectedFrameworkNode node : externalNodes) {
            root.add((MutableTreeNode)((Object)node));
        }
    }

    public void processUncheckedNodes(@NotNull Consumer<? super DetectedFrameworkTreeNodeBase> consumer) {
        if (consumer == null) {
            DetectedFrameworksTree.$$$reportNull$$$0(0);
        }
        TreeUtil.traverse((TreeNode)this.getRoot(), node -> {
            DetectedFrameworkTreeNodeBase frameworkNode;
            if (node instanceof DetectedFrameworkTreeNodeBase && !(frameworkNode = (DetectedFrameworkTreeNodeBase)((Object)((Object)node))).isChecked()) {
                consumer.consume((Object)frameworkNode);
            }
            return true;
        });
    }

    protected void onNodeStateChanged(CheckedTreeNode node) {
        List<DetectedFrameworkDescription> checked = Arrays.asList((DetectedFrameworkDescription[])this.getCheckedNodes(DetectedFrameworkDescription.class, null));
        List<DetectedFrameworkDescription> disabled = FrameworkDetectionUtil.getDisabledDescriptions(checked, Collections.emptyList());
        for (DetectedFrameworkDescription description : disabled) {
            DefaultMutableTreeNode treeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)this.getRoot(), (Object)description);
            if (!(treeNode instanceof CheckedTreeNode)) continue;
            ((CheckedTreeNode)treeNode).setChecked(false);
        }
    }

    private static FrameworkDirectoryNode collapseDirectoryNode(FrameworkDirectoryNode node) {
        TreeNode child2;
        if (node.getChildCount() == 1 && (child2 = node.getChildAt(0)) instanceof FrameworkDirectoryNode) {
            return DetectedFrameworksTree.collapseDirectoryNode((FrameworkDirectoryNode)((Object)child2));
        }
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            FrameworkDirectoryNode collapsed;
            TreeNode child3 = node.getChildAt(i2);
            if (!(child3 instanceof FrameworkDirectoryNode) || (collapsed = DetectedFrameworksTree.collapseDirectoryNode((FrameworkDirectoryNode)((Object)child3))) == child3) continue;
            node.remove(i2);
            node.insert((MutableTreeNode)((Object)collapsed), i2);
        }
        return node;
    }

    @NotNull
    private static FrameworkDirectoryNode createDirectoryNodes(@NotNull VirtualFile dir, @NotNull Map<VirtualFile, FrameworkDirectoryNode> nodes) {
        FrameworkDirectoryNode node;
        if (dir == null) {
            DetectedFrameworksTree.$$$reportNull$$$0(1);
        }
        if (nodes == null) {
            DetectedFrameworksTree.$$$reportNull$$$0(2);
        }
        if ((node = nodes.get(dir)) != null) {
            FrameworkDirectoryNode frameworkDirectoryNode = node;
            if (frameworkDirectoryNode == null) {
                DetectedFrameworksTree.$$$reportNull$$$0(3);
            }
            return frameworkDirectoryNode;
        }
        FrameworkDirectoryNode newNode = new FrameworkDirectoryNode(dir);
        nodes.put(dir, newNode);
        VirtualFile parent = dir.getParent();
        if (parent != null) {
            DetectedFrameworksTree.createDirectoryNodes(parent, nodes).add((MutableTreeNode)((Object)newNode));
        }
        FrameworkDirectoryNode frameworkDirectoryNode = newNode;
        if (frameworkDirectoryNode == null) {
            DetectedFrameworksTree.$$$reportNull$$$0(4);
        }
        return frameworkDirectoryNode;
    }

    private void createNodesGroupedByType(CheckedTreeNode root, List<? extends DetectedFrameworkDescription> frameworks) {
        HashMap<String, FrameworkTypeNode> groupNodes = new HashMap<String, FrameworkTypeNode>();
        for (DetectedFrameworkDescription detectedFrameworkDescription : frameworks) {
            FrameworkType type = detectedFrameworkDescription.getDetector().getFrameworkType();
            FrameworkTypeNode group2 = (FrameworkTypeNode)((Object)groupNodes.get(type.getId()));
            if (group2 == null) {
                group2 = new FrameworkTypeNode(type);
                groupNodes.put(type.getId(), group2);
                root.add((MutableTreeNode)((Object)group2));
            }
            group2.add((MutableTreeNode)((Object)new DetectedFrameworkNode(detectedFrameworkDescription, this.myContext)));
        }
    }

    private CheckedTreeNode getRoot() {
        return (CheckedTreeNode)this.getModel().getRoot();
    }

    public void changeGroupBy(DetectedFrameworksComponent.GroupByOption option2) {
        if (this.myGroupByOption.equals((Object)option2)) {
            return;
        }
        this.myGroupByOption = option2;
        if (this.myDetectedFrameworks != null) {
            this.rebuildTree(this.myDetectedFrameworks);
        }
    }

    public void rebuildTree(List<? extends DetectedFrameworkDescription> frameworks) {
        CheckedTreeNode root = this.getRoot();
        root.removeAllChildren();
        if (this.myGroupByOption == DetectedFrameworksComponent.GroupByOption.TYPE) {
            this.createNodesGroupedByType(root, frameworks);
        } else {
            this.createNodesGroupedByDirectory(root, frameworks);
        }
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged((TreeNode)root);
        TreeUtil.expandAll((JTree)((Object)this));
        this.myDetectedFrameworks = frameworks;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/impl/ui/DetectedFrameworksTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/impl/ui/DetectedFrameworksTree";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectoryNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processUncheckedNodes";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryNodes";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DetectedFrameworksTreeRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private DetectedFrameworksTreeRenderer() {
            super(true, false);
        }

        public void customizeRenderer(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (value2 instanceof DetectedFrameworkTreeNodeBase) {
                ((DetectedFrameworkTreeNodeBase)((Object)value2)).renderNode(this.getTextRenderer());
            }
        }
    }
}

