/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.ProbablyIncreasingLowerboundAlgorithm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlignmentImpl
extends Alignment {
    private static final List<LeafBlockWrapper> EMPTY = Collections.emptyList();
    private final boolean myAllowBackwardShift;
    private final Alignment.Anchor myAnchor;
    private List<LeafBlockWrapper> myOffsetRespBlocks;
    private AlignmentImpl myParentAlignment;
    private final ProbablyIncreasingLowerboundAlgorithm<LeafBlockWrapper> myOffsetRespBlocksCalculator;

    AlignmentImpl() {
        this(false, Alignment.Anchor.LEFT);
    }

    AlignmentImpl(boolean allowBackwardShift, @NotNull Alignment.Anchor anchor2) {
        if (anchor2 == null) {
            AlignmentImpl.$$$reportNull$$$0(0);
        }
        this.myOffsetRespBlocks = EMPTY;
        this.myAllowBackwardShift = allowBackwardShift;
        this.myAnchor = anchor2;
        this.myOffsetRespBlocksCalculator = new ProbablyIncreasingLowerboundAlgorithm<LeafBlockWrapper>(this.myOffsetRespBlocks);
    }

    public boolean isAllowBackwardShift() {
        return this.myAllowBackwardShift;
    }

    @NotNull
    public Alignment.Anchor getAnchor() {
        Alignment.Anchor anchor2 = this.myAnchor;
        if (anchor2 == null) {
            AlignmentImpl.$$$reportNull$$$0(1);
        }
        return anchor2;
    }

    public String getId() {
        return String.valueOf(System.identityHashCode((Object)this));
    }

    public void reset() {
        if (this.myOffsetRespBlocks != EMPTY) {
            this.myOffsetRespBlocks.clear();
        }
        this.myOffsetRespBlocksCalculator.reset();
    }

    public void setParent(Alignment base) {
        this.myParentAlignment = (AlignmentImpl)base;
    }

    @Nullable
    public LeafBlockWrapper getOffsetRespBlockBefore(@Nullable AbstractBlockWrapper block) {
        if (!this.continueOffsetResponsibleBlockRetrieval(block)) {
            return null;
        }
        LeafBlockWrapper result2 = null;
        List<LeafBlockWrapper> leftBlocks = this.myOffsetRespBlocksCalculator.getLeftSubList(block);
        if (!leftBlocks.isEmpty()) {
            result2 = leftBlocks.get(0);
        }
        if (result2 == null && this.myParentAlignment != null) {
            return this.myParentAlignment.getOffsetRespBlockBefore(block);
        }
        return result2;
    }

    public void setOffsetRespBlock(LeafBlockWrapper block) {
        if (block == null) {
            return;
        }
        if (this.myOffsetRespBlocks == EMPTY) {
            this.myOffsetRespBlocks = new ArrayList<LeafBlockWrapper>(1);
            this.myOffsetRespBlocksCalculator.setBlocksList(this.myOffsetRespBlocks);
        }
        this.myOffsetRespBlocks.add(block);
    }

    public Set<LeafBlockWrapper> getOffsetResponsibleBlocks() {
        return new HashSet<LeafBlockWrapper>(this.myOffsetRespBlocks);
    }

    @NotNull
    private static AbstractBlockWrapper extendBlockFromStart(@NotNull AbstractBlockWrapper block) {
        CompositeBlockWrapper parent;
        if (block == null) {
            AlignmentImpl.$$$reportNull$$$0(2);
        }
        while ((parent = block.getParent()) != null && parent.getStartOffset() == block.getStartOffset()) {
            block = parent;
        }
        AbstractBlockWrapper abstractBlockWrapper = block;
        if (abstractBlockWrapper == null) {
            AlignmentImpl.$$$reportNull$$$0(3);
        }
        return abstractBlockWrapper;
    }

    @NotNull
    private static AbstractBlockWrapper extendBlockFromEnd(@NotNull AbstractBlockWrapper block) {
        CompositeBlockWrapper parent;
        if (block == null) {
            AlignmentImpl.$$$reportNull$$$0(4);
        }
        while ((parent = block.getParent()) != null && parent.getEndOffset() == block.getEndOffset()) {
            block = parent;
        }
        AbstractBlockWrapper abstractBlockWrapper = block;
        if (abstractBlockWrapper == null) {
            AlignmentImpl.$$$reportNull$$$0(5);
        }
        return abstractBlockWrapper;
    }

    private boolean continueOffsetResponsibleBlockRetrieval(@Nullable AbstractBlockWrapper block) {
        if (!this.myAllowBackwardShift && block != null && !block.getWhiteSpace().containsLineFeeds()) {
            return false;
        }
        if (block != null) {
            AbstractBlockWrapper prevAlignBlock = this.myOffsetRespBlocksCalculator.getLeftRespNeighbor(block);
            if (!AlignmentImpl.onDifferentLines(prevAlignBlock, block)) {
                return false;
            }
            if (this.myAllowBackwardShift && this.myAnchor == Alignment.Anchor.RIGHT && prevAlignBlock != null && prevAlignBlock.getWhiteSpace().containsLineFeeds()) {
                AbstractBlockWrapper prev2;
                prevAlignBlock = AlignmentImpl.extendBlockFromStart(prevAlignBlock);
                AbstractBlockWrapper current2 = block;
                do {
                    if (current2.getStartOffset() < prevAlignBlock.getEndOffset()) {
                        return false;
                    }
                    if (current2.getWhiteSpace().containsLineFeeds()) break;
                    prev2 = current2.getPreviousBlock();
                    if (prev2 == null) continue;
                    prev2 = AlignmentImpl.extendBlockFromEnd(prev2);
                } while ((current2 = prev2) != null);
                if (current2 == null) {
                    return false;
                }
            }
        }
        return this.myParentAlignment == null || this.myParentAlignment.continueOffsetResponsibleBlockRetrieval(block);
    }

    private static boolean onDifferentLines(AbstractBlockWrapper block1, AbstractBlockWrapper block2) {
        AbstractBlockWrapper rightBlock;
        if (block1 == null || block2 == null) {
            return true;
        }
        AbstractBlockWrapper leftBlock = block1.getStartOffset() <= block2.getStartOffset() ? block1 : block2;
        AbstractBlockWrapper abstractBlockWrapper = rightBlock = block1.getStartOffset() > block2.getStartOffset() ? block1 : block2;
        while (rightBlock != null && rightBlock.getStartOffset() > leftBlock.getStartOffset()) {
            if (rightBlock.getWhiteSpace().containsLineFeeds()) {
                return true;
            }
            rightBlock = rightBlock.getPreviousBlock();
        }
        return false;
    }

    public String toString() {
        return "Align: " + System.identityHashCode((Object)this) + "," + this.getAnchor() + (this.isAllowBackwardShift() ? "<" : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/AlignmentImpl";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/AlignmentImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "extendBlockFromStart";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "extendBlockFromEnd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extendBlockFromStart";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extendBlockFromEnd";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

