/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.util.Processor;
import com.intellij.util.ui.EditableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public class ProjectStartupTasksTableModel
extends AbstractTableModel
implements EditableModel {
    public static final int NAME_COLUMN = 0;
    public static final int IS_SHARED_COLUMN = 1;
    private final Set<RunnerAndConfigurationSettings> mySharedConfigurations = new HashSet<RunnerAndConfigurationSettings>();
    private final List<RunnerAndConfigurationSettings> myAllConfigurations = new ArrayList<RunnerAndConfigurationSettings>();

    public void setData(Collection<? extends RunnerAndConfigurationSettings> shared, Collection<? extends RunnerAndConfigurationSettings> local) {
        this.mySharedConfigurations.clear();
        this.myAllConfigurations.clear();
        this.mySharedConfigurations.addAll(shared);
        this.myAllConfigurations.addAll(shared);
        this.myAllConfigurations.addAll(local);
        this.myAllConfigurations.sort(new RunnerAndConfigurationSettingsComparator());
    }

    public void addRow() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void exchangeRows(int oldIndex, int newIndex) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return false;
    }

    public void removeRow(int idx) {
        RunnerAndConfigurationSettings settings2 = this.myAllConfigurations.remove(idx);
        if (settings2 != null) {
            this.mySharedConfigurations.remove(settings2);
            this.fireTableDataChanged();
        }
    }

    @Override
    public int getRowCount() {
        return this.myAllConfigurations.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int columnIndex) {
        if (1 == columnIndex) {
            return Boolean.class;
        }
        Class<?> clazz = super.getColumnClass(columnIndex);
        if (clazz == null) {
            ProjectStartupTasksTableModel.$$$reportNull$$$0(0);
        }
        return clazz;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (0 == columnIndex) {
            return this.myAllConfigurations.get(rowIndex).getName();
        }
        if (1 == columnIndex) {
            return this.mySharedConfigurations.contains(this.myAllConfigurations.get(rowIndex));
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (1 == columnIndex) {
            if (Boolean.TRUE.equals(aValue)) {
                this.mySharedConfigurations.add(this.myAllConfigurations.get(rowIndex));
            } else {
                this.mySharedConfigurations.remove(this.myAllConfigurations.get(rowIndex));
            }
            this.fireTableRowsUpdated(rowIndex, rowIndex + 1);
        }
    }

    @Override
    @NotNull
    public String getColumnName(int column2) {
        if (0 == column2) {
            String string = ExecutionBundle.message((String)"project.startup.task.table.name.column", (Object[])new Object[0]);
            if (string == null) {
                ProjectStartupTasksTableModel.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (1 == column2) {
            String string = ExecutionBundle.message((String)"project.startup.task.table.is.shared.column", (Object[])new Object[0]);
            if (string == null) {
                ProjectStartupTasksTableModel.$$$reportNull$$$0(2);
            }
            return string;
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (0 == columnIndex) {
            return false;
        }
        return this.myAllConfigurations.get(rowIndex).isShared();
    }

    public void addConfiguration(@NotNull RunnerAndConfigurationSettings configuration2) {
        if (configuration2 == null) {
            ProjectStartupTasksTableModel.$$$reportNull$$$0(3);
        }
        if (this.myAllConfigurations.contains(configuration2)) {
            return;
        }
        this.myAllConfigurations.add(configuration2);
        this.myAllConfigurations.sort(RunnerAndConfigurationSettingsComparator.getInstance());
        if (configuration2.isShared()) {
            this.mySharedConfigurations.add(configuration2);
        }
        this.fireTableDataChanged();
    }

    public Set<RunnerAndConfigurationSettings> getSharedConfigurations() {
        return this.mySharedConfigurations;
    }

    public List<RunnerAndConfigurationSettings> getAllConfigurations() {
        return this.myAllConfigurations;
    }

    public void reValidateConfigurations(Processor<? super RunnerAndConfigurationSettings> existenceChecker) {
        Iterator<RunnerAndConfigurationSettings> iterator2 = this.myAllConfigurations.iterator();
        while (iterator2.hasNext()) {
            RunnerAndConfigurationSettings settings2 = iterator2.next();
            if (existenceChecker.process((Object)settings2)) continue;
            iterator2.remove();
            this.mySharedConfigurations.remove(settings2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/startup/ProjectStartupTasksTableModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/startup/ProjectStartupTasksTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RunnerAndConfigurationSettingsComparator
    implements Comparator<RunnerAndConfigurationSettings> {
        private static final RunnerAndConfigurationSettingsComparator ourInstance = new RunnerAndConfigurationSettingsComparator();

        public static RunnerAndConfigurationSettingsComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(RunnerAndConfigurationSettings o1, RunnerAndConfigurationSettings o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }
}

