/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.mediator.util;

import com.intellij.execution.process.mediator.util.NativeCall;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.ptr.IntByReference;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class MachUtil {
    private MachUtil() {
    }

    public static boolean isMac() {
        return Platform.isMac();
    }

    public static void setup(@Nullable Integer machNamespaceUid) {
        if (!MachUtil.isMac()) {
            throw new IllegalStateException("macOS only");
        }
        if (machNamespaceUid != null) {
            NativeCall.tryRun(() -> MachUtil.machMoveToUserNamespace(machNamespaceUid), "Failed to move to namespace of UID " + machNamespaceUid);
        }
    }

    private static void machMoveToUserNamespace(int uid) throws NativeCall.NativeCallException {
        LibSystem libSystem;
        try {
            libSystem = (LibSystem)Native.load((String)"System", LibSystem.class);
        }
        catch (UnsatisfiedLinkError e) {
            throw new IllegalStateException("Unable to load libSystem", e);
        }
        NativeLibrary systemLibrary = Objects.requireNonNull(((Library.Handler)Proxy.getInvocationHandler(libSystem)).getNativeLibrary());
        IntByReference bootstrapPort = new IntByReference();
        bootstrapPort.setPointer(systemLibrary.getGlobalVariableAddress("bootstrap_port"));
        IntByReference rootPort = new IntByReference();
        if (libSystem.bootstrap_get_root(bootstrapPort.getValue(), rootPort) != 0) {
            throw new NativeCall.NativeCallException("bootstrap_get_root");
        }
        IntByReference userPort = new IntByReference();
        if (libSystem.bootstrap_look_up_per_user(bootstrapPort.getValue(), null, uid, userPort) != 0) {
            throw new NativeCall.NativeCallException("bootstrap_look_up_per_user");
        }
        int task2 = libSystem.mach_task_self();
        if (libSystem.task_set_special_port(task2, 4, userPort.getValue()) != 0) {
            throw new NativeCall.NativeCallException("task_set_bootstrap_port");
        }
        if (libSystem.mach_port_deallocate(task2, bootstrapPort.getValue()) != 0) {
            throw new NativeCall.NativeCallException("mach_port_deallocate");
        }
        bootstrapPort.setValue(userPort.getValue());
    }

    private static interface LibSystem
    extends Library {
        public static final int KERN_SUCCESS = 0;
        public static final int TASK_BOOTSTRAP_PORT = 4;

        public int mach_task_self();

        public int mach_port_deallocate(int var1, int var2);

        public int task_set_special_port(int var1, int var2, int var3);

        public int bootstrap_get_root(int var1, IntByReference var2);

        public int bootstrap_look_up_per_user(int var1, String var2, int var3, IntByReference var4);
    }
}

