/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.mediator.launcher;

import com.google.protobuf.ByteString;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.mediator.client.ProcessMediatorClient;
import com.intellij.execution.process.mediator.daemon.DaemonClientCredentials;
import com.intellij.execution.process.mediator.daemon.DaemonLaunchOptions;
import com.intellij.execution.process.mediator.daemon.DaemonProcessRuntimeClasspath;
import com.intellij.execution.process.mediator.launcher.DaemonHandshakeTransport;
import com.intellij.execution.process.mediator.launcher.DaemonHandshakeTransportKt;
import com.intellij.execution.process.mediator.launcher.DaemonProcessLauncherKt;
import com.intellij.execution.process.mediator.launcher.ProcessMediatorConnection;
import com.intellij.execution.process.mediator.launcher.ProcessMediatorConnectionKt;
import com.intellij.execution.process.mediator.rpc.Handshake;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.processHandshake.ProcessHandshakeLauncher;
import com.intellij.util.io.processHandshake.ProcessHandshakeTransport;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0004J\b\u0010\r\u001a\u00020\u0003H\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0003H\u0014J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000fH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/process/mediator/launcher/DaemonProcessLauncher;", "Lcom/intellij/util/io/processHandshake/ProcessHandshakeLauncher;", "Lcom/intellij/execution/process/mediator/rpc/Handshake;", "Lcom/intellij/execution/process/mediator/launcher/DaemonHandshakeTransport;", "Lcom/intellij/execution/process/mediator/launcher/ProcessMediatorConnection;", "clientBuilder", "Lcom/intellij/execution/process/mediator/client/ProcessMediatorClient$Builder;", "(Lcom/intellij/execution/process/mediator/client/ProcessMediatorClient$Builder;)V", "createBaseLaunchOptions", "Lcom/intellij/execution/process/mediator/daemon/DaemonLaunchOptions;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "transport", "createHandshakeTransport", "createProcessHandler", "Lcom/intellij/execution/process/BaseOSProcessHandler;", "handshakeSucceeded", "handshake", "processHandler", "intellij.platform.elevation.client"})
public class DaemonProcessLauncher
extends ProcessHandshakeLauncher<Handshake, DaemonHandshakeTransport, ProcessMediatorConnection> {
    private final ProcessMediatorClient.Builder clientBuilder;

    @Override
    @NotNull
    protected ProcessMediatorConnection handshakeSucceeded(@NotNull Handshake handshake2, @NotNull DaemonHandshakeTransport transport, @NotNull BaseOSProcessHandler processHandler2) {
        Intrinsics.checkNotNullParameter((Object)handshake2, (String)"handshake");
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)processHandler2, (String)"processHandler");
        Optional<ProcessHandle> optional = ProcessHandle.of(handshake2.getPid());
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ProcessHandle.of(handshake.pid)");
        ProcessHandle processHandle = (ProcessHandle)UtilKt.orNull(optional);
        if (processHandle == null) {
            ProcessHandle processHandle2 = processHandler2.getProcess().toHandle();
            boolean bl = false;
            boolean bl2 = false;
            ProcessHandle it = processHandle2;
            boolean bl3 = false;
            processHandle = !transport.getDaemonLaunchOptions().getTrampoline() ? processHandle2 : null;
        }
        ProcessHandle daemonProcessHandle = processHandle;
        ByteString byteString = handshake2.getToken();
        Intrinsics.checkNotNullExpressionValue((Object)byteString, (String)"handshake.token");
        DaemonClientCredentials credentials2 = new DaemonClientCredentials(byteString);
        return ProcessMediatorConnectionKt.createDaemonConnection(ProcessMediatorConnection.Companion, daemonProcessHandle, handshake2.getPort(), credentials2, this.clientBuilder);
    }

    @Override
    @NotNull
    protected DaemonHandshakeTransport createHandshakeTransport() {
        return DaemonHandshakeTransportKt.createProcessStdoutTransport(DaemonHandshakeTransport.Companion, this.createBaseLaunchOptions());
    }

    @NotNull
    protected DaemonLaunchOptions createBaseLaunchOptions() {
        Long l = ProcessHandle.current().pid();
        boolean bl = false;
        boolean bl2 = false;
        long l2 = ((Number)l).longValue();
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = SystemInfo.isUnix;
        Long l3 = bl6 ? l : null;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 59;
        DaemonLaunchOptions.TokenEncryptionOption tokenEncryptionOption = null;
        DaemonLaunchOptions.HandshakeOption handshakeOption = null;
        Integer n2 = null;
        Long l4 = l3;
        boolean bl7 = bl3;
        boolean bl8 = bl4;
        return new DaemonLaunchOptions(bl8, bl7, l4, n2, handshakeOption, tokenEncryptionOption, n, defaultConstructorMarker);
    }

    @NotNull
    protected final GeneralCommandLine createCommandLine(@NotNull DaemonHandshakeTransport transport) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        DaemonLaunchOptions daemonLaunchOptions = transport.getDaemonLaunchOptions();
        Map<String, String> map2 = DaemonProcessRuntimeClasspath.getProperties();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"DaemonProcessRuntimeClasspath.getProperties()");
        List<Class<?>> list2 = DaemonProcessRuntimeClasspath.getClasspathClasses();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"DaemonProcessRuntimeClas\u2026ath.getClasspathClasses()");
        GeneralCommandLine generalCommandLine = DaemonProcessLauncherKt.access$createJavaVmCommandLine(map2, list2);
        String[] stringArray = new String[1];
        Class<?> clazz = DaemonProcessRuntimeClasspath.getMainClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"DaemonProcessRuntimeClasspath.getMainClass()");
        stringArray[0] = clazz.getName();
        GeneralCommandLine generalCommandLine2 = generalCommandLine.withParameters(stringArray).withParameters(daemonLaunchOptions.asCmdlineArgs());
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"createJavaVmCommandLine(\u2026hOptions.asCmdlineArgs())");
        return generalCommandLine2;
    }

    @Override
    @NotNull
    protected BaseOSProcessHandler createProcessHandler(@NotNull DaemonHandshakeTransport transport) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        GeneralCommandLine commandLine = this.createCommandLine(transport);
        return this.createProcessHandler((ProcessHandshakeTransport)transport, commandLine);
    }

    public DaemonProcessLauncher(@NotNull ProcessMediatorClient.Builder clientBuilder) {
        Intrinsics.checkNotNullParameter((Object)clientBuilder, (String)"clientBuilder");
        this.clientBuilder = clientBuilder;
    }
}

