/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.elevation;

import com.intellij.application.Topics;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ElevationService;
import com.intellij.execution.process.elevation.ElevationBundle;
import com.intellij.execution.process.elevation.ElevationDaemonProcessLauncher;
import com.intellij.execution.process.elevation.ElevationLogger;
import com.intellij.execution.process.elevation.settings.ElevationSettings;
import com.intellij.execution.process.mediator.client.MediatedProcess;
import com.intellij.execution.process.mediator.client.MediatedProcessHandler;
import com.intellij.execution.process.mediator.client.ProcessMediatorClient;
import com.intellij.execution.process.mediator.daemon.QuotaExceededException;
import com.intellij.execution.process.mediator.daemon.QuotaOptions;
import com.intellij.execution.process.mediator.launcher.ProcessMediatorConnection;
import com.intellij.execution.process.mediator.launcher.ProcessMediatorConnectionManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J'\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00140\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/execution/process/elevation/ElevationServiceImpl;", "Lcom/intellij/execution/process/ElevationService;", "Lcom/intellij/openapi/Disposable;", "()V", "connectionManager", "Lcom/intellij/execution/process/mediator/launcher/ProcessMediatorConnectionManager;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "authorizeService", "", "createProcess", "Lcom/intellij/execution/process/mediator/client/MediatedProcess;", "processBuilder", "Ljava/lang/ProcessBuilder;", "createProcessHandler", "Lcom/intellij/execution/process/mediator/client/MediatedProcessHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "dispose", "tryRelaunchingDaemonUntilHaveQuotaPermit", "R", "block", "Lkotlin/Function1;", "Lcom/intellij/execution/process/mediator/client/ProcessMediatorClient;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "intellij.platform.elevation"})
public final class ElevationServiceImpl
implements ElevationService,
Disposable {
    private final CoroutineScope coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)EmptyCoroutineContext.INSTANCE));
    private final ProcessMediatorConnectionManager connectionManager;
    private static final int MAX_RELAUNCHING_DAEMON_UNTIL_HAVE_QUOTA_PERMIT_ATTEMPTS = 3;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void authorizeService() {
        this.connectionManager.launchDaemonAndConnectIfNeeded();
    }

    @NotNull
    public MediatedProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        ProcessBuilder processBuilder = commandLine.toProcessBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)processBuilder, (String)"commandLine.toProcessBuilder()");
        ProcessBuilder processBuilder2 = processBuilder;
        MediatedProcess process2 = this.createProcess(processBuilder2);
        return new MediatedProcessHandler(process2, commandLine);
    }

    @NotNull
    public MediatedProcess createProcess(@NotNull ProcessBuilder processBuilder) {
        Intrinsics.checkNotNullParameter((Object)processBuilder, (String)"processBuilder");
        if (!ElevationSettings.Companion.getInstance().askEnableKeepAuthIfNeeded()) {
            throw (Throwable)new ProcessCanceledException();
        }
        return (MediatedProcess)this.tryRelaunchingDaemonUntilHaveQuotaPermit((Function1)new Function1<ProcessMediatorClient, MediatedProcess>(processBuilder){
            final /* synthetic */ ProcessBuilder $processBuilder;

            @NotNull
            public final MediatedProcess invoke(@NotNull ProcessMediatorClient client) {
                Intrinsics.checkNotNullParameter((Object)client, (String)"client");
                MediatedProcess mediatedProcess = MediatedProcess.Companion.create(client, this.$processBuilder);
                boolean bl = false;
                boolean bl2 = false;
                MediatedProcess $this$apply = mediatedProcess;
                boolean bl3 = false;
                ElevationLogger.INSTANCE.getLOG().info("Created process PID " + $this$apply.pid());
                return mediatedProcess;
            }
            {
                this.$processBuilder = processBuilder;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final <R> R tryRelaunchingDaemonUntilHaveQuotaPermit(Function1<? super ProcessMediatorClient, ? extends R> block) {
        int maxAttempts = 3;
        boolean bl = true;
        int n = maxAttempts;
        while (true) {
            ProcessMediatorConnection connection = this.connectionManager.launchDaemonAndConnectIfNeeded();
            try {
                return (R)block.invoke((Object)connection.getClient());
            }
            catch (Exception e) {
                void attempt;
                if (!(e instanceof RejectedExecutionException) && !(e instanceof QuotaExceededException)) {
                    throw (Throwable)e;
                }
                if (attempt > true) {
                    ElevationLogger.INSTANCE.getLOG().warn("Repeated launch error after " + (int)attempt + " attempts; " + "quota options: " + ElevationSettings.Companion.getInstance().getQuotaOptions(), (Throwable)e);
                }
                this.connectionManager.parkConnection(connection);
                if (attempt != n) {
                    ++attempt;
                    continue;
                }
                throw (Throwable)new ExecutionException(ElevationBundle.message("dialog.message.unable.to.configure.elevation.daemon.after.attempts", maxAttempts));
            }
            break;
        }
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    public ElevationServiceImpl() {
        void it;
        ProcessMediatorConnectionManager $this$apply;
        ProcessMediatorConnectionManager processMediatorConnectionManager = new ProcessMediatorConnectionManager((Function0<? extends ProcessMediatorConnection>)((Function0)new Function0<ProcessMediatorConnection>(this){
            final /* synthetic */ ElevationServiceImpl this$0;

            @NotNull
            public final ProcessMediatorConnection invoke() {
                ProcessMediatorClient.Builder clientBuilder = new ProcessMediatorClient.Builder(ElevationServiceImpl.access$getCoroutineScope$p(this.this$0), ElevationSettings.Companion.getInstance().getQuotaOptions());
                boolean debug2 = false;
                ElevationDaemonProcessLauncher elevationDaemonProcessLauncher = new ElevationDaemonProcessLauncher(clientBuilder);
                String string = ElevationBundle.message("progress.title.starting.elevation.daemon", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ElevationBundle.message(\u2026arting.elevation.daemon\")");
                return (ProcessMediatorConnection)elevationDaemonProcessLauncher.launchWithProgress(string);
            }
            {
                this.this$0 = elevationServiceImpl;
                super(0);
            }
        }));
        boolean bl = false;
        boolean bl2 = false;
        ProcessMediatorConnectionManager processMediatorConnectionManager2 = processMediatorConnectionManager;
        ElevationServiceImpl elevationServiceImpl = this;
        boolean bl3 = false;
        Topics.subscribe(ElevationSettings.Listener.TOPIC, (Disposable)$this$apply, (Object)new ElevationSettings.Listener($this$apply){
            final /* synthetic */ ProcessMediatorConnectionManager $this_apply;

            public void onDaemonQuotaOptionsChanged(@NotNull QuotaOptions oldValue, @NotNull QuotaOptions newValue2) {
                Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
                Intrinsics.checkNotNullParameter((Object)newValue2, (String)"newValue");
                this.$this_apply.adjustQuota(newValue2);
            }
            {
                this.$this_apply = $receiver;
            }
        });
        Unit unit = Unit.INSTANCE;
        bl = false;
        bl2 = false;
        $this$apply = processMediatorConnectionManager;
        boolean bl4 = false;
        Disposer.register((Disposable)this, (Disposable)((Disposable)it));
        unit = Unit.INSTANCE;
        elevationServiceImpl.connectionManager = processMediatorConnectionManager;
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(ElevationServiceImpl $this) {
        return $this.coroutineScope;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/execution/process/elevation/ElevationServiceImpl$Companion;", "", "()V", "MAX_RELAUNCHING_DAEMON_UNTIL_HAVE_QUOTA_PERMIT_ATTEMPTS", "", "intellij.platform.elevation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

