/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import org.jetbrains.annotations.NotNull;

public class EditorMergedHorizontalScrollBarLayout
extends AbstractLayoutManager {
    private final JScrollBar myScrollBar;
    private final EditorEx myFirst;
    private final EditorEx mySecond;
    private final boolean myForceAdditionalColumnsUsage;
    private final int myMinLineCount;

    public EditorMergedHorizontalScrollBarLayout(@NotNull JScrollBar scrollBar, @NotNull EditorEx first, @NotNull EditorEx second, boolean forceAdditionalColumnsUsage, int minLineCount) {
        if (scrollBar == null) {
            EditorMergedHorizontalScrollBarLayout.$$$reportNull$$$0(0);
        }
        if (first == null) {
            EditorMergedHorizontalScrollBarLayout.$$$reportNull$$$0(1);
        }
        if (second == null) {
            EditorMergedHorizontalScrollBarLayout.$$$reportNull$$$0(2);
        }
        this.myScrollBar = scrollBar;
        this.myFirst = first;
        this.mySecond = second;
        this.myForceAdditionalColumnsUsage = forceAdditionalColumnsUsage;
        this.myMinLineCount = minLineCount;
    }

    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    public void layoutContainer(@NotNull Container parent) {
        int componentCount;
        if (parent == null) {
            EditorMergedHorizontalScrollBarLayout.$$$reportNull$$$0(3);
        }
        if ((componentCount = parent.getComponentCount()) == 0) {
            return;
        }
        EditorEx history = this.myFirst;
        EditorEx input = this.mySecond;
        if (!input.getComponent().isVisible()) {
            parent.getComponent(0).setBounds(parent.getBounds());
            return;
        }
        Dimension panelSize = parent.getSize();
        if (this.myScrollBar.isVisible()) {
            Dimension size = this.myScrollBar.getPreferredSize();
            if (panelSize.height < size.height) {
                return;
            }
            panelSize.height -= size.height;
            this.myScrollBar.setBounds(0, panelSize.height, panelSize.width, size.height);
        }
        if (panelSize.getHeight() <= 0.0) {
            return;
        }
        Dimension historySize = history.getContentSize();
        Dimension inputSize = input.getContentSize();
        if (this.myForceAdditionalColumnsUsage) {
            history.getSoftWrapModel().forceAdditionalColumnsUsage();
            int minAdditionalColumns = 2;
            int historySpaceWidth = EditorUtil.getPlainSpaceWidth(history);
            historySize.width += historySpaceWidth * (minAdditionalColumns - history.getSettings().getAdditionalColumnsCount());
            int inputSpaceWidth = EditorUtil.getPlainSpaceWidth(input);
            inputSize.width += inputSpaceWidth * (minAdditionalColumns - input.getSettings().getAdditionalColumnsCount());
            int max = Math.max(historySize.width, inputSize.width);
            history.getSettings().setAdditionalColumnsCount(minAdditionalColumns + (max - historySize.width) / historySpaceWidth);
            input.getSettings().setAdditionalColumnsCount(minAdditionalColumns + (max - inputSize.width) / inputSpaceWidth);
        }
        if (history.getDocument().getLineCount() == 0) {
            historySize.height = 0;
        }
        int minHistoryHeight = historySize.height > 0 ? this.myMinLineCount * history.getLineHeight() : 0;
        int minInputHeight = input.isViewer() ? 0 : input.getLineHeight();
        int inputPreferredHeight = input.isViewer() ? 0 : Math.max(minInputHeight, inputSize.height);
        int historyPreferredHeight = Math.max(minHistoryHeight, historySize.height);
        int newInputHeight = panelSize.height < minInputHeight ? panelSize.height : (panelSize.height < inputPreferredHeight ? panelSize.height - minHistoryHeight : (panelSize.height < inputPreferredHeight + historyPreferredHeight || inputPreferredHeight == 0 ? inputPreferredHeight : panelSize.height - historyPreferredHeight));
        int oldHistoryHeight = history.getComponent().getHeight();
        int newHistoryHeight = panelSize.height - newInputHeight;
        int delta = newHistoryHeight - newHistoryHeight / history.getLineHeight() * history.getLineHeight();
        input.getComponent().setBounds(0, newHistoryHeight -= delta, panelSize.width, newInputHeight += delta);
        history.getComponent().setBounds(0, 0, panelSize.width, newHistoryHeight);
        input.getComponent().doLayout();
        history.getComponent().doLayout();
        if (newHistoryHeight < oldHistoryHeight) {
            JViewport viewport = history.getScrollPane().getViewport();
            Point position = viewport.getViewPosition();
            position.translate(0, oldHistoryHeight - newHistoryHeight);
            viewport.setViewPosition(position);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollBar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/console/EditorMergedHorizontalScrollBarLayout";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "layoutContainer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

