/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerProvider;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRunConfigurationAction
extends ActionGroup
implements UpdateInBackground {
    protected static final Logger LOG = Logger.getInstance(BaseRunConfigurationAction.class);
    @Nullable
    private static Integer ourLastTimeoutStamp = null;

    protected BaseRunConfigurationAction(@NotNull Supplier<String> text2, @NotNull Supplier<String> description, Icon icon2) {
        if (text2 == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(0);
        }
        if (description == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(1);
        }
        super(text2, description, icon2);
        this.setPopup(true);
        this.setEnabledInModalContext(true);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = e != null ? this.getChildren(e.getDataContext(), e.getPlace()) : EMPTY_ARRAY;
        if (anActionArray == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(2);
        }
        return anActionArray;
    }

    private AnAction[] getChildren(DataContext dataContext, @Nullable String place) {
        if (dataContext.getData(ExecutorAction.getOrderKey()) != null) {
            return EMPTY_ARRAY;
        }
        ConfigurationContext context2 = ConfigurationContext.getFromContext((DataContext)dataContext, (String)place);
        if (!Registry.is((String)"suggest.all.run.configurations.from.context") && this.findExisting(context2) != null) {
            return EMPTY_ARRAY;
        }
        return this.createChildActions(context2, this.getConfigurationsFromContext(context2)).toArray(EMPTY_ARRAY);
    }

    @Nullable
    protected RunnerAndConfigurationSettings findExisting(ConfigurationContext context2) {
        return context2.findExisting();
    }

    @NotNull
    protected List<AnAction> createChildActions(@NotNull ConfigurationContext context2, @NotNull List<? extends ConfigurationFromContext> configurations) {
        if (context2 == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(3);
        }
        if (configurations == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(4);
        }
        if (configurations.size() <= 1) {
            List<AnAction> list2 = Collections.emptyList();
            if (list2 == null) {
                BaseRunConfigurationAction.$$$reportNull$$$0(5);
            }
            return list2;
        }
        ArrayList<AnAction> childActions = new ArrayList<AnAction>();
        for (final ConfigurationFromContext configurationFromContext : configurations) {
            ConfigurationType configurationType = configurationFromContext.getConfigurationType();
            String actionName = BaseRunConfigurationAction.childActionName(configurationFromContext);
            AnAction anAction2 = new AnAction(actionName, configurationType.getDisplayName(), configurationFromContext.getConfiguration().getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    BaseRunConfigurationAction.this.perform(configurationFromContext, ConfigurationContext.getFromContext((DataContext)e.getDataContext(), (String)e.getPlace()));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/actions/BaseRunConfigurationAction$1", "actionPerformed"));
                }
            };
            anAction2.getTemplatePresentation().setText(actionName, false);
            childActions.add(anAction2);
        }
        ArrayList<AnAction> arrayList = childActions;
        if (arrayList == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private List<ConfigurationFromContext> getConfigurationsFromContext(ConfigurationContext context2) {
        List fromContext = context2.getConfigurationsFromContext();
        if (fromContext == null) {
            List<ConfigurationFromContext> list2 = Collections.emptyList();
            if (list2 == null) {
                BaseRunConfigurationAction.$$$reportNull$$$0(7);
            }
            return list2;
        }
        ArrayList<ConfigurationFromContext> enabledConfigurations = new ArrayList<ConfigurationFromContext>();
        for (ConfigurationFromContext configurationFromContext : fromContext) {
            if (!this.isEnabledFor(configurationFromContext.getConfiguration(), context2)) continue;
            enabledConfigurations.add(configurationFromContext);
        }
        ArrayList<ConfigurationFromContext> arrayList = enabledConfigurations;
        if (arrayList == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    protected boolean isEnabledFor(RunConfiguration configuration2) {
        return true;
    }

    protected boolean isEnabledFor(RunConfiguration configuration2, ConfigurationContext context2) {
        return this.isEnabledFor(configuration2);
    }

    public boolean canBePerformed(@NotNull DataContext dataContext) {
        Project project;
        if (dataContext == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(9);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) != null && DumbService.isDumb((Project)project)) {
            return false;
        }
        ConfigurationContext context2 = ConfigurationContext.getFromContext((DataContext)dataContext, (String)"unknown");
        RunnerAndConfigurationSettings existing = this.findExisting(context2);
        if (existing == null) {
            List<ConfigurationFromContext> fromContext = this.getConfigurationsFromContext(context2);
            return fromContext.size() <= 1 || dataContext.getData(ExecutorAction.getOrderKey()) != null;
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(10);
        }
        DataContext dataContext = e.getDataContext();
        MacroManager.getInstance().cacheMacrosPreview(e.getDataContext());
        ConfigurationContext context2 = ConfigurationContext.getFromContext((DataContext)dataContext, (String)e.getPlace());
        RunnerAndConfigurationSettings existing = this.findExisting(context2);
        if (existing == null || dataContext.getData(ExecutorAction.getOrderKey()) != null) {
            List<ConfigurationFromContext> producers2 = this.getConfigurationsFromContext(context2);
            if (producers2.isEmpty()) {
                return;
            }
            this.perform(BaseRunConfigurationAction.getOrderedConfiguration(dataContext, producers2), context2);
            return;
        }
        if (LOG.isDebugEnabled()) {
            String configurationClass = existing.getConfiguration().getClass().getName();
            LOG.debug(String.format("Use existing run configuration: %s", configurationClass));
        }
        this.perform(context2);
    }

    private static ConfigurationFromContext getOrderedConfiguration(DataContext dataContext, List<ConfigurationFromContext> producers2) {
        Integer order = dataContext.getData(ExecutorAction.getOrderKey());
        if (order != null && order < producers2.size()) {
            return producers2.get(order);
        }
        return producers2.get(0);
    }

    private void perform(ConfigurationFromContext configurationFromContext, ConfigurationContext context2) {
        int eventCount = IdeEventQueue.getInstance().getEventCount();
        RunnerAndConfigurationSettings configurationSettings = configurationFromContext.getConfigurationSettings();
        context2.setConfiguration(configurationSettings);
        configurationFromContext.onFirstRun(context2, () -> {
            if (LOG.isDebugEnabled()) {
                RunnerAndConfigurationSettings settings2 = context2.getConfiguration();
                RunConfiguration configuration2 = settings2 == null ? null : settings2.getConfiguration();
                String configurationClass = configuration2 == null ? null : configuration2.getClass().getName();
                LOG.debug(String.format("Create run configuration: %s", configurationClass));
            }
            if (!Utils.isAsyncDataContext(context2.getDataContext()) && eventCount != IdeEventQueue.getInstance().getEventCount()) {
                IdeEventQueue.getInstance().setEventCount(eventCount);
            }
            this.perform(configurationSettings, context2);
        });
    }

    protected void perform(RunnerAndConfigurationSettings configurationSettings, ConfigurationContext context2) {
        this.perform(context2);
    }

    protected abstract void perform(ConfigurationContext var1);

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(11);
        }
        this.fullUpdate(e);
    }

    public void update(@NotNull AnActionEvent event) {
        boolean success2;
        ThreeState hadAnythingRunnable;
        if (event == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(12);
        }
        boolean doFullUpdate = !ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode();
        VirtualFile vFile = (VirtualFile)event.getDataContext().getData(CommonDataKeys.VIRTUAL_FILE);
        ThreeState threeState = hadAnythingRunnable = vFile == null ? ThreeState.UNSURE : RunLineMarkerProvider.hadAnythingRunnable(vFile);
        if (doFullUpdate || hadAnythingRunnable == ThreeState.UNSURE) {
            this.fullUpdate(event);
            return;
        }
        boolean bl = success2 = !BaseRunConfigurationAction.alreadyExceededTimeoutOnSimilarAction() && ProgressIndicatorUtils.withTimeout(Registry.intValue((String)"run.configuration.update.timeout"), () -> {
            this.fullUpdate(event);
            return true;
        }) != null;
        if (!success2) {
            BaseRunConfigurationAction.recordUpdateTimeout();
            this.approximatePresentationByPreviousAvailability(event, hadAnythingRunnable);
        }
    }

    private static boolean alreadyExceededTimeoutOnSimilarAction() {
        return Objects.equals(IdeEventQueue.getInstance().getEventCount(), ourLastTimeoutStamp);
    }

    private static void recordUpdateTimeout() {
        ourLastTimeoutStamp = IdeEventQueue.getInstance().getEventCount();
    }

    protected void approximatePresentationByPreviousAvailability(AnActionEvent event, ThreeState hadAnythingRunnable) {
        event.getPresentation().copyFrom(this.getTemplatePresentation());
        event.getPresentation().setEnabledAndVisible(hadAnythingRunnable == ThreeState.YES);
    }

    protected void fullUpdate(@NotNull AnActionEvent event) {
        if (event == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(13);
        }
        DataContext dataContext = event.getDataContext();
        ConfigurationContext context2 = ConfigurationContext.getFromContext((DataContext)dataContext, (String)event.getPlace());
        Presentation presentation2 = event.getPresentation();
        RunnerAndConfigurationSettings existing = this.findExisting(context2);
        RunnerAndConfigurationSettings configuration2 = existing;
        if (configuration2 == null) {
            configuration2 = context2.getConfiguration();
        }
        if (configuration2 == null) {
            presentation2.setEnabledAndVisible(false);
        } else {
            presentation2.setEnabledAndVisible(true);
            VirtualFile vFile = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE);
            if (vFile != null) {
                RunLineMarkerProvider.markRunnable(vFile, true);
            }
            List<ConfigurationFromContext> fromContext = this.getConfigurationsFromContext(context2);
            if (existing == null && fromContext.isEmpty()) {
                presentation2.setEnabledAndVisible(false);
                return;
            }
            if (!(existing != null && dataContext.getData(ExecutorAction.getOrderKey()) == null || fromContext.isEmpty())) {
                ConfigurationFromContext configurationFromContext = BaseRunConfigurationAction.getOrderedConfiguration(dataContext, fromContext);
                configuration2 = configurationFromContext.getConfigurationSettings();
                context2.setConfiguration(configurationFromContext.getConfigurationSettings());
            }
            String name = BaseRunConfigurationAction.suggestRunActionName(configuration2.getConfiguration());
            this.updatePresentation(presentation2, existing != null || fromContext.size() <= 1 || dataContext.getData(ExecutorAction.getOrderKey()) != null ? name : "", context2);
        }
    }

    public boolean isDumbAware() {
        return false;
    }

    @NotNull
    @Nls
    public static String suggestRunActionName(@NotNull RunConfiguration configuration2) {
        String actionName;
        if (configuration2 == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(14);
        }
        if (configuration2 instanceof LocatableConfigurationBase && ((LocatableConfigurationBase)configuration2).isGeneratedName() && (actionName = ((LocatableConfigurationBase)configuration2).getActionName()) != null) {
            String string = actionName;
            if (string == null) {
                BaseRunConfigurationAction.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = ProgramRunnerUtil.shortenName(configuration2.getName(), 0);
        if (string == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static String suggestRunActionName(@NotNull LocatableConfiguration configuration2) {
        if (configuration2 == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(17);
        }
        return BaseRunConfigurationAction.suggestRunActionName((RunConfiguration)configuration2);
    }

    @NotNull
    @Nls
    private static String childActionName(ConfigurationFromContext configurationFromContext) {
        String locationDisplayName;
        RunConfiguration configuration2 = configurationFromContext.getConfiguration();
        if (!(configuration2 instanceof LocatableConfiguration)) {
            String string = configurationFromContext.getConfigurationType().getDisplayName();
            if (string == null) {
                BaseRunConfigurationAction.$$$reportNull$$$0(18);
            }
            return string;
        }
        if (configurationFromContext.isFromAlternativeLocation() && (locationDisplayName = configurationFromContext.getAlternativeLocationDisplayName()) != null) {
            String string = ((LocatableConfigurationBase)configuration2).getActionName() + " " + locationDisplayName;
            if (string == null) {
                BaseRunConfigurationAction.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = StringUtil.unquoteString((String)BaseRunConfigurationAction.suggestRunActionName(configurationFromContext.getConfiguration()));
        if (string == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(20);
        }
        return string;
    }

    protected abstract void updatePresentation(Presentation var1, @NotNull String var2, ConfigurationContext var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/BaseRunConfigurationAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/BaseRunConfigurationAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildActions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationsFromContext";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestRunActionName";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "childActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createChildActions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canBePerformed";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "beforeActionPerformedUpdate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fullUpdate";
                break;
            }
            case 14: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "suggestRunActionName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

