/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ListenerDiffViewerBase
extends DiffViewerBase {
    public ListenerDiffViewerBase(@NotNull DiffContext context2, @NotNull ContentDiffRequest request) {
        if (context2 == null) {
            ListenerDiffViewerBase.$$$reportNull$$$0(0);
        }
        if (request == null) {
            ListenerDiffViewerBase.$$$reportNull$$$0(1);
        }
        super(context2, request);
    }

    @Override
    protected void onInit() {
        super.onInit();
        BulkFileListener fileListener = this.createFileListener(this.myRequest);
        if (fileListener != null) {
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)fileListener);
        }
        DocumentListener documentListener = this.createDocumentListener();
        List documents = ContainerUtil.mapNotNull((Collection)this.myRequest.getContents(), content2 -> content2 instanceof DocumentContent ? ((DocumentContent)content2).getDocument() : null);
        TextDiffViewerUtil.installDocumentListeners(documentListener, documents, (Disposable)this);
    }

    @NotNull
    protected DocumentListener createDocumentListener() {
        return new DocumentListener(){

            public void beforeDocumentChange(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ListenerDiffViewerBase.this.onBeforeDocumentChange(event);
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                ListenerDiffViewerBase.this.onDocumentChange(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/diff/tools/util/base/ListenerDiffViewerBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeDocumentChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "documentChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    protected BulkFileListener createFileListener(@NotNull ContentDiffRequest request) {
        if (request == null) {
            ListenerDiffViewerBase.$$$reportNull$$$0(2);
        }
        final ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(0);
        for (DiffContent content2 : request.getContents()) {
            if (!(content2 instanceof FileContent) || content2 instanceof DocumentContent) continue;
            files2.add(((FileContent)content2).getFile());
        }
        if (files2.isEmpty()) {
            return null;
        }
        return new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file2;
                    if (!(vFileEvent instanceof VFileContentChangeEvent) && !(vFileEvent instanceof VFilePropertyChangeEvent) || !files2.contains(file2 = Objects.requireNonNull(vFileEvent.getFile()))) continue;
                    ListenerDiffViewerBase.this.onFileChange(file2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase$2", "after"));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    protected void onDocumentChange(@NotNull DocumentEvent documentEvent) {
        void event;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (event == null) {
            ListenerDiffViewerBase.$$$reportNull$$$0(3);
        }
        this.scheduleRediff();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    protected void onBeforeDocumentChange(@NotNull DocumentEvent documentEvent) {
        void event;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (event == null) {
            ListenerDiffViewerBase.$$$reportNull$$$0(4);
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    protected void onFileChange(@NotNull VirtualFile virtualFile2) {
        void file2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (file2 == null) {
            ListenerDiffViewerBase.$$$reportNull$$$0(5);
        }
        this.scheduleRediff();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/util/base/ListenerDiffViewerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onDocumentChange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onBeforeDocumentChange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onFileChange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

