/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.requests.BinaryMergeRequestImpl;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.requests.TextMergeRequestImpl;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.vcs.DiffVcsFacade;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffRequestFactoryImpl
extends DiffRequestFactory {
    @NlsSafe
    public static final String DIFF_TITLE_SEPARATOR = " - ";
    @NlsSafe
    public static final String DIFF_TITLE_RENAME_SEPARATOR = " -> ";
    private final DiffContentFactoryEx myContentFactory = DiffContentFactoryEx.getInstanceEx();

    @NotNull
    public ContentDiffRequest createFromFiles(@Nullable Project project, @Nullable VirtualFile file1, @Nullable VirtualFile file2) {
        assert (file1 != null || file2 != null);
        EmptyContent content1 = file1 != null ? this.myContentFactory.create(project, file1) : this.myContentFactory.createEmpty();
        EmptyContent content2 = file2 != null ? this.myContentFactory.create(project, file2) : this.myContentFactory.createEmpty();
        String title1 = this.getContentTitle(file1);
        String title2 = this.getContentTitle(file2);
        String title3 = this.getTitle(file1, file2);
        return new SimpleDiffRequest(title3, (DiffContent)content1, (DiffContent)content2, title1, title2);
    }

    @NotNull
    public ContentDiffRequest createFromFiles(@Nullable Project project, @NotNull VirtualFile leftFile, @NotNull VirtualFile baseFile, @NotNull VirtualFile rightFile) {
        if (leftFile == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(0);
        }
        if (baseFile == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(1);
        }
        if (rightFile == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(2);
        }
        DiffContent content1 = this.myContentFactory.create(project, leftFile);
        DiffContent content2 = this.myContentFactory.create(project, baseFile);
        DiffContent content3 = this.myContentFactory.create(project, rightFile);
        String title1 = this.getContentTitle(leftFile);
        String title2 = this.getContentTitle(baseFile);
        String title3 = this.getContentTitle(rightFile);
        return new SimpleDiffRequest(null, content1, content2, content3, title1, title2, title3);
    }

    @NotNull
    public ContentDiffRequest createClipboardVsValue(@NotNull String value2) {
        if (value2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(3);
        }
        DiffContent content1 = this.myContentFactory.createClipboardContent();
        DocumentContent content2 = this.myContentFactory.create(value2);
        String title1 = DiffBundle.message((String)"diff.content.clipboard.content.title", (Object[])new Object[0]);
        String title2 = DiffBundle.message((String)"diff.content.selected.value", (Object[])new Object[0]);
        String title3 = DiffBundle.message((String)"diff.clipboard.vs.value.dialog.title", (Object[])new Object[0]);
        return new SimpleDiffRequest(title3, content1, (DiffContent)content2, title1, title2);
    }

    @Nullable
    public String getContentTitle(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        return DiffRequestFactoryImpl.getContentTitle(DiffVcsFacade.getInstance().getFilePath(file2));
    }

    @NotNull
    public String getTitle(@Nullable VirtualFile file1, @Nullable VirtualFile file2) {
        FilePath path1 = file1 != null ? DiffVcsFacade.getInstance().getFilePath(file1) : null;
        FilePath path2 = file2 != null ? DiffVcsFacade.getInstance().getFilePath(file2) : null;
        return DiffRequestFactoryImpl.getTitle(path1, path2, DIFF_TITLE_SEPARATOR);
    }

    @NotNull
    public String getTitle(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(4);
        }
        String string = this.getTitle(file2, null);
        if (string == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nls
    @NotNull
    public static String getContentTitle(@NotNull FilePath path2) {
        if (path2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(6);
        }
        if (path2.isDirectory()) {
            String string = path2.getPresentableUrl();
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(7);
            }
            return string;
        }
        FilePath parent = path2.getParentPath();
        return DiffRequestFactoryImpl.getContentTitle(path2.getName(), path2.getPresentableUrl(), parent != null ? parent.getPresentableUrl() : null);
    }

    @Nls
    @NotNull
    public static String getTitle(@Nullable FilePath path1, @Nullable FilePath path2, @NotNull @Nls String separator) {
        if (separator == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(8);
        }
        assert (path1 != null || path2 != null);
        if (path1 == null || path2 == null) {
            return DiffRequestFactoryImpl.getContentTitle((FilePath)ObjectUtils.chooseNotNull((Object)path1, (Object)path2));
        }
        if ((path1.isDirectory() || path2.isDirectory()) && path1.getPath().equals(path2.getPath())) {
            String string = path1.getPresentableUrl();
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(9);
            }
            return string;
        }
        Object name1 = path1.getName();
        Object name2 = path2.getName();
        if (path1.isDirectory() ^ path2.isDirectory()) {
            if (path1.isDirectory()) {
                name1 = (String)name1 + File.separatorChar;
            }
            if (path2.isDirectory()) {
                name2 = (String)name2 + File.separatorChar;
            }
        }
        FilePath parent1 = path1.getParentPath();
        FilePath parent2 = path2.getParentPath();
        return DiffRequestFactoryImpl.getRequestTitle((String)name1, path1.getPresentableUrl(), parent1 != null ? parent1.getPresentableUrl() : null, (String)name2, path2.getPresentableUrl(), parent2 != null ? parent2.getPresentableUrl() : null, separator);
    }

    @Nls
    @NotNull
    private static String getContentTitle(@NotNull @Nls String name, @NotNull @Nls String path2, @Nullable @Nls String parentPath) {
        if (name == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(10);
        }
        if (path2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(11);
        }
        if (parentPath != null) {
            String string = name + " (" + parentPath + ")";
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = path2;
        if (string == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nls
    @NotNull
    private static String getRequestTitle(@NotNull @Nls String name1, @NotNull @Nls String path1, @Nullable @Nls String parentPath1, @NotNull @Nls String name2, @NotNull @Nls String path2, @Nullable @Nls String parentPath2, @NotNull @Nls String sep) {
        if (name1 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(14);
        }
        if (path1 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(15);
        }
        if (name2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(16);
        }
        if (path2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(17);
        }
        if (sep == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(18);
        }
        if (path1.equals(path2)) {
            return DiffRequestFactoryImpl.getContentTitle(name1, path1, parentPath1);
        }
        if (Objects.equals(parentPath1, parentPath2)) {
            if (parentPath1 != null) {
                String string = name1 + sep + name2 + " (" + parentPath1 + ")";
                if (string == null) {
                    DiffRequestFactoryImpl.$$$reportNull$$$0(19);
                }
                return string;
            }
            String string = path1 + sep + path2;
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(20);
            }
            return string;
        }
        if (name1.equals(name2)) {
            if (parentPath1 != null && parentPath2 != null) {
                String string = name1 + " (" + parentPath1 + sep + parentPath2 + ")";
                if (string == null) {
                    DiffRequestFactoryImpl.$$$reportNull$$$0(21);
                }
                return string;
            }
            String string = path1 + sep + path2;
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(22);
            }
            return string;
        }
        if (parentPath1 != null && parentPath2 != null) {
            String string = name1 + sep + name2 + " (" + parentPath1 + sep + parentPath2 + ")";
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = path1 + sep + path2;
        if (string == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project, @Nullable FileType fileType, @NotNull Document outputDocument, @NotNull List<String> textContents, @Nullable @NlsContexts.DialogTitle String title2, @NotNull List<@Nls String> titles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (outputDocument == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(25);
        }
        if (textContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(26);
        }
        if (titles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(27);
        }
        if (textContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (titles.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (!DiffUtil.canMakeWritable(outputDocument)) {
            throw new InvalidDiffRequestException("Output is read only");
        }
        DocumentContent outputContent = this.myContentFactory.create(project, outputDocument, fileType);
        CharSequence originalContent = outputDocument.getImmutableCharSequence();
        ArrayList<DocumentContent> contents = new ArrayList<DocumentContent>(3);
        for (String text2 : textContents) {
            contents.add(this.myContentFactory.create(project, text2, fileType));
        }
        TextMergeRequestImpl request = new TextMergeRequestImpl(project, outputContent, originalContent, contents, title2, titles);
        MergeRequest mergeRequest = MergeCallback.register((MergeRequest)request, applyCallback);
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(28);
        }
        return mergeRequest;
    }

    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project, @NotNull VirtualFile output2, @NotNull List<byte[]> byteContents, @Nullable @NlsContexts.DialogTitle String title2, @NotNull List<@Nls String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(29);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(30);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(31);
        }
        MergeRequest request = this.createMergeRequest(project, output2, byteContents, title2, contentTitles);
        MergeRequest mergeRequest = MergeCallback.register((MergeRequest)request, applyCallback);
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(32);
        }
        return mergeRequest;
    }

    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project, @NotNull VirtualFile output2, @NotNull List<byte[]> byteContents, @Nullable @NlsContexts.DialogTitle String title2, @NotNull List<@Nls String> contentTitles) throws InvalidDiffRequestException {
        if (output2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(33);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(34);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(35);
        }
        try {
            return this.createTextMergeRequest(project, output2, byteContents, title2, contentTitles);
        }
        catch (InvalidDiffRequestException e) {
            return this.createBinaryMergeRequest(project, output2, byteContents, title2, contentTitles);
        }
    }

    @NotNull
    public TextMergeRequest createTextMergeRequest(@Nullable Project project, @NotNull VirtualFile output2, @NotNull List<byte[]> byteContents, @Nullable @NlsContexts.DialogTitle String title2, @NotNull List<@Nls String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(36);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(37);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(38);
        }
        TextMergeRequest request = this.createTextMergeRequest(project, output2, byteContents, title2, contentTitles);
        TextMergeRequest textMergeRequest = (TextMergeRequest)MergeCallback.register((MergeRequest)request, applyCallback);
        if (textMergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(39);
        }
        return textMergeRequest;
    }

    @NotNull
    private TextMergeRequest createTextMergeRequest(@Nullable Project project, @NotNull VirtualFile output2, @NotNull List<byte[]> byteContents, @Nullable @NlsContexts.DialogTitle String title2, @NotNull List<@Nls String> contentTitles) throws InvalidDiffRequestException {
        if (output2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(40);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(41);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(42);
        }
        if (byteContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        Document outputDocument = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(output2));
        if (outputDocument == null) {
            throw new InvalidDiffRequestException("Can't get output document: " + output2.getPresentableUrl());
        }
        if (!DiffUtil.canMakeWritable(outputDocument)) {
            throw new InvalidDiffRequestException("Output is read only: " + output2.getPresentableUrl());
        }
        DocumentContent outputContent = this.myContentFactory.create(project, outputDocument);
        CharSequence originalContent = outputDocument.getImmutableCharSequence();
        ArrayList<DocumentContent> contents = new ArrayList<DocumentContent>(3);
        for (byte[] bytes : byteContents) {
            contents.add(this.myContentFactory.createDocumentFromBytes(project, (byte[])ObjectUtils.notNull((Object)bytes, (Object)ArrayUtilRt.EMPTY_BYTE_ARRAY), output2));
        }
        return new TextMergeRequestImpl(project, outputContent, originalContent, contents, title2, contentTitles);
    }

    @NotNull
    public MergeRequest createBinaryMergeRequest(@Nullable Project project, @NotNull VirtualFile output2, @NotNull List<byte[]> byteContents, @Nullable @NlsContexts.DialogTitle String title2, @NotNull List<@Nls String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(43);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(44);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(45);
        }
        MergeRequest request = this.createBinaryMergeRequest(project, output2, byteContents, title2, contentTitles);
        MergeRequest mergeRequest = MergeCallback.register((MergeRequest)request, applyCallback);
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(46);
        }
        return mergeRequest;
    }

    @NotNull
    private MergeRequest createBinaryMergeRequest(@Nullable Project project, @NotNull VirtualFile output2, @NotNull List<byte[]> byteContents, @Nullable @NlsContexts.DialogTitle String title2, @NotNull List<@Nls String> contentTitles) throws InvalidDiffRequestException {
        if (output2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(47);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(48);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(49);
        }
        if (byteContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            FileContent outputContent = this.myContentFactory.createFile(project, output2);
            if (outputContent == null) {
                throw new InvalidDiffRequestException("Can't process file: " + output2);
            }
            byte[] originalContent = (byte[])ReadAction.compute(() -> output2.contentsToByteArray());
            ArrayList<DiffContent> contents = new ArrayList<DiffContent>(3);
            for (byte[] bytes : byteContents) {
                contents.add(this.myContentFactory.createFromBytes(project, (byte[])ObjectUtils.notNull((Object)bytes, (Object)ArrayUtilRt.EMPTY_BYTE_ARRAY), output2));
            }
            return new BinaryMergeRequestImpl(project, outputContent, originalContent, contents, byteContents, title2, contentTitles);
        }
        catch (IOException e) {
            throw new InvalidDiffRequestException("Can't read from file", (Throwable)e);
        }
    }

    @NotNull
    public MergeRequest createMergeRequestFromFiles(@Nullable Project project, @NotNull VirtualFile output2, @NotNull List<? extends VirtualFile> fileContents, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(50);
        }
        if (fileContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(51);
        }
        String title2 = DiffBundle.message((String)"merge.window.title.file", (Object[])new Object[]{output2.getPresentableUrl()});
        List<String> titles = Arrays.asList(DiffBundle.message((String)"merge.version.title.our", (Object[])new Object[0]), DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]), DiffBundle.message((String)"merge.version.title.their", (Object[])new Object[0]));
        MergeRequest mergeRequest = this.createMergeRequestFromFiles(project, output2, fileContents, title2, titles, applyCallback);
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(52);
        }
        return mergeRequest;
    }

    @NotNull
    public MergeRequest createMergeRequestFromFiles(@Nullable Project project, @NotNull VirtualFile output2, @NotNull List<? extends VirtualFile> fileContents, @Nullable String title2, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        TextMergeRequest textMergeRequest;
        if (output2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(53);
        }
        if (fileContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(54);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(55);
        }
        if (fileContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            textMergeRequest = this.createTextMergeRequestFromFiles(project, output2, fileContents, title2, contentTitles, applyCallback);
        }
        catch (InvalidDiffRequestException e) {
            MergeRequest mergeRequest = this.createBinaryMergeRequestFromFiles(project, output2, fileContents, title2, contentTitles, applyCallback);
            if (mergeRequest == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(57);
            }
            return mergeRequest;
        }
        if (textMergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(56);
        }
        return textMergeRequest;
    }

    @NotNull
    public TextMergeRequest createTextMergeRequestFromFiles(@Nullable Project project, @NotNull VirtualFile output2, @NotNull List<? extends VirtualFile> fileContents, @Nullable String title2, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(58);
        }
        if (fileContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(59);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(60);
        }
        ArrayList<byte[]> byteContents = new ArrayList<byte[]>(3);
        for (VirtualFile virtualFile2 : fileContents) {
            try {
                byteContents.add((byte[])ReadAction.compute(() -> file2.contentsToByteArray()));
            }
            catch (IOException e) {
                throw new InvalidDiffRequestException("Can't read from file: " + virtualFile2.getPresentableUrl(), (Throwable)e);
            }
        }
        TextMergeRequest textMergeRequest = this.createTextMergeRequest(project, output2, byteContents, title2, contentTitles, applyCallback);
        if (textMergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(61);
        }
        return textMergeRequest;
    }

    @NotNull
    public MergeRequest createBinaryMergeRequestFromFiles(@Nullable Project project, @NotNull VirtualFile output2, @NotNull List<? extends VirtualFile> fileContents, @Nullable @NlsContexts.DialogTitle String title2, @NotNull List<@Nls String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        MergeRequest mergeRequest;
        if (output2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(62);
        }
        if (fileContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(63);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(64);
        }
        if (fileContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            FileContent outputContent = this.myContentFactory.createFile(project, output2);
            if (outputContent == null) {
                throw new InvalidDiffRequestException("Can't process file: " + output2.getPresentableUrl());
            }
            byte[] originalContent = (byte[])ReadAction.compute(() -> output2.contentsToByteArray());
            ArrayList<DiffContent> contents = new ArrayList<DiffContent>(3);
            ArrayList<byte[]> byteContents = new ArrayList<byte[]>(3);
            for (VirtualFile virtualFile2 : fileContents) {
                FileContent content2 = this.myContentFactory.createFile(project, virtualFile2);
                if (content2 == null) {
                    throw new InvalidDiffRequestException("Can't process file: " + virtualFile2.getPresentableUrl());
                }
                contents.add((DiffContent)content2);
                byteContents.add((byte[])ReadAction.compute(() -> file2.contentsToByteArray()));
            }
            BinaryMergeRequestImpl request = new BinaryMergeRequestImpl(project, outputContent, originalContent, contents, byteContents, title2, contentTitles);
            mergeRequest = MergeCallback.register((MergeRequest)request, applyCallback);
        }
        catch (IOException e) {
            throw new InvalidDiffRequestException("Can't read from file", (Throwable)e);
        }
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(65);
        }
        return mergeRequest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 32: 
            case 39: 
            case 46: 
            case 52: 
            case 56: 
            case 57: 
            case 61: 
            case 65: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 32: 
            case 39: 
            case 46: 
            case 52: 
            case 56: 
            case 57: 
            case 61: 
            case 65: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 32: 
            case 39: 
            case 46: 
            case 52: 
            case 56: 
            case 57: 
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/DiffRequestFactoryImpl";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name1";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path1";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path2";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sep";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDocument";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textContents";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titles";
                break;
            }
            case 29: 
            case 33: 
            case 36: 
            case 40: 
            case 43: 
            case 47: 
            case 50: 
            case 53: 
            case 58: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 30: 
            case 34: 
            case 37: 
            case 41: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteContents";
                break;
            }
            case 31: 
            case 35: 
            case 38: 
            case 42: 
            case 45: 
            case 49: 
            case 55: 
            case 60: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentTitles";
                break;
            }
            case 51: 
            case 54: 
            case 59: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/DiffRequestFactoryImpl";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 7: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentTitle";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestTitle";
                break;
            }
            case 28: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createMergeRequest";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextMergeRequest";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinaryMergeRequest";
                break;
            }
            case 52: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "createMergeRequestFromFiles";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextMergeRequestFromFiles";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinaryMergeRequestFromFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFromFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createClipboardVsValue";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 32: 
            case 39: 
            case 46: 
            case 52: 
            case 56: 
            case 57: 
            case 61: 
            case 65: {
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getContentTitle";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRequestTitle";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createMergeRequest";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createTextMergeRequest";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryMergeRequest";
                break;
            }
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createMergeRequestFromFiles";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createTextMergeRequestFromFiles";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryMergeRequestFromFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 32: 
            case 39: 
            case 46: 
            case 52: 
            case 56: 
            case 57: 
            case 61: 
            case 65: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

