/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.diagnostic.ThreadDumper;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class SamplingTask {
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private static final List<GarbageCollectorMXBean> GC_MX_BEANS = ManagementFactory.getGarbageCollectorMXBeans();
    private final int myDumpInterval;
    private final int myMaxDumps;
    private final List<ThreadInfo[]> myThreadInfos = new ArrayList<ThreadInfo[]>();
    private final ScheduledFuture<?> myFuture;
    private final long myStartTime;
    private long myCurrentTime;
    private final long myGcStartTime;
    private long myGcCurrentTime;
    private final double myProcessCpuLoad;

    public SamplingTask(int intervalMs, int maxDurationMs) {
        this.myDumpInterval = intervalMs;
        this.myMaxDumps = maxDurationMs / intervalMs;
        this.myCurrentTime = this.myStartTime = System.nanoTime();
        this.myGcCurrentTime = this.myGcStartTime = SamplingTask.currentGcTime();
        this.myProcessCpuLoad = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getProcessCpuLoad();
        ScheduledExecutorService executor = PerformanceWatcher.getInstance().getExecutor();
        this.myFuture = executor.scheduleWithFixedDelay(this::dumpThreads, 0L, this.myDumpInterval, TimeUnit.MILLISECONDS);
    }

    private void dumpThreads() {
        this.myCurrentTime = System.nanoTime();
        this.myGcCurrentTime = SamplingTask.currentGcTime();
        ThreadInfo[] infos = ThreadDumper.getThreadInfos((ThreadMXBean)THREAD_MX_BEAN, (boolean)false);
        if (!this.myFuture.isCancelled()) {
            this.myThreadInfos.add(infos);
            if (this.myThreadInfos.size() >= this.myMaxDumps) {
                this.stop();
            }
            this.dumpedThreads(ThreadDumper.getThreadDumpInfo((ThreadInfo[])infos));
        }
    }

    protected void dumpedThreads(@NotNull ThreadDump threadDump) {
        if (threadDump == null) {
            SamplingTask.$$$reportNull$$$0(0);
        }
    }

    private static long currentGcTime() {
        return GC_MX_BEANS.stream().mapToLong(GarbageCollectorMXBean::getCollectionTime).sum();
    }

    public final int getDumpInterval() {
        return this.myDumpInterval;
    }

    public final List<ThreadInfo[]> getThreadInfos() {
        return this.myThreadInfos;
    }

    public final long getTotalTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.myCurrentTime - this.myStartTime);
    }

    public final long getGcTime() {
        return this.myGcCurrentTime - this.myGcStartTime;
    }

    public final double getProcessCpuLoad() {
        return this.myProcessCpuLoad;
    }

    public final boolean isValid(long dumpingDuration) {
        return (long)this.myThreadInfos.size() >= Math.max(10L, Math.min((long)this.myMaxDumps, dumpingDuration / (long)this.myDumpInterval / 2L));
    }

    public void stop() {
        this.myFuture.cancel(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadDump", "com/intellij/diagnostic/SamplingTask", "dumpedThreads"));
    }
}

