/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JitWatcher {
    private static final Logger LOG = Logger.getInstance(JitWatcher.class);
    private final AtomicBoolean myJitProblemReported = new AtomicBoolean();
    private Method myIsCompilationEnabledMethod;
    private Method myIsCompilationStoppedForeverMethod;
    @NotNull
    private CompilerState myCompilationStateLastValue = CompilerState.STATE_UNKNOWN;

    JitWatcher() {
        try {
            Class<?> clazz = Class.forName("com.jetbrains.management.JitState");
            this.myIsCompilationEnabledMethod = clazz.getMethod("isCompilationEnabled", new Class[0]);
            this.myIsCompilationEnabledMethod.setAccessible(true);
            this.myIsCompilationStoppedForeverMethod = clazz.getMethod("isCompilationStoppedForever", new Class[0]);
            this.myIsCompilationStoppedForeverMethod.setAccessible(true);
            this.myCompilationStateLastValue = this.getJitCompilerState();
            LOG.info("JIT compilation state checking enabled");
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            LOG.debug("Could not enable JIT compilation state checking", (Throwable)e);
        }
    }

    void checkJitState() {
        CompilerState compilationStateCurrentValue = this.getJitCompilerState();
        if (compilationStateCurrentValue != this.myCompilationStateLastValue) {
            this.myCompilationStateLastValue = compilationStateCurrentValue;
            switch (this.myCompilationStateLastValue) {
                case STATE_UNKNOWN: {
                    break;
                }
                case DISABLED: {
                    this.notifyJitDisabled();
                    LOG.warn("The JIT compiler was temporary disabled.");
                    break;
                }
                case ENABLED: {
                    LOG.warn("The JIT compiler was enabled.");
                    break;
                }
                case STOPPED_FOREVER: {
                    this.notifyJitDisabled();
                    LOG.warn("The JIT compiler was stopped forever. This will affect IDE performance.");
                }
            }
        }
    }

    private void notifyJitDisabled() {
        if (this.myJitProblemReported.compareAndSet(false, true)) {
            final ApplicationEx app = ApplicationManagerEx.getApplicationEx();
            String action2 = IdeBundle.message((String)(app.isRestartCapable() ? "ide.restart.action" : "ide.shutdown.action"), (Object[])new Object[0]);
            String title2 = IdeBundle.message((String)"notification.title.jit.compiler.disabled", (Object[])new Object[0]);
            String content2 = IdeBundle.message((String)"notification.content.jit.compiler.disabled", (Object[])new Object[0]);
            new Notification("PerformanceWatcher", title2, content2, NotificationType.ERROR).setListener((NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (e == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if ("help".equals(e.getDescription())) {
                        HelpManager.getInstance().invokeHelp("Tuning_product_");
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/diagnostic/JitWatcher$2";
                    objectArray[2] = "hyperlinkActivated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }).addAction((AnAction)new NotificationAction(action2){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    notification.expire();
                    app.restart(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/diagnostic/JitWatcher$1";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }).notify(null);
        }
    }

    @Nullable
    String getJitProblem() {
        if (this.myCompilationStateLastValue == CompilerState.DISABLED || this.myCompilationStateLastValue == CompilerState.STOPPED_FOREVER) {
            return "JIT compiler " + this.myCompilationStateLastValue;
        }
        return null;
    }

    private CompilerState getJitCompilerState() {
        if (this.myIsCompilationEnabledMethod != null && this.myIsCompilationStoppedForeverMethod != null) {
            try {
                boolean compilationStateCurrentValue = (Boolean)this.myIsCompilationEnabledMethod.invoke(null, new Object[0]);
                if (((Boolean)this.myIsCompilationStoppedForeverMethod.invoke(null, new Object[0])).booleanValue()) {
                    return CompilerState.STOPPED_FOREVER;
                }
                if (compilationStateCurrentValue) {
                    return CompilerState.ENABLED;
                }
                return CompilerState.DISABLED;
            }
            catch (IllegalAccessException | IllegalStateException | InvocationTargetException e) {
                LOG.error("Could not perform compilation state check, disabling", (Throwable)e);
                this.myIsCompilationEnabledMethod = null;
                this.myIsCompilationStoppedForeverMethod = null;
            }
        }
        return CompilerState.STATE_UNKNOWN;
    }

    private static enum CompilerState {
        STATE_UNKNOWN,
        DISABLED,
        ENABLED,
        STOPPED_FOREVER;

    }
}

