/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.FakeDirectoryBasedStateSplitter;
import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.StateAnnotation;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.configurationStore.StreamProviderFactory;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"MODULE_FILE_STORAGE_ANNOTATION", "Lcom/intellij/configurationStore/FileStorageAnnotation;", "getProjectStateStorage", "Lcom/intellij/configurationStore/StateStorageBase;", "Lcom/intellij/configurationStore/StateMap;", "filePath", "", "store", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "project", "Lcom/intellij/openapi/project/Project;", "getStorageSpec", "Lcom/intellij/openapi/components/Storage;", "intellij.platform.configurationStore.impl"})
public final class ProjectStoreBridgeKt {
    private static final FileStorageAnnotation MODULE_FILE_STORAGE_ANNOTATION = new FileStorageAnnotation("$MODULE_FILE$", false);

    @Nullable
    public static final StateStorageBase<StateMap> getProjectStateStorage(@NotNull String filePath, @NotNull IProjectStore store, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Storage storage2 = ProjectStoreBridgeKt.getStorageSpec(filePath, project);
        if (storage2 == null) {
            return null;
        }
        Storage storageSpec = storage2;
        StateStorage stateStorage = store.getStorageManager().getStateStorage(storageSpec);
        if (stateStorage == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.configurationStore.StateStorageBase<com.intellij.configurationStore.StateMap>");
        }
        return (StateStorageBase)stateStorage;
    }

    private static final Storage getStorageSpec(String filePath, Project project) {
        String collapsedPath = null;
        Class<StateSplitterEx> splitterClass = null;
        String string = PathUtil.getFileName((String)filePath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtil.getFileName(filePath)");
        String fileName = string;
        String string2 = PathUtil.getParentPath((String)filePath);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PathUtil.getParentPath(filePath)");
        String parentPath = string2;
        String string3 = PathUtil.getFileName((String)parentPath);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"PathUtil.getFileName(parentPath)");
        String parentFileName = string3;
        if (FileUtil.extensionEquals((String)filePath, (String)"ipr") || Intrinsics.areEqual((Object)fileName, (Object)"misc.xml") && Intrinsics.areEqual((Object)parentFileName, (Object)".idea")) {
            collapsedPath = "$PROJECT_FILE$";
            splitterClass = StateSplitterEx.class;
        } else if (Intrinsics.areEqual((Object)parentFileName, (Object)".idea")) {
            collapsedPath = fileName;
            splitterClass = StateSplitterEx.class;
        } else {
            String string4 = PathUtil.getParentPath((String)parentPath);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"PathUtil.getParentPath(parentPath)");
            String grandParentPath = string4;
            collapsedPath = parentFileName;
            splitterClass = FakeDirectoryBasedStateSplitter.class;
            if (Intrinsics.areEqual((Object)PathUtil.getFileName((String)grandParentPath), (Object)".idea") ^ true) {
                List list2 = StreamProviderFactory.Companion.getEP_NAME().getExtensions((AreaInstance)project);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"StreamProviderFactory.EP\u2026ME.getExtensions(project)");
                StreamProviderFactory streamProviderFactory = (StreamProviderFactory)CollectionsKt.firstOrNull((List)list2);
                if (streamProviderFactory == null) {
                    return null;
                }
                StreamProviderFactory providerFactory = streamProviderFactory;
                if (Intrinsics.areEqual((Object)parentFileName, (Object)"project")) {
                    if (Intrinsics.areEqual((Object)fileName, (Object)"libraries.xml") || Intrinsics.areEqual((Object)fileName, (Object)"artifacts.xml")) {
                        FileStorageAnnotation inProjectStorage = new FileStorageAnnotation(FileUtil.getNameWithoutExtension((String)fileName), false, splitterClass);
                        String componentName = Intrinsics.areEqual((Object)fileName, (Object)"libraries.xml") ? "libraryTable" : "ArtifactManager";
                        return providerFactory.getOrCreateStorageSpec(fileName, new StateAnnotation(componentName, inProjectStorage));
                    }
                    if (Intrinsics.areEqual((Object)fileName, (Object)"modules.xml")) {
                        return StreamProviderFactory.DefaultImpls.getOrCreateStorageSpec$default(providerFactory, fileName, null, 2, null);
                    }
                }
                String string5 = filePath + " is not under .idea directory and not under external system cache";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string5.toString());
            }
        }
        return new FileStorageAnnotation(collapsedPath, false, splitterClass);
    }

    public static final /* synthetic */ FileStorageAnnotation access$getMODULE_FILE_STORAGE_ANNOTATION$p() {
        return MODULE_FILE_STORAGE_ANNOTATION;
    }
}

