/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.configurationStore.DirectoryBasedSaveSessionProducer;
import com.intellij.configurationStore.ProjectStoreBridgeKt;
import com.intellij.configurationStore.ProjectWithModulesSaveSessionProducerManager;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.components.impl.ModulePathMacroManager;
import com.intellij.openapi.components.impl.ProjectPathMacroManager;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileContentWriter;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsProjectSerializersImplKt;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/configurationStore/JpsStorageContentWriter;", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileContentWriter;", "session", "Lcom/intellij/configurationStore/ProjectWithModulesSaveSessionProducerManager;", "store", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/configurationStore/ProjectWithModulesSaveSessionProducerManager;Lcom/intellij/openapi/components/impl/stores/IProjectStore;Lcom/intellij/openapi/project/Project;)V", "getReplacePathMacroMap", "Lcom/intellij/openapi/components/PathMacroMap;", "fileUrl", "", "saveComponent", "", "componentName", "componentTag", "Lorg/jdom/Element;", "intellij.platform.configurationStore.impl"})
final class JpsStorageContentWriter
implements JpsFileContentWriter {
    private final ProjectWithModulesSaveSessionProducerManager session;
    private final IProjectStore store;
    private final Project project;

    @Override
    public void saveComponent(@NotNull String fileUrl, @NotNull String componentName, @Nullable Element componentTag) {
        block2: {
            SaveSessionProducer producer;
            block4: {
                String filePath;
                block3: {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
                        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
                        filePath = JpsPathUtil.urlToPath((String)fileUrl);
                        if (!FileUtil.extensionEquals((String)filePath, (String)"iml")) break block1;
                        String string = filePath;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filePath");
                        this.session.setModuleComponentState(string, componentName, componentTag);
                        break block2;
                    }
                    String string = filePath;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filePath");
                    if (!JpsProjectSerializersImplKt.isExternalModuleFile(string)) break block3;
                    String string2 = FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)filePath));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtil.getNameWithoutE\u2026il.getFileName(filePath))");
                    this.session.setExternalModuleComponentState(string2, componentName, componentTag);
                    break block2;
                }
                StateStorageBase<StateMap> stateStorageBase = ProjectStoreBridgeKt.getProjectStateStorage(filePath, this.store, this.project);
                if (stateStorageBase == null) {
                    return;
                }
                StateStorageBase<StateMap> stateStorage = stateStorageBase;
                producer = this.session.getProducer(stateStorage);
                if (!(producer instanceof DirectoryBasedSaveSessionProducer)) break block4;
                DirectoryBasedSaveSessionProducer directoryBasedSaveSessionProducer = (DirectoryBasedSaveSessionProducer)producer;
                String string = PathUtil.getFileName((String)filePath);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtil.getFileName(filePath)");
                Object object = componentTag;
                directoryBasedSaveSessionProducer.setFileState(string, componentName, object != null && (object = object.getChildren()) != null ? (Element)CollectionsKt.first((List)object) : null);
                break block2;
            }
            SaveSessionProducer saveSessionProducer = producer;
            if (saveSessionProducer == null) break block2;
            saveSessionProducer.setState(null, componentName, (Object)componentTag);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PathMacroMap getReplacePathMacroMap(@NotNull String fileUrl) {
        PathMacroMap pathMacroMap;
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        String filePath = JpsPathUtil.urlToPath((String)fileUrl);
        if (!FileUtil.extensionEquals((String)filePath, (String)"iml")) {
            String string = filePath;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filePath");
            if (!JpsProjectSerializersImplKt.isExternalModuleFile(string)) {
                PathMacroManager pathMacroManager = ProjectPathMacroManager.getInstance((ComponentManager)this.project);
                Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"ProjectPathMacroManager.getInstance(project)");
                ReplacePathToMacroMap replacePathToMacroMap = pathMacroManager.getReplacePathMap();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)replacePathToMacroMap), (String)"ProjectPathMacroManager.\u2026e(project).replacePathMap");
                pathMacroMap = replacePathToMacroMap;
                return pathMacroMap;
            }
        }
        ModulePathMacroManager modulePathMacroManager = ModulePathMacroManager.createInstance(new Supplier(filePath){
            final /* synthetic */ String $filePath;

            public final String get() {
                return this.$filePath;
            }
            {
                this.$filePath = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)modulePathMacroManager, (String)"ModulePathMacroManager.c\u2026ce(Supplier { filePath })");
        ReplacePathToMacroMap replacePathToMacroMap = modulePathMacroManager.getReplacePathMap();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)replacePathToMacroMap), (String)"ModulePathMacroManager.c\u2026ilePath }).replacePathMap");
        pathMacroMap = replacePathToMacroMap;
        return pathMacroMap;
    }

    public JpsStorageContentWriter(@NotNull ProjectWithModulesSaveSessionProducerManager session2, @NotNull IProjectStore store, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.session = session2;
        this.store = store;
        this.project = project;
    }
}

