/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.BlockSaving;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ConfigurationStoreBundle;
import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.FileBasedStorageConfiguration;
import com.intellij.configurationStore.FileBasedStorageConfigurationKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.ReadOnlyModificationException;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StorageManagerFileWriteRequestor;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.configurationStore.XmlElementStorageKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.openapi.util.SafeStAXStreamBuilder;
import com.intellij.openapi.util.StaxFactory;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.io.IoKt;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import javax.xml.stream.XMLStreamException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.codehaus.stax2.XMLStreamReader2;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001:\u0001<BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010$\u001a\u0004\u0018\u00010\u00112\u0006\u0010%\u001a\u00020&J\b\u0010'\u001a\u00020(H\u0014J\n\u0010)\u001a\u0004\u0018\u00010*H\u0014J\n\u0010+\u001a\u0004\u0018\u00010*H\u0002J\n\u0010,\u001a\u0004\u0018\u00010*H\u0002J\u000e\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020\u001aJ\u0018\u0010/\u001a\u00020(2\u000e\u00100\u001a\n\u0018\u000101j\u0004\u0018\u0001`2H\u0002J$\u00103\u001a\u0004\u0018\u0001H4\"\u0004\b\u0000\u001042\f\u00105\u001a\b\u0012\u0004\u0012\u0002H406H\u0082\b\u00a2\u0006\u0002\u00107J\u001a\u00108\u001a\u00020(2\b\u00109\u001a\u0004\u0018\u00010\u00112\b\u0010:\u001a\u0004\u0018\u00010\u0003J\b\u0010;\u001a\u00020\u0005H\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001aX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/configurationStore/FileBasedStorage;", "Lcom/intellij/configurationStore/XmlElementStorage;", "file", "Ljava/nio/file/Path;", "fileSpec", "", "rootElementName", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/PathMacroSubstitutor;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/configurationStore/StreamProvider;)V", "blockSaving", "Lcom/intellij/configurationStore/BlockSaving;", "cachedVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "configuration", "Lcom/intellij/configurationStore/FileBasedStorageConfiguration;", "getConfiguration", "()Lcom/intellij/configurationStore/FileBasedStorageConfiguration;", "<set-?>", "getFile", "()Ljava/nio/file/Path;", "isUseUnixLineSeparator", "", "()Z", "isUseVfsForWrite", "isUseXmlProlog", "lineSeparator", "Lcom/intellij/util/LineSeparator;", "createSaveSession", "Lcom/intellij/configurationStore/FileBasedStorage$FileSaveSession;", "states", "Lcom/intellij/configurationStore/StateMap;", "getVirtualFile", "reasonOperation", "Lcom/intellij/openapi/components/StateStorageOperation;", "handleVirtualFileNotFound", "", "loadLocalData", "Lorg/jdom/Element;", "loadLocalDataUsingIo", "loadUsingVfs", "preloadStorageData", "isEmpty", "processReadException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "runAndHandleExceptions", "T", "task", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "setFile", "virtualFile", "ioFileIfChanged", "toString", "FileSaveSession", "intellij.platform.configurationStore.impl"})
public class FileBasedStorage
extends XmlElementStorage {
    private volatile VirtualFile cachedVirtualFile;
    private LineSeparator lineSeparator;
    private BlockSaving blockSaving;
    @NotNull
    private volatile Path file;
    private final boolean isUseXmlProlog;

    @NotNull
    public final Path getFile() {
        return this.file;
    }

    @NotNull
    protected FileBasedStorageConfiguration getConfiguration() {
        return FileBasedStorageConfigurationKt.getDefaultFileBasedStorageConfiguration();
    }

    protected boolean isUseXmlProlog() {
        return this.isUseXmlProlog;
    }

    @Override
    public final boolean isUseVfsForWrite() {
        return this.getConfiguration().isUseVfsForWrite();
    }

    private final boolean isUseUnixLineSeparator() {
        return !this.isUseXmlProlog();
    }

    public final void setFile(@Nullable VirtualFile virtualFile2, @Nullable Path ioFileIfChanged) {
        this.cachedVirtualFile = virtualFile2;
        if (ioFileIfChanged != null) {
            this.file = ioFileIfChanged;
        }
    }

    @Override
    @NotNull
    protected FileSaveSession createSaveSession(@NotNull StateMap states) {
        Intrinsics.checkNotNullParameter((Object)states, (String)"states");
        return new FileSaveSession(states, this);
    }

    @Nullable
    public final VirtualFile getVirtualFile(@NotNull StateStorageOperation reasonOperation) {
        Intrinsics.checkNotNullParameter((Object)reasonOperation, (String)"reasonOperation");
        VirtualFile result2 = this.cachedVirtualFile;
        if (result2 == null) {
            this.cachedVirtualFile = result2 = this.getConfiguration().resolveVirtualFile(PathKt.getSystemIndependentPath((Path)this.file), reasonOperation);
        }
        return result2;
    }

    private final <T> T runAndHandleExceptions(Function0<? extends T> task2) {
        int $i$f$runAndHandleExceptions = 0;
        try {
            return (T)task2.invoke();
        }
        catch (JDOMException e) {
            this.processReadException((Exception)((Object)e));
        }
        catch (XMLStreamException e) {
            this.processReadException(e);
        }
        catch (IOException e) {
            this.processReadException(e);
        }
        return null;
    }

    public final void preloadStorageData(boolean isEmpty) {
        if (isEmpty) {
            this.getStorageDataRef().set(StateMap.Companion.getEMPTY$intellij_platform_configurationStore_impl());
        } else {
            this.getStorageData();
        }
    }

    @Override
    @Nullable
    protected Element loadLocalData() {
        Element element2;
        block4: {
            this.blockSaving = null;
            FileBasedStorage this_$iv = this;
            boolean $i$f$runAndHandleExceptions = false;
            try {
                boolean bl = false;
                element2 = this.getConfiguration().isUseVfsForRead() ? this.loadUsingVfs() : this.loadLocalDataUsingIo();
                break block4;
            }
            catch (JDOMException e$iv) {
                this_$iv.processReadException((Exception)((Object)e$iv));
            }
            catch (XMLStreamException e$iv) {
                this_$iv.processReadException(e$iv);
            }
            catch (IOException e$iv) {
                this_$iv.processReadException(e$iv);
            }
            element2 = null;
        }
        return element2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Element loadLocalDataUsingIo() {
        BasicFileAttributes attributes2 = null;
        try {
            attributes2 = Files.readAttributes(this.file, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException e) {
            Logger $this$debug$iv = ComponentStoreImplKt.getLOG();
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv;
                boolean bl = false;
                String string = "Document was not loaded for " + this.getFileSpec() + ", doesn't exist";
                logger.debug(string, (Throwable)e$iv);
            }
            return null;
        }
        BasicFileAttributes basicFileAttributes = attributes2;
        Intrinsics.checkNotNullExpressionValue((Object)basicFileAttributes, (String)"attributes");
        if (!basicFileAttributes.isRegularFile()) {
            Logger $this$debug$iv = ComponentStoreImplKt.getLOG();
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv;
                boolean bl = false;
                String string = "Document was not loaded for " + this.getFileSpec() + ", not a file";
                logger.debug(string, (Throwable)e$iv);
            }
            return null;
        }
        if (attributes2.size() == 0L) {
            this.processReadException(null);
            return null;
        }
        if (this.isUseUnixLineSeparator()) {
            this.lineSeparator = LineSeparator.LF;
            InputStream inputStream2 = Files.newInputStream(this.file, new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"Files.newInputStream(file)");
            try (XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader((InputStream)inputStream2);){
                Element element2 = SafeStAXStreamBuilder.build((XMLStreamReader2)xmlStreamReader, (boolean)true, (boolean)false, (SafeJdomFactory)SafeStAXStreamBuilder.FACTORY);
                return element2;
            }
        }
        InputStream inputStream3 = CharsetToolkit.inputStreamSkippingBOM((InputStream)Files.newInputStream(this.file, new OpenOption[0]));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream3, (String)"CharsetToolkit.inputStre\u2026les.newInputStream(file))");
        InputStream inputStream4 = inputStream3;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        CharSequence data2 = IoKt.readCharSequence((Reader)new InputStreamReader(inputStream4, charset), (int)((int)attributes2.size()));
        this.lineSeparator = FileBasedStorageKt.detectLineSeparators(data2, this.isUseXmlProlog() ? null : LineSeparator.LF);
        return JDOMUtil.load((CharSequence)data2);
    }

    private final Element loadUsingVfs() {
        CharBuffer charBuffer;
        VirtualFile virtualFile2 = this.getVirtualFile(StateStorageOperation.READ);
        if (virtualFile2 == null || !virtualFile2.exists()) {
            this.handleVirtualFileNotFound();
            return null;
        }
        byte[] byteArray = virtualFile2.contentsToByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byteArray, (String)"byteArray");
        byte[] byArray = byteArray;
        boolean bl = false;
        if (byArray.length == 0) {
            this.processReadException(null);
            return null;
        }
        CharBuffer charBuffer2 = charBuffer = Charsets.UTF_8.decode(ByteBuffer.wrap(byteArray));
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer2, (String)"charBuffer");
        this.lineSeparator = FileBasedStorageKt.detectLineSeparators(charBuffer2, this.isUseXmlProlog() ? null : LineSeparator.LF);
        return JDOMUtil.load((CharSequence)charBuffer);
    }

    protected void handleVirtualFileNotFound() {
    }

    private final void processReadException(Exception e) {
        Application app;
        boolean contentTruncated;
        boolean bl = contentTruncated = e == null;
        if (!contentTruncated && (Intrinsics.areEqual((Object)this.getFileSpec(), (Object)"$PROJECT_FILE$") || StringsKt.startsWith$default((String)this.getFileSpec(), (String)"$PROJECT_CONFIG_DIR$", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)this.getFileSpec(), (Object)"$MODULE_FILE$") || Intrinsics.areEqual((Object)this.getFileSpec(), (Object)"$WORKSPACE_FILE$"))) {
            Object object = e;
            if (object == null || (object = ((Throwable)object).toString()) == null) {
                object = "empty file";
            }
            this.blockSaving = new BlockSaving((String)object);
        } else {
            this.blockSaving = null;
        }
        if (e != null) {
            ComponentStoreImplKt.getLOG().warn("Cannot read " + this.toString(), (Throwable)e);
        }
        Application application = app = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
        if (!application.isUnitTestMode() && !app.isHeadlessEnvironment()) {
            String string;
            if (contentTruncated) {
                string = ConfigurationStoreBundle.message("notification.load.settings.error.reason.truncated", new Object[0]);
            } else {
                Exception exception = e;
                Intrinsics.checkNotNull((Object)exception);
                string = exception.getMessage();
            }
            String reason = string;
            String string2 = this.blockSaving == null ? ConfigurationStoreBundle.message("notification.load.settings.action.content.will.be.recreated", new Object[0]) : ConfigurationStoreBundle.message("notification.load.settings.action.please.correct.file.content", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (blockSaving == null)\u2026se.correct.file.content\")");
            String action2 = string2;
            new Notification("System Messages", ConfigurationStoreBundle.message("notification.load.settings.title", new Object[0]), ConfigurationStoreBundle.message("notification.load.settings.content", this.file) + ": " + reason + '\n' + action2, NotificationType.WARNING).notify(null);
        }
    }

    @NotNull
    public String toString() {
        return "FileBasedStorage(file=" + this.file + ", fileSpec=" + this.getFileSpec() + ", isBlockSavingTheContent=" + this.blockSaving + ')';
    }

    public FileBasedStorage(@NotNull Path file2, @NotNull String fileSpec, @Nullable String rootElementName, @Nullable PathMacroSubstitutor pathMacroManager, @Nullable RoamingType roamingType, @Nullable StreamProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        super(fileSpec, rootElementName, pathMacroManager, roamingType, provider2);
        this.file = file2;
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isUnitTestMode() && StringsKt.startsWith$default((CharSequence)((Object)file2).toString(), (char)'$', (boolean)false, (int)2, null)) {
            throw (Throwable)((Object)new AssertionError((Object)("It seems like some macros were not expanded for path: " + file2)));
        }
    }

    public /* synthetic */ FileBasedStorage(Path path2, String string, String string2, PathMacroSubstitutor pathMacroSubstitutor, RoamingType roamingType, StreamProvider streamProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            pathMacroSubstitutor = null;
        }
        if ((n & 0x10) != 0) {
            roamingType = null;
        }
        if ((n & 0x20) != 0) {
            streamProvider = null;
        }
        this(path2, string, string2, pathMacroSubstitutor, roamingType, streamProvider);
    }

    public static final /* synthetic */ void access$setBlockSaving$p(FileBasedStorage $this, BlockSaving blockSaving) {
        $this.blockSaving = blockSaving;
    }

    public static final /* synthetic */ Path access$getFile$p(FileBasedStorage $this) {
        return $this.file;
    }

    public static final /* synthetic */ void access$setFile$p(FileBasedStorage $this, Path path2) {
        $this.file = path2;
    }

    public static final /* synthetic */ VirtualFile access$getCachedVirtualFile$p(FileBasedStorage $this) {
        return $this.cachedVirtualFile;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0014\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0004J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/configurationStore/FileBasedStorage$FileSaveSession;", "Lcom/intellij/configurationStore/XmlElementStorage$XmlElementStorageSaveSession;", "Lcom/intellij/configurationStore/FileBasedStorage;", "storageData", "Lcom/intellij/configurationStore/StateMap;", "storage", "(Lcom/intellij/configurationStore/StateMap;Lcom/intellij/configurationStore/FileBasedStorage;)V", "isSaveAllowed", "", "saveLocally", "", "dataWriter", "Lcom/intellij/configurationStore/DataWriter;", "intellij.platform.configurationStore.impl"})
    protected static class FileSaveSession
    extends XmlElementStorage.XmlElementStorageSaveSession<FileBasedStorage> {
        @Override
        protected final boolean isSaveAllowed() {
            if (!super.isSaveAllowed()) {
                return false;
            }
            if (((FileBasedStorage)this.getStorage()).blockSaving != null) {
                ComponentStoreImplKt.getLOG().warn("Save blocked for " + (FileBasedStorage)this.getStorage());
                return false;
            }
            return true;
        }

        @Override
        protected void saveLocally(@Nullable DataWriter dataWriter) {
            boolean isUseVfs;
            LineSeparator lineSeparator = ((FileBasedStorage)this.getStorage()).lineSeparator;
            if (lineSeparator == null) {
                lineSeparator = ((FileBasedStorage)this.getStorage()).isUseUnixLineSeparator() ? LineSeparator.LF : LineSeparator.getSystemLineSeparator();
                ((FileBasedStorage)this.getStorage()).lineSeparator = lineSeparator;
            }
            VirtualFile virtualFile2 = (isUseVfs = ((FileBasedStorage)this.getStorage()).getConfiguration().isUseVfsForWrite()) ? ((FileBasedStorage)this.getStorage()).getVirtualFile(StateStorageOperation.WRITE) : null;
            if (dataWriter == null) {
                if (isUseVfs && virtualFile2 == null) {
                    ComponentStoreImplKt.getLOG().warn("Cannot find virtual file " + virtualFile2);
                }
                FileBasedStorageKt.access$deleteFile(((FileBasedStorage)this.getStorage()).getFile(), (StorageManagerFileWriteRequestor)this, virtualFile2);
                ((FileBasedStorage)this.getStorage()).cachedVirtualFile = null;
            } else if (isUseVfs) {
                ((FileBasedStorage)this.getStorage()).cachedVirtualFile = FileBasedStorageKt.writeFile(((FileBasedStorage)this.getStorage()).getFile(), (StorageManagerFileWriteRequestor)this, virtualFile2, dataWriter, lineSeparator, ((FileBasedStorage)this.getStorage()).isUseXmlProlog());
            } else {
                Path file2 = ((FileBasedStorage)this.getStorage()).getFile();
                Logger $this$debug$iv = ComponentStoreImplKt.getLOG();
                Exception e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    Logger logger = $this$debug$iv;
                    boolean bl = false;
                    String string = "Save " + file2;
                    logger.debug(string, (Throwable)e$iv);
                }
                try {
                    String string = lineSeparator.getSeparatorString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator.separatorString");
                    XmlElementStorageKt.writeTo(dataWriter, file2, this, string);
                }
                catch (ReadOnlyModificationException e) {
                    throw (Throwable)e;
                }
                catch (Throwable e) {
                    throw (Throwable)new RuntimeException("Cannot write " + file2, e);
                }
            }
        }

        public FileSaveSession(@NotNull StateMap storageData, @NotNull FileBasedStorage storage2) {
            Intrinsics.checkNotNullParameter((Object)storageData, (String)"storageData");
            Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
            super(storageData, (XmlElementStorage)storage2);
        }
    }
}

