/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.api.graphql;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.collaboration.api.graphql.GraphQLFileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u001bB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\r\u001a\n \n*\u0004\u0018\u00010\u000e0\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0015J\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003J\"\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J.\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00142\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u00060\u000bR\u00020\u00000\u001aH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R^\u0010\b\u001aR\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u0003\u0012\u0014\u0012\u0012 \n*\b\u0018\u00010\u000bR\u00020\u00000\u000bR\u00020\u0000 \n*(\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u0003\u0012\u0014\u0012\u0012 \n*\b\u0018\u00010\u000bR\u00020\u00000\u000bR\u00020\u0000\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\f\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u0003 \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/collaboration/api/graphql/CachingGraphQLQueryLoader;", "", "fragmentsDirectory", "", "fragmentsFileExtension", "(Ljava/lang/String;Ljava/lang/String;)V", "fragmentDefinitionRegex", "Lkotlin/text/Regex;", "fragmentsCache", "Lcom/google/common/cache/Cache;", "kotlin.jvm.PlatformType", "Lcom/intellij/collaboration/api/graphql/CachingGraphQLQueryLoader$Fragment;", "queriesCache", "getFileStream", "Ljava/io/InputStream;", "relativePath", "loadQuery", "queryPath", "readCollectingFragmentNames", "Lkotlin/Pair;", "", "filePath", "readFragmentsWithDependencies", "", "names", "into", "", "Fragment", "intellij.platform.collaborationTools"})
public abstract class CachingGraphQLQueryLoader {
    private final Regex fragmentDefinitionRegex;
    private final Cache<String, Fragment> fragmentsCache;
    private final Cache<String, String> queriesCache;
    private final String fragmentsDirectory;
    private final String fragmentsFileExtension;

    @NotNull
    public final String loadQuery(@NotNull String queryPath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)queryPath, (String)"queryPath");
        Object object = this.queriesCache.get((Object)queryPath, new Callable(this, queryPath){
            final /* synthetic */ CachingGraphQLQueryLoader this$0;
            final /* synthetic */ String $queryPath;

            /*
             * WARNING - void declaration
             */
            public final String call() {
                void body;
                Pair pair = CachingGraphQLQueryLoader.access$readCollectingFragmentNames(this.this$0, this.$queryPath);
                String string = (String)pair.component1();
                Set fragmentNames = (Set)pair.component2();
                StringBuilder builder2 = new StringBuilder();
                LinkedHashMap<K, V> fragments = new LinkedHashMap<K, V>();
                CachingGraphQLQueryLoader.access$readFragmentsWithDependencies(this.this$0, fragmentNames, fragments);
                Collection<V> collection = fragments.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"fragments.values");
                for (Fragment fragment2 : CollectionsKt.reversed((Iterable)collection)) {
                    builder2.append(fragment2.getBody()).append("\n");
                }
                builder2.append((String)body);
                return builder2.toString();
            }
            {
                this.this$0 = cachingGraphQLQueryLoader;
                this.$queryPath = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"queriesCache.get(queryPa\u2026 builder.toString()\n    }");
        return (String)object;
    }

    /*
     * WARNING - void declaration
     */
    private final void readFragmentsWithDependencies(Set<String> names2, Map<String, Fragment> into) {
        for (String name : names2) {
            void $this$filterTo$iv$iv;
            Fragment fragment2 = (Fragment)this.fragmentsCache.get((Object)name, new Callable(this, name){
                final /* synthetic */ CachingGraphQLQueryLoader this$0;
                final /* synthetic */ String $name;

                public final Fragment call() {
                    return this.this$0.new Fragment(this.$name);
                }
                {
                    this.this$0 = cachingGraphQLQueryLoader;
                    this.$name = string;
                }
            });
            String string = fragment2.getName();
            Fragment fragment3 = fragment2;
            Intrinsics.checkNotNullExpressionValue((Object)fragment3, (String)"fragment");
            into.put(string, fragment3);
            Iterable $this$filter$iv = fragment2.getDependencies();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                Map<String, Fragment> map2 = into;
                boolean bl2 = false;
                Map<String, Fragment> map3 = map2;
                boolean bl3 = false;
                if (!(!map3.containsKey(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set nonProcessedDependencies = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            this.readFragmentsWithDependencies(nonProcessedDependencies, into);
        }
    }

    private final Pair<String, Set<String>> readCollectingFragmentNames(String filePath) {
        InputStream stream;
        StringBuilder bodyBuilder = new StringBuilder();
        boolean bl = false;
        Set fragments = new LinkedHashSet();
        boolean bl2 = false;
        Set innerFragments = new LinkedHashSet();
        InputStream inputStream2 = this.getFileStream(filePath);
        if (inputStream2 == null) {
            throw (Throwable)new GraphQLFileNotFoundException("Couldn't find file " + filePath);
        }
        InputStream inputStream3 = stream = inputStream2;
        Charset charset = Charsets.UTF_8;
        boolean bl3 = false;
        TextStreamsKt.forEachLine((Reader)new InputStreamReader(inputStream3, charset), (Function1)((Function1)new Function1<String, Unit>(this, bodyBuilder, innerFragments, fragments){
            final /* synthetic */ CachingGraphQLQueryLoader this$0;
            final /* synthetic */ StringBuilder $bodyBuilder;
            final /* synthetic */ Set $innerFragments;
            final /* synthetic */ Set $fragments;

            public final void invoke(@NotNull String it) {
                String fragmentName;
                int n;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it;
                boolean bl = false;
                String line = ((Object)StringsKt.trim((CharSequence)string)).toString();
                this.$bodyBuilder.append(line).append("\n");
                if (StringsKt.startsWith$default((String)line, (String)"fragment", (boolean)false, (int)2, null)) {
                    String string2;
                    Object object = CachingGraphQLQueryLoader.access$getFragmentDefinitionRegex$p(this.this$0).matchEntire((CharSequence)line);
                    if (object != null && (object = object.getGroupValues()) != null && (object = (String)object.get(1)) != null) {
                        Object object2 = object;
                        n = 0;
                        Object object3 = object2;
                        if (object3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString();
                    } else {
                        string2 = fragmentName = null;
                    }
                    if (fragmentName != null) {
                        this.$innerFragments.add(fragmentName);
                    }
                }
                if (StringsKt.startsWith$default((String)line, (String)"...", (boolean)false, (int)2, null) && line.length() > 3 && !CharsKt.isWhitespace((char)line.charAt(3))) {
                    String string3 = line;
                    n = 3;
                    boolean bl2 = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                    fragmentName = string5;
                    this.$fragments.add(fragmentName);
                }
            }
            {
                this.this$0 = cachingGraphQLQueryLoader;
                this.$bodyBuilder = stringBuilder;
                this.$innerFragments = set2;
                this.$fragments = set3;
                super(1);
            }
        }));
        fragments.removeAll(innerFragments);
        String string = bodyBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bodyBuilder.toString()");
        return TuplesKt.to((Object)StringsKt.removeSuffix((String)string, (CharSequence)"\n"), (Object)fragments);
    }

    @VisibleForTesting
    protected InputStream getFileStream(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return this.getClass().getClassLoader().getResourceAsStream(relativePath);
    }

    public CachingGraphQLQueryLoader(@NotNull String fragmentsDirectory, @NotNull String fragmentsFileExtension) {
        Intrinsics.checkNotNullParameter((Object)fragmentsDirectory, (String)"fragmentsDirectory");
        Intrinsics.checkNotNullParameter((Object)fragmentsFileExtension, (String)"fragmentsFileExtension");
        this.fragmentsDirectory = fragmentsDirectory;
        this.fragmentsFileExtension = fragmentsFileExtension;
        this.fragmentDefinitionRegex = new Regex("fragment (.*) on .*\\{");
        this.fragmentsCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).build();
        this.queriesCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    }

    public /* synthetic */ CachingGraphQLQueryLoader(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "graphql/fragment";
        }
        if ((n & 2) != 0) {
            string2 = "graphql";
        }
        this(string, string2);
    }

    public CachingGraphQLQueryLoader() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ void access$readFragmentsWithDependencies(CachingGraphQLQueryLoader $this, Set names2, Map into) {
        $this.readFragmentsWithDependencies(names2, into);
    }

    public static final /* synthetic */ Regex access$getFragmentDefinitionRegex$p(CachingGraphQLQueryLoader $this) {
        return $this.fragmentDefinitionRegex;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/collaboration/api/graphql/CachingGraphQLQueryLoader$Fragment;", "", "name", "", "(Lcom/intellij/collaboration/api/graphql/CachingGraphQLQueryLoader;Ljava/lang/String;)V", "body", "getBody", "()Ljava/lang/String;", "dependencies", "", "getDependencies", "()Ljava/util/Set;", "getName", "equals", "", "other", "hashCode", "", "intellij.platform.collaborationTools"})
    private final class Fragment {
        @NotNull
        private final String body;
        @NotNull
        private final Set<String> dependencies;
        @NotNull
        private final String name;

        @NotNull
        public final String getBody() {
            return this.body;
        }

        @NotNull
        public final Set<String> getDependencies() {
            return this.dependencies;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Fragment)) {
                return false;
            }
            return !(Intrinsics.areEqual((Object)this.name, (Object)((Fragment)other).name) ^ true);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        /*
         * WARNING - void declaration
         */
        public Fragment(String name) {
            void body;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            Pair pair = CachingGraphQLQueryLoader.this.readCollectingFragmentNames(CachingGraphQLQueryLoader.this.fragmentsDirectory + '/' + this.name + '.' + CachingGraphQLQueryLoader.this.fragmentsFileExtension);
            String string = (String)pair.component1();
            Set dependencies = (Set)pair.component2();
            this.body = body;
            this.dependencies = dependencies;
        }
    }
}

