/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.offlineViewer.OfflineInspectionRVContentProvider;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionNodeInfo;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionResultsViewUtil;
import com.intellij.codeInspection.ui.InspectionSeverityGroupNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeLoadingProgressAware;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionViewChangeAdapter;
import com.intellij.codeInspection.ui.InspectionViewNavigationPanel;
import com.intellij.codeInspection.ui.InspectionViewSuppressActionHolder;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.ProblemPreviewEditorPresentation;
import com.intellij.codeInspection.ui.QuickFixPreviewPanelFactory;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.RerunAction;
import com.intellij.codeInspection.ui.actions.ExportHTMLAction;
import com.intellij.codeInspection.ui.actions.InvokeQuickFixAction;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.exclusion.ExclusionHandler;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class InspectionResultsView
extends JPanel
implements Disposable,
DataProvider,
OccurenceNavigator {
    private static final Logger LOG = Logger.getInstance(InspectionResultsView.class);
    public static final DataKey<InspectionResultsView> DATA_KEY = DataKey.create("inspectionView");
    private static final Key<Boolean> PREVIEW_EDITOR_IS_REUSED_KEY = Key.create((String)"inspection.tool.window.preview.editor.is.reused");
    @NotNull
    private final InspectionTree myTree;
    private volatile InspectionProfileImpl myInspectionProfile;
    private final boolean mySettingsEnabled;
    @NotNull
    private final AnalysisScope myScope;
    @NonNls
    public static final String HELP_ID = "reference.toolWindows.inspections";
    private final Splitter mySplitter;
    @NotNull
    private final GlobalInspectionContextImpl myGlobalInspectionContext;
    private boolean myRerun;
    private volatile boolean myDisposed;
    private boolean myApplyingFix;
    @NotNull
    private final InspectionRVContentProvider myProvider;
    @NotNull
    private final ExclusionHandler<InspectionTreeNode> myExclusionHandler;
    private EditorEx myPreviewEditor;
    private InspectionTreeLoadingProgressAware myLoadingProgressPreview;
    private final Alarm myLoadingProgressPreviewAlarm;
    private final InspectionViewSuppressActionHolder mySuppressActionHolder;
    private final Executor myTreeUpdater;
    private volatile boolean myUpdating;

    public InspectionResultsView(@NotNull GlobalInspectionContextImpl globalInspectionContext, @NotNull InspectionRVContentProvider provider2) {
        String toolId;
        InspectionProfileImpl profile;
        InspectionToolWrapper tool;
        JComponent toolPanel;
        if (globalInspectionContext == null) {
            InspectionResultsView.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            InspectionResultsView.$$$reportNull$$$0(1);
        }
        this.myLoadingProgressPreviewAlarm = new Alarm((Disposable)this);
        this.mySuppressActionHolder = new InspectionViewSuppressActionHolder();
        this.myTreeUpdater = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Inspection-View-Tree-Updater");
        this.setLayout(new BorderLayout());
        this.myInspectionProfile = globalInspectionContext.getCurrentProfile();
        this.myScope = globalInspectionContext.getCurrentScope();
        this.myGlobalInspectionContext = globalInspectionContext;
        this.myProvider = provider2;
        this.myTree = new InspectionTree(this);
        this.mySplitter = new OnePixelSplitter(false, AnalysisUIOptions.getInstance((Project)globalInspectionContext.getProject()).SPLITTER_PROPORTION);
        this.mySplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree), (int)1));
        this.mySplitter.setHonorComponentsMinimumSize(false);
        this.mySplitter.addPropertyChangeListener(evt -> {
            if ("proportion".equals(evt.getPropertyName())) {
                this.myGlobalInspectionContext.setSplitterProportion(((Float)evt.getNewValue()).floatValue());
            }
        });
        this.add((Component)this.mySplitter, "Center");
        this.myExclusionHandler = new ExclusionHandler<InspectionTreeNode>(){

            public boolean isNodeExclusionAvailable(@NotNull InspectionTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            public boolean isNodeExcluded(@NotNull InspectionTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                return node.isExcluded();
            }

            public void excludeNode(@NotNull InspectionTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                node.excludeElement();
                node.dropProblemCountCaches();
            }

            public void includeNode(@NotNull InspectionTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(3);
                }
                node.amnestyElement();
                node.dropProblemCountCaches();
            }

            public boolean isActionEnabled(boolean isExcludeAction) {
                return isExcludeAction || !InspectionResultsView.this.myGlobalInspectionContext.getUIOptions().FILTER_RESOLVED_ITEMS;
            }

            public void onDone(boolean isExcludeAction) {
                if (isExcludeAction) {
                    InspectionResultsView.this.myTree.removeSelectedProblems();
                } else {
                    InspectionResultsView.this.myTree.repaint();
                }
                InspectionResultsView.this.syncRightPanel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionResultsView$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isNodeExclusionAvailable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isNodeExcluded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "excludeNode";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "includeNode";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.createActionsToolbar();
        PsiManager.getInstance((Project)this.getProject()).addPsiTreeChangeListener((PsiTreeChangeListener)new InspectionViewChangeAdapter(this), (Disposable)this);
        this.getProject().getMessageBus().connect((Disposable)this).subscribe(ProfileChangeAdapter.TOPIC, (Object)new ProfileChangeAdapter(){

            public void profileChanged(@NotNull InspectionProfile profile) {
                if (profile == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (profile == ProjectInspectionProfileManager.getInstance(InspectionResultsView.this.getProject()).getCurrentProfile()) {
                    InspectionResultsView.this.profileChanged();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInspection/ui/InspectionResultsView$2", "profileChanged"));
            }
        });
        this.mySettingsEnabled = !this.isSingleInspectionRun() ? true : (toolPanel = (tool = Objects.requireNonNull((profile = this.getCurrentProfile()).getInspectionTool(toolId = Objects.requireNonNull(profile.getSingleTool()), this.getProject()))).getTool().createOptionsPanel()) != null;
    }

    void profileChanged() {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myTree.revalidate();
            this.myTree.repaint();
            this.syncRightPanel();
        });
    }

    private void createActionsToolbar() {
        BorderLayoutPanel westPanel = JBUI.Panels.simplePanel().addToLeft((Component)this.createLeftActionsToolbar()).addToRight((Component)this.createRightActionsToolbar());
        this.add((Component)westPanel, "West");
    }

    private JComponent createRightActionsToolbar() {
        DefaultActionGroup specialGroup = new DefaultActionGroup();
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createGroupBySeverityAction(this));
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createGroupByDirectoryAction(this));
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createFilterResolvedItemsAction(this));
        specialGroup.add((AnAction)this.myGlobalInspectionContext.createToggleAutoscrollAction());
        specialGroup.add((AnAction)new ExportHTMLAction(this));
        specialGroup.add((AnAction)new InvokeQuickFixAction(this));
        return InspectionResultsView.createToolbar(specialGroup);
    }

    private JComponent createLeftActionsToolbar() {
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)new RerunAction(this));
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)((Object)this.myTree));
        group2.add(actionsManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)((Object)this.myTree)));
        group2.add(actionsManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)((Object)this.myTree)));
        group2.add(actionsManager.createPrevOccurenceAction(this.myTree.getOccurenceNavigator()));
        group2.add(actionsManager.createNextOccurenceAction(this.myTree.getOccurenceNavigator()));
        group2.add(ActionManager.getInstance().getAction("EditInspectionSettings"));
        return InspectionResultsView.createToolbar(group2);
    }

    public boolean hasNextOccurence() {
        return this.myTree.getOccurenceNavigator().hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myTree.getOccurenceNavigator().hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myTree.getOccurenceNavigator().goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myTree.getOccurenceNavigator().goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string = this.myTree.getOccurenceNavigator().getNextOccurenceActionName();
        if (string == null) {
            InspectionResultsView.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = this.myTree.getOccurenceNavigator().getPreviousOccurenceActionName();
        if (string == null) {
            InspectionResultsView.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static JComponent createToolbar(DefaultActionGroup specialGroup) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("CodeInspection", (ActionGroup)specialGroup, false);
        return toolbar.getComponent();
    }

    public void dispose() {
        InspectionResultsViewUtil.releaseEditor(this.myPreviewEditor);
        this.mySplitter.dispose();
        this.myInspectionProfile = null;
        this.myDisposed = true;
        if (this.myLoadingProgressPreview != null) {
            Disposer.dispose((Disposable)this.myLoadingProgressPreview);
            this.myLoadingProgressPreview = null;
        }
    }

    boolean isAutoScrollMode() {
        String activeToolWindowId = ToolWindowManager.getInstance((Project)this.getProject()).getActiveToolWindowId();
        return this.myGlobalInspectionContext.getUIOptions().AUTOSCROLL_TO_SOURCE && (activeToolWindowId == null || activeToolWindowId.equals("Problems View") || activeToolWindowId.equals("Inspection Results"));
    }

    public void setApplyingFix(boolean applyingFix) {
        this.myApplyingFix = applyingFix;
        this.syncRightPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncRightPanel() {
        EditorEx oldEditor = this.myPreviewEditor;
        try {
            if (this.myLoadingProgressPreview != null) {
                Disposer.dispose((Disposable)this.myLoadingProgressPreview);
                this.myLoadingProgressPreview = null;
            }
            if (this.myApplyingFix) {
                InspectionToolWrapper wrapper2 = this.myTree.getSelectedToolWrapper(true);
                LOG.assertTrue(wrapper2 != null);
                this.mySplitter.setSecondComponent(InspectionResultsViewUtil.getApplyingFixLabel(wrapper2));
            } else if (this.myTree.getSelectionModel().getSelectionCount() != 1) {
                if (this.myTree.getSelectedToolWrapper(true) == null) {
                    this.mySplitter.setSecondComponent((JComponent)InspectionResultsViewUtil.getNothingToShowTextLabel());
                } else {
                    this.showInRightPanel(this.myTree.getCommonSelectedElement());
                }
            } else {
                TreePath pathSelected = this.myTree.getSelectionModel().getLeadSelectionPath();
                if (pathSelected != null) {
                    InspectionTreeNode node = (InspectionTreeNode)pathSelected.getLastPathComponent();
                    if (node instanceof ProblemDescriptionNode) {
                        ProblemDescriptionNode problemNode = (ProblemDescriptionNode)node;
                        this.showInRightPanel(problemNode.getElement());
                    } else if (node instanceof InspectionPackageNode || node instanceof InspectionModuleNode || node instanceof RefElementNode || this.isSingleInspectionRun() && node instanceof InspectionSeverityGroupNode) {
                        this.showInRightPanel(node.getContainingFileLocalEntity());
                    } else if (node instanceof InspectionNode) {
                        if (this.myGlobalInspectionContext.getPresentation(((InspectionNode)node).getToolWrapper()).isDummy()) {
                            this.mySplitter.setSecondComponent((JComponent)InspectionResultsViewUtil.getNothingToShowTextLabel());
                        } else {
                            this.showInRightPanel(null);
                        }
                    } else if (node instanceof InspectionGroupNode || node instanceof InspectionSeverityGroupNode) {
                        InspectionViewNavigationPanel panel2 = new InspectionViewNavigationPanel(node, this.myTree);
                        this.myLoadingProgressPreview = panel2;
                        this.mySplitter.setSecondComponent((JComponent)panel2);
                    } else {
                        LOG.error("Unexpected node: " + node.getClass());
                    }
                }
            }
        }
        finally {
            if (oldEditor != null) {
                if (Boolean.TRUE.equals(oldEditor.getUserData(PREVIEW_EDITOR_IS_REUSED_KEY))) {
                    oldEditor.putUserData(PREVIEW_EDITOR_IS_REUSED_KEY, null);
                } else {
                    InspectionResultsViewUtil.releaseEditor(oldEditor);
                    if (oldEditor == this.myPreviewEditor) {
                        this.myPreviewEditor = null;
                    }
                }
            }
        }
    }

    private void showInRightPanel(@Nullable RefEntity refEntity) {
        JComponent fixToolbar;
        JPanel editorPanel = new JPanel();
        editorPanel.setLayout(new BorderLayout());
        JPanel actionsPanel = new JPanel(new BorderLayout());
        editorPanel.add((Component)actionsPanel, "North");
        int problemCount = this.myTree.getSelectedProblemCount();
        JComponent previewPanel = null;
        InspectionToolWrapper tool = this.myTree.getSelectedToolWrapper(true);
        if (tool != null) {
            InspectionToolPresentation presentation2 = this.myGlobalInspectionContext.getPresentation(tool);
            TreePath path2 = this.myTree.getSelectionPath();
            if (path2 != null) {
                Object last = path2.getLastPathComponent();
                if (last instanceof ProblemDescriptionNode) {
                    CommonProblemDescriptor descriptor2 = ((ProblemDescriptionNode)last).getDescriptor();
                    if (descriptor2 != null) {
                        previewPanel = presentation2.getCustomPreviewPanel(descriptor2, this);
                        JComponent customActions = presentation2.getCustomActionsPanel(descriptor2, this);
                        if (customActions != null) {
                            actionsPanel.add((Component)customActions, "East");
                        }
                    }
                } else if (refEntity != null && refEntity.isValid()) {
                    previewPanel = presentation2.getCustomPreviewPanel(refEntity);
                }
            }
        }
        EditorEx previewEditor = null;
        if (previewPanel == null) {
            Pair<JComponent, EditorEx> panelAndEditor = this.createBaseRightComponentFor(problemCount, refEntity);
            previewPanel = (JComponent)panelAndEditor.getFirst();
            previewEditor = (EditorEx)panelAndEditor.getSecond();
        }
        editorPanel.add(previewPanel, "Center");
        if (problemCount > 0 && (fixToolbar = QuickFixPreviewPanelFactory.create(this)) != null) {
            if (fixToolbar instanceof InspectionTreeLoadingProgressAware) {
                this.myLoadingProgressPreview = (InspectionTreeLoadingProgressAware)((Object)fixToolbar);
            }
            if (previewEditor != null) {
                previewPanel.setBorder(IdeBorderFactory.createBorder((int)2));
            }
            actionsPanel.add((Component)fixToolbar, "West");
        }
        if (previewEditor != null) {
            ProblemPreviewEditorPresentation.setupFoldingsAndHighlightProblems(previewEditor, this);
        }
        this.mySplitter.setSecondComponent((JComponent)editorPanel);
    }

    private Pair<JComponent, EditorEx> createBaseRightComponentFor(int problemCount, RefEntity selectedEntity) {
        if (selectedEntity instanceof RefElement && selectedEntity.isValid() && !(((RefElement)selectedEntity).getPsiElement() instanceof PsiDirectory)) {
            PsiFile file2;
            Document document;
            PsiElement element2;
            CommonProblemDescriptor descriptor2;
            CommonProblemDescriptor[] descriptors2;
            PsiElement selectedElement = ((RefElement)selectedEntity).getPsiElement();
            if (problemCount == 1 && (descriptors2 = this.myTree.getSelectedDescriptors()).length != 0 && (descriptor2 = descriptors2[0]) instanceof ProblemDescriptorBase && (element2 = ((ProblemDescriptorBase)descriptor2).getPsiElement()) != null) {
                selectedElement = element2;
            }
            if ((document = PsiDocumentManager.getInstance((Project)(file2 = InjectedLanguageManager.getInstance((Project)this.getProject()).getTopLevelFile(selectedElement)).getProject()).getDocument(file2)) == null) {
                return Pair.create((Object)InspectionResultsViewUtil.createLabelForText(InspectionsBundle.message((String)"inspections.view.no.preview.label", (Object[])new Object[]{file2.getName()})), null);
            }
            if (this.reuseEditorFor(document)) {
                this.myPreviewEditor.putUserData(PREVIEW_EDITOR_IS_REUSED_KEY, true);
                this.myPreviewEditor.getFoldingModel().runBatchFoldingOperation(() -> this.myPreviewEditor.getFoldingModel().clearFoldRegions());
                this.myPreviewEditor.getMarkupModel().removeAllHighlighters();
            } else {
                this.myPreviewEditor = (EditorEx)EditorFactory.getInstance().createEditor(document, this.getProject(), file2.getVirtualFile(), true);
                DiffUtil.setFoldingModelSupport(this.myPreviewEditor);
                EditorSettings settings2 = this.myPreviewEditor.getSettings();
                settings2.setLineNumbersShown(false);
                settings2.setFoldingOutlineShown(true);
                settings2.setLineMarkerAreaShown(true);
                settings2.setGutterIconsShown(false);
                settings2.setAdditionalColumnsCount(0);
                settings2.setAdditionalLinesCount(0);
                settings2.setLeadingWhitespaceShown(true);
                this.myPreviewEditor.getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, this.myPreviewEditor.getColorsScheme().getDefaultBackground());
                this.myPreviewEditor.getScrollPane().setBorder((Border)JBUI.Borders.empty());
            }
            if (problemCount == 0) {
                this.myPreviewEditor.getScrollingModel().scrollTo(this.myPreviewEditor.offsetToLogicalPosition(selectedElement.getTextOffset()), ScrollType.CENTER_UP);
            }
            this.myPreviewEditor.getComponent().setBorder((Border)JBUI.Borders.empty());
            return Pair.create((Object)this.myPreviewEditor.getComponent(), (Object)this.myPreviewEditor);
        }
        if (selectedEntity == null) {
            return Pair.create((Object)new InspectionNodeInfo(this.myTree, this.getProject()), null);
        }
        if (selectedEntity.isValid()) {
            return Pair.create((Object)InspectionResultsViewUtil.getPreviewIsNotAvailable(selectedEntity), null);
        }
        return Pair.create((Object)InspectionResultsViewUtil.getInvalidEntityLabel(selectedEntity), null);
    }

    private boolean reuseEditorFor(Document document) {
        return this.myPreviewEditor != null && !this.myPreviewEditor.isDisposed() && this.myPreviewEditor.getDocument() == document;
    }

    private void addTool(@NotNull InspectionToolWrapper toolWrapper, HighlightDisplayLevel errorLevel, boolean groupedBySeverity, boolean isSingleInspectionRun) {
        if (toolWrapper == null) {
            InspectionResultsView.$$$reportNull$$$0(4);
        }
        InspectionTreeNode toolNode = this.myTree.getToolProblemsRootNode(toolWrapper, errorLevel, groupedBySeverity, isSingleInspectionRun);
        this.myProvider.appendToolNodeContent(this.myGlobalInspectionContext, toolWrapper, toolNode, this.myGlobalInspectionContext.getUIOptions().SHOW_STRUCTURE, groupedBySeverity);
        InspectionToolPresentation presentation2 = this.myGlobalInspectionContext.getPresentation(toolWrapper);
        presentation2.patchToolNode(toolNode, this.myProvider, this.myGlobalInspectionContext.getUIOptions().SHOW_STRUCTURE, groupedBySeverity);
        this.registerActionShortcuts(presentation2);
    }

    private void registerActionShortcuts(@NotNull InspectionToolPresentation presentation2) {
        if (presentation2 == null) {
            InspectionResultsView.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            for (QuickFixAction fix : presentation2.getQuickFixes(RefEntity.EMPTY_ELEMENTS_ARRAY)) {
                fix.registerCustomShortcutSet(fix.getShortcutSet(), this);
            }
        });
    }

    public InspectionViewSuppressActionHolder getSuppressActionHolder() {
        return this.mySuppressActionHolder;
    }

    @Nullable
    public String getCurrentProfileName() {
        return this.myInspectionProfile == null ? null : this.myInspectionProfile.getDisplayName();
    }

    public InspectionProfileImpl getCurrentProfile() {
        return this.myInspectionProfile;
    }

    void addProblemDescriptors(InspectionToolWrapper wrapper2, RefEntity refElement, CommonProblemDescriptor[] descriptors2) {
        this.updateTree(() -> ReadAction.run(() -> {
            if (!this.isDisposed()) {
                ApplicationManager.getApplication().assertReadAccessAllowed();
                AnalysisUIOptions uiOptions = this.myGlobalInspectionContext.getUIOptions();
                InspectionToolPresentation presentation2 = this.myGlobalInspectionContext.getPresentation(wrapper2);
                InspectionTreeNode toolNode = this.myTree.getToolProblemsRootNode(wrapper2, HighlightDisplayLevel.find((HighlightSeverity)presentation2.getSeverity((RefElement)refElement)), uiOptions.GROUP_BY_SEVERITY, this.isSingleInspectionRun());
                HashMap<RefEntity, CommonProblemDescriptor[]> problems = new HashMap<RefEntity, CommonProblemDescriptor[]>(1);
                problems.put(refElement, descriptors2);
                HashMap<String, Set<RefEntity>> contents = new HashMap<String, Set<RefEntity>>();
                String groupName = refElement.getRefManager().getGroupName((RefElement)refElement);
                Set content2 = contents.computeIfAbsent(groupName, __ -> new HashSet());
                content2.add(refElement);
                this.getProvider().appendToolNodeContent(this.myGlobalInspectionContext, wrapper2, toolNode, uiOptions.SHOW_STRUCTURE, true, contents, problems::get);
                if (!this.myLoadingProgressPreviewAlarm.isDisposed()) {
                    this.myLoadingProgressPreviewAlarm.cancelAllRequests();
                    this.myLoadingProgressPreviewAlarm.addRequest(() -> {
                        if (this.myLoadingProgressPreview != null) {
                            this.myLoadingProgressPreview.updateLoadingProgress();
                        }
                    }, 200);
                }
            }
        }));
    }

    public void update() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Application app = ApplicationManager.getApplication();
        ArrayList<Tools> tools = new ArrayList<Tools>(this.myGlobalInspectionContext.getTools().values());
        Runnable buildAction = () -> {
            try {
                this.setUpdating(true);
                this.myTree.removeAllNodes();
                this.addToolsSynchronously(tools);
            }
            finally {
                this.setUpdating(false);
            }
        };
        if (app.isUnitTestMode()) {
            buildAction.run();
        } else {
            this.updateTree(buildAction);
        }
    }

    public void setUpdating(boolean isUpdating) {
        this.myUpdating = isUpdating;
        if (!isUpdating) {
            this.myLoadingProgressPreviewAlarm.cancelAllRequests();
            this.myLoadingProgressPreviewAlarm.addRequest(() -> {
                if (this.myLoadingProgressPreview != null) {
                    this.myLoadingProgressPreview.treeLoaded();
                }
            }, 200);
        }
        EdtInvocationManager.getInstance().invokeLater(() -> this.myTree.setPaintBusy(this.myUpdating));
    }

    public void addTools(Collection<? extends Tools> tools) {
        this.updateTree(() -> this.addToolsSynchronously(tools));
    }

    private void addToolsSynchronously(Collection<? extends Tools> tools) {
        if (this.isDisposed()) {
            return;
        }
        InspectionProfileImpl profile = this.myInspectionProfile;
        boolean isGroupedBySeverity = this.myGlobalInspectionContext.getUIOptions().GROUP_BY_SEVERITY;
        boolean singleInspectionRun = this.isSingleInspectionRun();
        for (Tools tools2 : tools) {
            InspectionToolWrapper defaultToolWrapper = tools2.getDefaultState().getTool();
            HighlightDisplayKey key = HighlightDisplayKey.find((String)defaultToolWrapper.getShortName());
            for (ScopeToolState scopeToolState : this.myProvider.getTools(tools2)) {
                InspectionToolWrapper toolWrapper = scopeToolState.getTool();
                if (!((Boolean)ReadAction.compute(() -> this.myProvider.checkReportedProblems(this.myGlobalInspectionContext, toolWrapper))).booleanValue()) continue;
                this.addTool(toolWrapper, profile.getErrorLevel(key, scopeToolState.getScope(this.getProject()), this.getProject()), isGroupedBySeverity, singleInspectionRun);
            }
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myGlobalInspectionContext.getProject();
        if (project == null) {
            InspectionResultsView.$$$reportNull$$$0(6);
        }
        return project;
    }

    @Override
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            InspectionResultsView.$$$reportNull$$$0(7);
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        if (ExclusionHandler.EXCLUSION_HANDLER.is(dataId)) {
            return this.myExclusionHandler;
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        if (paths.length > 1) {
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                RefEntity[] refElements = this.myTree.getSelectedElements();
                ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
                for (RefEntity refElement : refElements) {
                    PsiElement psiElement;
                    PsiElement psiElement2 = psiElement = refElement instanceof RefElement ? ((RefElement)refElement).getPsiElement() : null;
                    if (psiElement == null || !psiElement.isValid()) continue;
                    psiElements.add(psiElement);
                }
                return PsiUtilCore.toPsiElementArray(psiElements);
            }
            return null;
        }
        TreePath path2 = paths[0];
        InspectionTreeNode selectedNode = (InspectionTreeNode)path2.getLastPathComponent();
        if (!CommonDataKeys.NAVIGATABLE.is(dataId) && !CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return null;
        }
        if (selectedNode instanceof RefElementNode) {
            PsiElement psiElement;
            RefElementNode refElementNode = (RefElementNode)selectedNode;
            RefEntity refElement = refElementNode.getElement();
            if (refElement == null || !refElement.isValid()) {
                return null;
            }
            RefEntity item = refElement.getRefManager().getRefinedElement(refElement);
            if (!item.isValid()) {
                return null;
            }
            PsiElement psiElement3 = psiElement = item instanceof RefElement ? ((RefElement)item).getPsiElement() : null;
            if (psiElement == null) {
                return null;
            }
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                return InspectionResultsView.getSelectedNavigatable(null, psiElement);
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return psiElement.isValid() ? psiElement : null;
            }
        } else if (selectedNode instanceof ProblemDescriptionNode && CommonDataKeys.NAVIGATABLE.is(dataId)) {
            Navigatable navigatable = InspectionResultsView.getSelectedNavigatable(((ProblemDescriptionNode)selectedNode).getDescriptor());
            return navigatable == null ? InspectionResultsViewUtil.getNavigatableForInvalidNode((ProblemDescriptionNode)selectedNode) : navigatable;
        }
        return null;
    }

    @Nullable
    public static Navigatable getSelectedNavigatable(CommonProblemDescriptor descriptor2) {
        return InspectionResultsView.getSelectedNavigatable(descriptor2, descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getPsiElement() : null);
    }

    @Nullable
    private static Navigatable getSelectedNavigatable(CommonProblemDescriptor descriptor2, PsiElement psiElement) {
        VirtualFile virtualFile2;
        Navigatable navigatable;
        if (descriptor2 instanceof ProblemDescriptorBase && (navigatable = ((ProblemDescriptorBase)descriptor2).getNavigatable()) != null) {
            return navigatable;
        }
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        VirtualFile virtualFile3 = virtualFile2 = containingFile == null ? null : containingFile.getVirtualFile();
        if (virtualFile2 != null) {
            TextRange textRange;
            int startOffset = psiElement.getTextOffset();
            if (descriptor2 instanceof ProblemDescriptorBase && (textRange = ((ProblemDescriptorBase)descriptor2).getTextRangeForNavigation()) != null) {
                if (virtualFile2 instanceof VirtualFileWindow) {
                    virtualFile2 = ((VirtualFileWindow)virtualFile2).getDelegate();
                }
                startOffset = textRange.getStartOffset();
            }
            return PsiNavigationSupport.getInstance().createNavigatable(psiElement.getProject(), virtualFile2, startOffset);
        }
        return null;
    }

    @NotNull
    public InspectionTree getTree() {
        InspectionTree inspectionTree = this.myTree;
        if (inspectionTree == null) {
            InspectionResultsView.$$$reportNull$$$0(8);
        }
        return inspectionTree;
    }

    @NotNull
    public GlobalInspectionContextImpl getGlobalInspectionContext() {
        GlobalInspectionContextImpl globalInspectionContextImpl = this.myGlobalInspectionContext;
        if (globalInspectionContextImpl == null) {
            InspectionResultsView.$$$reportNull$$$0(9);
        }
        return globalInspectionContextImpl;
    }

    @NotNull
    public InspectionRVContentProvider getProvider() {
        InspectionRVContentProvider inspectionRVContentProvider = this.myProvider;
        if (inspectionRVContentProvider == null) {
            InspectionResultsView.$$$reportNull$$$0(10);
        }
        return inspectionRVContentProvider;
    }

    public boolean isSingleToolInSelection() {
        return this.myTree.getSelectedToolWrapper(true) != null;
    }

    public boolean isRerun() {
        boolean rerun = this.myRerun;
        this.myRerun = false;
        return rerun;
    }

    public boolean areSettingsEnabled() {
        return this.mySettingsEnabled;
    }

    public boolean isSingleInspectionRun() {
        return this.myInspectionProfile.getSingleTool() != null;
    }

    public static void showPopup(AnActionEvent e, JBPopup popup2) {
        InputEvent event = e.getInputEvent();
        if (event instanceof MouseEvent) {
            popup2.showUnderneathOf(event.getComponent());
        } else {
            popup2.showInBestPositionFor(e.getDataContext());
        }
    }

    @NotNull
    public AnalysisScope getScope() {
        AnalysisScope analysisScope = this.myScope;
        if (analysisScope == null) {
            InspectionResultsView.$$$reportNull$$$0(11);
        }
        return analysisScope;
    }

    public boolean isUpdating() {
        return this.myUpdating;
    }

    public boolean hasProblems() {
        return InspectionResultsView.hasProblems(this.myGlobalInspectionContext.getTools().values(), this.myGlobalInspectionContext, this.myProvider);
    }

    public static boolean hasProblems(@NotNull Collection<? extends Tools> tools, @NotNull GlobalInspectionContextImpl context2, @NotNull InspectionRVContentProvider contentProvider) {
        if (tools == null) {
            InspectionResultsView.$$$reportNull$$$0(12);
        }
        if (context2 == null) {
            InspectionResultsView.$$$reportNull$$$0(13);
        }
        if (contentProvider == null) {
            InspectionResultsView.$$$reportNull$$$0(14);
        }
        for (Tools tools2 : tools) {
            boolean hasProblems = (Boolean)ReadAction.compute(() -> {
                for (ScopeToolState scopeToolState : contentProvider.getTools(currentTools)) {
                    InspectionToolWrapper toolWrapper = scopeToolState.getTool();
                    if (!context2.getPresentation(toolWrapper).hasReportedProblems() && !contentProvider.checkReportedProblems(context2, toolWrapper)) continue;
                    return true;
                }
                return false;
            });
            if (!hasProblems) continue;
            return true;
        }
        return false;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public boolean isRerunAvailable() {
        return !(this.myProvider instanceof OfflineInspectionRVContentProvider) && this.myScope.isValid();
    }

    public void rerun() {
        this.myRerun = true;
        if (this.myScope.isValid()) {
            this.myGlobalInspectionContext.doInspections(this.myScope);
        } else {
            GlobalInspectionContextImpl.NOTIFICATION_GROUP.createNotification(InspectionsBundle.message((String)"inspection.view.invalid.scope.message", (Object[])new Object[0]), NotificationType.INFORMATION).notify(this.getProject());
        }
    }

    private void updateTree(@NotNull Runnable action2) {
        if (action2 == null) {
            InspectionResultsView.$$$reportNull$$$0(15);
        }
        this.myTreeUpdater.execute(() -> ProgressManager.getInstance().runProcess(action2, (ProgressIndicator)new EmptyProgressIndicator()));
    }

    @TestOnly
    public void dispatchTreeUpdate() throws ExecutionException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.myTreeUpdater.execute(() -> latch.countDown());
        latch.await();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalInspectionContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/InspectionResultsView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentProvider";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionResultsView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalInspectionContext";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addTool";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerActionShortcuts";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasProblems";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

