/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.LiveTemplateRunLogger;
import com.intellij.codeInsight.template.impl.TemplateExpressionLookupElement;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSegments;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.TemplateStateProcessor;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CoreCodeStyleUtil;
import com.intellij.psi.impl.source.codeStyle.NewLineIndentMarkerProvider;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.util.CharTable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class InteractiveTemplateStateProcessor
implements TemplateStateProcessor {
    @NonNls
    private static final String DUMMY_IDENTIFIER = "xxx";
    private boolean myLookupShown;

    InteractiveTemplateStateProcessor() {
    }

    @Override
    public boolean isUndoOrRedoInProgress(Project project) {
        return UndoManager.getInstance((Project)project).isUndoOrRedoInProgress();
    }

    @Override
    public void registerUndoableAction(TemplateState state, Project project, Document document) {
        MyBasicUndoableAction undoableAction = new MyBasicUndoableAction(state, project, document);
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)undoableAction);
        Disposer.register((Disposable)state, (Disposable)undoableAction);
    }

    @Override
    public TextRange insertNewLineIndentMarker(PsiFile file2, Document document, int offset) {
        return InteractiveTemplateStateProcessor.doInsertNewLineIndentMarker(file2, document, offset);
    }

    @Override
    public PsiElement findWhiteSpaceNode(PsiFile file2, int offset) {
        return (PsiElement)InteractiveTemplateStateProcessor.doFindWhiteSpaceNode((PsiFile)file2, (int)offset).first;
    }

    @NotNull
    private static Pair<PsiElement, CharTable> doFindWhiteSpaceNode(@NotNull PsiFile file2, int offset) {
        ASTNode astNode;
        if (file2 == null) {
            InteractiveTemplateStateProcessor.$$$reportNull$$$0(0);
        }
        if (!((astNode = SourceTreeToPsiMap.psiElementToTree((PsiElement)file2)) instanceof FileElement)) {
            return new Pair(null, null);
        }
        PsiElement elementAt = InjectedLanguageManager.getInstance((Project)file2.getProject()).findInjectedElementAt(file2, offset);
        CharTable charTable = ((FileElement)astNode).getCharTable();
        if (elementAt == null) {
            elementAt = CoreCodeStyleUtil.findElementInTreeWithFormatterEnabled(file2, offset);
        }
        if (elementAt == null) {
            return new Pair(null, (Object)charTable);
        }
        ASTNode node = elementAt.getNode();
        if (node == null || node.getElementType() != TokenType.WHITE_SPACE) {
            return new Pair(null, (Object)charTable);
        }
        Pair pair = Pair.create((Object)elementAt, (Object)charTable);
        if (pair == null) {
            InteractiveTemplateStateProcessor.$$$reportNull$$$0(1);
        }
        return pair;
    }

    @Override
    public void logTemplate(Project project, TemplateImpl template, Language language) {
        LiveTemplateRunLogger.log(project, template, language);
    }

    @Override
    public void runLookup(TemplateState state, Project project, Editor editor, LookupElement @NotNull [] elements, Expression expressionNode) {
        if (elements == null) {
            InteractiveTemplateStateProcessor.$$$reportNull$$$0(2);
        }
        ArrayList<TemplateExpressionLookupElement> lookupItems = new ArrayList<TemplateExpressionLookupElement>();
        for (int i2 = 0; i2 < elements.length; ++i2) {
            lookupItems.add(new TemplateExpressionLookupElement(state, elements[i2], i2));
        }
        if (((TemplateManagerImpl)TemplateManager.getInstance(project)).shouldSkipInTests()) {
            InteractiveTemplateStateProcessor.insertSingleItem(editor, lookupItems);
        } else {
            for (LookupElement lookupElement : lookupItems) {
                assert (lookupElement != null) : expressionNode;
            }
            AsyncEditorLoader.performWhenLoaded(editor, () -> this.runLookup(state, lookupItems, project, editor, expressionNode.getAdvertisingText(), expressionNode.getLookupFocusDegree()));
        }
    }

    private void runLookup(final TemplateState state, final List<TemplateExpressionLookupElement> lookupItems, Project project, Editor editor, @Nullable @NlsContexts.PopupAdvertisement String advertisingText, @NotNull LookupFocusDegree lookupFocusDegree) {
        if (lookupFocusDegree == null) {
            InteractiveTemplateStateProcessor.$$$reportNull$$$0(3);
        }
        if (state.isDisposed()) {
            return;
        }
        LookupManager lookupManager = LookupManager.getInstance(project);
        final LookupImpl lookup2 = (LookupImpl)lookupManager.showLookup(editor, lookupItems.toArray(LookupElement.EMPTY_ARRAY));
        if (lookup2 == null) {
            return;
        }
        if (CodeInsightSettings.getInstance().AUTO_POPUP_COMPLETION_LOOKUP && editor.getUserData(InplaceRefactoring.INPLACE_RENAMER) == null) {
            lookup2.setStartCompletionWhenNothingMatches(true);
        }
        if (advertisingText != null) {
            lookup2.addAdvertisement(advertisingText, null);
        } else {
            ActionManager am = ActionManager.getInstance();
            String enterShortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)am.getAction("EditorChooseLookupItem"));
            String tabShortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)am.getAction("EditorChooseLookupItemReplace"));
            lookup2.addAdvertisement(LangBundle.message((String)"popup.advertisement.press.or.to.replace", (Object[])new Object[]{enterShortcut, tabShortcut}), null);
        }
        lookup2.setLookupFocusDegree(lookupFocusDegree);
        lookup2.refreshUi(true, true);
        this.myLookupShown = true;
        lookup2.addLookupListener(new LookupListener(){

            public void lookupCanceled(@NotNull LookupEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                lookup2.removeLookupListener(this);
                InteractiveTemplateStateProcessor.this.myLookupShown = false;
            }

            public void itemSelected(@NotNull LookupEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                lookup2.removeLookupListener(this);
                if (state.isFinished()) {
                    return;
                }
                InteractiveTemplateStateProcessor.this.myLookupShown = false;
                LookupElement item = event.getItem();
                if (item instanceof TemplateExpressionLookupElement) {
                    ((TemplateExpressionLookupElement)item).handleTemplateInsert(lookupItems, event.getCompletionChar());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/codeInsight/template/impl/InteractiveTemplateStateProcessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lookupCanceled";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "itemSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void insertSingleItem(Editor editor, List<TemplateExpressionLookupElement> lookupItems) {
        TemplateExpressionLookupElement first = lookupItems.get(0);
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)first.getLookupString());
        first.handleTemplateInsert(lookupItems, '\u0000');
    }

    @Override
    public boolean isLookupShown() {
        return this.myLookupShown;
    }

    @Override
    public boolean skipSettingFinalEditorState(Project project) {
        return !((TemplateManagerImpl)TemplateManager.getInstance(project)).shouldSkipInTests();
    }

    @Override
    public boolean isCaretOutsideCurrentSegment(Editor editor, TemplateSegments segments, int currentSegmentNumber, String commandName2) {
        if (editor != null && currentSegmentNumber >= 0) {
            int offset = editor.getCaretModel().getOffset();
            boolean hasSelection = editor.getSelectionModel().hasSelection();
            int segmentStart = segments.getSegmentStart(currentSegmentNumber);
            if (offset < segmentStart || !hasSelection && offset == segmentStart && ActionsBundle.actionText((String)"EditorBackSpace").equals(commandName2)) {
                return true;
            }
            int segmentEnd = segments.getSegmentEnd(currentSegmentNumber);
            if (offset > segmentEnd || !hasSelection && offset == segmentEnd && ActionsBundle.actionText((String)"EditorDelete").equals(commandName2)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static TextRange doInsertNewLineIndentMarker(@NotNull PsiFile file2, @NotNull Document document, int offset) {
        if (file2 == null) {
            InteractiveTemplateStateProcessor.$$$reportNull$$$0(4);
        }
        if (document == null) {
            InteractiveTemplateStateProcessor.$$$reportNull$$$0(5);
        }
        CharSequence text2 = document.getImmutableCharSequence();
        if (offset <= 0 || offset >= text2.length() || !InteractiveTemplateStateProcessor.isWhiteSpaceSymbol(text2.charAt(offset))) {
            return null;
        }
        if (!InteractiveTemplateStateProcessor.isWhiteSpaceSymbol(text2.charAt(offset - 1))) {
            return null;
        }
        for (int end = offset; end < text2.length() && text2.charAt(end) != '\n'; ++end) {
            if (InteractiveTemplateStateProcessor.isWhiteSpaceSymbol(text2.charAt(end))) continue;
            return null;
        }
        String marker = InteractiveTemplateStateProcessor.createMarker(file2, offset);
        document.insertString(offset, (CharSequence)marker);
        return new TextRange(offset, offset + marker.length());
    }

    private static boolean isWhiteSpaceSymbol(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    @NotNull
    private static String createMarker(@NotNull PsiFile file2, int offset) {
        String marker;
        Project project;
        PsiElement injectedElement;
        if (file2 == null) {
            InteractiveTemplateStateProcessor.$$$reportNull$$$0(6);
        }
        Language language = (injectedElement = InjectedLanguageManager.getInstance((Project)(project = file2.getProject())).findInjectedElementAt(file2, offset)) != null ? injectedElement.getLanguage() : PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset);
        CoreCodeStyleUtil.setSequentialProcessingAllowed(false);
        NewLineIndentMarkerProvider markerProvider = (NewLineIndentMarkerProvider)NewLineIndentMarkerProvider.EP.forLanguage(language);
        String string = marker = markerProvider == null ? null : markerProvider.createMarker(file2, offset);
        if (marker != null) {
            String string2 = marker;
            if (string2 == null) {
                InteractiveTemplateStateProcessor.$$$reportNull$$$0(7);
            }
            return string2;
        }
        PsiComment comment = null;
        try {
            comment = PsiParserFacade.SERVICE.getInstance((Project)project).createLineOrBlockCommentFromText(language, "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String text2 = comment != null ? comment.getText() : null;
        return text2 != null ? text2 : DUMMY_IDENTIFIER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/InteractiveTemplateStateProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupFocusDegree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/InteractiveTemplateStateProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindWhiteSpaceNode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doFindWhiteSpaceNode";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runLookup";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doInsertNewLineIndentMarker";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMarker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyBasicUndoableAction
    extends BasicUndoableAction
    implements Disposable {
        private final Project myProject;
        @Nullable
        private TemplateState myTemplateState;

        private MyBasicUndoableAction(@NotNull TemplateState templateState2, Project project, @Nullable Document document) {
            DocumentReference[] documentReferenceArray;
            if (templateState2 == null) {
                MyBasicUndoableAction.$$$reportNull$$$0(0);
            }
            if (document != null) {
                DocumentReference[] documentReferenceArray2 = new DocumentReference[1];
                documentReferenceArray = documentReferenceArray2;
                documentReferenceArray2[0] = DocumentReferenceManager.getInstance().create(document);
            } else {
                documentReferenceArray = null;
            }
            super(documentReferenceArray);
            this.myTemplateState = templateState2;
            this.myProject = project;
        }

        public void undo() {
            if (this.myTemplateState != null) {
                LookupManager.getInstance(this.myProject).hideActiveLookup();
                this.myTemplateState.cancelTemplate();
            }
        }

        public void redo() {
        }

        public void dispose() {
            this.myTemplateState = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateState", "com/intellij/codeInsight/template/impl/InteractiveTemplateStateProcessor$MyBasicUndoableAction", "<init>"));
        }
    }
}

