/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionLookupArrangerImpl;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.LookupElementListPresenter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.ShowHideIntentionIconLookupAction;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupUtil;
import com.intellij.codeInsight.lookup.impl.CompletionExtender;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupActionsStep;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.codeInsight.lookup.impl.LookupOffsets;
import com.intellij.codeInsight.lookup.impl.LookupPreview;
import com.intellij.codeInsight.lookup.impl.LookupUi;
import com.intellij.codeInsight.lookup.impl.LookupUsageTracker;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.codeInsight.lookup.impl.actions.ChooseItemAction;
import com.intellij.codeInsight.template.impl.actions.NextVariableAction;
import com.intellij.codeWithMe.ClientId;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.ui.UISettings;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.lang.LangBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.Advertiser;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class LookupImpl
extends LightweightHint
implements LookupEx,
Disposable,
LookupElementListPresenter {
    private static final Logger LOG = Logger.getInstance(LookupImpl.class);
    private final LookupOffsets myOffsets;
    private final Project myProject;
    private final Editor myEditor;
    private final Object myUiLock;
    private final JBList myList;
    final LookupCellRenderer myCellRenderer;
    private final List<LookupListener> myListeners;
    private final List<PrefixChangeListener> myPrefixChangeListeners;
    private final LookupPreview myPreview;
    private final FontPreferences myFontPreferences;
    private final long myCreatedTimestamp;
    private long myStampShown;
    protected boolean myShown;
    private boolean myHidden;
    private boolean mySelectionTouched;
    private LookupFocusDegree myLookupFocusDegree;
    private volatile boolean myCalculating;
    private final Advertiser myAdComponent;
    private int myGuardedChanges;
    private volatile LookupArranger myArranger;
    private LookupArranger myPresentableArranger;
    private boolean myStartCompletionWhenNothingMatches;
    boolean myResizePending;
    private boolean myFinishing;
    boolean myUpdating;
    private LookupUi myUi;
    private final ClientId myClientId;
    private final AtomicInteger myDummyItemCount;
    private final EmptyLookupItem myDummyItem;
    private Throwable disposeTrace;

    public LookupImpl(Project project, Editor editor, @NotNull LookupArranger arranger) {
        if (arranger == null) {
            LookupImpl.$$$reportNull$$$0(0);
        }
        super(new JPanel(new BorderLayout()));
        this.myUiLock = new Object();
        this.myList = new JBList<LookupElement>((ListModel)new CollectionListModel((Object[])new LookupElement[0])){

            protected void processKeyEvent(@NotNull KeyEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                LookupImpl.this.myEditor.getContentComponent().dispatchEvent(e);
            }

            @NotNull
            protected ExpandableItemsHandler<Integer> createExpandableItemsHandler() {
                return new CompletionExtender((JList)((Object)this));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$1", "processKeyEvent"));
            }
        };
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myPrefixChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myPreview = new LookupPreview(this);
        this.myFontPreferences = new FontPreferencesImpl();
        this.myStampShown = 0L;
        this.myShown = false;
        this.myHidden = false;
        this.myLookupFocusDegree = LookupFocusDegree.FOCUSED;
        this.myClientId = ClientId.getCurrent();
        this.myDummyItemCount = new AtomicInteger();
        this.myDummyItem = new EmptyLookupItem(CommonBundle.message((String)"tree.node.loading", (Object[])new Object[0]), true);
        this.disposeTrace = null;
        this.setForceShowAsPopup(true);
        this.setCancelOnClickOutside(false);
        this.setResizable(true);
        this.myProject = project;
        this.myEditor = InjectedLanguageEditorUtil.getTopLevelEditor(editor);
        this.myArranger = arranger;
        this.myPresentableArranger = arranger;
        this.myEditor.getColorsScheme().getFontPreferences().copyTo(this.myFontPreferences);
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).disableUpdateByTimer((Disposable)this);
        this.myCellRenderer = new LookupCellRenderer(this, this.myEditor.getContentComponent());
        this.myCellRenderer.itemAdded(this.myDummyItem, LookupElementPresentation.renderElement((LookupElement)this.myDummyItem));
        this.myList.setCellRenderer((ListCellRenderer)this.myCellRenderer);
        this.myList.setFocusable(false);
        this.myList.setFixedCellWidth(50);
        this.myList.setBorder(null);
        if (SystemInfoRt.isWindows) {
            AccessibleContextUtil.setParent((Component)this.myList, (Component)this.myEditor.getContentComponent());
        }
        this.myList.setSelectionMode(0);
        this.myList.setBackground(LookupCellRenderer.BACKGROUND_COLOR);
        this.myAdComponent = new Advertiser();
        this.myAdComponent.setBackground(LookupCellRenderer.BACKGROUND_COLOR);
        this.myOffsets = new LookupOffsets(this.myEditor);
        CollectionListModel<LookupElement> model2 = this.getListModel();
        this.addEmptyItem(model2);
        this.updateListHeight((ListModel<LookupElement>)model2);
        this.addListeners();
        this.myCreatedTimestamp = System.currentTimeMillis();
    }

    private CollectionListModel<LookupElement> getListModel() {
        return (CollectionListModel)this.myList.getModel();
    }

    public LookupArranger getArranger() {
        return this.myArranger;
    }

    public void setArranger(LookupArranger arranger) {
        this.myArranger = arranger;
    }

    public boolean isFocused() {
        return this.getLookupFocusDegree() == LookupFocusDegree.FOCUSED;
    }

    @NotNull
    public LookupFocusDegree getLookupFocusDegree() {
        LookupFocusDegree lookupFocusDegree = this.myLookupFocusDegree;
        if (lookupFocusDegree == null) {
            LookupImpl.$$$reportNull$$$0(1);
        }
        return lookupFocusDegree;
    }

    public void setLookupFocusDegree(@NotNull LookupFocusDegree lookupFocusDegree) {
        if (lookupFocusDegree == null) {
            LookupImpl.$$$reportNull$$$0(2);
        }
        this.myLookupFocusDegree = lookupFocusDegree;
        for (LookupListener listener2 : this.myListeners) {
            listener2.focusDegreeChanged();
        }
    }

    public boolean isCalculating() {
        return this.myCalculating;
    }

    public void setCalculating(boolean calculating) {
        this.myCalculating = calculating;
        if (this.myUi != null) {
            this.myUi.setCalculating(calculating);
        }
    }

    public void markSelectionTouched() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        this.mySelectionTouched = true;
        this.myList.repaint();
    }

    @TestOnly
    public void setSelectionTouched(boolean selectionTouched) {
        this.mySelectionTouched = selectionTouched;
    }

    public int getSelectedIndex() {
        return this.myList.getSelectedIndex();
    }

    public void setSelectedIndex(int index2) {
        this.myList.setSelectedIndex(index2);
        this.myList.ensureIndexIsVisible(index2);
    }

    public int getDummyItemCount() {
        return this.myDummyItemCount.get();
    }

    public void setDummyItemCount(int count) {
        this.myDummyItemCount.set(count);
    }

    @NotNull
    public LookupElement getDummyItem() {
        EmptyLookupItem emptyLookupItem = this.myDummyItem;
        if (emptyLookupItem == null) {
            LookupImpl.$$$reportNull$$$0(3);
        }
        return emptyLookupItem;
    }

    public void repaintLookup(boolean onExplicitAction, boolean reused, boolean selectionVisible, boolean itemsChanged) {
        this.myUi.refreshUi(selectionVisible, itemsChanged, reused, onExplicitAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resort(boolean addAgain) {
        List<LookupElement> items = this.getItems();
        this.myPresentableArranger.prefixChanged(this);
        Iterator<LookupElement> iterator2 = this.myUiLock;
        synchronized (iterator2) {
            this.getListModel().removeAll();
        }
        if (addAgain) {
            for (LookupElement item : items) {
                this.addItem(item, this.itemMatcher(item));
            }
        }
        this.refreshUi(true, true);
    }

    public boolean addItem(LookupElement item, PrefixMatcher matcher) {
        LookupElementPresentation presentation2 = LookupElementPresentation.renderElement((LookupElement)item);
        if (LookupImpl.containsDummyIdentifier(presentation2.getItemText()) || LookupImpl.containsDummyIdentifier(presentation2.getTailText()) || LookupImpl.containsDummyIdentifier(presentation2.getTypeText())) {
            return false;
        }
        this.myCellRenderer.itemAdded(item, presentation2);
        LookupArranger arranger = this.myArranger;
        arranger.registerMatcher(item, matcher);
        arranger.addElement(item, presentation2);
        return true;
    }

    public void scheduleItemUpdate(@NotNull LookupElement item) {
        if (item == null) {
            LookupImpl.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(this.getItems().contains(item), (Object)"Item isn't present in lookup");
        this.myCellRenderer.updateItemPresentation(item);
    }

    private void addDummyItems(int count) {
        for (int i2 = count; i2 > 0; --i2) {
            this.getListModel().add((Object)this.myDummyItem);
        }
    }

    private static boolean containsDummyIdentifier(@Nullable String s) {
        return s != null && s.contains(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED);
    }

    public void updateLookupWidth() {
        this.myCellRenderer.scheduleUpdateLookupWidthFromVisibleItems();
    }

    public void requestResize() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myResizePending = true;
    }

    public Collection<LookupElementAction> getActionsFor(LookupElement element2) {
        CollectConsumer consumer = new CollectConsumer();
        for (LookupActionProvider provider2 : (LookupActionProvider[])LookupActionProvider.EP_NAME.getExtensions()) {
            provider2.fillActions(element2, this, (Consumer<LookupElementAction>)consumer);
        }
        if (!consumer.getResult().isEmpty()) {
            consumer.consume((Object)new ShowHideIntentionIconLookupAction());
        }
        return consumer.getResult();
    }

    public JList getList() {
        return this.myList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LookupElement> getItems() {
        Object object = this.myUiLock;
        synchronized (object) {
            return ContainerUtil.findAll((Collection)this.getListModel().toList(), element2 -> !(element2 instanceof EmptyLookupItem));
        }
    }

    @NotNull
    public String getAdditionalPrefix() {
        String string = this.myOffsets.getAdditionalPrefix();
        if (string == null) {
            LookupImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void fireBeforeAppendPrefix(char c) {
        this.myPrefixChangeListeners.forEach(listener2 -> listener2.beforeAppend(c));
    }

    public void appendPrefix(char c) {
        this.appendPrefix(c, true);
    }

    public void appendPrefix(char c, boolean refreshUi) {
        this.checkValid();
        this.myOffsets.appendPrefix(c);
        this.myPresentableArranger.prefixChanged(this);
        this.requestResize();
        if (refreshUi) {
            this.refreshUi(false, true);
            this.ensureSelectionVisible(true);
        }
        this.myPrefixChangeListeners.forEach(listener2 -> listener2.afterAppend(c));
    }

    public void setStartCompletionWhenNothingMatches(boolean startCompletionWhenNothingMatches) {
        this.myStartCompletionWhenNothingMatches = startCompletionWhenNothingMatches;
    }

    public boolean isStartCompletionWhenNothingMatches() {
        return this.myStartCompletionWhenNothingMatches;
    }

    public void ensureSelectionVisible(boolean forceTopSelection) {
        int firstVisibleIndex;
        if (this.isSelectionVisible() && !forceTopSelection) {
            return;
        }
        if (!forceTopSelection) {
            ScrollingUtil.ensureIndexIsVisible((JList)this.myList, (int)this.myList.getSelectedIndex(), (int)1);
            return;
        }
        int top = this.myList.getSelectedIndex();
        if (top > 0) {
            --top;
        }
        if ((firstVisibleIndex = this.myList.getFirstVisibleIndex()) == top) {
            return;
        }
        ScrollingUtil.ensureRangeIsVisible((JList)this.myList, (int)top, (int)(top + this.myList.getLastVisibleIndex() - firstVisibleIndex));
    }

    public void truncatePrefix(boolean preserveSelection, int hideOffset) {
        this.truncatePrefix(preserveSelection, hideOffset, true);
    }

    public void truncatePrefix(boolean preserveSelection, int hideOffset, boolean refreshUi) {
        if (!this.myOffsets.truncatePrefix()) {
            this.myArranger.prefixTruncated(this, hideOffset);
            return;
        }
        this.myPrefixChangeListeners.forEach(listener2 -> listener2.beforeTruncate());
        if (preserveSelection) {
            this.markSelectionTouched();
        }
        this.myPresentableArranger.prefixChanged(this);
        this.requestResize();
        if (refreshUi && this.myPresentableArranger == this.myArranger) {
            this.refreshUi(false, true);
            this.ensureSelectionVisible(true);
        }
        this.myPrefixChangeListeners.forEach(listener2 -> listener2.afterTruncate());
    }

    void moveToCaretPosition() {
        this.myOffsets.destabilizeLookupStart();
        this.refreshUi(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateList(boolean onExplicitAction, boolean reused) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        this.checkValid();
        CollectionListModel<LookupElement> listModel = this.getListModel();
        Pair<List<LookupElement>, Integer> pair = this.myPresentableArranger.arrangeItems(this, onExplicitAction || reused);
        List items = (List)pair.first;
        Integer toSelect2 = (Integer)pair.second;
        if (toSelect2 == null || toSelect2 < 0 || items.size() > 0 && toSelect2 >= items.size()) {
            LOG.error("Arranger " + this.myPresentableArranger + " returned invalid selection index=" + toSelect2 + "; items=" + items);
            toSelect2 = 0;
        }
        this.myOffsets.checkMinPrefixLengthChanges(items, this);
        List oldModel = listModel.toList();
        Object object = this.myUiLock;
        synchronized (object) {
            listModel.removeAll();
            if (!items.isEmpty()) {
                listModel.add(items);
                this.addDummyItems(this.myDummyItemCount.get());
            } else {
                this.addEmptyItem(listModel);
            }
        }
        this.updateListHeight((ListModel<LookupElement>)listModel);
        this.myList.setSelectedIndex(toSelect2.intValue());
        return !ContainerUtil.equalsIdentity((List)oldModel, (List)items);
    }

    public boolean isSelectionVisible() {
        return ScrollingUtil.isIndexFullyVisible((JList)this.myList, (int)this.myList.getSelectedIndex());
    }

    private boolean checkReused() {
        EDT.assertIsEdt();
        if (this.myPresentableArranger != this.myArranger) {
            this.myPresentableArranger = this.myArranger;
            this.clearIfLookupAndArrangerPrefixesMatch();
            this.myPresentableArranger.prefixChanged(this);
            return true;
        }
        return false;
    }

    private void clearIfLookupAndArrangerPrefixesMatch() {
        boolean isCompletionArranger = this.myArranger instanceof CompletionLookupArrangerImpl;
        if (isCompletionArranger) {
            String lastLookupArrangersPrefix = ((CompletionLookupArrangerImpl)this.myArranger).getLastLookupPrefix();
            if (lastLookupArrangersPrefix != null && !lastLookupArrangersPrefix.equals(this.getAdditionalPrefix())) {
                LOG.trace("prefixes don't match, do not clear lookup additional prefix");
            } else {
                this.myOffsets.clearAdditionalPrefix();
            }
        } else {
            this.myOffsets.clearAdditionalPrefix();
        }
    }

    private void updateListHeight(ListModel<LookupElement> model2) {
        this.myList.setFixedCellHeight(this.myCellRenderer.getListCellRendererComponent((JList)this.myList, (LookupElement)model2.getElementAt((int)0), (int)0, (boolean)false, (boolean)false).getPreferredSize().height);
        this.myList.setVisibleRowCount(Math.min(model2.getSize(), UISettings.getInstance().getMaxLookupListHeight()));
    }

    private void addEmptyItem(CollectionListModel<? super LookupElement> model2) {
        EmptyLookupItem item = new EmptyLookupItem(this.myCalculating ? " " : LangBundle.message((String)"completion.no.suggestions", (Object[])new Object[0]), false);
        model2.add((Object)item);
        this.myCellRenderer.itemAdded(item, LookupElementPresentation.renderElement((LookupElement)item));
        this.requestResize();
    }

    @NotNull
    public String itemPattern(@NotNull LookupElement element2) {
        if (element2 == null) {
            LookupImpl.$$$reportNull$$$0(6);
        }
        if (element2 instanceof EmptyLookupItem) {
            return "";
        }
        String string = this.myPresentableArranger.itemPattern(element2);
        if (string == null) {
            LookupImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public PrefixMatcher itemMatcher(@NotNull LookupElement item) {
        if (item == null) {
            LookupImpl.$$$reportNull$$$0(8);
        }
        if (item instanceof EmptyLookupItem) {
            return new CamelHumpMatcher("");
        }
        PrefixMatcher prefixMatcher = this.myPresentableArranger.itemMatcher(item);
        if (prefixMatcher == null) {
            LookupImpl.$$$reportNull$$$0(9);
        }
        return prefixMatcher;
    }

    public void finishLookup(char completionChar) {
        this.finishLookup(completionChar, (LookupElement)this.myList.getSelectedValue());
    }

    public void finishLookup(char completionChar, @Nullable LookupElement item) {
        boolean writableOk;
        LOG.assertTrue(!ApplicationManager.getApplication().isWriteAccessAllowed(), (Object)"finishLookup should be called without a write action");
        PsiFile file2 = this.getPsiFile();
        boolean bl = writableOk = file2 == null || FileModificationService.getInstance().prepareFileForWrite(file2);
        if (this.isLookupDisposed()) {
            return;
        }
        if (!writableOk) {
            this.hideWithItemSelected(null, completionChar);
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> this.finishLookupInWritableFile(completionChar, item), null, null);
    }

    void finishLookupInWritableFile(char completionChar, @Nullable LookupElement item) {
        if (item == null || !item.isValid() || item instanceof EmptyLookupItem) {
            this.hideWithItemSelected(null, completionChar);
            return;
        }
        if (item.getUserData(CodeCompletionHandlerBase.DIRECT_INSERTION) != null) {
            this.hideWithItemSelected(item, completionChar);
            return;
        }
        if (this.isLookupDisposed()) {
            return;
        }
        String prefix2 = this.itemPattern(item);
        boolean plainMatch = ContainerUtil.or((Iterable)item.getAllLookupStrings(), s -> StringUtil.containsIgnoreCase((String)s, (String)prefix2));
        if (!plainMatch) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.camelHumps");
        }
        this.myFinishing = true;
        if (this.fireBeforeItemSelected(item, completionChar)) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                this.myEditor.getDocument().startGuardedBlockChecking();
                try {
                    this.insertLookupString(item, this.getPrefixLength(item));
                }
                finally {
                    this.myEditor.getDocument().stopGuardedBlockChecking();
                }
            });
        }
        if (this.isLookupDisposed()) {
            return;
        }
        this.doHide(false, true);
        this.fireItemSelected(item, completionChar);
    }

    private void hideWithItemSelected(LookupElement lookupItem, char completionChar) {
        this.fireBeforeItemSelected(lookupItem, completionChar);
        this.doHide(false, true);
        this.fireItemSelected(lookupItem, completionChar);
    }

    public int getPrefixLength(LookupElement item) {
        return this.myOffsets.getPrefixLength(item, this);
    }

    protected void insertLookupString(LookupElement item, int prefix2) {
        LookupImpl.insertLookupString(this.myProject, this.getTopLevelEditor(), item, this.itemMatcher(item), this.itemPattern(item), prefix2);
    }

    public static void insertLookupString(Project project, Editor editor, LookupElement item, PrefixMatcher matcher, String itemPattern, int prefixLength) {
        String lookupString = LookupUtil.getCaseCorrectedLookupString(item, matcher, itemPattern);
        Editor hostEditor = editor;
        hostEditor.getCaretModel().runForEachCaret(__ -> {
            EditorModificationUtil.deleteSelectedText((Editor)hostEditor);
            int caretOffset = hostEditor.getCaretModel().getOffset();
            int offset = LookupUtil.insertLookupInDocumentWindowIfNeeded(project, editor, caretOffset, prefixLength, lookupString);
            hostEditor.getCaretModel().moveToOffset(offset);
            hostEditor.getSelectionModel().removeSelection();
        });
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    public int getLookupStart() {
        return this.myOffsets.getLookupStart(this.disposeTrace);
    }

    public int getLookupOriginalStart() {
        return this.myOffsets.getLookupOriginalStart();
    }

    @Override
    public boolean performGuardedChange(Runnable change) {
        boolean result2;
        this.checkValid();
        this.myEditor.getDocument().startGuardedBlockChecking();
        ++this.myGuardedChanges;
        try {
            result2 = this.myOffsets.performGuardedChange(change);
        }
        finally {
            this.myEditor.getDocument().stopGuardedBlockChecking();
            --this.myGuardedChanges;
        }
        if (!result2 || this.isLookupDisposed()) {
            this.hideLookup(false);
            return false;
        }
        if (this.isVisible() && this.myEditor.getContentComponent().isShowing()) {
            HintManagerImpl.updateLocation(this, this.myEditor, this.myUi.calculatePosition().getLocation());
        }
        this.checkValid();
        return true;
    }

    @Override
    public boolean vetoesHiding() {
        return this.myGuardedChanges > 0;
    }

    public boolean isAvailableToUser() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return this.myShown;
        }
        return this.isVisible();
    }

    public boolean isShown() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        return this.myShown;
    }

    public boolean showLookup() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkValid();
        LOG.assertTrue(!this.myShown);
        this.myShown = true;
        this.myStampShown = System.currentTimeMillis();
        this.fireLookupShown();
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return true;
        }
        if (!UIUtil.isShowing((Component)this.myEditor.getContentComponent())) {
            this.hideLookup(false);
            return false;
        }
        LookupUsageTracker.trackLookup(this.myCreatedTimestamp, this);
        return this.doShowLookup();
    }

    protected boolean doShowLookup() {
        this.myAdComponent.showRandomText();
        if (Boolean.TRUE.equals(this.myEditor.getUserData(AutoPopupController.NO_ADS))) {
            this.myAdComponent.clearAdvertisements();
        }
        this.myUi = new LookupUi(this, this.myAdComponent, this.myList);
        this.myUi.setCalculating(this.myCalculating);
        Point p = this.myUi.calculatePosition().getLocation();
        if (ScreenReader.isActive()) {
            this.myList.setFocusable(true);
            this.setFocusRequestor((JComponent)this.myList);
            AnActionEvent actionEvent = AnActionEvent.createFromDataContext((String)"EditorPopup", null, (DataContext)((EditorImpl)this.myEditor).getDataContext());
            this.delegateActionToEditor("EditorBackSpace", null, actionEvent);
            this.delegateActionToEditor("EditorEscape", null, actionEvent);
            this.delegateActionToEditor("EditorTab", () -> new ChooseItemAction.Replacing(), actionEvent);
            this.delegateActionToEditor("EditorEnter", () -> this.getLookupFocusDegree() == LookupFocusDegree.UNFOCUSED ? new NextVariableAction() : new ChooseItemAction.FocusedOnly(), actionEvent);
            this.delegateActionToEditor("EditorUp", null, actionEvent);
            this.delegateActionToEditor("EditorDown", null, actionEvent);
            this.delegateActionToEditor("EditorRight", null, actionEvent);
            this.delegateActionToEditor("EditorLeft", null, actionEvent);
            this.delegateActionToEditor("RenameElement", null, actionEvent);
        }
        try {
            HintManagerImpl.getInstanceImpl().showEditorHint((LightweightHint)this, this.myEditor, p, 129, 0, false, HintManagerImpl.createHintHint(this.myEditor, p, this, (short)2).setRequestFocus(ScreenReader.isActive()).setAwtTooltip(false));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        if (!this.isVisible() || !this.myList.isShowing()) {
            this.hideLookup(false);
            return false;
        }
        return true;
    }

    private void fireLookupShown() {
        if (!this.myListeners.isEmpty()) {
            LookupEvent event = new LookupEvent((Lookup)this, false);
            for (LookupListener listener2 : this.myListeners) {
                listener2.lookupShown(event);
            }
        }
    }

    private void delegateActionToEditor(@NotNull String actionID, @Nullable Supplier<? extends AnAction> delegateActionSupplier, @NotNull AnActionEvent actionEvent) {
        if (actionID == null) {
            LookupImpl.$$$reportNull$$$0(10);
        }
        if (actionEvent == null) {
            LookupImpl.$$$reportNull$$$0(11);
        }
        AnAction action2 = ActionManager.getInstance().getAction(actionID);
        DumbAwareAction.create(e -> ActionUtil.performActionDumbAwareWithCallbacks((AnAction)(delegateActionSupplier == null ? action2 : (AnAction)delegateActionSupplier.get()), (AnActionEvent)actionEvent)).registerCustomShortcutSet(action2.getShortcutSet(), (JComponent)this.myList);
    }

    public Advertiser getAdvertiser() {
        return this.myAdComponent;
    }

    public boolean mayBeNoticed() {
        return this.myStampShown > 0L && System.currentTimeMillis() - this.myStampShown > 300L;
    }

    private void addListeners() {
        this.myEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (LookupImpl.this.canHide()) {
                    LookupImpl.this.hideLookup(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$2", "documentChanged"));
            }
        }, (Disposable)this);
        EditorMouseListener mouseListener = new EditorMouseListener(){

            public void mouseClicked(@NotNull EditorMouseEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                e.consume();
                LookupImpl.this.hideLookup(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$3", "mouseClicked"));
            }
        };
        this.myEditor.getCaretModel().addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (LookupImpl.this.canHide()) {
                    LookupImpl.this.hideLookup(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$4", "caretPositionChanged"));
            }
        }, (Disposable)this);
        this.myEditor.getSelectionModel().addSelectionListener(new SelectionListener(){

            public void selectionChanged(@NotNull SelectionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (LookupImpl.this.canHide()) {
                    LookupImpl.this.hideLookup(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$5", "selectionChanged"));
            }
        }, (Disposable)this);
        this.myEditor.addEditorMouseListener(mouseListener, (Disposable)this);
        JComponent editorComponent = this.myEditor.getContentComponent();
        if (editorComponent.isShowing()) {
            Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector((Component)editorComponent, new Activatable(){

                public void hideNotify() {
                    LookupImpl.this.hideLookup(false);
                }
            }));
            Window window = ComponentUtil.getWindow((Component)editorComponent);
            if (window != null) {
                ComponentAdapter windowListener2 = new ComponentAdapter(){

                    @Override
                    public void componentMoved(ComponentEvent event) {
                        LookupImpl.this.hideLookup(false);
                    }
                };
                window.addComponentListener(windowListener2);
                Disposer.register((Disposable)this, () -> window.removeComponentListener(windowListener2));
            }
        }
        this.myList.addListSelectionListener(new ListSelectionListener(){
            private LookupElement oldItem = null;

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (!LookupImpl.this.myUpdating) {
                    LookupElement item = LookupImpl.this.getCurrentItem();
                    LookupImpl.this.fireCurrentItemChanged(this.oldItem, item);
                    this.oldItem = item;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$8", "valueChanged"));
            }
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                LookupImpl.this.setLookupFocusDegree(LookupFocusDegree.FOCUSED);
                LookupImpl.this.markSelectionTouched();
                if (clickCount == 2) {
                    CommandProcessor.getInstance().executeCommand(LookupImpl.this.myProject, () -> LookupImpl.this.finishLookup('\n'), "", null, LookupImpl.this.myEditor.getDocument());
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$9", "onClick"));
            }
        }.installOn((Component)this.myList);
        this.addPrefixChangeListener(new PrefixChangeListener(){

            @Override
            public void afterAppend(char c) {
                LookupImpl.this.myCellRenderer.scheduleUpdateLookupWidthFromVisibleItems();
            }
        }, this);
    }

    private boolean canHide() {
        return this.myGuardedChanges == 0 && !this.myFinishing && !this.suppressHidingOnChange() && ClientId.isCurrentlyUnderLocalId();
    }

    protected boolean suppressHidingOnChange() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LookupElement getCurrentItem() {
        Object object = this.myUiLock;
        synchronized (object) {
            LookupElement item = (LookupElement)this.myList.getSelectedValue();
            return item instanceof EmptyLookupItem ? null : item;
        }
    }

    public LookupElement getCurrentItemOrEmpty() {
        return (LookupElement)this.myList.getSelectedValue();
    }

    @Override
    public void setCurrentItem(LookupElement item) {
        this.markSelectionTouched();
        this.myList.setSelectedValue((Object)item, false);
    }

    public void addLookupListener(LookupListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeLookupListener(LookupListener listener2) {
        this.myListeners.remove(listener2);
    }

    public Rectangle getCurrentItemBounds() {
        Rectangle itemBounds;
        int index2 = this.myList.getSelectedIndex();
        if (index2 < 0) {
            LOG.error("No selected element, size=" + this.getListModel().getSize() + "; items" + this.getItems());
        }
        if ((itemBounds = this.myList.getCellBounds(index2, index2)) == null) {
            LOG.error("No bounds for " + index2 + "; size=" + this.getListModel().getSize());
            return null;
        }
        return SwingUtilities.convertRectangle((Component)this.myList, itemBounds, this.getComponent());
    }

    private boolean fireBeforeItemSelected(@Nullable LookupElement item, char completionChar) {
        boolean result2 = true;
        if (!this.myListeners.isEmpty()) {
            LookupEvent event = new LookupEvent((Lookup)this, item, completionChar);
            for (LookupListener listener2 : this.myListeners) {
                try {
                    if (listener2.beforeItemSelected(event)) continue;
                    result2 = false;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        return result2;
    }

    public void fireItemSelected(@Nullable LookupElement item, char completionChar) {
        if (item != null && item.requiresCommittedDocuments()) {
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        }
        this.myArranger.itemSelected(item, completionChar);
        if (!this.myListeners.isEmpty()) {
            LookupEvent event = new LookupEvent((Lookup)this, item, completionChar);
            for (LookupListener listener2 : this.myListeners) {
                try {
                    listener2.itemSelected(event);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    private void fireLookupCanceled(boolean explicitly) {
        if (!this.myListeners.isEmpty()) {
            LookupEvent event = new LookupEvent((Lookup)this, explicitly);
            for (LookupListener listener2 : this.myListeners) {
                try {
                    listener2.lookupCanceled(event);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    private void fireCurrentItemChanged(@Nullable LookupElement oldItem, @Nullable LookupElement currentItem) {
        if (oldItem != currentItem && !this.myListeners.isEmpty()) {
            LookupEvent event = new LookupEvent((Lookup)this, currentItem, '\u0000');
            for (LookupListener listener2 : this.myListeners) {
                listener2.currentItemChanged(event);
            }
        }
        this.myPreview.updatePreview(currentItem);
    }

    private void fireUiRefreshed() {
        for (LookupListener listener2 : this.myListeners) {
            listener2.uiRefreshed();
        }
    }

    public void replacePrefix(String presentPrefix, String newPrefix) {
        if (!this.performGuardedChange(() -> {
            EditorModificationUtil.deleteSelectedText((Editor)this.myEditor);
            int offset = this.myEditor.getCaretModel().getOffset();
            int start2 = offset - presentPrefix.length();
            this.myEditor.getDocument().replaceString(start2, offset, (CharSequence)newPrefix);
            this.myOffsets.clearAdditionalPrefix();
            this.myEditor.getCaretModel().moveToOffset(start2 + newPrefix.length());
        })) {
            return;
        }
        this.myPresentableArranger.prefixReplaced(this, newPrefix);
        this.refreshUi(true, true);
    }

    @Nullable
    public PsiFile getPsiFile() {
        return PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.getEditor().getDocument());
    }

    public boolean isCompletion() {
        return this.myArranger.isCompletion();
    }

    public PsiElement getPsiElement() {
        PsiFile file2 = this.getPsiFile();
        if (file2 == null) {
            return null;
        }
        int offset = this.getLookupStart();
        Editor editor = this.getEditor();
        if (editor instanceof EditorWindow) {
            offset = editor.logicalPositionToOffset(((EditorWindow)editor).hostToInjected(this.myEditor.offsetToLogicalPosition(offset)));
        }
        if (offset > 0) {
            return file2.findElementAt(offset - 1);
        }
        return file2.findElementAt(0);
    }

    @Nullable
    private static DocumentWindow getInjectedDocument(Project project, Editor editor, int offset) {
        PsiFile hostFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (hostFile != null) {
            List injected = InjectedLanguageManager.getInstance((Project)project).getCachedInjectedDocumentsInRange(hostFile, TextRange.create((int)offset, (int)offset));
            for (DocumentWindow documentWindow : injected) {
                if (!documentWindow.isValid() || !documentWindow.containsRange(offset, offset)) continue;
                return documentWindow;
            }
        }
        return null;
    }

    @NotNull
    public Editor getEditor() {
        DocumentWindow documentWindow = LookupImpl.getInjectedDocument(this.myProject, this.myEditor, this.myEditor.getCaretModel().getOffset());
        if (documentWindow != null) {
            PsiFile injectedFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)documentWindow);
            Editor editor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(this.myEditor, injectedFile);
            if (editor == null) {
                LookupImpl.$$$reportNull$$$0(12);
            }
            return editor;
        }
        Editor editor = this.myEditor;
        if (editor == null) {
            LookupImpl.$$$reportNull$$$0(13);
        }
        return editor;
    }

    @NotNull
    public Editor getTopLevelEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            LookupImpl.$$$reportNull$$$0(14);
        }
        return editor;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            LookupImpl.$$$reportNull$$$0(15);
        }
        return project;
    }

    public boolean isPositionedAboveCaret() {
        return this.myUi != null && this.myUi.isPositionedAboveCaret();
    }

    public boolean isSelectionTouched() {
        return this.mySelectionTouched;
    }

    public int getLastVisibleIndex() {
        return this.myList.getLastVisibleIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LookupElement> getVisibleItems() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        int itemsCount = this.myList.getItemsCount();
        if (!this.myShown || itemsCount == 0) {
            return Collections.emptyList();
        }
        Object object = this.myUiLock;
        synchronized (object) {
            int lowerItemIndex = this.myList.getFirstVisibleIndex();
            int higherItemIndex = this.myList.getLastVisibleIndex();
            if (lowerItemIndex < 0 || higherItemIndex < 0) {
                return Collections.emptyList();
            }
            return this.getListModel().toList().subList(lowerItemIndex, Math.min(higherItemIndex + 1, itemsCount));
        }
    }

    public List<String> getAdvertisements() {
        return this.myAdComponent.getAdvertisements();
    }

    @Override
    public void hide() {
        this.hideLookup(true);
    }

    @Override
    public void hideLookup(boolean explicitly) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myHidden) {
            return;
        }
        this.doHide(true, explicitly);
    }

    private void doHide(boolean fireCanceled, boolean explicitly) {
        if (this.isLookupDisposed()) {
            LOG.error(this.formatDisposeTrace());
        }
        if (!this.myClientId.equals((Object)ClientId.getCurrent())) {
            LOG.error(ClientId.getCurrent() + " tries to hide lookup of " + this.myClientId);
        } else {
            this.myHidden = true;
            try {
                super.hide();
                Disposer.dispose((Disposable)this);
                ToolTipManager.sharedInstance().unregisterComponent((JComponent)this.myList);
                assert (this.isLookupDisposed());
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        if (fireCanceled) {
            this.fireLookupCanceled(explicitly);
        }
    }

    @Override
    protected void onPopupCancel() {
        this.hide();
    }

    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (this.myHidden);
        this.myOffsets.disposeMarkers();
        this.disposeTrace = new Throwable();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Disposing lookup:", this.disposeTrace);
        }
    }

    private String formatDisposeTrace() {
        return ExceptionUtil.getThrowableText((Throwable)this.disposeTrace) + "\n============";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUi(boolean mayCheckReused, boolean onExplicitAction) {
        assert (!this.myUpdating);
        LookupElement prevItem = this.getCurrentItem();
        this.myUpdating = true;
        try {
            boolean reused = mayCheckReused && this.checkReused();
            boolean selectionVisible = this.isSelectionVisible();
            boolean itemsChanged = this.updateList(onExplicitAction, reused);
            if (this.isVisible()) {
                LOG.assertTrue(!ApplicationManager.getApplication().isUnitTestMode());
                this.myUi.refreshUi(selectionVisible, itemsChanged, reused, onExplicitAction);
            }
        }
        finally {
            this.myUpdating = false;
            this.fireCurrentItemChanged(prevItem, this.getCurrentItem());
            this.fireUiRefreshed();
        }
    }

    public void markReused() {
        EDT.assertIsEdt();
        this.myArranger = this.myArranger.createEmptyCopy();
        this.requestResize();
    }

    public void addAdvertisement(@NotNull @NlsContexts.PopupAdvertisement String text2, @Nullable Icon icon2) {
        if (text2 == null) {
            LookupImpl.$$$reportNull$$$0(16);
        }
        if (!LookupImpl.containsDummyIdentifier(text2)) {
            this.myAdComponent.addAdvertisement(text2, icon2);
            this.requestResize();
        }
    }

    public boolean isLookupDisposed() {
        return this.disposeTrace != null;
    }

    public void checkValid() {
        if (this.isLookupDisposed()) {
            throw new AssertionError((Object)("Disposed at: " + this.formatDisposeTrace()));
        }
    }

    @Override
    public void showElementActions(@Nullable InputEvent event) {
        if (!this.isVisible()) {
            return;
        }
        LookupElement element2 = this.getCurrentItem();
        if (element2 == null) {
            return;
        }
        Collection<LookupElementAction> actions2 = this.getActionsFor(element2);
        if (actions2.isEmpty()) {
            return;
        }
        UIEventLogger.LookupShowElementActions.log(this.myProject);
        Rectangle itemBounds = this.getCurrentItemBounds();
        Rectangle visibleRect = SwingUtilities.convertRectangle((Component)this.myList, this.myList.getVisibleRect(), this.getComponent());
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new LookupActionsStep(actions2, this, element2));
        Point p = itemBounds.intersects(visibleRect) || event == null ? new Point(itemBounds.x + itemBounds.width, itemBounds.y) : SwingUtilities.convertPoint(event.getComponent(), new Point(0, event.getComponent().getHeight() + JBUIScale.scale((int)2)), this.getComponent());
        listPopup.show(new RelativePoint(this.getComponent(), p));
    }

    @NotNull
    public Map<LookupElement, List<Pair<String, Object>>> getRelevanceObjects(@NotNull Iterable<? extends LookupElement> items, boolean hideSingleValued) {
        if (items == null) {
            LookupImpl.$$$reportNull$$$0(17);
        }
        Map<LookupElement, List<Pair<String, Object>>> map2 = this.myPresentableArranger.getRelevanceObjects(items, hideSingleValued);
        if (map2 == null) {
            LookupImpl.$$$reportNull$$$0(18);
        }
        return map2;
    }

    public void setPrefixChangeListener(PrefixChangeListener listener2) {
        this.myPrefixChangeListeners.add(listener2);
    }

    public void addPrefixChangeListener(PrefixChangeListener listener2, Disposable parentDisposable) {
        ContainerUtil.add((Object)listener2, this.myPrefixChangeListeners, (Disposable)parentDisposable);
    }

    @ApiStatus.Internal
    public void addPresentationCustomizer(@NotNull LookupCellRenderer.ItemPresentationCustomizer customizer) {
        if (customizer == null) {
            LookupImpl.$$$reportNull$$$0(19);
        }
        this.myCellRenderer.addPresentationCustomizer(customizer);
    }

    FontPreferences getFontPreferences() {
        return this.myFontPreferences;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arranger";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/impl/LookupImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupFocusDegree";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionID";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionEvent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupFocusDegree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDummyItem";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPrefix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "itemPattern";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "itemMatcher";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelEditor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelevanceObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setLookupFocusDegree";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scheduleItemUpdate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "itemPattern";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "itemMatcher";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "delegateActionToEditor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addAdvertisement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRelevanceObjects";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addPresentationCustomizer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

