/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.codeInsight.hints.CollectorWithSettings;
import com.intellij.codeInsight.hints.HintUtils;
import com.intellij.codeInsight.hints.InlayHintsPass;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.codeInsight.hints.InlayHintsUtilsKt;
import com.intellij.codeInsight.hints.ProviderWithSettings;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.lang.impl"})
public final class InlayHintsPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    private static final Key<Long> PSI_MODIFICATION_STAMP;
    private static final Key<Boolean> HINTS_DISABLED_FOR_EDITOR;
    private static final Key<Set<SettingsKey<?>>> ALWAYS_ENABLED_HINTS_PROVIDERS;
    @NotNull
    public static final Companion Companion;

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        int[] nArray = new int[]{4};
        boolean bl = false;
        boolean bl2 = false;
        int[] it = nArray;
        boolean bl3 = false;
        int[] ghl = (int[])(((TextEditorHighlightingPassRegistrarImpl)registrar).isSerializeCodeInsightPasses() ? nArray : null);
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, ghl, null, false, -1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (editor.isOneLineMode()) {
            return null;
        }
        Long savedStamp = (Long)editor.getUserData(PSI_MODIFICATION_STAMP);
        long currentStamp = InlayHintsPassFactory.Companion.getCurrentModificationStamp(file2);
        if (savedStamp != null && savedStamp == currentStamp) {
            return null;
        }
        InlayHintsSettings settings2 = InlayHintsSettings.Companion.instance();
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"file.language");
        Language language2 = language;
        if (InlayHintsPassFactory.Companion.isHintsEnabledForEditor(editor)) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Project project = file2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
            Iterable iterable = HintUtils.INSTANCE.getHintProvidersForLanguage(language2, project);
            boolean $i$f$mapNotNull = false;
            void var11_9 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                CollectorWithSettings collectorWithSettings;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                ProviderWithSettings it = (ProviderWithSettings)element$iv$iv;
                boolean bl2 = false;
                if (InlayHintsUtilsKt.getCollectorWrapperFor(it, file2, editor, language2) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                CollectorWithSettings it$iv$iv = collectorWithSettings;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CollectorWithSettings it = (CollectorWithSettings)element$iv$iv;
                boolean bl = false;
                if (!(settings2.hintsShouldBeShown(it.getKey(), language2) || InlayHintsPassFactory.Companion.isProviderAlwaysEnabledForEditor(editor, it.getKey()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List collectors = list2;
        return new InlayHintsPass((PsiElement)file2, collectors, editor);
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"inlay.psi.modification.stamp");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"inlay.psi.modification.stamp\")");
        PSI_MODIFICATION_STAMP = key;
        Key key2 = Key.create((String)"inlay.hints.enabled.for.editor");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create(\"inlay.hints.enabled.for.editor\")");
        HINTS_DISABLED_FOR_EDITOR = key2;
        Key key3 = Key.create((String)"inlay.hints.always.enabled.providers");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"Key.create(\"inlay.hints.always.enabled.providers\")");
        ALWAYS_ENABLED_HINTS_PROVIDERS = key3;
    }

    @JvmStatic
    @ApiStatus.Experimental
    public static final void setHintsEnabled(@NotNull Editor editor, boolean value2) {
        Companion.setHintsEnabled(editor, value2);
    }

    @JvmStatic
    @ApiStatus.Experimental
    public static final void setAlwaysEnabledHintsProviders(@NotNull Editor editor, @Nullable Iterable<? extends SettingsKey<?>> keys2) {
        Companion.setAlwaysEnabledHintsProviders(editor, keys2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u0016\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012J$\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u001a\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0018\u00010\u001bH\u0007J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\tH\u0007R&\u0010\u0003\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002R\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsPassFactory$Companion;", "", "()V", "ALWAYS_ENABLED_HINTS_PROVIDERS", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getALWAYS_ENABLED_HINTS_PROVIDERS$annotations", "HINTS_DISABLED_FOR_EDITOR", "", "getHINTS_DISABLED_FOR_EDITOR$annotations", "PSI_MODIFICATION_STAMP", "", "getPSI_MODIFICATION_STAMP$annotations", "forceHintsUpdateOnNextPass", "", "getCurrentModificationStamp", "file", "Lcom/intellij/psi/PsiFile;", "isHintsEnabledForEditor", "editor", "Lcom/intellij/openapi/editor/Editor;", "isProviderAlwaysEnabledForEditor", "providerKey", "putCurrentModificationStamp", "setAlwaysEnabledHintsProviders", "keys", "", "setHintsEnabled", "value", "intellij.platform.lang.impl"})
    public static final class Companion {
        public final void forceHintsUpdateOnNextPass() {
            EditorFactory editorFactory = EditorFactory.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
            for (Editor editor : editorFactory.getAllEditors()) {
                editor.putUserData(PSI_MODIFICATION_STAMP, null);
            }
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
            Project[] projectArray = projectManager.getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
            Project[] $this$forEach$iv = projectArray;
            boolean $i$f$forEach = false;
            Editor[] editorArray = $this$forEach$iv;
            int n = editorArray.length;
            for (int j = 0; j < n; ++j) {
                Editor element$iv;
                Editor project = element$iv = editorArray[j];
                boolean bl = false;
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }
        }

        @JvmStatic
        private static /* synthetic */ void getPSI_MODIFICATION_STAMP$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getHINTS_DISABLED_FOR_EDITOR$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getALWAYS_ENABLED_HINTS_PROVIDERS$annotations() {
        }

        public final void putCurrentModificationStamp(@NotNull Editor editor, @NotNull PsiFile file2) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            editor.putUserData(PSI_MODIFICATION_STAMP, (Object)this.getCurrentModificationStamp(file2));
        }

        private final long getCurrentModificationStamp(PsiFile file2) {
            PsiManager psiManager = file2.getManager();
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"file.manager");
            PsiModificationTracker psiModificationTracker = psiManager.getModificationTracker();
            Intrinsics.checkNotNullExpressionValue((Object)psiModificationTracker, (String)"file.manager.modificationTracker");
            return psiModificationTracker.getModificationCount();
        }

        private final boolean isHintsEnabledForEditor(Editor editor) {
            return Intrinsics.areEqual((Object)((Boolean)editor.getUserData(HINTS_DISABLED_FOR_EDITOR)), (Object)true) ^ true;
        }

        @JvmStatic
        @ApiStatus.Experimental
        public final void setHintsEnabled(@NotNull Editor editor, boolean value2) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (value2) {
                editor.putUserData(HINTS_DISABLED_FOR_EDITOR, null);
            } else {
                editor.putUserData(HINTS_DISABLED_FOR_EDITOR, (Object)true);
            }
            this.forceHintsUpdateOnNextPass();
        }

        private final boolean isProviderAlwaysEnabledForEditor(Editor editor, SettingsKey<?> providerKey) {
            Set alwaysEnabledProviderKeys = (Set)editor.getUserData(ALWAYS_ENABLED_HINTS_PROVIDERS);
            if (alwaysEnabledProviderKeys == null) {
                return false;
            }
            return alwaysEnabledProviderKeys.contains(providerKey);
        }

        @JvmStatic
        @ApiStatus.Experimental
        public final void setAlwaysEnabledHintsProviders(@NotNull Editor editor, @Nullable Iterable<? extends SettingsKey<?>> keys2) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (keys2 == null) {
                editor.putUserData(ALWAYS_ENABLED_HINTS_PROVIDERS, null);
                return;
            }
            Set keySet = CollectionsKt.toSet(keys2);
            editor.putUserData(ALWAYS_ENABLED_HINTS_PROVIDERS, (Object)keySet);
            this.forceHintsUpdateOnNextPass();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

