/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandlerEP;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.TypingActionsExtension;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.highlighting.NontrivialBraceMatcher;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LanguageQuoteHandling;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PreloadingActivity;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DefaultRawTypedHandler;
import com.intellij.openapi.editor.impl.TypedActionImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileWithOneLanguage;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypedHandler
extends TypedActionHandlerBase {
    private static final Set<Character> COMPLEX_CHARS = Set.of(Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('\"'), Character.valueOf('\''));
    private static final Logger LOG = Logger.getInstance(TypedHandler.class);
    private static final KeyedExtensionCollector<QuoteHandler, String> quoteHandlers = new KeyedExtensionCollector(QuoteHandlerEP.EP_NAME);
    private static final Map<Class<? extends Language>, QuoteHandler> ourBaseLanguageQuoteHandlers = new HashMap<Class<? extends Language>, QuoteHandler>();

    public TypedHandler(TypedActionHandler originalHandler) {
        super(originalHandler);
    }

    @Nullable
    public static QuoteHandler getQuoteHandler(@NotNull PsiFile file2, @NotNull Editor editor) {
        FileType fileFileType;
        FileType fileType;
        QuoteHandler quoteHandler;
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(1);
        }
        if ((quoteHandler = TypedHandler.getQuoteHandlerForType(fileType = TypedHandler.getFileType(file2, editor))) == null && (fileFileType = file2.getFileType()) != fileType) {
            quoteHandler = TypedHandler.getQuoteHandlerForType(fileFileType);
        }
        if (quoteHandler == null) {
            return TypedHandler.getLanguageQuoteHandler(file2.getViewProvider().getBaseLanguage());
        }
        return quoteHandler;
    }

    public static QuoteHandler getLanguageQuoteHandler(Language baseLanguage) {
        for (Map.Entry<Class<? extends Language>, QuoteHandler> entry2 : ourBaseLanguageQuoteHandlers.entrySet()) {
            if (!entry2.getKey().isInstance(baseLanguage)) continue;
            return entry2.getValue();
        }
        return (QuoteHandler)LanguageQuoteHandling.INSTANCE.forLanguage(baseLanguage);
    }

    @NotNull
    static FileType getFileType(@NotNull PsiFile file2, @NotNull Editor editor) {
        LanguageFileType associatedFileType;
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(3);
        }
        FileType fileType = file2.getFileType();
        Language language = PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)file2.getProject());
        if (language != null && language != PlainTextLanguage.INSTANCE && (associatedFileType = language.getAssociatedFileType()) != null) {
            fileType = associatedFileType;
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            TypedHandler.$$$reportNull$$$0(4);
        }
        return fileType2;
    }

    public static void registerBaseLanguageQuoteHandler(@NotNull Class<? extends Language> languageClass, @NotNull QuoteHandler quoteHandler) {
        if (languageClass == null) {
            TypedHandler.$$$reportNull$$$0(5);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(6);
        }
        ourBaseLanguageQuoteHandlers.put(languageClass, quoteHandler);
    }

    public static QuoteHandler getQuoteHandlerForType(@NotNull FileType fileType) {
        if (fileType == null) {
            TypedHandler.$$$reportNull$$$0(7);
        }
        return (QuoteHandler)ContainerUtil.getFirstItem((List)quoteHandlers.forKey((Object)fileType.getName()));
    }

    @Deprecated
    public static void registerQuoteHandler(@NotNull FileType fileType, @NotNull QuoteHandler quoteHandler) {
        if (fileType == null) {
            TypedHandler.$$$reportNull$$$0(8);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(9);
        }
        quoteHandlers.addExplicitExtension((Object)fileType.getName(), (Object)quoteHandler);
    }

    @Override
    public void beforeExecute(@NotNull Editor editor, char c, @NotNull DataContext context2, @NotNull ActionPlan plan) {
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(10);
        }
        if (context2 == null) {
            TypedHandler.$$$reportNull$$$0(11);
        }
        if (plan == null) {
            TypedHandler.$$$reportNull$$$0(12);
        }
        if (COMPLEX_CHARS.contains(Character.valueOf(c)) || Character.isSurrogate(c)) {
            return;
        }
        for (TypedHandlerDelegate delegate2 : TypedHandlerDelegate.EP_NAME.getExtensionList()) {
            if (delegate2.isImmediatePaintingEnabled(editor, c, context2)) continue;
            return;
        }
        if (editor.isInsertMode()) {
            int offset = plan.getCaretOffset();
            plan.replace(offset, offset, String.valueOf(c));
        }
        super.beforeExecute(editor, c, context2, plan);
    }

    public void execute(@NotNull Editor originalEditor, char charTyped, @NotNull DataContext dataContext) {
        if (originalEditor == null) {
            TypedHandler.$$$reportNull$$$0(13);
        }
        if (dataContext == null) {
            TypedHandler.$$$reportNull$$$0(14);
        }
        SlowOperations.allowSlowOperations(() -> this.doExecute(originalEditor, charTyped, dataContext));
    }

    private void doExecute(@NotNull Editor originalEditor, char charTyped, @NotNull DataContext dataContext) {
        PsiFile originalFile;
        Project project;
        if (originalEditor == null) {
            TypedHandler.$$$reportNull$$$0(15);
        }
        if (dataContext == null) {
            TypedHandler.$$$reportNull$$$0(16);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null || (originalFile = PsiUtilBase.getPsiFileInEditor((Editor)originalEditor, (Project)project)) == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(originalEditor, charTyped, dataContext);
            }
            return;
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)originalEditor)) {
            return;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        Document originalDocument = originalEditor.getDocument();
        originalEditor.getCaretModel().runForEachCaret(caret -> {
            boolean handled;
            Editor editor;
            PsiFile file2;
            if (psiDocumentManager.isDocumentBlockedByPsi(originalDocument)) {
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(originalDocument);
            }
            PsiFile psiFile = file2 = (editor = TypedHandler.injectedEditorIfCharTypedIsSignificant(charTyped, originalEditor, originalFile)) == originalEditor ? originalFile : Objects.requireNonNull(psiDocumentManager.getPsiFile(editor.getDocument()));
            if (caret == originalEditor.getCaretModel().getPrimaryCaret() && !(handled = TypedHandler.callDelegates(delegate2 -> delegate2.checkAutoPopup(charTyped, project, editor, file2)))) {
                TypedHandler.autoPopupCompletion(editor, charTyped, project, file2);
                TypedHandler.autoPopupParameterInfo(editor, charTyped, project, file2);
            }
            if (!editor.isInsertMode()) {
                TypedHandler.type(originalEditor, project, charTyped);
                return;
            }
            if (TypedHandler.callDelegates(delegate2 -> delegate2.beforeSelectionRemoved(charTyped, project, editor, file2))) {
                return;
            }
            EditorModificationUtil.deleteSelectedText((Editor)editor);
            FileType fileType = TypedHandler.getFileType(file2, editor);
            if (TypedHandler.callDelegates(delegate2 -> delegate2.beforeCharTyped(charTyped, project, editor, file2, fileType))) {
                return;
            }
            if (')' == charTyped || ']' == charTyped || '}' == charTyped ? FileTypes.PLAIN_TEXT != fileType && TypedHandler.handleRParen(editor, fileType, charTyped) : ('\"' == charTyped || '\'' == charTyped || '`' == charTyped) && TypedHandler.handleQuote(editor, project, charTyped, file2)) {
                return;
            }
            long modificationStampBeforeTyping = editor.getDocument().getModificationStamp();
            TypedHandler.type(originalEditor, project, charTyped);
            AutoHardWrapHandler.getInstance().wrapLineIfNecessary(originalEditor, dataContext, modificationStampBeforeTyping);
            if (editor.isDisposed()) {
                return;
            }
            if (('(' == charTyped || '[' == charTyped || '{' == charTyped) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && fileType != FileTypes.PLAIN_TEXT) {
                TypedHandler.handleAfterLParen(editor, fileType, charTyped);
            } else if ('}' == charTyped) {
                TypedHandler.indentClosingBrace(project, editor);
            } else if (')' == charTyped) {
                TypedHandler.indentClosingParenth(project, editor);
            }
            if (TypedHandler.callDelegates(delegate2 -> delegate2.charTyped(charTyped, project, editor, file2))) {
                return;
            }
            if ('{' == charTyped) {
                TypedHandler.indentOpenedBrace(project, editor);
            } else if ('(' == charTyped) {
                TypedHandler.indentOpenedParenth(project, editor);
            }
        });
    }

    private static boolean callDelegates(Function<? super TypedHandlerDelegate, TypedHandlerDelegate.Result> action2) {
        for (TypedHandlerDelegate delegate2 : TypedHandlerDelegate.EP_NAME.getExtensionList()) {
            TypedHandlerDelegate.Result result2 = action2.apply((TypedHandlerDelegate)delegate2);
            if (result2 == TypedHandlerDelegate.Result.STOP) {
                return true;
            }
            if (result2 != TypedHandlerDelegate.Result.DEFAULT) continue;
            break;
        }
        return false;
    }

    private static void type(Editor editor, Project project, char charTyped) {
        CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message((String)"typing.in.editor.command.name", (Object[])new Object[0]));
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)String.valueOf(charTyped), (boolean)true, (boolean)true);
        ((UndoManagerImpl)UndoManager.getInstance((Project)project)).addDocumentAsAffected(editor.getDocument());
    }

    private static void autoPopupParameterInfo(@NotNull Editor editor, char charTyped, @NotNull Project project, @NotNull PsiFile file2) {
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(17);
        }
        if (project == null) {
            TypedHandler.$$$reportNull$$$0(18);
        }
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(19);
        }
        if (!(charTyped != '(' && charTyped != ',' || TypedHandler.isInsideStringLiteral(editor, file2))) {
            AutoPopupController.getInstance(project).autoPopupParameterInfo(editor, null);
        }
    }

    public static void autoPopupCompletion(@NotNull Editor editor, char charTyped, @NotNull Project project, @NotNull PsiFile file2) {
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(20);
        }
        if (project == null) {
            TypedHandler.$$$reportNull$$$0(21);
        }
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(22);
        }
        if (charTyped == '.' || TypedHandler.isAutoPopup(editor, file2, charTyped)) {
            AutoPopupController.getInstance(project).autoPopupMemberLookup(editor, null);
        }
    }

    public static void commitDocumentIfCurrentCaretIsNotTheFirstOne(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(23);
        }
        if (project == null) {
            TypedHandler.$$$reportNull$$$0(24);
        }
        if (ContainerUtil.getFirstItem((List)editor.getCaretModel().getAllCarets()) != editor.getCaretModel().getCurrentCaret()) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        }
    }

    private static boolean isAutoPopup(@NotNull Editor editor, @NotNull PsiFile file2, char charTyped) {
        int offset;
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(25);
        }
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(26);
        }
        if ((offset = editor.getCaretModel().getOffset() - 1) >= 0) {
            Language language;
            PsiElement element2;
            if (file2 instanceof PsiFileWithOneLanguage) {
                element2 = null;
                language = file2.getLanguage();
            } else {
                element2 = file2.findElementAt(offset);
                if (element2 == null) {
                    return false;
                }
                language = element2.getLanguage();
            }
            for (CompletionContributor contributor : CompletionContributor.forLanguageHonorDumbness((Language)language, (Project)file2.getProject())) {
                if (element2 == null && (element2 = file2.findElementAt(offset)) == null) {
                    return false;
                }
                if (!contributor.invokeAutoPopup(element2, charTyped)) continue;
                LOG.debug(contributor + " requested completion autopopup when typing '" + charTyped + "'");
                return true;
            }
        }
        return false;
    }

    private static boolean isInsideStringLiteral(@NotNull Editor editor, @NotNull PsiFile file2) {
        int offset;
        PsiElement element2;
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(27);
        }
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(28);
        }
        if ((element2 = file2.findElementAt(offset = editor.getCaretModel().getOffset())) == null) {
            return false;
        }
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element2.getLanguage());
        if (definition != null) {
            ASTNode parentNode;
            TokenSet stringLiteralElements = definition.getStringLiteralElements();
            ASTNode node = element2.getNode();
            if (node == null) {
                return false;
            }
            IElementType elementType = node.getElementType();
            if (stringLiteralElements.contains(elementType)) {
                return true;
            }
            PsiElement parent = element2.getParent();
            if (parent != null && (parentNode = parent.getNode()) != null && stringLiteralElements.contains(parentNode.getElementType())) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static Editor injectedEditorIfCharTypedIsSignificant(char charTyped, @NotNull Editor editor, @NotNull PsiFile oldFile) {
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(29);
        }
        if (oldFile == null) {
            TypedHandler.$$$reportNull$$$0(30);
        }
        return TypedHandler.injectedEditorIfCharTypedIsSignificant((int)charTyped, editor, oldFile);
    }

    @NotNull
    public static Editor injectedEditorIfCharTypedIsSignificant(int charTyped, @NotNull Editor editor, @NotNull PsiFile oldFile) {
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(31);
        }
        if (oldFile == null) {
            TypedHandler.$$$reportNull$$$0(32);
        }
        int offset = editor.getCaretModel().getOffset();
        List injected = InjectedLanguageManager.getInstance((Project)oldFile.getProject()).getCachedInjectedDocumentsInRange(oldFile, (TextRange)ProperTextRange.create((int)offset, (int)offset));
        for (DocumentWindow documentWindow : injected) {
            PsiFile injectedFile;
            if (!documentWindow.isValid() || !documentWindow.containsRange(offset, offset) || (injectedFile = PsiDocumentManager.getInstance((Project)oldFile.getProject()).getPsiFile((Document)documentWindow)) == null) continue;
            Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
            TextRange hostRange = documentWindow.getHostRange(offset);
            CharSequence sequence = editor.getDocument().getCharsSequence();
            if ((sequence.length() <= offset || charTyped == Character.codePointAt(sequence, offset)) && (hostRange == null || !hostRange.contains(offset))) continue;
            Editor editor2 = injectedEditor;
            if (editor2 == null) {
                TypedHandler.$$$reportNull$$$0(33);
            }
            return editor2;
        }
        Editor editor3 = editor;
        if (editor3 == null) {
            TypedHandler.$$$reportNull$$$0(34);
        }
        return editor3;
    }

    private static void handleAfterLParen(@NotNull Editor editor, @NotNull FileType fileType, char lparenChar) {
        boolean matched;
        int lparenOffset;
        boolean atEndOfDocument;
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(35);
        }
        if (fileType == null) {
            TypedHandler.$$$reportNull$$$0(36);
        }
        int offset = editor.getCaretModel().getOffset();
        HighlighterIterator iterator2 = editor.getHighlighter().createIterator(offset);
        boolean bl = atEndOfDocument = offset == editor.getDocument().getTextLength();
        if (!atEndOfDocument) {
            iterator2.retreat();
        }
        if (iterator2.atEnd()) {
            return;
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
        if (iterator2.atEnd()) {
            return;
        }
        IElementType braceTokenType = iterator2.getTokenType();
        CharSequence fileText = editor.getDocument().getCharsSequence();
        if (!braceMatcher.isLBraceToken(iterator2, fileText, fileType)) {
            return;
        }
        if (!iterator2.atEnd()) {
            iterator2.advance();
            if (!iterator2.atEnd() && !BraceMatchingUtil.isPairedBracesAllowedBeforeTypeInFileType(braceTokenType, iterator2.getTokenType(), fileType)) {
                return;
            }
            iterator2.retreat();
        }
        if ((lparenOffset = BraceMatchingUtil.findLeftmostLParen(iterator2, braceTokenType, fileText, fileType)) < 0) {
            lparenOffset = 0;
        }
        if (!(matched = BraceMatchingUtil.matchBrace(fileText, fileType, iterator2 = editor.getHighlighter().createIterator(lparenOffset), true, true))) {
            String text2;
            if (lparenChar == '(') {
                text2 = ")";
            } else if (lparenChar == '[') {
                text2 = "]";
            } else if (lparenChar == '<') {
                text2 = ">";
            } else if (lparenChar == '{') {
                text2 = "}";
            } else {
                throw new AssertionError((Object)("Unknown char " + lparenChar));
            }
            editor.getDocument().insertString(offset, (CharSequence)text2);
            TabOutScopesTracker.getInstance().registerEmptyScope(editor, offset);
        }
    }

    public static boolean handleRParen(@NotNull Editor editor, @NotNull FileType fileType, char charTyped) {
        boolean matched;
        CharSequence text2;
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(37);
        }
        if (fileType == null) {
            TypedHandler.$$$reportNull$$$0(38);
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        HighlighterIterator iterator2 = editor.getHighlighter().createIterator(offset);
        if (iterator2.atEnd()) {
            return false;
        }
        if (iterator2.getEnd() - iterator2.getStart() != 1 || editor.getDocument().getCharsSequence().charAt(iterator2.getStart()) != charTyped) {
            return false;
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
        if (!braceMatcher.isRBraceToken(iterator2, text2 = editor.getDocument().getCharsSequence(), fileType)) {
            return false;
        }
        IElementType tokenType = iterator2.getTokenType();
        iterator2.retreat();
        IElementType lparenTokenType = braceMatcher.getOppositeBraceTokenType(tokenType);
        int lparenthOffset = BraceMatchingUtil.findLeftmostLParen(iterator2, lparenTokenType, text2, fileType);
        if (lparenthOffset < 0) {
            if (braceMatcher instanceof NontrivialBraceMatcher) {
                for (IElementType t : ((NontrivialBraceMatcher)braceMatcher).getOppositeBraceTokenTypes(tokenType)) {
                    if (t != lparenTokenType && (lparenthOffset = BraceMatchingUtil.findLeftmostLParen(iterator2, t, text2, fileType)) >= 0) break;
                }
            }
            if (lparenthOffset < 0) {
                return false;
            }
        }
        if (!(matched = BraceMatchingUtil.matchBrace(text2, fileType, iterator2 = editor.getHighlighter().createIterator(lparenthOffset), true, true))) {
            return false;
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        return true;
    }

    @ApiStatus.Internal
    public static boolean handleQuote(@NotNull Editor editor, Project project, char quote, @NotNull PsiFile file2) {
        CharSequence closingQuote;
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(39);
        }
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(40);
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            return false;
        }
        QuoteHandler quoteHandler = TypedHandler.getQuoteHandler(file2, editor);
        if (quoteHandler == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        int length = document.getTextLength();
        if (TypedHandler.isTypingEscapeQuote(editor, quoteHandler, offset)) {
            return false;
        }
        if (offset < length && chars.charAt(offset) == quote && TypedHandler.isClosingQuote(editor, quoteHandler, offset)) {
            EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
            return true;
        }
        HighlighterIterator iterator2 = editor.getHighlighter().createIterator(offset);
        if (!iterator2.atEnd()) {
            IElementType tokenType = iterator2.getTokenType();
            if (quoteHandler instanceof JavaLikeQuoteHandler) {
                try {
                    if (!((JavaLikeQuoteHandler)quoteHandler).isAppropriateElementTypeForLiteral(tokenType)) {
                        return false;
                    }
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
        }
        TypedHandler.type(editor, project, quote);
        offset = editor.getCaretModel().getOffset();
        if (quoteHandler instanceof MultiCharQuoteHandler && (closingQuote = TypedHandler.getClosingQuote(editor, (MultiCharQuoteHandler)quoteHandler, offset)) != null && TypedHandler.hasNonClosedLiterals(editor, quoteHandler, offset - 1) && (offset == document.getTextLength() || !Character.isUnicodeIdentifierPart(document.getCharsSequence().charAt(offset)))) {
            ((MultiCharQuoteHandler)quoteHandler).insertClosingQuote(editor, offset, file2, closingQuote);
            return true;
        }
        if (offset > 0 && TypedHandler.isOpeningQuote(editor, quoteHandler, offset - 1) && TypedHandler.hasNonClosedLiterals(editor, quoteHandler, offset - 1) && (offset == document.getTextLength() || !Character.isUnicodeIdentifierPart(document.getCharsSequence().charAt(offset)))) {
            document.insertString(offset, (CharSequence)String.valueOf(quote));
            TabOutScopesTracker.getInstance().registerEmptyScope(editor, offset);
        }
        return true;
    }

    private static boolean isClosingQuote(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator2;
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(41);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(42);
        }
        if ((iterator2 = editor.getHighlighter().createIterator(offset)).atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.isClosingQuote(iterator2, offset);
    }

    @Nullable
    private static CharSequence getClosingQuote(@NotNull Editor editor, @NotNull MultiCharQuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator2;
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(43);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(44);
        }
        if ((iterator2 = editor.getHighlighter().createIterator(offset)).atEnd()) {
            LOG.assertTrue(false);
            return null;
        }
        return quoteHandler.getClosingQuote(iterator2, offset);
    }

    private static boolean isOpeningQuote(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator2;
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(45);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(46);
        }
        if ((iterator2 = editor.getHighlighter().createIterator(offset)).atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.isOpeningQuote(iterator2, offset);
    }

    private static boolean hasNonClosedLiterals(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator2;
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(47);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(48);
        }
        if ((iterator2 = editor.getHighlighter().createIterator(offset)).atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.hasNonClosedLiteral(editor, iterator2, offset);
    }

    private static boolean isTypingEscapeQuote(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(49);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(50);
        }
        if (offset == 0) {
            return false;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        int offset1 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)"\\");
        int slashCount = offset - 1 - offset1;
        return slashCount % 2 != 0 && TypedHandler.isInsideLiteral(editor, quoteHandler, offset);
    }

    private static boolean isInsideLiteral(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(51);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(52);
        }
        if (offset == 0) {
            return false;
        }
        HighlighterIterator iterator2 = editor.getHighlighter().createIterator(offset - 1);
        if (iterator2.atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.isInsideLiteral(iterator2);
    }

    private static void indentClosingBrace(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            TypedHandler.$$$reportNull$$$0(53);
        }
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(54);
        }
        TypedHandler.indentBrace(project, editor, '}');
    }

    public static void indentOpenedBrace(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            TypedHandler.$$$reportNull$$$0(55);
        }
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(56);
        }
        TypedHandler.indentBrace(project, editor, '{');
    }

    private static void indentOpenedParenth(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            TypedHandler.$$$reportNull$$$0(57);
        }
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(58);
        }
        TypedHandler.indentBrace(project, editor, '(');
    }

    private static void indentClosingParenth(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            TypedHandler.$$$reportNull$$$0(59);
        }
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(60);
        }
        TypedHandler.indentBrace(project, editor, ')');
    }

    public static void indentBrace(@NotNull Project project, @NotNull Editor editor, char braceChar) {
        if (project == null) {
            TypedHandler.$$$reportNull$$$0(61);
        }
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(62);
        }
        int offset = editor.getCaretModel().getOffset() - 1;
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        if (offset < 0 || chars.charAt(offset) != braceChar) {
            return;
        }
        int spaceStart = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t");
        if (spaceStart < 0 || chars.charAt(spaceStart) == '\n' || chars.charAt(spaceStart) == '\r') {
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (file2 == null || !file2.isWritable()) {
                return;
            }
            EditorHighlighter highlighter = editor.getHighlighter();
            HighlighterIterator iterator2 = highlighter.createIterator(offset);
            FileType fileType = file2.getFileType();
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
            boolean rBraceToken = braceMatcher.isRBraceToken(iterator2, chars, fileType);
            boolean isBrace = braceMatcher.isLBraceToken(iterator2, chars, fileType) || rBraceToken;
            int lBraceOffset = -1;
            if (CodeInsightSettings.getInstance().REFORMAT_BLOCK_ON_RBRACE && rBraceToken && braceMatcher.isStructuralBrace(iterator2, chars, fileType) && offset > 0) {
                lBraceOffset = BraceMatchingUtil.findLeftLParen(highlighter.createIterator(offset - 1), braceMatcher.getOppositeBraceTokenType(iterator2.getTokenType()), editor.getDocument().getCharsSequence(), fileType);
            }
            if (isBrace) {
                DefaultRawTypedHandler handler2 = ((TypedActionImpl)TypedAction.getInstance()).getDefaultRawTypedHandler();
                handler2.beginUndoablePostProcessing();
                int finalLBraceOffset = lBraceOffset;
                ApplicationManager.getApplication().runWriteAction(() -> {
                    TypingActionsExtension extension2 = TypingActionsExtension.findForContext(project, editor);
                    try {
                        RangeMarker marker = document.createRangeMarker(offset, offset + 1);
                        if (finalLBraceOffset != -1) {
                            extension2.format(project, editor, 4, finalLBraceOffset, offset, 0, false);
                        } else {
                            extension2.format(project, editor, 3, offset, offset, 0, false);
                        }
                        editor.getCaretModel().moveToOffset(marker.getStartOffset() + 1);
                        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        editor.getSelectionModel().removeSelection();
                        marker.dispose();
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                });
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/TypedHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageClass";
                break;
            }
            case 6: 
            case 9: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoteHandler";
                break;
            }
            case 7: 
            case 8: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plan";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalEditor";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 18: 
            case 21: 
            case 24: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/TypedHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "injectedEditorIfCharTypedIsSignificant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuoteHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileType";
                break;
            }
            case 4: 
            case 33: 
            case 34: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerBaseLanguageQuoteHandler";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getQuoteHandlerForType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerQuoteHandler";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "beforeExecute";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "autoPopupParameterInfo";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "autoPopupCompletion";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "commitDocumentIfCurrentCaretIsNotTheFirstOne";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isAutoPopup";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isInsideStringLiteral";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "injectedEditorIfCharTypedIsSignificant";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "handleAfterLParen";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "handleRParen";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "handleQuote";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isClosingQuote";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getClosingQuote";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isOpeningQuote";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "hasNonClosedLiterals";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isTypingEscapeQuote";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isInsideLiteral";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "indentClosingBrace";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "indentOpenedBrace";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "indentOpenedParenth";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "indentClosingParenth";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "indentBrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class TypedHandlerDelegatePreloader
    extends PreloadingActivity {
        TypedHandlerDelegatePreloader() {
        }

        @Override
        public void preload(@NotNull ProgressIndicator indicator2) {
            if (indicator2 == null) {
                TypedHandlerDelegatePreloader.$$$reportNull$$$0(0);
            }
            if (!ApplicationManagerEx.getApplicationEx().isLightEditMode()) {
                TypedHandlerDelegate.EP_NAME.getExtensionList();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/editorActions/TypedHandler$TypedHandlerDelegatePreloader", "preload"));
        }
    }
}

