/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.editorActions.TypingActionsExtension;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DefaultTypingActionsExtension
implements TypingActionsExtension {
    private static final Logger LOG = Logger.getInstance(DefaultTypingActionsExtension.class);
    private static final int LINE_LIMIT_FOR_BULK_CHANGE = 5000;

    @Override
    public void startCopy(@NotNull Project project, @NotNull Editor editor) {
        boolean commitAllDocuments;
        if (project == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(1);
        }
        List postProcessors = ContainerUtil.filter((Collection)CopyPastePostProcessor.EP_NAME.getExtensionList(), p -> p.requiresAllDocumentsToBeCommitted(editor, project));
        List preProcessors = ContainerUtil.filter((Collection)CopyPastePreProcessor.EP_NAME.getExtensionList(), p -> p.requiresAllDocumentsToBeCommitted(editor, project));
        boolean bl = commitAllDocuments = !preProcessors.isEmpty() || !postProcessors.isEmpty();
        if (LOG.isDebugEnabled()) {
            LOG.debug("CommitAllDocuments: " + commitAllDocuments);
            if (commitAllDocuments) {
                String processorNames = StringUtil.join((Iterable)preProcessors, (String)",") + "," + StringUtil.join((Iterable)postProcessors, (String)",");
                LOG.debug("Processors with commitAllDocuments requirement: [" + processorNames + "]");
            }
        }
        if (commitAllDocuments) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        } else {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        }
    }

    @Override
    public boolean isSuitableContext(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(3);
        }
        LOG.error("Should not be called for `DefaultTypingActionsExtension`. Please, override.");
        return false;
    }

    @Override
    public void format(@NotNull Project project, @NotNull Editor editor, int howtoReformat, int startOffset, int endOffset, int anchorColumn, boolean indentBeforeReformat) {
        if (project == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(5);
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        switch (howtoReformat) {
            case 2: {
                this.indentBlock(project, editor, startOffset, endOffset, anchorColumn);
                break;
            }
            case 3: {
                this.indentEachLine(project, editor, startOffset, endOffset);
                break;
            }
            case 4: {
                RangeMarker bounds2 = editor.getDocument().createRangeMarker(startOffset, endOffset);
                if (indentBeforeReformat) {
                    this.indentEachLine(project, editor, startOffset, endOffset);
                }
                this.reformatRange(project, editor, bounds2.getStartOffset(), bounds2.getEndOffset());
                bounds2.dispose();
            }
        }
    }

    protected void adjustLineIndent(@NotNull Project project, @NotNull Editor editor, int startOffset, int endOffset) {
        if (project == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(7);
        }
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(document);
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            return;
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        try {
            codeStyleManager.adjustLineIndent(file2, new TextRange(startOffset, endOffset));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void adjustLineIndent(@NotNull Project project, @NotNull Editor editor, int offset) {
        if (project == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(9);
        }
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(document);
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            return;
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        try {
            codeStyleManager.adjustLineIndent(file2, offset);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void reformatRange(@NotNull Project project, @NotNull Editor editor, int startOffset, int endOffset) {
        if (project == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(11);
        }
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(document);
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            return;
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        try {
            codeStyleManager.reformatRange((PsiElement)file2, startOffset, endOffset, true);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void indentBlock(@NotNull Project project, @NotNull Editor editor, int startOffset, int endOffset, int originalCaretCol) {
        Document document;
        PsiDocumentManager documentManager;
        PsiFile file2;
        if (project == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(13);
        }
        if ((file2 = (documentManager = PsiDocumentManager.getInstance((Project)project)).getPsiFile(document = editor.getDocument())) == null) {
            return;
        }
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null) {
            this.indentBlockWithFormatter(project, editor, startOffset, endOffset);
        } else {
            DefaultTypingActionsExtension.indentPlainTextBlock(document, startOffset, endOffset, originalCaretCol);
        }
    }

    private void indentEachLine(@NotNull Project project, @NotNull Editor editor, int startOffset, int endOffset) {
        if (project == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(14);
        }
        if (editor == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(15);
        }
        CharSequence text2 = editor.getDocument().getCharsSequence();
        if (startOffset > 0 && endOffset > startOffset + 1 && text2.charAt(endOffset - 1) == '\n' && text2.charAt(startOffset - 1) == '\n') {
            --endOffset;
        }
        this.adjustLineIndent(project, editor, startOffset, endOffset);
    }

    private static void indentPlainTextBlock(@NotNull Document document, int startOffset, int endOffset, int indentLevel) {
        int endLine;
        if (document == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(16);
        }
        CharSequence chars = document.getCharsSequence();
        int spaceEnd = CharArrayUtil.shiftForward((CharSequence)chars, (int)startOffset, (String)" \t");
        int startLine = document.getLineNumber(startOffset);
        if (spaceEnd > endOffset || indentLevel <= 0 || startLine >= document.getLineCount() - 1 || chars.charAt(spaceEnd) == '\n') {
            return;
        }
        for (endLine = startLine + 1; endLine < document.getLineCount() && document.getLineStartOffset(endLine) < endOffset; ++endLine) {
        }
        String indentString = StringUtil.repeatSymbol((char)' ', (int)indentLevel);
        DefaultTypingActionsExtension.indentLines(document, startLine + 1, endLine - 1, indentString);
    }

    private void indentBlockWithFormatter(@NotNull Project project, @NotNull Editor editor, int startOffset, int endOffset) {
        int lastLine;
        if (project == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(17);
        }
        if (editor == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(18);
        }
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        int firstLine = document.getLineNumber(startOffset);
        int firstLineStart = document.getLineStartOffset(firstLine);
        boolean saveLastLineIndent = false;
        for (int i2 = endOffset - 1; i2 >= startOffset; --i2) {
            char c = chars.charAt(i2);
            if (c == '\n') {
                saveLastLineIndent = true;
                break;
            }
            if (c != ' ' && c != '\t') break;
        }
        if (saveLastLineIndent) {
            int indentToKeepEndOffset;
            int i3;
            lastLine = document.getLineNumber(endOffset) - 1;
            int start2 = document.getLineStartOffset(lastLine + 1);
            if (start2 < endOffset && (i3 = CharArrayUtil.shiftForward((CharSequence)chars, (int)start2, (String)" \t")) > start2) {
                i3 = Math.min(i3, endOffset);
                document.deleteString(start2, i3);
            }
            if ((indentToKeepEndOffset = Math.min(startOffset, CharArrayUtil.shiftForward((CharSequence)chars, (int)firstLineStart, (String)" \t"))) > firstLineStart) {
                document.insertString(start2, chars.subSequence(firstLineStart, indentToKeepEndOffset));
            }
        } else {
            lastLine = document.getLineNumber(endOffset);
        }
        int i4 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(startOffset - 1), (String)" \t");
        if (chars.charAt(startOffset) != '\n' && i4 > 0 && chars.charAt(i4) != '\n') {
            int firstNonWsOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)firstLineStart, (String)" \t");
            if (firstNonWsOffset > firstLineStart) {
                CharSequence toInsert = chars.subSequence(firstLineStart, firstNonWsOffset);
                DefaultTypingActionsExtension.indentLines(document, firstLine + 1, lastLine, toInsert);
            }
            return;
        }
        int j = CharArrayUtil.shiftForward((CharSequence)chars, (int)startOffset, (String)" \t\n");
        if (j >= endOffset) {
            return;
        }
        int anchorLine = document.getLineNumber(j);
        int anchorLineStart = document.getLineStartOffset(anchorLine);
        this.adjustLineIndent(project, editor, j);
        if (anchorLine == firstLine && j == startOffset) {
            int indentOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)firstLineStart, (String)" \t");
            if (indentOffset > firstLineStart) {
                CharSequence toInsert = chars.subSequence(firstLineStart, indentOffset);
                DefaultTypingActionsExtension.indentLines(document, firstLine + 1, lastLine, toInsert);
            }
            return;
        }
        int firstNonWsOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)anchorLineStart, (String)" \t");
        int diff = firstNonWsOffset - j;
        if (diff == 0) {
            return;
        }
        if (diff > 0) {
            CharSequence toInsert = chars.subSequence(anchorLineStart, anchorLineStart + diff);
            DefaultTypingActionsExtension.indentLines(document, anchorLine + 1, lastLine, toInsert);
            return;
        }
        if (anchorLine == firstLine && -diff == startOffset - firstLineStart) {
            return;
        }
        if (anchorLine != firstLine || -diff > startOffset - firstLineStart) {
            int desiredSymbolsToRemove = anchorLine == firstLine ? -diff - (startOffset - firstLineStart) : -diff;
            Runnable unindentTask = () -> {
                for (int line = anchorLine + 1; line <= lastLine; ++line) {
                    int currentLineStart = document.getLineStartOffset(line);
                    int currentLineIndentOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)currentLineStart, (String)" \t");
                    int symbolsToRemove = Math.min(currentLineIndentOffset - currentLineStart, desiredSymbolsToRemove);
                    if (symbolsToRemove <= 0) continue;
                    document.deleteString(currentLineStart, currentLineStart + symbolsToRemove);
                }
            };
            DocumentUtil.executeInBulk(document, lastLine - anchorLine > 5000, unindentTask);
        } else {
            CharSequence toInsert = chars.subSequence(anchorLineStart, diff + startOffset);
            DefaultTypingActionsExtension.indentLines(document, anchorLine + 1, lastLine, toInsert);
        }
    }

    private static void indentLines(@NotNull Document document, int startLine, int endLine, @NotNull CharSequence indentString) {
        if (document == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(19);
        }
        if (indentString == null) {
            DefaultTypingActionsExtension.$$$reportNull$$$0(20);
        }
        Runnable indentTask = () -> {
            for (int line = startLine; line <= endLine; ++line) {
                int lineStartOffset = document.getLineStartOffset(line);
                document.insertString(lineStartOffset, indentString);
            }
        };
        DocumentUtil.executeInBulk(document, endLine - startLine > 5000, indentTask);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentString";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/DefaultTypingActionsExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startCopy";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuitableContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "format";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustLineIndent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatRange";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "indentBlock";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "indentEachLine";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "indentPlainTextBlock";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "indentBlockWithFormatter";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "indentLines";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

