/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocFontSizePopup;
import com.intellij.codeInsight.documentation.DocumentationActionProvider;
import com.intellij.codeInsight.documentation.DocumentationComponentListener;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.ToggleShowDocsOnHoverAction;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.BaseNavigateToSourceAction;
import com.intellij.ide.actions.ExternalJavaDocAction;
import com.intellij.ide.actions.WindowAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorCssFontResolver;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.WidthBasedLayout;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ImageLoader;
import com.intellij.util.MathUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.awt.image.renderable.RenderableImageProducer;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.ImageView;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

public class DocumentationComponent
extends JPanel
implements Disposable,
DataProvider,
WidthBasedLayout {
    private static final Logger LOG = Logger.getInstance(DocumentationComponent.class);
    private static final String DOCUMENTATION_TOPIC_ID = "reference.toolWindows.Documentation";
    public static final ColorKey COLOR_KEY = EditorColors.DOCUMENTATION_COLOR;
    public static final Color SECTION_COLOR = Gray.get((int)144);
    private static final Highlighter.HighlightPainter LINK_HIGHLIGHTER = new LinkHighlighter();
    private static final int PREFERRED_HEIGHT_MAX_EM = 10;
    private static final JBDimension MAX_DEFAULT = new JBDimension(650, 500);
    private static final JBDimension MIN_DEFAULT = new JBDimension(300, 36);
    private final ExternalDocAction myExternalDocAction;
    private DocumentationManager myManager;
    private SmartPsiElementPointer<PsiElement> myElement;
    private long myModificationCount;
    private static final String QUICK_DOC_FONT_SIZE_V1_PROPERTY = "quick.doc.font.size";
    private static final String QUICK_DOC_FONT_SIZE_V2_PROPERTY = "quick.doc.font.size.v2";
    private static final String QUICK_DOC_FONT_SIZE_V3_PROPERTY = "quick.doc.font.size.v3";
    private final Stack<Context> myBackStack = new Stack();
    private final Stack<Context> myForwardStack = new Stack();
    private final ActionToolbarImpl myToolBar;
    private volatile boolean myIsEmpty;
    private boolean mySizeTrackerRegistered;
    private boolean myIgnoreFontSizeSliderChange;
    private String myExternalUrl;
    private DocumentationProvider myProvider;
    private Reference<Component> myReferenceComponent;
    private final MyDictionary<String, Image> myImageProvider = new MyDictionary<String, Image>(){

        @Override
        public Image get(Object key) {
            return DocumentationComponent.this.getImageByKeyImpl(key);
        }
    };
    private Runnable myToolwindowCallback;
    private final ActionButton myCorner;
    private final MyScrollPane myScrollPane;
    private final JEditorPane myEditorPane;
    @Nls
    private String myText;
    private final JComponent myControlPanel;
    private boolean myControlPanelVisible;
    private int myHighlightedLink = -1;
    private Object myHighlightingTag;
    private final boolean myStoreSize;
    private boolean myManuallyResized;
    private AbstractPopup myHint;
    private final Map<KeyStroke, ActionListener> myKeyboardActions = new HashMap<KeyStroke, ActionListener>();

    @NotNull
    public static DocumentationComponent createAndFetch(@NotNull Project project, @NotNull PsiElement element2, @NotNull Disposable disposable2) {
        if (project == null) {
            DocumentationComponent.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            DocumentationComponent.$$$reportNull$$$0(1);
        }
        if (disposable2 == null) {
            DocumentationComponent.$$$reportNull$$$0(2);
        }
        DocumentationManager manager2 = DocumentationManager.getInstance(project);
        DocumentationComponent component2 = new DocumentationComponent(manager2);
        Disposer.register((Disposable)disposable2, (Disposable)component2);
        manager2.fetchDocInfo(element2, component2);
        DocumentationComponent documentationComponent = component2;
        if (documentationComponent == null) {
            DocumentationComponent.$$$reportNull$$$0(3);
        }
        return documentationComponent;
    }

    public DocumentationComponent(DocumentationManager manager2) {
        this(manager2, true);
    }

    public DocumentationComponent(final DocumentationManager manager2, boolean storeSize) {
        this.myManager = manager2;
        this.myIsEmpty = true;
        this.myStoreSize = storeSize;
        this.myEditorPane = new JEditorPane(){
            Point initialClick;
            {
                this.enableEvents(8L);
            }

            @Override
            protected void processKeyEvent(KeyEvent e) {
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                ActionListener listener2 = DocumentationComponent.this.myKeyboardActions.get(keyStroke);
                if (listener2 != null) {
                    listener2.actionPerformed(new ActionEvent(DocumentationComponent.this, 0, ""));
                    e.consume();
                    return;
                }
                super.processKeyEvent(e);
            }

            @Override
            protected void processMouseEvent(MouseEvent e) {
                if (e.getID() == 501 && DocumentationComponent.this.myHint != null) {
                    int y;
                    int x;
                    this.initialClick = null;
                    StyledDocument document = (StyledDocument)this.getDocument();
                    if (!(this.hasTextAt(document, x = e.getX(), y = e.getY()) || this.hasTextAt(document, x + 3, y) || this.hasTextAt(document, x - 3, y) || this.hasTextAt(document, x, y + 3) || this.hasTextAt(document, x, y - 3))) {
                        this.initialClick = e.getPoint();
                    }
                }
                super.processMouseEvent(e);
            }

            private boolean hasTextAt(StyledDocument document, int x, int y) {
                Element element2 = document.getCharacterElement(this.viewToModel(new Point(x, y)));
                try {
                    String text2 = document.getText(element2.getStartOffset(), element2.getEndOffset() - element2.getStartOffset());
                    if (StringUtil.isEmpty((String)text2.trim())) {
                        return false;
                    }
                }
                catch (BadLocationException ignored) {
                    return false;
                }
                return true;
            }

            @Override
            protected void processMouseMotionEvent(MouseEvent e) {
                if (e.getID() == 506 && DocumentationComponent.this.myHint != null && this.initialClick != null) {
                    Point location = DocumentationComponent.this.myHint.getLocationOnScreen();
                    DocumentationComponent.this.myHint.setLocation(new Point(location.x + e.getX() - this.initialClick.x, location.y + e.getY() - this.initialClick.y));
                    e.consume();
                    return;
                }
                super.processMouseMotionEvent(e);
            }

            @Override
            protected void paintComponent(Graphics g) {
                GraphicsUtil.setupAntialiasing((Graphics)g);
                super.paintComponent(g);
            }

            @Override
            public void setDocument(Document doc) {
                super.setDocument(doc);
                doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
                if (doc instanceof StyledDocument) {
                    doc.putProperty("imageCache", DocumentationComponent.this.myImageProvider);
                }
            }
        };
        DataProvider helpDataProvider = dataId -> PlatformDataKeys.HELP_ID.is(dataId) ? DOCUMENTATION_TOPIC_ID : null;
        this.myEditorPane.putClientProperty("DataProvider", helpDataProvider);
        this.myText = "";
        this.myEditorPane.setEditable(false);
        if (ScreenReader.isActive()) {
            this.myEditorPane.getCaret().setVisible(true);
        } else {
            this.myEditorPane.putClientProperty("caretWidth", 0);
            UIUtil.doNotScrollToCaret((JTextComponent)this.myEditorPane);
        }
        this.myEditorPane.setBackground(EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)COLOR_KEY));
        JBHtmlEditorKit editorKit = new JBHtmlEditorKit(true, true){

            public ViewFactory getViewFactory() {
                JBHtmlEditorKit.JBHtmlFactory factory2 = new JBHtmlEditorKit.JBHtmlFactory(){

                    public View create(Element elem) {
                        View view = super.create(elem);
                        if (view instanceof ImageView) {
                            return new MyScalingImageView(elem);
                        }
                        return view;
                    }
                };
                factory2.setAdditionalIconResolver(src -> {
                    ModuleType id2 = ModuleTypeManager.getInstance().findByID(src);
                    return id2 == null ? null : id2.getIcon();
                });
                return factory2;
            }
        };
        DocumentationComponent.prepareCSS(editorKit);
        this.myEditorPane.setEditorKit((EditorKit)editorKit);
        this.myEditorPane.setBorder((Border)JBUI.Borders.empty());
        this.myScrollPane = new MyScrollPane();
        this.myScrollPane.putClientProperty("DataProvider", helpDataProvider);
        final FocusAdapter focusAdapter2 = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Component previouslyFocused = WindowManagerEx.getInstanceEx().getFocusedComponent(manager2.getProject(DocumentationComponent.this.getElement()));
                if (previouslyFocused != DocumentationComponent.this.myEditorPane && DocumentationComponent.this.myHint != null && !DocumentationComponent.this.myHint.isDisposed()) {
                    DocumentationComponent.this.myHint.cancel();
                }
            }
        };
        this.myEditorPane.addFocusListener(focusAdapter2);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                DocumentationComponent.this.myEditorPane.removeFocusListener(focusAdapter2);
            }
        });
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
        final DefaultActionGroup actions2 = new DefaultActionGroup();
        BackAction back = new BackAction();
        ForwardAction forward = new ForwardAction();
        EditDocumentationSourceAction edit = new EditDocumentationSourceAction();
        this.myExternalDocAction = new ExternalDocAction();
        actions2.add((AnAction)back);
        actions2.add((AnAction)forward);
        actions2.add((AnAction)edit);
        for (DocumentationActionProvider provider2 : (DocumentationActionProvider[])DocumentationActionProvider.EP_NAME.getExtensions()) {
            provider2.additionalActions(this).forEach(arg_0 -> ((DefaultActionGroup)actions2).add(arg_0));
        }
        try {
            String backKey = ScreenReader.isActive() ? "alt LEFT" : "LEFT";
            CustomShortcutSet backShortcutSet = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)backKey), KeymapUtil.parseMouseShortcut((String)"button4")});
            String forwardKey = ScreenReader.isActive() ? "alt RIGHT" : "RIGHT";
            CustomShortcutSet forwardShortcutSet = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)forwardKey), KeymapUtil.parseMouseShortcut((String)"button5")});
            back.registerCustomShortcutSet((ShortcutSet)backShortcutSet, this);
            forward.registerCustomShortcutSet((ShortcutSet)forwardShortcutSet, this);
            back.registerCustomShortcutSet((ShortcutSet)backShortcutSet, this.myEditorPane);
            forward.registerCustomShortcutSet((ShortcutSet)forwardShortcutSet, this.myEditorPane);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        this.myExternalDocAction.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"UP"}), this);
        this.myExternalDocAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExternalJavaDoc").getShortcutSet(), this.myEditorPane);
        edit.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this);
        PopupHandler popupHandler = new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu contextMenu = ((ActionManagerImpl)ActionManager.getInstance()).createActionPopupMenu("JavadocToolbar", (ActionGroup)actions2, new MenuItemPresentationFactory(true));
                contextMenu.getComponent().show(comp, x, y);
            }
        };
        this.myEditorPane.addMouseListener((MouseListener)popupHandler);
        Disposer.register((Disposable)this, () -> this.myEditorPane.removeMouseListener((MouseListener)popupHandler));
        new NextLinkAction().registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"TAB"}), this);
        new PreviousLinkAction().registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"shift TAB"}), this);
        new ActivateLinkAction().registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER"}), this);
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        toolbarActions.add((AnAction)actions2);
        toolbarActions.addAction((AnAction)new ShowAsToolwindowAction()).setAsSecondary(true);
        toolbarActions.addAction((AnAction)new ToggleShowDocsOnHoverAction(this.myManager, true)).setAsSecondary(true);
        toolbarActions.addAction((AnAction)new MyShowSettingsAction(true)).setAsSecondary(true);
        toolbarActions.addAction((AnAction)new ShowToolbarAction()).setAsSecondary(true);
        toolbarActions.addAction((AnAction)new RestoreDefaultSizeAction()).setAsSecondary(true);
        this.myToolBar = new ActionToolbarImpl("JavadocToolbar", (ActionGroup)toolbarActions, true){
            Point initialClick;

            @Override
            protected void processMouseEvent(MouseEvent e) {
                if (e.getID() == 501 && DocumentationComponent.this.myHint != null) {
                    this.initialClick = e.getPoint();
                }
                super.processMouseEvent(e);
            }

            @Override
            protected void processMouseMotionEvent(MouseEvent e) {
                if (e.getID() == 506 && DocumentationComponent.this.myHint != null && this.initialClick != null) {
                    Point location = DocumentationComponent.this.myHint.getLocationOnScreen();
                    DocumentationComponent.this.myHint.setLocation(new Point(location.x + e.getX() - this.initialClick.x, location.y + e.getY() - this.initialClick.y));
                    e.consume();
                    return;
                }
                super.processMouseMotionEvent(e);
            }
        };
        this.myToolBar.setSecondaryActionsIcon(AllIcons.Actions.More, true);
        this.myToolBar.setTargetComponent(this);
        JBLayeredPane layeredPane2 = new JBLayeredPane(){

            public void doLayout() {
                Rectangle r = this.getBounds();
                for (Component component2 : this.getComponents()) {
                    if (component2 instanceof JScrollPane) {
                        component2.setBounds(0, 0, r.width, r.height);
                        continue;
                    }
                    Dimension d = component2.getPreferredSize();
                    component2.setBounds(r.width - d.width - 2, r.height - d.height - 7, d.width, d.height);
                }
            }

            public Dimension getPreferredSize() {
                Dimension size = DocumentationComponent.this.myScrollPane.getPreferredSize();
                if (DocumentationComponent.this.myHint == null && DocumentationComponent.this.myManager != null && DocumentationComponent.this.myManager.myToolWindow == null) {
                    int em = DocumentationComponent.this.myEditorPane.getFont().getSize();
                    int prefHeightMax = 10 * em;
                    return new Dimension(size.width, Math.min(prefHeightMax, size.height + (DocumentationComponent.this.needsToolbar() ? DocumentationComponent.this.myControlPanel.getPreferredSize().height : 0)));
                }
                return size;
            }
        };
        layeredPane2.add((Component)((Object)this.myScrollPane));
        layeredPane2.setLayer((Component)((Object)this.myScrollPane), 0);
        MyGearActionGroup gearActions = new MyGearActionGroup(new AnAction[0]);
        ShowAsToolwindowAction showAsToolwindowAction = new ShowAsToolwindowAction();
        gearActions.add(showAsToolwindowAction);
        gearActions.add((AnAction)new ToggleShowDocsOnHoverAction(this.myManager, false));
        gearActions.add(new MyShowSettingsAction(false));
        gearActions.add((AnAction)new ShowToolbarAction());
        gearActions.add(new RestoreDefaultSizeAction());
        gearActions.addSeparator();
        gearActions.addAll((ActionGroup)actions2);
        Presentation presentation2 = new Presentation();
        presentation2.setIcon(AllIcons.Actions.More);
        presentation2.putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)Boolean.TRUE);
        this.myCorner = new ActionButton((AnAction)gearActions, presentation2, "unknown", new Dimension(20, 20)){

            @Override
            protected DataContext getDataContext() {
                return DataManager.getInstance().getDataContext((Component)DocumentationComponent.this.myCorner);
            }
        };
        this.myCorner.setNoIconsInPopup(true);
        showAsToolwindowAction.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"QuickJavaDoc"), this.myCorner);
        layeredPane2.add(this.myCorner);
        layeredPane2.setLayer(this.myCorner, JLayeredPane.POPUP_LAYER);
        this.add((Component)layeredPane2, "Center");
        this.myControlPanel = this.myToolBar.getComponent();
        this.myControlPanel.setBorder(IdeBorderFactory.createBorder((Color)UIUtil.getTooltipSeparatorColor(), (int)8));
        this.myControlPanelVisible = false;
        final HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                HyperlinkEvent.EventType type = e.getEventType();
                if (type == HyperlinkEvent.EventType.ACTIVATED) {
                    manager2.navigateByLink(DocumentationComponent.this, null, e.getDescription());
                }
            }
        };
        this.myEditorPane.addHyperlinkListener(hyperlinkListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                DocumentationComponent.this.myEditorPane.removeHyperlinkListener(hyperlinkListener);
            }
        });
        if (this.myHint != null) {
            Disposer.register((Disposable)this.myHint, (Disposable)this);
        } else if (this.myManager.myToolWindow != null) {
            Disposer.register((Disposable)this.myManager.myToolWindow.getContentManager(), (Disposable)this);
        }
        this.registerActions();
        this.updateControlState();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.myEditorPane != null) {
            this.myEditorPane.setBackground(color);
        }
        if (this.myControlPanel != null) {
            this.myControlPanel.setBackground(color);
        }
    }

    public AnAction[] getActions() {
        return (AnAction[])this.myToolBar.getActions().stream().filter(action2 -> !(action2 instanceof Separator)).toArray(AnAction[]::new);
    }

    public AnAction getFontSizeAction() {
        return new MyShowSettingsAction(false);
    }

    public void removeCornerMenu() {
        this.myCorner.setVisible(false);
    }

    public void setToolwindowCallback(Runnable callback2) {
        this.myToolwindowCallback = callback2;
    }

    public void showExternalDoc() {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
        this.myExternalDocAction.actionPerformed(AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext));
    }

    @Override
    public boolean requestFocusInWindow() {
        if (ScreenReader.isActive()) {
            return this.myEditorPane.requestFocusInWindow();
        }
        return this.myScrollPane.requestFocusInWindow();
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
            if (ScreenReader.isActive()) {
                IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditorPane, true);
            } else {
                IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.myScrollPane), true);
            }
        });
    }

    private static void prepareCSS(@NotNull JBHtmlEditorKit editorKit) {
        if (editorKit == null) {
            DocumentationComponent.$$$reportNull$$$0(4);
        }
        Color borderColor = UIUtil.getTooltipSeparatorColor();
        int leftPadding = 8;
        int definitionTopPadding = 4;
        editorKit.setFontResolver((JBHtmlEditorKit.FontResolver)EditorCssFontResolver.getGlobalInstance());
        String editorFontStyle = "{font-family:\"_EditorFontNoLigatures_\"; font-size: 96%;}";
        editorKit.getStyleSheet().addRule("tt" + editorFontStyle);
        editorKit.getStyleSheet().addRule("code" + editorFontStyle);
        editorKit.getStyleSheet().addRule("pre" + editorFontStyle);
        editorKit.getStyleSheet().addRule(".pre" + editorFontStyle);
        editorKit.getStyleSheet().addRule("html { padding-bottom: 8px; }");
        editorKit.getStyleSheet().addRule("h1, h2, h3, h4, h5, h6 { margin-top: 0; padding-top: 1px; }");
        editorKit.getStyleSheet().addRule("a { color: #" + ColorUtil.toHex((Color)DocumentationComponent.getLinkColor()) + "; text-decoration: none;}");
        editorKit.getStyleSheet().addRule(".definition { padding: " + definitionTopPadding + "px 17px 1px " + leftPadding + "px; border-bottom: thin solid #" + ColorUtil.toHex((Color)borderColor) + "; }");
        editorKit.getStyleSheet().addRule(".definition-only { padding: " + definitionTopPadding + "px 17px 0 " + leftPadding + "px; }");
        editorKit.getStyleSheet().addRule(".definition-only pre { margin-bottom: 0 }");
        editorKit.getStyleSheet().addRule(".content { padding: 5px 16px 0 " + leftPadding + "px; max-width: 100% }");
        editorKit.getStyleSheet().addRule(".content-separated { padding: 5px 16px 5px " + leftPadding + "px; max-width: 100%;                     border-bottom: thin solid #" + ColorUtil.toHex((Color)borderColor) + "; }");
        editorKit.getStyleSheet().addRule(".content-only { padding: 8px 16px 0 " + leftPadding + "px; max-width: 100% }");
        editorKit.getStyleSheet().addRule(".bottom { padding: 3px 16px 0 " + leftPadding + "px; }");
        editorKit.getStyleSheet().addRule(".bottom-no-content { padding: 5px 16px 0 " + leftPadding + "px; }");
        editorKit.getStyleSheet().addRule("p { padding: 1px 0 2px 0; }");
        editorKit.getStyleSheet().addRule("ol { padding: 0 16px 0 0; }");
        editorKit.getStyleSheet().addRule("ul { padding: 0 16px 0 0; }");
        editorKit.getStyleSheet().addRule("li { padding: 1px 0 2px 0; }");
        editorKit.getStyleSheet().addRule(".grayed { color: #909090; display: inline;}");
        editorKit.getStyleSheet().addRule(".centered { text-align: center}");
        editorKit.getStyleSheet().addRule(".sections { padding: 0 16px 0 " + leftPadding + "px; border-spacing: 0; }");
        editorKit.getStyleSheet().addRule("tr { margin: 0 0 0 0; padding: 0 0 0 0; }");
        editorKit.getStyleSheet().addRule("table p { padding-bottom: 0}");
        editorKit.getStyleSheet().addRule("td { margin: 4px 0 0 0; padding: 0 0 0 0; }");
        editorKit.getStyleSheet().addRule("th { text-align: left; }");
        editorKit.getStyleSheet().addRule("td pre { padding: 1px 0 0 0; margin: 0 0 0 0 }");
        editorKit.getStyleSheet().addRule(".section { color: " + ColorUtil.toHtmlColor((Color)SECTION_COLOR) + "; padding-right: 4px; white-space:nowrap;}");
    }

    private static Color getLinkColor() {
        return JBUI.CurrentTheme.Link.Foreground.ENABLED;
    }

    @Override
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DocumentationComponent.$$$reportNull$$$0(5);
        }
        if (DocumentationManager.SELECTED_QUICK_DOC_TEXT.is(dataId)) {
            String selectedText = this.myEditorPane.getSelectedText();
            return selectedText == null ? null : selectedText.replace('\u00a0', ' ');
        }
        return null;
    }

    @NotNull
    public static FontSize getQuickDocFontSize() {
        FontSize v1 = DocumentationComponent.readFontSizeFromSettings(QUICK_DOC_FONT_SIZE_V1_PROPERTY, true);
        FontSize v2 = DocumentationComponent.readFontSizeFromSettings(QUICK_DOC_FONT_SIZE_V2_PROPERTY, true);
        FontSize v3 = DocumentationComponent.readFontSizeFromSettings(QUICK_DOC_FONT_SIZE_V3_PROPERTY, false);
        if (v3 != null) {
            FontSize fontSize = v3;
            if (fontSize == null) {
                DocumentationComponent.$$$reportNull$$$0(6);
            }
            return fontSize;
        }
        if (v2 != null) {
            v3 = DocumentationComponent.migrateV2ToV3(v2);
            DocumentationComponent.setQuickDocFontSize(v3);
            FontSize fontSize = v3;
            if (fontSize == null) {
                DocumentationComponent.$$$reportNull$$$0(7);
            }
            return fontSize;
        }
        if (v1 != null) {
            v3 = DocumentationComponent.migrateV2ToV3(DocumentationComponent.migrateV1ToV2(v1));
            DocumentationComponent.setQuickDocFontSize(v3);
            FontSize fontSize = v3;
            if (fontSize == null) {
                DocumentationComponent.$$$reportNull$$$0(8);
            }
            return fontSize;
        }
        FontSize fontSize = FontSize.SMALL;
        if (fontSize == null) {
            DocumentationComponent.$$$reportNull$$$0(9);
        }
        return fontSize;
    }

    @NotNull
    private static FontSize migrateV1ToV2(@NotNull FontSize size) {
        if (size == null) {
            DocumentationComponent.$$$reportNull$$$0(10);
        }
        FontSize fontSize = size == FontSize.X_LARGE ? FontSize.XX_LARGE : (size == FontSize.LARGE ? FontSize.X_LARGE : size);
        if (fontSize == null) {
            DocumentationComponent.$$$reportNull$$$0(11);
        }
        return fontSize;
    }

    @NotNull
    private static FontSize migrateV2ToV3(@NotNull FontSize size) {
        if (size == null) {
            DocumentationComponent.$$$reportNull$$$0(12);
        }
        FontSize fontSize = size == FontSize.X_SMALL ? FontSize.XX_SMALL : (size == FontSize.SMALL ? FontSize.X_SMALL : size);
        if (fontSize == null) {
            DocumentationComponent.$$$reportNull$$$0(13);
        }
        return fontSize;
    }

    @Nullable
    private static FontSize readFontSizeFromSettings(@NotNull String propertyName, boolean unsetAfterReading) {
        String strValue;
        if (propertyName == null) {
            DocumentationComponent.$$$reportNull$$$0(14);
        }
        if ((strValue = PropertiesComponent.getInstance().getValue(propertyName)) != null) {
            if (unsetAfterReading) {
                PropertiesComponent.getInstance().unsetValue(propertyName);
            }
            try {
                return FontSize.valueOf((String)strValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setQuickDocFontSize(@NotNull FontSize fontSize) {
        if (fontSize == null) {
            DocumentationComponent.$$$reportNull$$$0(15);
        }
        PropertiesComponent.getInstance().setValue(QUICK_DOC_FONT_SIZE_V3_PROPERTY, fontSize.toString());
    }

    public boolean isEmpty() {
        return this.myIsEmpty;
    }

    public void startWait() {
        this.myIsEmpty = true;
    }

    private void setControlPanelVisible() {
        if (this.myControlPanelVisible) {
            return;
        }
        this.add((Component)this.myControlPanel, "North");
        this.myControlPanelVisible = true;
    }

    public void setHint(JBPopup hint) {
        this.myHint = (AbstractPopup)hint;
    }

    public JBPopup getHint() {
        return this.myHint;
    }

    public JComponent getComponent() {
        return this.myEditorPane;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement != null ? this.myElement.getElement() : null;
    }

    private void setElement(SmartPsiElementPointer<PsiElement> element2) {
        this.myElement = element2;
        this.myModificationCount = this.getCurrentModificationCount();
    }

    public boolean isUpToDate() {
        return this.getElement() != null && this.myModificationCount == this.getCurrentModificationCount();
    }

    private long getCurrentModificationCount() {
        return this.myElement != null ? PsiModificationTracker.SERVICE.getInstance((Project)this.myElement.getProject()).getModificationCount() : -1L;
    }

    public void setText(@NotNull @Nls String text2, @Nullable PsiElement element2, @Nullable DocumentationProvider provider2) {
        if (text2 == null) {
            DocumentationComponent.$$$reportNull$$$0(16);
        }
        this.setData(element2, text2, null, null, provider2);
    }

    public void replaceText(@NotNull @Nls String text2, @Nullable PsiElement element2) {
        PsiElement current2;
        if (text2 == null) {
            DocumentationComponent.$$$reportNull$$$0(17);
        }
        if ((current2 = this.getElement()) == null || !current2.getManager().areElementsEquivalent(current2, element2)) {
            return;
        }
        this.restoreContext(this.saveContext().withText(text2));
    }

    public void clearHistory() {
        this.myForwardStack.clear();
        this.myBackStack.clear();
    }

    private void pushHistory() {
        if (this.myElement != null) {
            this.myBackStack.push((Object)this.saveContext());
            this.myForwardStack.clear();
        }
    }

    public void setData(@Nullable PsiElement element2, @NotNull @Nls String text2, @Nullable String effectiveExternalUrl, @Nullable String ref, @Nullable DocumentationProvider provider2) {
        if (text2 == null) {
            DocumentationComponent.$$$reportNull$$$0(18);
        }
        this.pushHistory();
        this.myExternalUrl = effectiveExternalUrl;
        this.myProvider = provider2;
        SmartPsiElementPointer pointer = null;
        if (element2 != null && element2.isValid()) {
            pointer = SmartPointerManager.getInstance((Project)element2.getProject()).createSmartPsiElementPointer(element2);
        }
        this.setDataInternal((SmartPsiElementPointer<PsiElement>)pointer, text2, new Rectangle(0, 0), ref);
    }

    private void setDataInternal(@Nullable SmartPsiElementPointer<PsiElement> element2, @NotNull @Nls String text2, @NotNull Rectangle viewRect, @Nullable String ref) {
        if (text2 == null) {
            DocumentationComponent.$$$reportNull$$$0(19);
        }
        if (viewRect == null) {
            DocumentationComponent.$$$reportNull$$$0(20);
        }
        this.myIsEmpty = false;
        if (this.myManager == null) {
            return;
        }
        this.myText = text2;
        this.setElement(element2);
        if (element2 != null && element2.getElement() != null) {
            this.myManager.updateToolWindowTabName(element2.getElement());
        }
        this.showHint(viewRect, ref);
        if (this.myManager != null) {
            ((DocumentationComponentListener)this.myManager.getProject().getMessageBus().syncPublisher(DocumentationComponentListener.TOPIC)).onComponentDataChanged();
        }
    }

    protected void showHint(@NotNull Rectangle viewRect, @Nullable String ref) {
        Rectangle viewRectToUse;
        String refToUse;
        if (viewRect == null) {
            DocumentationComponent.$$$reportNull$$$0(21);
        }
        if ("$keepScrollingPosition$".equals(ref)) {
            refToUse = null;
            viewRectToUse = this.myScrollPane.getViewport().getViewRect();
        } else {
            refToUse = ref;
            viewRectToUse = viewRect;
        }
        this.updateControlState();
        this.highlightLink(-1);
        this.myEditorPane.setText(this.myText);
        this.applyFontProps();
        this.showHint();
        SwingUtilities.invokeLater(() -> {
            this.myEditorPane.scrollRectToVisible(viewRectToUse);
            if (refToUse != null) {
                UIUtil.scrollToReference((JEditorPane)this.myEditorPane, (String)refToUse);
            } else if (ScreenReader.isActive()) {
                this.myEditorPane.setCaretPosition(0);
            }
        });
    }

    protected void showHint() {
        if (this.myHint == null) {
            return;
        }
        this.setHintSize();
        DataContext dataContext = this.getDataContext();
        PopupPositionManager.positionPopupInBestPosition(this.myHint, this.myManager.getEditor(), dataContext, PopupPositionManager.Position.RIGHT, PopupPositionManager.Position.LEFT);
        Window window = this.myHint.getPopupWindow();
        if (window != null) {
            window.setFocusableWindowState(true);
        }
        this.registerSizeTracker();
    }

    private DataContext getDataContext() {
        Component referenceComponent;
        if (this.myReferenceComponent == null) {
            referenceComponent = IdeFocusManager.getInstance((Project)this.myManager.myProject).getFocusOwner();
            this.myReferenceComponent = new WeakReference<Component>(referenceComponent);
        } else {
            referenceComponent = (Component)SoftReference.dereference(this.myReferenceComponent);
            if (referenceComponent == null || !referenceComponent.isShowing()) {
                referenceComponent = this.myHint.getComponent();
            }
        }
        return DataManager.getInstance().getDataContext(referenceComponent);
    }

    private void setHintSize() {
        Dimension hintSize;
        if (!this.myManuallyResized && this.myHint.getDimensionServiceKey() == null) {
            hintSize = this.getOptimalSize();
        } else {
            if (this.myManuallyResized) {
                hintSize = this.myHint.getSize();
                JBInsets.removeFrom((Dimension)hintSize, (Insets)this.myHint.getContent().getInsets());
            } else {
                hintSize = DimensionService.getInstance().getSize("javadoc.popup.new", this.myManager.myProject);
            }
            if (hintSize == null) {
                hintSize = new Dimension((Dimension)MIN_DEFAULT);
            } else {
                hintSize.width = Math.max(hintSize.width, DocumentationComponent.MIN_DEFAULT.width);
                hintSize.height = Math.max(hintSize.height, DocumentationComponent.MIN_DEFAULT.height);
            }
        }
        this.myHint.setSize(hintSize);
    }

    public Dimension getOptimalSize() {
        int width = this.getPreferredWidth();
        int height = this.getPreferredHeight(width);
        return new Dimension(width, height);
    }

    public int getPreferredWidth() {
        int minWidth = JBUIScale.scale((int)300);
        int maxWidth = this.getPopupAnchor() != null ? JBUIScale.scale((int)435) : JBUIScale.scale((int)DocumentationComponent.MAX_DEFAULT.width);
        int width = this.definitionPreferredWidth();
        width = width < 0 ? this.myEditorPane.getPreferredSize().width : Math.max(width, this.myEditorPane.getMinimumSize().width);
        Insets insets = this.getInsets();
        return MathUtil.clamp((int)width, (int)minWidth, (int)maxWidth) + insets.left + insets.right;
    }

    public int getPreferredHeight(int width) {
        this.myEditorPane.setBounds(0, 0, width, DocumentationComponent.MAX_DEFAULT.height);
        this.myEditorPane.setText(this.myText);
        Dimension preferredSize = this.myEditorPane.getPreferredSize();
        int height = preferredSize.height + (this.needsToolbar() ? this.myControlPanel.getPreferredSize().height : 0);
        JScrollBar scrollBar = this.myScrollPane.getHorizontalScrollBar();
        int reservedForScrollBar = width < preferredSize.width && scrollBar.isOpaque() ? scrollBar.getPreferredSize().height : 0;
        Insets insets = this.getInsets();
        return MathUtil.clamp((int)height, (int)DocumentationComponent.MIN_DEFAULT.height, (int)DocumentationComponent.MAX_DEFAULT.height) + insets.top + insets.bottom + reservedForScrollBar;
    }

    private Component getPopupAnchor() {
        LookupEx lookup2;
        LookupEx lookupEx = lookup2 = this.myManager == null ? null : LookupManager.getActiveLookup(this.myManager.getEditor());
        if (lookup2 != null && lookup2.getCurrentItem() != null && lookup2.getComponent().isShowing()) {
            return lookup2.getComponent();
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        JBPopup popup2 = PopupUtil.getPopupContainerFor((Component)focusOwner);
        if (popup2 != null && popup2 != this.myHint && !popup2.isDisposed()) {
            return popup2.getContent();
        }
        return null;
    }

    private void registerSizeTracker() {
        AbstractPopup hint = this.myHint;
        if (hint == null || this.mySizeTrackerRegistered) {
            return;
        }
        this.mySizeTrackerRegistered = true;
        hint.addResizeListener(this::onManualResizing, this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
                if (action2 == null) {
                    12.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    12.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    12.$$$reportNull$$$0(2);
                }
                if (action2 instanceof WindowAction) {
                    DocumentationComponent.this.onManualResizing();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$12";
                objectArray[2] = "afterActionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void onManualResizing() {
        this.myManuallyResized = true;
        if (this.myStoreSize && this.myHint != null) {
            this.myHint.setDimensionServiceKey("javadoc.popup.new");
            this.myHint.storeDimensionSize();
        }
    }

    private int definitionPreferredWidth() {
        TextUI ui2 = this.myEditorPane.getUI();
        View view = ui2.getRootView(this.myEditorPane);
        View definition = DocumentationComponent.findDefinition(view);
        if (definition == null) {
            return -1;
        }
        int defaultPreferredSize = (int)definition.getPreferredSpan(0);
        int textLength = definition.getDocument().getLength();
        int contentLengthPreferredSize = textLength < 200 ? JBUIScale.scale((int)300) : (textLength > 200 && textLength < 1000 ? JBUIScale.scale((int)300) + JBUIScale.scale((int)1) * (textLength - 200) * 200 / 800 : JBUIScale.scale((int)500));
        return Math.max(contentLengthPreferredSize, defaultPreferredSize);
    }

    private static View findDefinition(View view) {
        if ("definition".equals(view.getElement().getAttributes().getAttribute(HTML.Attribute.CLASS))) {
            return view;
        }
        for (int i2 = 0; i2 < view.getViewCount(); ++i2) {
            View definition = DocumentationComponent.findDefinition(view.getView(i2));
            if (definition == null) continue;
            return definition;
        }
        return null;
    }

    private void applyFontProps() {
        Document document = this.myEditorPane.getDocument();
        if (!(document instanceof StyledDocument)) {
            return;
        }
        String fontName = Registry.is((String)"documentation.component.editor.font") ? EditorColorsManager.getInstance().getGlobalScheme().getEditorFontName() : this.myEditorPane.getFont().getFontName();
        this.myEditorPane.setFont(UIUtil.getFontWithFallback((String)fontName, (int)0, (int)JBUIScale.scale((int)DocumentationComponent.getQuickDocFontSize().getSize())));
    }

    @Nullable
    private Image getImageByKeyImpl(Object key) {
        if (this.myManager == null || key == null) {
            return null;
        }
        PsiElement element2 = this.getElement();
        if (element2 == null) {
            return null;
        }
        URL url = (URL)key;
        Image inMemory = this.myManager.getElementImage(element2, url.toExternalForm());
        if (inMemory != null) {
            return inMemory;
        }
        Url parsedUrl = Urls.parseEncoded((String)url.toExternalForm());
        BuiltInServerManager builtInServerManager = BuiltInServerManager.getInstance();
        if (parsedUrl != null && builtInServerManager.isOnBuiltInWebServer(parsedUrl)) {
            try {
                url = new URL(builtInServerManager.addAuthToken(parsedUrl).toExternalForm());
            }
            catch (MalformedURLException e) {
                LOG.warn((Throwable)e);
            }
        }
        final URL imageUrl = url;
        return Toolkit.getDefaultToolkit().createImage(new RenderableImageProducer(new RenderableImage(){
            private Image myImage;
            private boolean myImageLoaded;

            @Override
            public Vector<RenderableImage> getSources() {
                return null;
            }

            @Override
            public Object getProperty(String name) {
                return null;
            }

            @Override
            public String[] getPropertyNames() {
                return ArrayUtilRt.EMPTY_STRING_ARRAY;
            }

            @Override
            public boolean isDynamic() {
                return false;
            }

            @Override
            public float getWidth() {
                return this.getImage().getWidth(null);
            }

            @Override
            public float getHeight() {
                return this.getImage().getHeight(null);
            }

            @Override
            public float getMinX() {
                return 0.0f;
            }

            @Override
            public float getMinY() {
                return 0.0f;
            }

            @Override
            public RenderedImage createScaledRendering(int w, int h, RenderingHints hints2) {
                return this.createDefaultRendering();
            }

            @Override
            public RenderedImage createDefaultRendering() {
                return (RenderedImage)((Object)this.getImage());
            }

            @Override
            public RenderedImage createRendering(RenderContext renderContext) {
                return this.createDefaultRendering();
            }

            private Image getImage() {
                if (!this.myImageLoaded) {
                    Image image = this.loadImageFromUrl();
                    this.myImage = ImageUtil.toBufferedImage((Image)(image != null ? image : ((ImageIcon)UIManager.getLookAndFeelDefaults().get("html.missingImage")).getImage()), (boolean)false, (boolean)true);
                    this.myImageLoaded = true;
                }
                return this.myImage;
            }

            @Nullable
            private Image loadImageFromUrl() {
                Image image = ImageLoader.loadFromUrl((URL)imageUrl);
                if (image != null && image.getWidth(null) > 0 && image.getHeight(null) > 0) {
                    return image;
                }
                try {
                    BufferedImage direct = ImageIO.read(imageUrl);
                    if (direct != null) {
                        return ImageUtil.ensureHiDPI((Image)direct, (ScaleContext)ScaleContext.create((Component)DocumentationComponent.this.myEditorPane));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return image;
            }
        }, null));
    }

    private void goBack() {
        if (this.myBackStack.isEmpty()) {
            return;
        }
        Context context2 = (Context)this.myBackStack.pop();
        this.myForwardStack.push((Object)this.saveContext());
        this.restoreContext(context2);
    }

    private void goForward() {
        if (this.myForwardStack.isEmpty()) {
            return;
        }
        Context context2 = (Context)this.myForwardStack.pop();
        this.myBackStack.push((Object)this.saveContext());
        this.restoreContext(context2);
    }

    private Context saveContext() {
        Rectangle rect = this.myScrollPane.getViewport().getViewRect();
        return new Context(this.myElement, this.myText, this.myExternalUrl, this.myProvider, rect, this.myHighlightedLink);
    }

    private void restoreContext(@NotNull Context context2) {
        PsiElement element2;
        if (context2 == null) {
            DocumentationComponent.$$$reportNull$$$0(22);
        }
        this.myExternalUrl = context2.externalUrl;
        this.myProvider = context2.provider;
        this.setDataInternal(context2.element, context2.text, context2.viewRect, null);
        this.highlightLink(context2.highlightedLink);
        if (this.myManager != null && (element2 = context2.element.getElement()) != null) {
            this.myManager.updateToolWindowTabName(element2);
        }
    }

    private void updateControlState() {
        if (this.needsToolbar()) {
            this.myToolBar.updateActionsImmediately();
            this.setControlPanelVisible();
            this.removeCornerMenu();
        } else {
            this.myControlPanelVisible = false;
            this.remove(this.myControlPanel);
            if (this.myManager.myToolWindow != null) {
                return;
            }
            this.myCorner.setVisible(true);
        }
    }

    public boolean needsToolbar() {
        return this.myManager.myToolWindow == null && Registry.is((String)"documentation.show.toolbar");
    }

    private static boolean isToolbar(@NotNull AnActionEvent e) {
        if (e == null) {
            DocumentationComponent.$$$reportNull$$$0(23);
        }
        return "JavadocToolbar".equals(e.getPlace());
    }

    private boolean hasExternalDoc() {
        boolean enabled = false;
        if (this.myElement != null && this.myProvider != null) {
            PsiElement element2 = this.myElement.getElement();
            PsiElement originalElement = DocumentationManager.getOriginalElement(element2);
            enabled = element2 != null && CompositeDocumentationProvider.hasUrlsFor((DocumentationProvider)this.myProvider, (PsiElement)element2, (PsiElement)originalElement);
        }
        return enabled;
    }

    private void registerActions() {
        if (!ScreenReader.isActive()) {
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(38, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    int value2 = scrollBar.getValue() - scrollBar.getUnitIncrement(-1);
                    value2 = Math.max(value2, 0);
                    scrollBar.setValue(value2);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(40, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    int value2 = scrollBar.getValue() + scrollBar.getUnitIncrement(1);
                    value2 = Math.min(value2, scrollBar.getMaximum());
                    scrollBar.setValue(value2);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(37, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                    int value2 = scrollBar.getValue() - scrollBar.getUnitIncrement(-1);
                    value2 = Math.max(value2, 0);
                    scrollBar.setValue(value2);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(39, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                    int value2 = scrollBar.getValue() + scrollBar.getUnitIncrement(1);
                    value2 = Math.min(value2, scrollBar.getMaximum());
                    scrollBar.setValue(value2);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(33, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    int value2 = scrollBar.getValue() - scrollBar.getBlockIncrement(-1);
                    value2 = Math.max(value2, 0);
                    scrollBar.setValue(value2);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(34, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    int value2 = scrollBar.getValue() + scrollBar.getBlockIncrement(1);
                    value2 = Math.min(value2, scrollBar.getMaximum());
                    scrollBar.setValue(value2);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(36, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                    scrollBar.setValue(0);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(35, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                    scrollBar.setValue(scrollBar.getMaximum());
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(36, 2), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    scrollBar.setValue(0);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(35, 2), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    scrollBar.setValue(scrollBar.getMaximum());
                }
            });
        }
    }

    @Nls
    public String getText() {
        return this.myText;
    }

    @Nls
    public String getDecoratedText() {
        return this.myText;
    }

    public void dispose() {
        this.myEditorPane.getCaret().setVisible(false);
        this.myBackStack.clear();
        this.myForwardStack.clear();
        this.myKeyboardActions.clear();
        this.myElement = null;
        this.myManager = null;
        this.myHint = null;
    }

    private int getLinkCount() {
        HTMLDocument document = (HTMLDocument)this.myEditorPane.getDocument();
        int linkCount = 0;
        HTMLDocument.Iterator it = document.getIterator(HTML.Tag.A);
        while (it.isValid()) {
            if (it.getAttributes().isDefined(HTML.Attribute.HREF)) {
                ++linkCount;
            }
            it.next();
        }
        return linkCount;
    }

    @Nullable
    private HTMLDocument.Iterator getLink(int n) {
        if (n >= 0) {
            HTMLDocument document = (HTMLDocument)this.myEditorPane.getDocument();
            int linkCount = 0;
            HTMLDocument.Iterator it = document.getIterator(HTML.Tag.A);
            while (it.isValid()) {
                if (it.getAttributes().isDefined(HTML.Attribute.HREF) && linkCount++ == n) {
                    return it;
                }
                it.next();
            }
        }
        return null;
    }

    private void highlightLink(int n) {
        this.myHighlightedLink = n;
        Highlighter highlighter = this.myEditorPane.getHighlighter();
        HTMLDocument.Iterator link2 = this.getLink(n);
        if (link2 != null) {
            int startOffset = link2.getStartOffset();
            int endOffset = link2.getEndOffset();
            try {
                if (this.myHighlightingTag == null) {
                    this.myHighlightingTag = highlighter.addHighlight(startOffset, endOffset, LINK_HIGHLIGHTER);
                } else {
                    highlighter.changeHighlight(this.myHighlightingTag, startOffset, endOffset);
                }
                this.myEditorPane.setCaretPosition(startOffset);
                if (!ScreenReader.isActive()) {
                    this.myEditorPane.scrollRectToVisible(this.myEditorPane.modelToView(startOffset));
                }
            }
            catch (BadLocationException e) {
                LOG.warn("Error highlighting link", (Throwable)e);
            }
        } else if (this.myHighlightingTag != null) {
            highlighter.removeHighlight(this.myHighlightingTag);
            this.myHighlightingTag = null;
        }
    }

    private void activateLink(int n) {
        HTMLDocument.Iterator link2 = this.getLink(n);
        if (link2 != null) {
            String href = (String)link2.getAttributes().getAttribute(HTML.Attribute.HREF);
            this.myManager.navigateByLink(this, null, href);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationComponent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorKit";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontSize";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRect";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndFetch";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickDocFontSize";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "migrateV1ToV2";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "migrateV2ToV3";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAndFetch";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareCSS";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "migrateV1ToV2";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "migrateV2ToV3";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readFontSizeFromSettings";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setQuickDocFontSize";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setData";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setDataInternal";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "restoreContext";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isToolbar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyScalingImageView
    extends ImageView {
        private MyScalingImageView(Element elem) {
            super(elem);
        }

        @Override
        public float getMaximumSpan(int axis) {
            return super.getMaximumSpan(axis) / JBUIScale.sysScale((Component)DocumentationComponent.this.myEditorPane);
        }

        @Override
        public float getMinimumSpan(int axis) {
            return super.getMinimumSpan(axis) / JBUIScale.sysScale((Component)DocumentationComponent.this.myEditorPane);
        }

        @Override
        public float getPreferredSpan(int axis) {
            return super.getPreferredSpan(axis) / JBUIScale.sysScale((Component)DocumentationComponent.this.myEditorPane);
        }

        @Override
        public void paint(Graphics g, Shape a) {
            Rectangle bounds2 = a.getBounds();
            int width = (int)super.getPreferredSpan(0);
            int height = (int)super.getPreferredSpan(1);
            if (width <= 0 || height <= 0) {
                return;
            }
            BufferedImage image = new BufferedImage(width, height, 2);
            Graphics2D graphics = image.createGraphics();
            super.paint(graphics, new Rectangle(image.getWidth(), image.getHeight()));
            StartupUiUtil.drawImage((Graphics)g, (Image)ImageUtil.ensureHiDPI((Image)image, (ScaleContext)ScaleContext.create((Component)DocumentationComponent.this.myEditorPane)), (int)bounds2.x, (int)bounds2.y, null);
        }
    }

    private class RestoreDefaultSizeAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        RestoreDefaultSizeAction() {
            super(CodeInsightBundle.messagePointer((String)"javadoc.restore.size", (Object[])new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreDefaultSizeAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabledAndVisible(DocumentationComponent.this.myHint != null && (DocumentationComponent.this.myManuallyResized || DocumentationComponent.this.myHint.getDimensionServiceKey() != null));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreDefaultSizeAction.$$$reportNull$$$0(1);
            }
            DocumentationComponent.this.myManuallyResized = false;
            if (DocumentationComponent.this.myStoreSize) {
                DimensionService.getInstance().setSize("javadoc.popup.new", null, DocumentationComponent.this.myManager.myProject);
                DocumentationComponent.this.myHint.setDimensionServiceKey(null);
            }
            DocumentationComponent.this.showHint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$RestoreDefaultSizeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowAsToolwindowAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        ShowAsToolwindowAction() {
            super(CodeInsightBundle.messagePointer((String)"javadoc.open.as.tool.window", (Object[])new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowAsToolwindowAction.$$$reportNull$$$0(0);
            }
            Presentation presentation2 = e.getPresentation();
            if (DocumentationComponent.this.myManager == null) {
                presentation2.setEnabledAndVisible(false);
            } else {
                presentation2.setIcon(ToolWindowManager.getInstance((Project)DocumentationComponent.this.myManager.myProject).getLocationIcon("Documentation", EmptyIcon.ICON_16));
                presentation2.setEnabledAndVisible(DocumentationComponent.this.myToolwindowCallback != null);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowAsToolwindowAction.$$$reportNull$$$0(1);
            }
            DocumentationComponent.this.myToolwindowCallback.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$ShowAsToolwindowAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyScrollPane
    extends JBScrollPane {
        MyScrollPane() {
            super((Component)DocumentationComponent.this.myEditorPane, 20, 30);
            this.setLayout((LayoutManager)new JBScrollPane.Layout(){

                public void layoutContainer(Container parent) {
                    Rectangle bounds2;
                    super.layoutContainer(parent);
                    if (!DocumentationComponent.this.myCorner.isVisible()) {
                        return;
                    }
                    if (this.vsb != null) {
                        bounds2 = this.vsb.getBounds();
                        this.vsb.setBounds(bounds2.x, bounds2.y, bounds2.width, bounds2.height - DocumentationComponent.this.myCorner.getPreferredSize().height - 3);
                    }
                    if (this.hsb != null) {
                        bounds2 = this.hsb.getBounds();
                        int vsbOffset = this.vsb != null ? this.vsb.getBounds().width : 0;
                        this.hsb.setBounds(bounds2.x, bounds2.y, bounds2.width - DocumentationComponent.this.myCorner.getPreferredSize().width - 3 + vsbOffset, bounds2.height);
                    }
                }
            });
        }

        public Border getViewportBorder() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processMouseWheelEvent(MouseWheelEvent e) {
            if (!EditorSettingsExternalizable.getInstance().isWheelFontChangeEnabled() || !EditorUtil.isChangeFontSize(e)) {
                super.processMouseWheelEvent(e);
                return;
            }
            int rotation = e.getWheelRotation();
            if (rotation == 0) {
                return;
            }
            boolean increase = rotation <= 0;
            FontSize newFontSize = DocumentationComponent.getQuickDocFontSize();
            for (int change = Math.abs(rotation); change > 0; --change) {
                newFontSize = increase ? newFontSize.larger() : newFontSize.smaller();
            }
            if (newFontSize == DocumentationComponent.getQuickDocFontSize()) {
                return;
            }
            DocumentationComponent.setQuickDocFontSize(newFontSize);
            DocumentationComponent.this.applyFontProps();
            DocumentationComponent.this.myIgnoreFontSizeSliderChange = true;
            try {
                DocFontSizePopup.update();
            }
            finally {
                DocumentationComponent.this.myIgnoreFontSizeSliderChange = false;
            }
        }
    }

    private class ShowToolbarAction
    extends ToggleAction
    implements HintManagerImpl.ActionToIgnore {
        ShowToolbarAction() {
            super(CodeInsightBundle.messagePointer((String)"javadoc.show.toolbar", (Object[])new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowToolbarAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            if (DocumentationComponent.this.myManager == null || DocumentationComponent.this.myManager.myToolWindow != null) {
                e.getPresentation().setEnabledAndVisible(false);
            }
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowToolbarAction.$$$reportNull$$$0(1);
            }
            return Registry.get((String)"documentation.show.toolbar").asBoolean();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowToolbarAction.$$$reportNull$$$0(2);
            }
            Registry.get((String)"documentation.show.toolbar").setValue(state);
            DocumentationComponent.this.updateControlState();
            DocumentationComponent.this.showHint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$ShowToolbarAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LinkHighlighter
    implements Highlighter.HighlightPainter {
        private static final Stroke STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f}, 0.0f);

        private LinkHighlighter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g, int p0, int p1, Shape bounds2, JTextComponent c) {
            try {
                Rectangle target2 = c.getUI().getRootView(c).modelToView(p0, Position.Bias.Forward, p1, Position.Bias.Backward, bounds2).getBounds();
                Graphics2D g2d = (Graphics2D)g.create();
                try {
                    g2d.setStroke(STROKE);
                    g2d.setColor(c.getSelectionColor());
                    g2d.drawRect(target2.x, target2.y, target2.width - 1, target2.height - 1);
                }
                finally {
                    g2d.dispose();
                }
            }
            catch (Exception e) {
                LOG.warn("Error painting link highlight", (Throwable)e);
            }
        }
    }

    private class ActivateLinkAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private ActivateLinkAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ActivateLinkAction.$$$reportNull$$$0(0);
            }
            DocumentationComponent.this.activateLink(DocumentationComponent.this.myHighlightedLink);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/DocumentationComponent$ActivateLinkAction", "actionPerformed"));
        }
    }

    private class NextLinkAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private NextLinkAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            int linkCount;
            if (e == null) {
                NextLinkAction.$$$reportNull$$$0(0);
            }
            if ((linkCount = DocumentationComponent.this.getLinkCount()) <= 0) {
                return;
            }
            DocumentationComponent.this.highlightLink((DocumentationComponent.this.myHighlightedLink + 1) % linkCount);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/DocumentationComponent$NextLinkAction", "actionPerformed"));
        }
    }

    private class PreviousLinkAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private PreviousLinkAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            int linkCount;
            if (e == null) {
                PreviousLinkAction.$$$reportNull$$$0(0);
            }
            if ((linkCount = DocumentationComponent.this.getLinkCount()) <= 0) {
                return;
            }
            DocumentationComponent.this.highlightLink(DocumentationComponent.this.myHighlightedLink < 0 ? linkCount - 1 : (DocumentationComponent.this.myHighlightedLink + linkCount - 1) % linkCount);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/DocumentationComponent$PreviousLinkAction", "actionPerformed"));
        }
    }

    private static abstract class MyDictionary<K, V>
    extends Dictionary<K, V> {
        private MyDictionary() {
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Enumeration<K> keys() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Enumeration<V> elements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V put(K key, V value2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }
    }

    private class MyShowSettingsAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private final boolean myOnToolbar;

        MyShowSettingsAction(boolean onToolbar) {
            super(CodeInsightBundle.message((String)"javadoc.adjust.font.size", (Object[])new Object[0]));
            this.myOnToolbar = onToolbar;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowSettingsAction.$$$reportNull$$$0(0);
            }
            if (DocumentationComponent.this.myManager == null || this.myOnToolbar && DocumentationComponent.this.myManager.myToolWindow != null) {
                e.getPresentation().setEnabledAndVisible(false);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowSettingsAction.$$$reportNull$$$0(1);
            }
            DocFontSizePopup.show(() -> {
                if (DocumentationComponent.this.myIgnoreFontSizeSliderChange) {
                    return;
                }
                DocumentationComponent.this.applyFontProps();
                if (!DocumentationComponent.this.myManuallyResized && DocumentationComponent.this.myHint != null && DocumentationComponent.this.myHint.getDimensionServiceKey() == null) {
                    DocumentationComponent.this.showHint();
                }
            }, DocumentationComponent.this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$MyShowSettingsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Context {
        final SmartPsiElementPointer<PsiElement> element;
        @Nls
        final String text;
        final String externalUrl;
        final DocumentationProvider provider;
        final Rectangle viewRect;
        final int highlightedLink;

        Context(SmartPsiElementPointer<PsiElement> element2, @Nls String text2, String externalUrl, DocumentationProvider provider2, Rectangle viewRect, int highlightedLink) {
            this.element = element2;
            this.text = text2;
            this.externalUrl = externalUrl;
            this.provider = provider2;
            this.viewRect = viewRect;
            this.highlightedLink = highlightedLink;
        }

        @NotNull
        Context withText(@NotNull @Nls String text2) {
            if (text2 == null) {
                Context.$$$reportNull$$$0(0);
            }
            return new Context(this.element, text2, this.externalUrl, this.provider, this.viewRect, this.highlightedLink);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/documentation/DocumentationComponent$Context", "withText"));
        }
    }

    private final class ExternalDocAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private ExternalDocAction() {
            super(CodeInsightBundle.message((String)"javadoc.action.view.external", (Object[])new Object[0]), null, AllIcons.Actions.PreviousOccurence);
            this.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExternalJavaDoc").getShortcutSet(), null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ExternalDocAction.$$$reportNull$$$0(0);
            }
            if (DocumentationComponent.this.myElement == null) {
                return;
            }
            PsiElement element2 = DocumentationComponent.this.myElement.getElement();
            PsiElement originalElement = DocumentationManager.getOriginalElement(element2);
            ExternalJavaDocAction.showExternalJavadoc(element2, originalElement, DocumentationComponent.this.myExternalUrl, e.getDataContext());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExternalDocAction.$$$reportNull$$$0(1);
            }
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(DocumentationComponent.this.hasExternalDoc());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$ExternalDocAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class EditDocumentationSourceAction
    extends BaseNavigateToSourceAction {
        private EditDocumentationSourceAction() {
            super(true);
            this.getTemplatePresentation().setIcon(AllIcons.Actions.EditSource);
            this.getTemplatePresentation().setText(CodeInsightBundle.messagePointer((String)"action.presentation.DocumentationComponent.text", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditDocumentationSourceAction.$$$reportNull$$$0(0);
            }
            super.actionPerformed(e);
            AbstractPopup hint = DocumentationComponent.this.myHint;
            if (hint != null && hint.isVisible()) {
                hint.cancel();
            }
        }

        @Override
        protected Navigatable @Nullable [] getNavigatables(DataContext dataContext) {
            SmartPsiElementPointer<PsiElement> element2 = DocumentationComponent.this.myElement;
            if (element2 != null) {
                Navigatable[] navigatableArray;
                PsiElement psiElement = element2.getElement();
                if (psiElement instanceof Navigatable) {
                    Navigatable[] navigatableArray2 = new Navigatable[1];
                    navigatableArray = navigatableArray2;
                    navigatableArray2[0] = (Navigatable)psiElement;
                } else {
                    navigatableArray = null;
                }
                return navigatableArray;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/DocumentationComponent$EditDocumentationSourceAction", "actionPerformed"));
        }
    }

    private class ForwardAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        ForwardAction() {
            super(CodeInsightBundle.messagePointer((String)"javadoc.action.forward", (Object[])new Object[0]), AllIcons.Actions.Forward);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ForwardAction.$$$reportNull$$$0(0);
            }
            DocumentationComponent.this.goForward();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ForwardAction.$$$reportNull$$$0(1);
            }
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(!DocumentationComponent.this.myForwardStack.isEmpty());
            if (!DocumentationComponent.isToolbar(e)) {
                presentation2.setVisible(presentation2.isEnabled());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$ForwardAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class BackAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        BackAction() {
            super(CodeInsightBundle.messagePointer((String)"javadoc.action.back", (Object[])new Object[0]), AllIcons.Actions.Back);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                BackAction.$$$reportNull$$$0(0);
            }
            DocumentationComponent.this.goBack();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                BackAction.$$$reportNull$$$0(1);
            }
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(!DocumentationComponent.this.myBackStack.isEmpty());
            if (!DocumentationComponent.isToolbar(e)) {
                presentation2.setVisible(presentation2.isEnabled());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$BackAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyGearActionGroup
    extends DefaultActionGroup
    implements HintManagerImpl.ActionToIgnore {
        MyGearActionGroup(AnAction ... actions2) {
            if (actions2 == null) {
                MyGearActionGroup.$$$reportNull$$$0(0);
            }
            super(actions2);
            this.setPopup(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/codeInsight/documentation/DocumentationComponent$MyGearActionGroup", "<init>"));
        }
    }
}

