/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlPathReferenceInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            XmlPathReferenceInspection.$$$reportNull$$$0(0);
        }
        return new XmlElementVisitor(){

            public void visitXmlAttributeValue(XmlAttributeValue value2) {
                XmlPathReferenceInspection.this.checkRefs((PsiElement)value2, holder);
            }

            public void visitXmlDoctype(XmlDoctype xmlDoctype) {
                XmlPathReferenceInspection.this.checkRefs((PsiElement)xmlDoctype, holder);
            }

            public void visitXmlTag(XmlTag tag2) {
                XmlPathReferenceInspection.this.checkRefs((PsiElement)tag2, holder);
            }
        };
    }

    private void checkRefs(PsiElement element2, ProblemsHolder holder) {
        PsiReference[] references;
        for (PsiReference reference2 : references = element2.getReferences()) {
            boolean isHtml;
            if (!XmlHighlightVisitor.isUrlReference(reference2) || XmlHighlightVisitor.isInjectedWithoutValidation(element2) || !this.needToCheckRef(reference2) || (isHtml = HtmlUtil.isHtmlTagContainingFile(element2)) ^ this.isForHtml() || !isHtml && XmlHighlightVisitor.skipValidation(element2)) continue;
            reference2.getElement();
            TextRange range2 = reference2.getElement().getTextRange();
            if (range2 == null || range2.isEmpty() || !XmlHighlightVisitor.hasBadResolve(reference2, false)) continue;
            holder.registerProblem(reference2, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference2), isHtml ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    protected boolean needToCheckRef(PsiReference reference2) {
        return true;
    }

    protected boolean isForHtml() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/XmlPathReferenceInspection", "buildVisitor"));
    }
}

