/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.XmlNSRenderer;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlNamespaceHelper;
import java.util.Collections;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ImportNSAction
implements QuestionAction {
    private final List<String> myNamespaces;
    private final XmlFile myFile;
    private final PsiElement myElement;
    private final Editor myEditor;
    private final @NlsContexts.PopupTitle String myTitle;

    public ImportNSAction(List<String> namespaces, XmlFile file2, @NotNull PsiElement element2, Editor editor, @NlsContexts.PopupTitle String title2) {
        if (element2 == null) {
            ImportNSAction.$$$reportNull$$$0(0);
        }
        this.myNamespaces = namespaces;
        this.myFile = file2;
        this.myElement = element2;
        this.myEditor = editor;
        this.myTitle = title2;
    }

    public boolean execute() {
        int offset = this.myElement.getTextOffset();
        final RangeMarker marker = this.myEditor.getDocument().createRangeMarker(offset, offset);
        Consumer consumer = namespace -> {
            if (namespace != null) {
                Project project = this.myFile.getProject();
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{this.myFile}).run(() -> {
                    final XmlNamespaceHelper extension2 = XmlNamespaceHelper.getHelper((PsiFile)this.myFile);
                    String prefix2 = extension2.getNamespacePrefix(this.myElement);
                    extension2.insertNamespaceDeclaration(this.myFile, this.myEditor, Collections.singleton(namespace), prefix2, new XmlNamespaceHelper.Runner<String, IncorrectOperationException>(){

                        @Override
                        public void run(String s) throws IncorrectOperationException {
                            PsiDocumentManager.getInstance((Project)ImportNSAction.this.myFile.getProject()).doPostponedOperationsAndUnblockDocument(ImportNSAction.this.myEditor.getDocument());
                            PsiElement element2 = ImportNSAction.this.myFile.findElementAt(marker.getStartOffset());
                            if (element2 != null) {
                                extension2.qualifyWithPrefix(s, element2, ImportNSAction.this.myEditor.getDocument());
                            }
                        }
                    });
                });
            }
        };
        if (this.myNamespaces.size() == 1) {
            consumer.consume((Object)this.myNamespaces.get(0));
        } else {
            JBPopupFactory.getInstance().createPopupChooserBuilder(this.myNamespaces).setItemChosenCallback(consumer).setRenderer((ListCellRenderer)((Object)XmlNSRenderer.INSTANCE)).setTitle(this.myTitle).createPopup().showInBestPositionFor(this.myEditor);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ImportNSAction", "<init>"));
    }
}

