/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonTooltipRenderer;
import com.intellij.codeInsight.daemon.impl.DaemonTooltipWithActionRenderer;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoComposite;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.tooltips.TooltipActionProvider;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.ex.TooltipAction;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DaemonTooltipRendererProvider
implements ErrorStripTooltipRendererProvider {
    private final Project myProject;
    private final Editor myEditor;

    DaemonTooltipRendererProvider(Project project, Editor editor) {
        this.myProject = project;
        this.myEditor = editor;
    }

    @Override
    public TooltipRenderer calcTooltipRenderer(@NotNull Collection<? extends RangeHighlighter> highlighters) {
        if (highlighters == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(0);
        }
        LineTooltipRenderer bigRenderer = null;
        SmartList infos = new SmartList();
        HashSet<String> tooltips = new HashSet<String>();
        for (RangeHighlighter rangeHighlighter : highlighters) {
            Object tooltipObject = rangeHighlighter.getErrorStripeTooltip();
            if (tooltipObject == null) continue;
            if (tooltipObject instanceof HighlightInfo) {
                HighlightInfo info2 = (HighlightInfo)tooltipObject;
                if (info2.getToolTip() == null || !tooltips.add(info2.getToolTip())) continue;
                infos.add(info2);
                continue;
            }
            @NlsContexts.Tooltip String text2 = tooltipObject.toString();
            if (!tooltips.add(text2)) continue;
            if (bigRenderer == null) {
                bigRenderer = new DaemonTooltipRenderer(text2, new Object[]{highlighters});
                continue;
            }
            bigRenderer.addBelow(text2);
        }
        if (!infos.isEmpty()) {
            Object[] objectArray;
            ContainerUtil.quickSort((List)infos, (o1, o2) -> {
                int i2 = SeverityRegistrar.getSeverityRegistrar(this.myProject).compare(o2.getSeverity(), o1.getSeverity());
                if (i2 != 0) {
                    return i2;
                }
                return o1.getToolTip().compareTo(o2.getToolTip());
            });
            HighlightInfoComposite composite2 = HighlightInfoComposite.create((List<? extends HighlightInfo>)infos);
            String string = composite2.getToolTip();
            TooltipAction action2 = TooltipActionProvider.calcTooltipAction(composite2, this.myEditor);
            if (action2 == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = string;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = string;
                objectArray = objectArray3;
                objectArray3[1] = action2;
            }
            DaemonTooltipWithActionRenderer myRenderer2 = new DaemonTooltipWithActionRenderer(string, action2, 0, objectArray);
            if (bigRenderer != null) {
                myRenderer2.addBelow(bigRenderer.getText());
            }
            bigRenderer = myRenderer2;
        }
        return bigRenderer;
    }

    @Override
    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text2) {
        if (text2 == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(1);
        }
        return new DaemonTooltipRenderer(text2, new Object[]{text2});
    }

    @Override
    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text2, int width) {
        if (text2 == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(2);
        }
        return new DaemonTooltipRenderer(text2, width, new Object[]{text2});
    }

    @Override
    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text2, @Nullable TooltipAction action2, int width) {
        Object[] objectArray;
        if (text2 == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(3);
        }
        if (action2 == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = text2;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = text2;
            objectArray = objectArray3;
            objectArray3[1] = action2;
        }
        return new DaemonTooltipWithActionRenderer(text2, action2, width, objectArray);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "highlighters";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider";
        objectArray[2] = "calcTooltipRenderer";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

