/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.controlflow;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.controlflow.TransparentInstruction;
import com.intellij.codeInsight.controlflow.impl.ConditionalInstructionImpl;
import com.intellij.codeInsight.controlflow.impl.ControlFlowImpl;
import com.intellij.codeInsight.controlflow.impl.InstructionImpl;
import com.intellij.codeInsight.controlflow.impl.TransparentInstructionImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowBuilder {
    public static final Logger LOG = Logger.getInstance(ControlFlowBuilder.class);
    public List<Instruction> instructions = new ArrayList<Instruction>();
    public Instruction prevInstruction;
    public List<Pair<PsiElement, Instruction>> pending = new ArrayList<Pair<PsiElement, Instruction>>();
    public int instructionCount = 0;
    public int transparentInstructionCount = 0;

    @Nullable
    public Instruction findInstructionByElement(PsiElement element2) {
        for (int i2 = this.instructions.size() - 1; i2 >= 0; --i2) {
            Instruction instruction = this.instructions.get(i2);
            if (!element2.equals(instruction.getElement())) continue;
            return instruction;
        }
        return null;
    }

    @NotNull
    public final ControlFlow getControlFlow() {
        return new ControlFlowImpl(this.instructions.toArray(Instruction.EMPTY_ARRAY));
    }

    @NotNull
    public final ControlFlow getCompleteControlFlow() {
        if (this.transparentInstructionCount == 0) {
            return this.getControlFlow();
        }
        ArrayList<Instruction> result2 = new ArrayList<Instruction>(this.instructionCount);
        int processedTransparentInstructions = 0;
        for (Instruction instruction : this.instructions) {
            if (instruction instanceof TransparentInstruction) {
                ++processedTransparentInstructions;
                Collection predecessors = instruction.allPred();
                Collection successors = instruction.allSucc();
                for (Instruction predecessor : predecessors) {
                    predecessor.replaceSucc(instruction, successors);
                }
                for (Instruction successor : successors) {
                    successor.replacePred(instruction, predecessors);
                }
                continue;
            }
            result2.add(instruction);
        }
        if (result2.size() != this.instructionCount || processedTransparentInstructions != this.transparentInstructionCount) {
            LOG.error("Control flow graph is inconsistent. Instructions: (" + result2.size() + ", " + this.instructionCount + ")\nTransparent instructions: (" + processedTransparentInstructions + ", " + this.transparentInstructionCount + ")");
        }
        if (!this.pending.isEmpty()) {
            LOG.error("Control flow is used incorrectly. All pending node must be connected to fake exit point. Pending: " + this.pending);
        }
        return new ControlFlowImpl(result2.toArray(Instruction.EMPTY_ARRAY));
    }

    public void addEdge(@Nullable Instruction beginInstruction, @Nullable Instruction endInstruction) {
        if (beginInstruction == null || endInstruction == null) {
            return;
        }
        beginInstruction.addSucc(endInstruction);
        endInstruction.addPred(beginInstruction);
    }

    public final void addNode(@NotNull Instruction instruction) {
        if (instruction == null) {
            ControlFlowBuilder.$$$reportNull$$$0(0);
        }
        this.instructions.add(instruction);
        if (this.prevInstruction != null) {
            this.addEdge(this.prevInstruction, instruction);
        }
        this.prevInstruction = instruction;
    }

    public final void addNodeAndCheckPending(Instruction instruction) {
        this.addNode(instruction);
        this.checkPending(instruction);
    }

    public final void flowAbrupted() {
        this.prevInstruction = null;
    }

    public void addPendingEdge(@Nullable PsiElement pendingScope, @Nullable Instruction instruction) {
        int i2;
        if (instruction == null) {
            return;
        }
        if (pendingScope != null) {
            Pair<PsiElement, Instruction> pair;
            PsiElement scope2;
            for (i2 = 0; i2 < this.pending.size() && ((scope2 = (PsiElement)(pair = this.pending.get(i2)).getFirst()) == null || PsiTreeUtil.isAncestor((PsiElement)scope2, (PsiElement)pendingScope, (boolean)true)); ++i2) {
            }
        }
        this.pending.add(i2, (Pair<PsiElement, Instruction>)Pair.create((Object)pendingScope, (Object)instruction));
    }

    public final void checkPending(@NotNull Instruction instruction) {
        PsiElement element2;
        if (instruction == null) {
            ControlFlowBuilder.$$$reportNull$$$0(1);
        }
        if ((element2 = instruction.getElement()) == null) {
            for (Pair<PsiElement, Instruction> pair : this.pending) {
                this.addEdge((Instruction)pair.getSecond(), instruction);
            }
            this.pending.clear();
        } else {
            for (int i2 = this.pending.size() - 1; i2 >= 0; --i2) {
                Pair<PsiElement, Instruction> pair = this.pending.get(i2);
                PsiElement scopeWhenToAdd = (PsiElement)pair.getFirst();
                if (scopeWhenToAdd == null) continue;
                if (PsiTreeUtil.isAncestor((PsiElement)scopeWhenToAdd, (PsiElement)element2, (boolean)false)) break;
                this.addEdge((Instruction)pair.getSecond(), instruction);
                this.pending.remove(i2);
            }
        }
    }

    @NotNull
    public Instruction startNode(@Nullable PsiElement element2) {
        InstructionImpl instruction = new InstructionImpl(this, element2);
        this.addNodeAndCheckPending(instruction);
        InstructionImpl instructionImpl = instruction;
        if (instructionImpl == null) {
            ControlFlowBuilder.$$$reportNull$$$0(2);
        }
        return instructionImpl;
    }

    @NotNull
    public final TransparentInstruction startTransparentNode(@Nullable PsiElement element2, String markerName) {
        TransparentInstructionImpl instruction = new TransparentInstructionImpl(this, element2, markerName);
        this.addNodeAndCheckPending(instruction);
        TransparentInstructionImpl transparentInstructionImpl = instruction;
        if (transparentInstructionImpl == null) {
            ControlFlowBuilder.$$$reportNull$$$0(3);
        }
        return transparentInstructionImpl;
    }

    public final Instruction startConditionalNode(PsiElement element2, PsiElement condition, boolean result2) {
        ConditionalInstructionImpl instruction = new ConditionalInstructionImpl(this, element2, condition, result2);
        this.addNodeAndCheckPending(instruction);
        return instruction;
    }

    @NotNull
    public final ControlFlow build(@NotNull PsiElementVisitor visitor, @NotNull PsiElement element2) {
        if (visitor == null) {
            ControlFlowBuilder.$$$reportNull$$$0(4);
        }
        if (element2 == null) {
            ControlFlowBuilder.$$$reportNull$$$0(5);
        }
        this.visitFor(visitor, element2);
        return this.getCompleteControlFlow();
    }

    public final void visitFor(@NotNull PsiElementVisitor visitor, @NotNull PsiElement element2) {
        if (visitor == null) {
            ControlFlowBuilder.$$$reportNull$$$0(6);
        }
        if (element2 == null) {
            ControlFlowBuilder.$$$reportNull$$$0(7);
        }
        this.addEntryPointNode(element2);
        element2.acceptChildren(visitor);
        Instruction exitInstruction = this.startNode(null);
        this.checkPending(exitInstruction);
    }

    protected void addEntryPointNode(PsiElement startElement) {
        this.startNode(null);
    }

    public final void updatePendingElementScope(@NotNull PsiElement parentForScope, @Nullable PsiElement newParentScope) {
        if (parentForScope == null) {
            ControlFlowBuilder.$$$reportNull$$$0(8);
        }
        this.processPending((pendingScope, instruction) -> {
            if (pendingScope != null && PsiTreeUtil.isAncestor((PsiElement)parentForScope, (PsiElement)pendingScope, (boolean)false)) {
                this.addPendingEdge(newParentScope, instruction);
            } else {
                this.addPendingEdge(pendingScope, instruction);
            }
        });
    }

    public void processPending(@NotNull PendingProcessor processor2) {
        if (processor2 == null) {
            ControlFlowBuilder.$$$reportNull$$$0(9);
        }
        List<Pair<PsiElement, Instruction>> pending2 = this.pending;
        this.pending = new ArrayList<Pair<PsiElement, Instruction>>();
        for (Pair<PsiElement, Instruction> pair : pending2) {
            processor2.process((PsiElement)pair.getFirst(), (Instruction)pair.getSecond());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/controlflow/ControlFlowBuilder";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentForScope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/controlflow/ControlFlowBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "startNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startTransparentNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkPending";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updatePendingElementScope";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processPending";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface PendingProcessor {
        public void process(@Nullable PsiElement var1, @NotNull Instruction var2);
    }
}

