/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.WordCompletionContributor;
import com.intellij.codeInsight.completion.XmlSmartCompletionProvider;
import com.intellij.codeInsight.lookup.InsertHandlerDecorator;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.template.emmet.completion.EmmetAbbreviationCompletionProvider;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.XmlEnumeratedValueReference;
import com.intellij.xml.util.XmlUtil;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlCompletionContributor
extends CompletionContributor {
    public static final Key<Boolean> WORD_COMPLETION_COMPATIBLE = Key.create((String)"WORD_COMPLETION_COMPATIBLE");
    public static final EntityRefInsertHandler ENTITY_INSERT_HANDLER = new EntityRefInsertHandler();
    @NonNls
    public static final String TAG_NAME_COMPLETION_FEATURE = "tag.name.completion";
    private static final InsertHandler<LookupElementDecorator<LookupElement>> QUOTE_EATER = new InsertHandlerDecorator<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElementDecorator<LookupElement> item) {
            char completionChar;
            if (context2 == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((completionChar = context2.getCompletionChar()) == '\'' || completionChar == '\"') {
                char c;
                context2.setAddCompletionChar(false);
                item.getDelegate().handleInsert(context2);
                Editor editor = context2.getEditor();
                Document document = editor.getDocument();
                int tailOffset = editor.getCaretModel().getOffset();
                if (document.getTextLength() > tailOffset && ((c = document.getCharsSequence().charAt(tailOffset)) == completionChar || completionChar == '\'')) {
                    editor.getCaretModel().moveToOffset(tailOffset + 1);
                }
            } else {
                item.getDelegate().handleInsert(context2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/completion/XmlCompletionContributor$1";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public XmlCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlFile()), new EmmetAbbreviationCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlFile()), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
                PsiElement position;
                IElementType type;
                if (parameters2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((type = (position = parameters2.getPosition()).getNode().getElementType()) != XmlTokenType.XML_DATA_CHARACTERS && type != XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                    return;
                }
                if (position.getPrevSibling() != null && position.getPrevSibling().textMatches((CharSequence)"&") || position.textContains('&')) {
                    PrefixMatcher matcher = result2.getPrefixMatcher();
                    String prefix2 = matcher.getPrefix();
                    if (prefix2.startsWith("&")) {
                        prefix2 = prefix2.substring(1);
                    } else if (prefix2.contains("&")) {
                        prefix2 = prefix2.substring(prefix2.indexOf("&") + 1);
                    }
                    XmlCompletionContributor.addEntityRefCompletions(position, result2.withPrefixMatcher(prefix2));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/XmlCompletionContributor$2";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlAttributeValue()), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
                PsiElement position;
                if (parameters2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (!(position = parameters2.getPosition()).getLanguage().isKindOf((Language)XMLLanguage.INSTANCE)) {
                    return;
                }
                XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)position, XmlAttributeValue.class, (boolean)false);
                if (attributeValue == null) {
                    return;
                }
                HashSet<String> usedWords = new HashSet<String>();
                Ref addWordVariants = Ref.create((Object)true);
                result2.runRemainingContributors(parameters2, r -> {
                    if (r.getLookupElement().getUserData(WORD_COMPLETION_COMPATIBLE) == null) {
                        addWordVariants.set((Object)false);
                    }
                    usedWords.add(r.getLookupElement().getLookupString());
                    result2.passResult(r.withLookupElement((LookupElement)LookupElementDecorator.withInsertHandler((LookupElement)r.getLookupElement(), QUOTE_EATER)));
                });
                if (((Boolean)addWordVariants.get()).booleanValue()) {
                    addWordVariants.set((Object)(attributeValue.getReferences().length == 0 ? 1 : 0));
                }
                if (((Boolean)addWordVariants.get()).booleanValue() && parameters2.getInvocationCount() > 0) {
                    WordCompletionContributor.addWordCompletionVariants(result2, parameters2, usedWords);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/XmlCompletionContributor$3";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withElementType(XmlTokenType.XML_DATA_CHARACTERS), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
                XmlTag simpleContent;
                XmlTag tag2;
                if (parameters2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    4.$$$reportNull$$$0(2);
                }
                if ((tag2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)parameters2.getPosition(), XmlTag.class, (boolean)false)) != null && !XmlCompletionContributor.hasEnumerationReference(parameters2, result2) && (simpleContent = XmlUtil.getSchemaSimpleContent(tag2)) != null) {
                    XmlUtil.processEnumerationValues(simpleContent, (Processor<? super XmlTag>)((Processor)element2 -> {
                        String value2 = element2.getAttributeValue("value");
                        assert (value2 != null);
                        result2.addElement((LookupElement)LookupElementBuilder.create((String)value2));
                        return true;
                    }));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/XmlCompletionContributor$4";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    static boolean hasEnumerationReference(CompletionParameters parameters2, CompletionResultSet result2) {
        Ref hasRef = Ref.create((Object)false);
        LegacyCompletionContributor.processReferences(parameters2, result2, (PairConsumer<? super PsiReference, ? super CompletionResultSet>)((PairConsumer)(reference2, resultSet) -> {
            if (reference2 instanceof XmlEnumeratedValueReference) {
                hasRef.set((Object)true);
            }
        }));
        return (Boolean)hasRef.get();
    }

    public static boolean isXmlNameCompletion(CompletionParameters parameters2) {
        ASTNode node = parameters2.getPosition().getNode();
        return node != null && node.getElementType() == XmlTokenType.XML_NAME;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        if (parameters2 == null) {
            XmlCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            XmlCompletionContributor.$$$reportNull$$$0(1);
        }
        super.fillCompletionVariants(parameters2, result2);
        if (result2.isStopped()) {
            return;
        }
        PsiElement element2 = parameters2.getPosition();
        if (parameters2.isExtendedCompletion()) {
            XmlCompletionContributor.completeTagName(parameters2, result2);
        } else if (parameters2.getCompletionType() == CompletionType.SMART) {
            new XmlSmartCompletionProvider().complete(parameters2, result2, element2);
        }
    }

    static void completeTagName(CompletionParameters parameters2, CompletionResultSet result2) {
        PsiElement element2 = parameters2.getPosition();
        if (!XmlCompletionContributor.isXmlNameCompletion(parameters2)) {
            return;
        }
        PsiElement parent = element2.getParent();
        if (!(parent instanceof XmlTag) || !(parameters2.getOriginalFile() instanceof XmlFile)) {
            return;
        }
        result2.stopHere();
        XmlTag tag2 = (XmlTag)parent;
        String namespace = tag2.getNamespace();
        String prefix2 = result2.getPrefixMatcher().getPrefix();
        int pos = prefix2.indexOf(58);
        PsiReference reference2 = tag2.getReference();
        String namespacePrefix = tag2.getNamespacePrefix();
        if (reference2 != null && !namespace.isEmpty() && !namespacePrefix.isEmpty()) {
            result2.runRemainingContributors(parameters2, true);
        } else {
            CompletionResultSet newResult = result2.withPrefixMatcher(pos >= 0 ? prefix2.substring(pos + 1) : prefix2);
            XmlFile file2 = (XmlFile)parameters2.getOriginalFile();
            List<XmlExtension.TagInfo> names2 = XmlExtension.getExtension((PsiFile)file2).getAvailableTagNames(file2, tag2);
            for (XmlExtension.TagInfo info2 : names2) {
                LookupElement item = XmlCompletionContributor.createLookupElement(info2, info2.namespace, namespacePrefix.isEmpty() ? null : namespacePrefix);
                newResult.addElement(item);
            }
        }
    }

    public static LookupElement createLookupElement(XmlExtension.TagInfo tagInfo, String tailText, @Nullable String namespacePrefix) {
        LookupElementBuilder builder2 = LookupElementBuilder.create((Object)tagInfo, (String)tagInfo.name).withInsertHandler((InsertHandler)new ExtendedTagInsertHandler(tagInfo.name, tagInfo.namespace, namespacePrefix));
        if (!StringUtil.isEmpty((String)tailText)) {
            builder2 = builder2.withTypeText(tailText, true);
        }
        return builder2;
    }

    public String advertise(@NotNull CompletionParameters parameters2) {
        if (parameters2 == null) {
            XmlCompletionContributor.$$$reportNull$$$0(2);
        }
        if (XmlCompletionContributor.isXmlNameCompletion(parameters2) && parameters2.getCompletionType() == CompletionType.BASIC && FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup(TAG_NAME_COMPLETION_FEATURE, parameters2.getPosition().getProject())) {
            String shortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion");
            return XmlBundle.message((String)"tag.name.completion.hint", (Object[])new Object[]{shortcut});
        }
        return super.advertise(parameters2);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context2) {
        PsiElement at;
        if (context2 == null) {
            XmlCompletionContributor.$$$reportNull$$$0(3);
        }
        int offset = context2.getStartOffset();
        PsiFile file2 = context2.getFile();
        XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)offset, XmlAttributeValue.class, (boolean)true);
        if (attributeValue != null && offset == attributeValue.getTextRange().getStartOffset()) {
            context2.setDummyIdentifier("");
        }
        if ((at = file2.findElementAt(offset)) != null && at.getNode().getElementType() == XmlTokenType.XML_NAME && at.getParent() instanceof XmlAttribute) {
            context2.getOffsetMap().addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, at.getTextRange().getEndOffset());
        }
        if (at != null && at.getParent() instanceof XmlAttributeValue) {
            int end = at.getParent().getTextRange().getEndOffset();
            Document document = context2.getEditor().getDocument();
            int lineEnd = document.getLineEndOffset(document.getLineNumber(offset));
            if (lineEnd < end) {
                context2.setReplacementOffset(lineEnd);
            }
        }
    }

    private static void addEntityRefCompletions(PsiElement context2, final CompletionResultSet resultSet) {
        XmlProlog element2;
        XmlFile containingFile = (XmlFile)ObjectUtils.tryCast((Object)context2.getContainingFile(), XmlFile.class);
        if (containingFile == null) {
            return;
        }
        List descriptorFiles = XmlExtension.getExtension((PsiFile)containingFile).getCharEntitiesDTDs(containingFile);
        XmlTag tag2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context2, XmlTag.class);
        if (tag2 != null && descriptorFiles.isEmpty()) {
            descriptorFiles = ContainerUtil.packNullables((Object[])new XmlFile[]{XmlUtil.findDescriptorFile(tag2, containingFile)});
        }
        final boolean acceptSystemEntities = containingFile.getFileType() == XmlFileType.INSTANCE;
        PsiElementProcessor<PsiElement> processor2 = new PsiElementProcessor<PsiElement>(){

            public boolean execute(@NotNull PsiElement element2) {
                LookupElementBuilder _item;
                XmlEntityDecl xmlEntityDecl;
                if (element2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (element2 instanceof XmlEntityDecl && ((xmlEntityDecl = (XmlEntityDecl)element2).isInternalReference() || acceptSystemEntities) && (_item = XmlCompletionContributor.buildEntityLookupItem(xmlEntityDecl)) != null) {
                    resultSet.addElement((LookupElement)_item);
                    resultSet.stopHere();
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/XmlCompletionContributor$5", "execute"));
            }
        };
        for (XmlFile descriptorFile : descriptorFiles) {
            XmlUtil.processXmlElements((XmlElement)descriptorFile, (PsiElementProcessor<? super PsiElement>)processor2, true);
        }
        XmlDocument document = containingFile.getDocument();
        if (acceptSystemEntities && document != null && (element2 = document.getProlog()) != null) {
            XmlUtil.processXmlElements((XmlElement)element2, (PsiElementProcessor<? super PsiElement>)processor2, true);
        }
    }

    @Nullable
    private static LookupElementBuilder buildEntityLookupItem(@NotNull XmlEntityDecl decl) {
        String valueText;
        int i2;
        ASTNode[] nodes;
        String name;
        if (decl == null) {
            XmlCompletionContributor.$$$reportNull$$$0(4);
        }
        if ((name = decl.getName()) == null) {
            return null;
        }
        LookupElementBuilder result2 = LookupElementBuilder.create((String)name).withInsertHandler((InsertHandler)ENTITY_INSERT_HANDLER);
        XmlAttributeValue value2 = decl.getValueElement();
        ASTNode node = value2.getNode();
        if (node != null && (nodes = node.getChildren(TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_CHAR_ENTITY_REF}))).length == 1 && (i2 = (valueText = nodes[0].getText()).indexOf(35)) > 0) {
            String s = valueText.substring(i2 + 1);
            s = StringUtil.trimEnd((String)s, (String)";");
            try {
                char unicodeChar = (char)Integer.valueOf(s).intValue();
                return result2.withTypeText(String.valueOf(unicodeChar)).withLookupString(String.valueOf(unicodeChar));
            }
            catch (NumberFormatException e) {
                return result2;
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decl";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/XmlCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "advertise";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCompletion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "buildEntityLookupItem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EntityRefInsertHandler
    extends BasicInsertHandler<LookupElement> {
        private EntityRefInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
            if (context2 == null) {
                EntityRefInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                EntityRefInsertHandler.$$$reportNull$$$0(1);
            }
            super.handleInsert(context2, item);
            context2.setAddCompletionChar(false);
            Editor editor = context2.getEditor();
            CaretModel caretModel = editor.getCaretModel();
            int caretOffset = caretModel.getOffset();
            if (!CharArrayUtil.regionMatches((CharSequence)editor.getDocument().getCharsSequence(), (int)caretOffset, (CharSequence)";")) {
                editor.getDocument().insertString(caretOffset, (CharSequence)";");
            }
            caretModel.moveToOffset(caretOffset + 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/completion/XmlCompletionContributor$EntityRefInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

