/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.FilePosition;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileNavigatable
implements Navigatable {
    private final Project myProject;
    private final NullableLazyValue<OpenFileDescriptor> myValue;
    private final FilePosition myFilePosition;

    public FileNavigatable(@NotNull Project project, @NotNull FilePosition filePosition) {
        if (project == null) {
            FileNavigatable.$$$reportNull$$$0(0);
        }
        if (filePosition == null) {
            FileNavigatable.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myFilePosition = filePosition;
        this.myValue = new NullableLazyValue<OpenFileDescriptor>(){

            @Nullable
            protected OpenFileDescriptor compute() {
                return FileNavigatable.this.createDescriptor();
            }
        };
    }

    public void navigate(boolean requestFocus) {
        OpenFileDescriptor descriptor2 = this.getFileDescriptor();
        if (descriptor2 != null) {
            descriptor2.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        OpenFileDescriptor descriptor2 = this.getFileDescriptor();
        if (descriptor2 != null) {
            return descriptor2.canNavigate();
        }
        return false;
    }

    public boolean canNavigateToSource() {
        OpenFileDescriptor descriptor2 = this.getFileDescriptor();
        if (descriptor2 != null) {
            return descriptor2.canNavigateToSource();
        }
        return false;
    }

    @Nullable
    public OpenFileDescriptor getFileDescriptor() {
        return (OpenFileDescriptor)this.myValue.getValue();
    }

    @NotNull
    public FilePosition getFilePosition() {
        FilePosition filePosition = this.myFilePosition;
        if (filePosition == null) {
            FileNavigatable.$$$reportNull$$$0(2);
        }
        return filePosition;
    }

    @Nullable
    private OpenFileDescriptor createDescriptor() {
        OpenFileDescriptor descriptor2 = null;
        VirtualFile file2 = VfsUtil.findFileByIoFile((File)this.myFilePosition.getFile(), (boolean)false);
        if (file2 != null) {
            descriptor2 = new OpenFileDescriptor(this.myProject, file2, this.myFilePosition.getStartLine(), this.myFilePosition.getStartColumn());
        }
        return descriptor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePosition";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/FileNavigatable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/FileNavigatable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

