/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.ExecutionNode;
import com.intellij.build.events.BuildEventsNls;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultBuildDescriptor
implements BuildDescriptor {
    private final Object myId;
    private final @BuildEventsNls.Title String myTitle;
    private final String myWorkingDir;
    private final long myStartTime;
    private boolean myActivateToolWindowWhenAdded;
    private boolean myActivateToolWindowWhenFailed;
    @NotNull
    private ThreeState myNavigateToError;
    private boolean myAutoFocusContent;
    @NotNull
    private final List<AnAction> myActions;
    @NotNull
    private final List<AnAction> myRestartActions;
    @NotNull
    private final List<Filter> myExecutionFilters;
    @NotNull
    private final List<Function<? super ExecutionNode, ? extends AnAction>> myContextActions;
    @Nullable
    private BuildProcessHandler myProcessHandler;
    private Consumer<? super ConsoleView> myAttachedConsoleConsumer;
    @Nullable
    private ExecutionEnvironment myExecutionEnvironment;
    private Supplier<? extends RunContentDescriptor> myContentDescriptorSupplier;

    public DefaultBuildDescriptor(@NotNull Object id2, @NotNull @BuildEventsNls.Title String title2, @NotNull String workingDir, long startTime) {
        if (id2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(0);
        }
        if (title2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(1);
        }
        if (workingDir == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(2);
        }
        this.myActivateToolWindowWhenAdded = false;
        this.myActivateToolWindowWhenFailed = true;
        this.myNavigateToError = ThreeState.UNSURE;
        this.myAutoFocusContent = false;
        this.myActions = new SmartList();
        this.myRestartActions = new SmartList();
        this.myExecutionFilters = new SmartList();
        this.myContextActions = new SmartList();
        this.myId = id2;
        this.myTitle = title2;
        this.myWorkingDir = workingDir;
        this.myStartTime = startTime;
    }

    public DefaultBuildDescriptor(@Nullable @NotNull BuildDescriptor descriptor2) {
        this(descriptor2.getId(), descriptor2.getTitle(), descriptor2.getWorkingDir(), descriptor2.getStartTime());
        if (descriptor2 instanceof DefaultBuildDescriptor) {
            DefaultBuildDescriptor defaultBuildDescriptor = (DefaultBuildDescriptor)descriptor2;
            this.myActivateToolWindowWhenAdded = defaultBuildDescriptor.myActivateToolWindowWhenAdded;
            this.myActivateToolWindowWhenFailed = defaultBuildDescriptor.myActivateToolWindowWhenFailed;
            this.myAutoFocusContent = defaultBuildDescriptor.myAutoFocusContent;
            defaultBuildDescriptor.myRestartActions.forEach(this::withRestartAction);
            defaultBuildDescriptor.myActions.forEach(this::withAction);
            defaultBuildDescriptor.myExecutionFilters.forEach(this::withExecutionFilter);
            defaultBuildDescriptor.myContextActions.forEach(this::withContextAction);
            this.myContentDescriptorSupplier = defaultBuildDescriptor.myContentDescriptorSupplier;
            this.myExecutionEnvironment = defaultBuildDescriptor.myExecutionEnvironment;
            this.myProcessHandler = defaultBuildDescriptor.myProcessHandler;
            this.myAttachedConsoleConsumer = defaultBuildDescriptor.myAttachedConsoleConsumer;
        }
    }

    @NotNull
    public Object getId() {
        Object object = this.myId;
        if (object == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(3);
        }
        return object;
    }

    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getWorkingDir() {
        String string = this.myWorkingDir;
        if (string == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(5);
        }
        return string;
    }

    public long getStartTime() {
        return this.myStartTime;
    }

    @ApiStatus.Experimental
    @NotNull
    public List<AnAction> getActions() {
        List<AnAction> list2 = Collections.unmodifiableList(this.myActions);
        if (list2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @ApiStatus.Experimental
    @NotNull
    public List<AnAction> getRestartActions() {
        List<AnAction> list2 = Collections.unmodifiableList(this.myRestartActions);
        if (list2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @ApiStatus.Experimental
    @NotNull
    public List<AnAction> getContextActions(@NotNull ExecutionNode node) {
        if (node == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(8);
        }
        List list2 = ContainerUtil.map(this.myContextActions, function -> (AnAction)function.apply(node));
        if (list2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @ApiStatus.Experimental
    @NotNull
    public List<Filter> getExecutionFilters() {
        List<Filter> list2 = Collections.unmodifiableList(this.myExecutionFilters);
        if (list2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(10);
        }
        return list2;
    }

    public boolean isActivateToolWindowWhenAdded() {
        return this.myActivateToolWindowWhenAdded;
    }

    public void setActivateToolWindowWhenAdded(boolean activateToolWindowWhenAdded) {
        this.myActivateToolWindowWhenAdded = activateToolWindowWhenAdded;
    }

    public boolean isActivateToolWindowWhenFailed() {
        return this.myActivateToolWindowWhenFailed;
    }

    public void setActivateToolWindowWhenFailed(boolean activateToolWindowWhenFailed) {
        this.myActivateToolWindowWhenFailed = activateToolWindowWhenFailed;
    }

    @NotNull
    public ThreeState isNavigateToError() {
        ThreeState threeState = this.myNavigateToError;
        if (threeState == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(11);
        }
        return threeState;
    }

    public void setNavigateToError(@NotNull ThreeState navigateToError) {
        if (navigateToError == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(12);
        }
        this.myNavigateToError = navigateToError;
    }

    public boolean isAutoFocusContent() {
        return this.myAutoFocusContent;
    }

    public void setAutoFocusContent(boolean autoFocusContent) {
        this.myAutoFocusContent = autoFocusContent;
    }

    @Nullable
    public BuildProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    @Nullable
    public ExecutionEnvironment getExecutionEnvironment() {
        return this.myExecutionEnvironment;
    }

    @Nullable
    public Supplier<? extends RunContentDescriptor> getContentDescriptorSupplier() {
        return this.myContentDescriptorSupplier;
    }

    public Consumer<? super ConsoleView> getAttachedConsoleConsumer() {
        return this.myAttachedConsoleConsumer;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withAction(@NotNull AnAction action2) {
        if (action2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(13);
        }
        this.myActions.add(action2);
        return this;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withActions(AnAction ... actions2) {
        if (actions2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(14);
        }
        this.myActions.addAll(Arrays.asList(actions2));
        return this;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withRestartAction(@NotNull AnAction action2) {
        if (action2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(15);
        }
        this.myRestartActions.add(action2);
        return this;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withRestartActions(AnAction ... actions2) {
        if (actions2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(16);
        }
        this.myRestartActions.addAll(Arrays.asList(actions2));
        return this;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withContextAction(Function<? super ExecutionNode, ? extends AnAction> contextAction) {
        this.myContextActions.add(contextAction);
        return this;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withContextActions(AnAction ... actions2) {
        if (actions2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(17);
        }
        for (AnAction action2 : actions2) {
            this.myContextActions.add(node -> action2);
        }
        return this;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withExecutionFilter(@NotNull Filter filter) {
        if (filter == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(18);
        }
        this.myExecutionFilters.add(filter);
        return this;
    }

    public DefaultBuildDescriptor withContentDescriptor(Supplier<? extends RunContentDescriptor> contentDescriptorSupplier) {
        this.myContentDescriptorSupplier = contentDescriptorSupplier;
        return this;
    }

    public DefaultBuildDescriptor withProcessHandler(@Nullable BuildProcessHandler processHandler2, @Nullable Consumer<? super ConsoleView> attachedConsoleConsumer) {
        this.myProcessHandler = processHandler2;
        this.myAttachedConsoleConsumer = attachedConsoleConsumer;
        return this;
    }

    public DefaultBuildDescriptor withExecutionEnvironment(@Nullable ExecutionEnvironment env) {
        this.myExecutionEnvironment = env;
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/DefaultBuildDescriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigateToError";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/DefaultBuildDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDir";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestartActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextActions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionFilters";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "isNavigateToError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContextActions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setNavigateToError";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "withAction";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "withActions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "withRestartAction";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "withRestartActions";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "withContextActions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "withExecutionFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

