/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.application.options.colors.FontEditorPreview;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.application.options.colors.highlighting.HighlightData;
import com.intellij.application.options.colors.highlighting.HighlightsExtractor;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.UsedColors;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.EditorHighlightingProvidingColorSettingsPage;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.EditorCustomization;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleEditorPreview
implements PreviewPanel {
    private final ColorSettingsPage myPage;
    private final EditorEx myEditor;
    private final Alarm myBlinkingAlarm;
    private final List<HighlightData> myHighlightData = new ArrayList<HighlightData>();
    private final ColorAndFontOptions myOptions;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private final HighlightsExtractor myHighlightsExtractor;
    private final ColorSettingsPage.PreviewCustomizer myCustomizer;
    private static final int BLINK_COUNT = 6;

    public SimpleEditorPreview(ColorAndFontOptions options2, ColorSettingsPage page) {
        this(options2, page, true);
    }

    public SimpleEditorPreview(ColorAndFontOptions options2, ColorSettingsPage page, boolean navigatable) {
        this.myOptions = options2;
        this.myPage = page;
        this.myCustomizer = page.getPreviewEditorCustomizer();
        this.myHighlightsExtractor = new HighlightsExtractor(page.getAdditionalHighlightingTagToDescriptorMap(), page.getAdditionalInlineElementToDescriptorMap(), page.getAdditionalHighlightingTagToColorKeyMap());
        this.myEditor = (EditorEx)FontEditorPreview.createPreviewEditor(this.myHighlightsExtractor.extractHighlights(page.getDemoText(), this.myHighlightData), this.myOptions.getSelectedScheme(), false);
        if (page instanceof EditorCustomization) {
            ((EditorCustomization)page).customize(this.myEditor);
        }
        FontEditorPreview.installTrafficLights(this.myEditor);
        this.myBlinkingAlarm = new Alarm(this.myEditor.getComponent(), ((EditorImpl)this.myEditor).getDisposable());
        if (navigatable) {
            this.myEditor.getContentComponent().addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (SimpleEditorPreview.this.myCustomizer != null && SimpleEditorPreview.this.myCustomizer.getCustomizationAt((Editor)SimpleEditorPreview.this.myEditor, e.getPoint()) != null) {
                        SimpleEditorPreview.this.setCursor(true);
                        return;
                    }
                    SimpleEditorPreview.this.navigate(false, SimpleEditorPreview.this.myEditor.xyToLogicalPosition(new Point(e.getX(), e.getY())));
                }
            });
            this.myEditor.addEditorMouseListener(new EditorMouseListener(){

                public void mouseClicked(@NotNull EditorMouseEvent event) {
                    String customization;
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (event.getArea() == EditorMouseEventArea.EDITING_AREA && SimpleEditorPreview.this.myCustomizer != null && (customization = SimpleEditorPreview.this.myCustomizer.getCustomizationAt((Editor)SimpleEditorPreview.this.myEditor, event.getMouseEvent().getPoint())) != null) {
                        ((ColorAndFontSettingsListener)SimpleEditorPreview.this.myDispatcher.getMulticaster()).selectionInPreviewChanged(customization);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/colors/SimpleEditorPreview$2", "mouseClicked"));
                }
            });
            this.myEditor.getCaretModel().addCaretListener(new CaretListener(){

                public void caretPositionChanged(@NotNull CaretEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    SimpleEditorPreview.this.navigate(true, e.getNewPosition());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/colors/SimpleEditorPreview$3", "caretPositionChanged"));
                }
            });
        }
    }

    public EditorEx getEditor() {
        return this.myEditor;
    }

    private void navigate(boolean select2, @NotNull LogicalPosition pos) {
        if (pos == null) {
            SimpleEditorPreview.$$$reportNull$$$0(0);
        }
        int offset = this.myEditor.logicalPositionToOffset(pos);
        SyntaxHighlighter highlighter = this.myPage.getHighlighter();
        HighlightData highlightData = this.getDataFromOffset(offset);
        String type = highlightData != null ? (RainbowHighlighter.isRainbowTempKey(highlightData.getHighlightKey()) ? "rainbow" : (highlightData.getAdditionalColorKey() == null ? highlightData.getHighlightType() : highlightData.getAdditionalColorKey().getExternalName())) : SimpleEditorPreview.selectItem(this.myEditor.getHighlighter().createIterator(offset), highlighter);
        this.setCursor(type != null);
        if (select2 && type != null) {
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).selectionInPreviewChanged(type);
        }
    }

    @Nullable
    private HighlightData getDataFromOffset(int offset) {
        for (HighlightData highlightData : this.myHighlightData) {
            if (offset < highlightData.getStartOffset() || offset > highlightData.getEndOffset()) continue;
            return highlightData;
        }
        return null;
    }

    @Nullable
    private static String selectItem(HighlighterIterator itr, SyntaxHighlighter highlighter) {
        IElementType tokenType = itr.getTokenType();
        if (tokenType == null) {
            return null;
        }
        TextAttributesKey[] highlights = highlighter.getTokenHighlights(tokenType);
        String s = null;
        for (int i2 = highlights.length - 1; i2 >= 0; --i2) {
            if (highlights[i2] == HighlighterColors.TEXT) continue;
            s = highlights[i2].getExternalName();
            break;
        }
        return s == null ? HighlighterColors.TEXT.getExternalName() : s;
    }

    @Override
    public JComponent getPanel() {
        return this.myEditor.getComponent();
    }

    @Override
    public void updateView() {
        EditorColorsScheme scheme2 = this.myOptions.getSelectedScheme();
        this.myEditor.setColorsScheme(scheme2);
        EditorHighlighter highlighter = null;
        if (this.myPage instanceof EditorHighlightingProvidingColorSettingsPage) {
            highlighter = ((EditorHighlightingProvidingColorSettingsPage)this.myPage).createEditorHighlighter(scheme2);
        }
        if (highlighter == null) {
            SyntaxHighlighter pageHighlighter = this.myPage.getHighlighter();
            highlighter = HighlighterFactory.createHighlighter((SyntaxHighlighter)pageHighlighter, (EditorColorsScheme)scheme2);
        }
        this.myEditor.setHighlighter(highlighter);
        this.updateHighlighters();
        this.myEditor.reinitSettings();
    }

    private void updateHighlighters() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myEditor.isDisposed()) {
                return;
            }
            this.removeDecorations();
            Map<TextAttributesKey, String> displayText = ColorSettingsUtil.keyToDisplayTextMap(this.myPage);
            for (HighlightData data2 : this.myHighlightData) {
                data2.addHighlToView(this.myEditor, this.myOptions.getSelectedScheme(), displayText);
            }
            if (this.myCustomizer != null) {
                this.myCustomizer.addCustomizations((Editor)this.myEditor, null);
            }
        });
    }

    private void removeDecorations() {
        this.myEditor.getMarkupModel().removeAllHighlighters();
        for (Inlay inlay : this.myEditor.getInlayModel().getInlineElementsInRange(0, this.myEditor.getDocument().getTextLength())) {
            Disposer.dispose((Disposable)inlay);
        }
        if (this.myCustomizer != null) {
            this.myCustomizer.removeCustomizations((Editor)this.myEditor);
        }
    }

    @Override
    public void blinkSelectedHighlightType(Object description) {
        if (description instanceof EditorSchemeAttributeDescriptor) {
            String type = ((EditorSchemeAttributeDescriptor)description).getType();
            List<HighlightData> highlights = this.startBlinkingHighlights(this.myEditor, type, this.myPage.getHighlighter(), true, this.myBlinkingAlarm, 6, this.myPage);
            this.scrollHighlightInView(highlights);
        }
    }

    private void scrollHighlightInView(@Nullable List<? extends HighlightData> highlightDatas) {
        if (highlightDatas == null) {
            return;
        }
        boolean needScroll = true;
        int minOffset = Integer.MAX_VALUE;
        for (HighlightData highlightData : highlightDatas) {
            if (this.isOffsetVisible(highlightData.getStartOffset())) {
                needScroll = false;
                break;
            }
            minOffset = Math.min(minOffset, highlightData.getStartOffset());
        }
        if (needScroll && minOffset != Integer.MAX_VALUE) {
            LogicalPosition pos = this.myEditor.offsetToLogicalPosition(minOffset);
            this.myEditor.getScrollingModel().scrollTo(pos, ScrollType.MAKE_VISIBLE);
        }
    }

    private boolean isOffsetVisible(int startOffset) {
        return this.myEditor.getScrollingModel().getVisibleAreaOnScrollingFinished().contains(this.myEditor.logicalPositionToXY(this.myEditor.offsetToLogicalPosition(startOffset)));
    }

    private void stopBlinking() {
        this.myBlinkingAlarm.cancelAllRequests();
    }

    private List<HighlightData> startBlinkingHighlights(EditorEx editor, String attrKey, SyntaxHighlighter highlighter, boolean show2, Alarm alarm2, int count, ColorSettingsPage page) {
        TextRange range2;
        if (show2 && count <= 0) {
            return Collections.emptyList();
        }
        this.removeDecorations();
        boolean found = false;
        ArrayList<HighlightData> highlights = new ArrayList<HighlightData>();
        ArrayList<HighlightData> matchingHighlights = new ArrayList<HighlightData>();
        for (HighlightData highlightData : this.myHighlightData) {
            boolean highlight = show2 && (highlightData.getHighlightType().equals(attrKey) || highlightData.getAdditionalColorKey() != null && highlightData.getAdditionalColorKey().getExternalName().equals(attrKey));
            highlightData.addToCollection(highlights, highlight);
            if (!highlight) continue;
            matchingHighlights.add(highlightData);
            found = true;
        }
        if (show2 && !found && highlighter != null) {
            HighlighterIterator iterator2 = editor.getHighlighter().createIterator(0);
            do {
                TextAttributesKey[] tokenHighlights;
                IElementType tokenType = iterator2.getTokenType();
                for (TextAttributesKey tokenHighlight : tokenHighlights = highlighter.getTokenHighlights(tokenType)) {
                    String type = tokenHighlight.getExternalName();
                    if (!type.equals(attrKey)) continue;
                    HighlightData highlightData = new HighlightData(iterator2.getStart(), iterator2.getEnd(), CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES);
                    highlights.add(highlightData);
                    matchingHighlights.add(highlightData);
                }
                iterator2.advance();
            } while (!iterator2.atEnd());
        }
        Map<TextAttributesKey, String> displayText = ColorSettingsUtil.keyToDisplayTextMap(page);
        highlights.sort(Comparator.comparingInt(HighlightData::getStartOffset));
        for (int i2 = highlights.size() - 1; i2 >= 0; --i2) {
            HighlightData prevHighlightData;
            HighlightData highlightData = (HighlightData)highlights.get(i2);
            int startOffset = highlightData.getStartOffset();
            HighlightData highlightData2 = prevHighlightData = i2 == 0 ? null : (HighlightData)highlights.get(i2 - 1);
            if (prevHighlightData != null && startOffset <= prevHighlightData.getEndOffset() && highlightData.getHighlightType().equals(prevHighlightData.getHighlightType())) {
                prevHighlightData.setEndOffset(highlightData.getEndOffset());
                continue;
            }
            highlightData.addHighlToView(editor, this.myOptions.getSelectedScheme(), displayText);
        }
        if (this.myCustomizer != null && (range2 = this.myCustomizer.addCustomizations((Editor)this.myEditor, show2 ? attrKey : null)) != null) {
            matchingHighlights.add(new HighlightData(range2.getStartOffset(), range2.getEndOffset(), null));
        }
        alarm2.cancelAllRequests();
        alarm2.addComponentRequest(() -> this.startBlinkingHighlights(editor, attrKey, highlighter, !show2, alarm2, count - 1, page), 400);
        return matchingHighlights;
    }

    @Override
    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        if (listener2 == null) {
            SimpleEditorPreview.$$$reportNull$$$0(1);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void disposeUIResources() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.releaseEditor((Editor)this.myEditor);
        this.stopBlinking();
    }

    private void setCursor(boolean hand) {
        this.myEditor.setCustomCursor(SimpleEditorPreview.class, hand ? Cursor.getPredefinedCursor(12) : null);
    }

    void setupRainbow(@NotNull EditorColorsScheme colorsScheme, @NotNull RainbowColorSettingsPage page) {
        if (colorsScheme == null) {
            SimpleEditorPreview.$$$reportNull$$$0(2);
        }
        if (page == null) {
            SimpleEditorPreview.$$$reportNull$$$0(3);
        }
        ArrayList<HighlightData> initialMarkup = new ArrayList<HighlightData>();
        this.myHighlightsExtractor.extractHighlights(page.getDemoText(), initialMarkup);
        List<HighlightData> rainbowMarkup = this.setupRainbowHighlighting(page, initialMarkup, new RainbowHighlighter((TextAttributesScheme)colorsScheme).getRainbowTempKeys(), RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)colorsScheme, page.getLanguage()));
        this.myHighlightData.clear();
        this.myHighlightData.addAll(rainbowMarkup);
    }

    @NotNull
    private List<HighlightData> setupRainbowHighlighting(@NotNull RainbowColorSettingsPage page, @NotNull List<HighlightData> initialMarkup, TextAttributesKey @NotNull [] rainbowTempKeys, boolean isRainbowOn) {
        int colorCount;
        if (page == null) {
            SimpleEditorPreview.$$$reportNull$$$0(4);
        }
        if (initialMarkup == null) {
            SimpleEditorPreview.$$$reportNull$$$0(5);
        }
        if (rainbowTempKeys == null) {
            SimpleEditorPreview.$$$reportNull$$$0(6);
        }
        if ((colorCount = rainbowTempKeys.length) == 0) {
            List<HighlightData> list2 = initialMarkup;
            if (list2 == null) {
                SimpleEditorPreview.$$$reportNull$$$0(7);
            }
            return list2;
        }
        ArrayList<HighlightData> rainbowMarkup = new ArrayList<HighlightData>();
        int tempKeyIndex = 0;
        boolean repeatAnchor = true;
        for (HighlightData d : initialMarkup) {
            boolean rainbowDemoType;
            TextAttributesKey highlightKey = d.getHighlightKey();
            boolean rainbowType = page.isRainbowType(highlightKey);
            boolean bl = rainbowDemoType = highlightKey == RainbowHighlighter.RAINBOW_GRADIENT_DEMO;
            if (rainbowType || rainbowDemoType) {
                HighlightData rainbowAnchor = new HighlightData(d.getStartOffset(), d.getEndOffset(), RainbowHighlighter.RAINBOW_ANCHOR);
                if (isRainbowOn) {
                    HighlightData rainbowTemp;
                    if (rainbowType) {
                        rainbowTemp = this.getRainbowTemp(rainbowTempKeys, d.getStartOffset(), d.getEndOffset());
                    } else {
                        rainbowTemp = new HighlightData(d.getStartOffset(), d.getEndOffset(), rainbowTempKeys[tempKeyIndex % colorCount]);
                        if (repeatAnchor && tempKeyIndex == colorCount / 2) {
                            repeatAnchor = false;
                        } else {
                            ++tempKeyIndex;
                        }
                    }
                    rainbowMarkup.add(rainbowTemp);
                    rainbowMarkup.add(rainbowAnchor);
                    rainbowMarkup.add(d);
                    rainbowMarkup.add(rainbowAnchor);
                    rainbowMarkup.add(rainbowTemp);
                    continue;
                }
                if (rainbowType) {
                    rainbowMarkup.add(d);
                    rainbowMarkup.add(rainbowAnchor);
                    rainbowMarkup.add(d);
                    continue;
                }
                rainbowMarkup.add(rainbowAnchor);
                continue;
            }
            if (RainbowHighlighter.isRainbowTempKey(highlightKey) || highlightKey == RainbowHighlighter.RAINBOW_ANCHOR) continue;
            rainbowMarkup.add(d);
        }
        ArrayList<HighlightData> arrayList = rainbowMarkup;
        if (arrayList == null) {
            SimpleEditorPreview.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private HighlightData getRainbowTemp(TextAttributesKey @NotNull [] rainbowTempKeys, int startOffset, int endOffset) {
        if (rainbowTempKeys == null) {
            SimpleEditorPreview.$$$reportNull$$$0(9);
        }
        String id2 = this.myEditor.getDocument().getText(TextRange.create((int)startOffset, (int)endOffset));
        int index2 = UsedColors.getOrAddColorIndex((UserDataHolderEx)((EditorImpl)this.myEditor), id2, rainbowTempKeys.length);
        return new HighlightData(startOffset, endOffset, rainbowTempKeys[index2]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsScheme";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "page";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialMarkup";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rainbowTempKeys";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/SimpleEditorPreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/SimpleEditorPreview";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setupRainbowHighlighting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupRainbow";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setupRainbowHighlighting";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRainbowTemp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

