/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.markup.AnalyzerStatus;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontEditorPreview
implements PreviewPanel {
    private static final String PREVIEW_TEXT_KEY = "FontPreviewText";
    private static final Key<PreviewTextModel> TEXT_MODEL_KEY = Key.create((String)"RestorePreviewTextAction.textModel");
    private final EditorEx myEditor;
    private final JPanel myTopPanel;
    private final PreviewTextModel myTextModel;
    private final Supplier<? extends EditorColorsScheme> mySchemeSupplier;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private static final ShortcutSet TOGGLE_BOLD_SHORTCUT = CustomShortcutSet.fromString((String[])new String[]{"control B"});

    public FontEditorPreview(Supplier<? extends EditorColorsScheme> schemeSupplier, boolean editable) {
        this.mySchemeSupplier = schemeSupplier;
        @Nls String text2 = PropertiesComponent.getInstance().getValue(PREVIEW_TEXT_KEY, FontEditorPreview.getIDEDemoText());
        this.myTextModel = new PreviewTextModel(text2);
        this.myEditor = (EditorEx)FontEditorPreview.createPreviewEditor(this.myTextModel.getText(), this.mySchemeSupplier.get(), editable);
        this.myEditor.setBorder((Border)JBUI.Borders.empty());
        this.myEditor.setHighlighter(new PreviewHighlighter(this.myTextModel, this.myEditor.getDocument()));
        this.myEditor.getDocument().addDocumentListener(this.myTextModel);
        this.myTopPanel = new JPanel(new BorderLayout());
        this.myTopPanel.add((Component)this.myEditor.getComponent(), "Center");
        JLabel previewLabel = new JLabel(ApplicationBundle.message((String)"settings.editor.font.preview.hint", (Object[])new Object[0]));
        previewLabel.setFont((Font)JBUI.Fonts.smallFont());
        previewLabel.setForeground(UIUtil.getContextHelpForeground());
        previewLabel.setBorder((Border)JBUI.Borders.empty((int)10, (int)15, (int)10, (int)0));
        previewLabel.setBackground(this.myEditor.getBackgroundColor());
        this.myTopPanel.add((Component)previewLabel, "South");
        this.myTopPanel.setBackground(this.myEditor.getBackgroundColor());
        this.myTopPanel.setBorder(this.getBorder());
        this.registerActions(this.myEditor);
        FontEditorPreview.installTrafficLights(this.myEditor);
    }

    protected Border getBorder() {
        return JBUI.Borders.customLine((Color)JBColor.border());
    }

    private void registerActions(EditorEx editor) {
        editor.putUserData(TEXT_MODEL_KEY, this.myTextModel);
        AnAction restoreAction2 = ActionManager.getInstance().getAction("RestoreFontPreviewTextAction");
        AnAction toggleBoldFontAction = ActionManager.getInstance().getAction("fontEditorPreview.ToggleBoldFont");
        if (restoreAction2 != null || toggleBoldFontAction != null) {
            String originalGroupId = editor.getContextMenuGroupId();
            AnAction originalGroup = originalGroupId == null ? null : ActionManager.getInstance().getAction(originalGroupId);
            DefaultActionGroup group2 = new DefaultActionGroup();
            if (originalGroup instanceof ActionGroup) {
                group2.addAll(((ActionGroup)originalGroup).getChildren(null));
            }
            if (restoreAction2 != null) {
                group2.add(restoreAction2);
            }
            if (toggleBoldFontAction != null) {
                group2.add(toggleBoldFontAction);
                DumbAwareAction.create(event -> FontEditorPreview.toggleBoldFont(editor)).registerCustomShortcutSet(TOGGLE_BOLD_SHORTCUT, editor.getComponent());
            }
            editor.installPopupHandler(new ContextMenuPopupHandler.Simple((ActionGroup)group2));
        }
    }

    private static String getIDEDemoText() {
        return ApplicationNamesInfo.getInstance().getFullProductName() + " is an <bold>Integrated \nDevelopment Environment (IDE)</bold> designed\nto maximize productivity. It provides\n<bold>clever code completion, static code\nanalysis, and refactorings,</bold> and lets\nyou focus on the bright side of\nsoftware development making\nit an enjoyable experience.\n\nDefault:\nabcdefghijklmnopqrstuvwxyz\nABCDEFGHIJKLMNOPQRSTUVWXYZ\n 0123456789 (){}[]\n +-*/= .,;:!? #&$%@|^\n\n<bold>Bold:\nabcdefghijklmnopqrstuvwxyz\nABCDEFGHIJKLMNOPQRSTUVWXYZ\n 0123456789 (){}[]\n +-*/= .,;:!? #&$%@|^</bold>\n\n<!-- -- != := === >= >- >=> |-> -> <$>\n</> #[ |||> |= ~@\n\n";
    }

    static void installTrafficLights(@NotNull EditorEx editor) {
        if (editor == null) {
            FontEditorPreview.$$$reportNull$$$0(0);
        }
        EditorMarkupModel markupModel = (EditorMarkupModel)((Object)editor.getMarkupModel());
        markupModel.setErrorStripeRenderer(new DumbTrafficLightRenderer());
        markupModel.setErrorStripeVisible(true);
    }

    static Editor createPreviewEditor(String text2, EditorColorsScheme scheme2, boolean editable) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document editorDocument = editorFactory.createDocument((CharSequence)text2);
        FileDocumentManagerBase.registerDocument(editorDocument, (VirtualFile)new LightVirtualFile());
        EditorEx editor = (EditorEx)(editable ? editorFactory.createEditor(editorDocument) : editorFactory.createViewer(editorDocument));
        editor.setColorsScheme(scheme2);
        EditorSettings settings2 = editor.getSettings();
        settings2.setLineNumbersShown(false);
        settings2.setWhitespacesShown(true);
        settings2.setLineMarkerAreaShown(false);
        settings2.setIndentGuidesShown(false);
        settings2.setAdditionalColumnsCount(0);
        settings2.setAdditionalLinesCount(0);
        settings2.setRightMarginShown(true);
        settings2.setRightMargin(60);
        settings2.setGutterIconsShown(false);
        settings2.setIndentGuidesShown(false);
        ((EditorGutterComponentEx)editor.getGutter()).setPaintBackground(false);
        return editor;
    }

    @Override
    public JComponent getPanel() {
        return this.myTopPanel;
    }

    @Override
    public void updateView() {
        EditorColorsScheme scheme2 = this.updateOptionsScheme(this.mySchemeSupplier.get());
        this.myEditor.setColorsScheme(scheme2);
        this.myEditor.reinitSettings();
    }

    protected EditorColorsScheme updateOptionsScheme(EditorColorsScheme selectedScheme) {
        return selectedScheme;
    }

    @Override
    public void blinkSelectedHighlightType(Object description) {
    }

    @Override
    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        if (listener2 == null) {
            FontEditorPreview.$$$reportNull$$$0(1);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void disposeUIResources() {
        if (this.myTextModel.isDefault()) {
            PropertiesComponent.getInstance().unsetValue(PREVIEW_TEXT_KEY);
        } else {
            PropertiesComponent.getInstance().setValue(PREVIEW_TEXT_KEY, this.myTextModel.getRawText());
        }
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
    }

    private static void toggleBoldFont(@NotNull EditorEx editor) {
        PreviewTextModel textModel;
        if (editor == null) {
            FontEditorPreview.$$$reportNull$$$0(2);
        }
        if ((textModel = (PreviewTextModel)ObjectUtils.doIfNotNull((Object)editor, it -> (PreviewTextModel)it.getUserData(TEXT_MODEL_KEY))) != null) {
            SelectionModel selectionModel = editor.getSelectionModel();
            textModel.toggleBoldFont(TextRange.create((int)selectionModel.getSelectionStart(), (int)selectionModel.getSelectionEnd()));
            editor.reinitSettings();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/colors/FontEditorPreview";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "installTrafficLights";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "toggleBoldFont";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PreviewHighlighterIterator
    implements HighlighterIterator {
        private final PreviewTextModel myTextModel;
        private final Document myDocument;
        private static final TextAttributes PLAIN_ATTRIBUTES = new TextAttributes(null, null, null, null, 0);
        private static final TextAttributes BOLD_ATTRIBUTES = new TextAttributes(null, null, null, null, 1);
        private static final RangeHighlightingData EMPTY_RANGE_DATA = new RangeHighlightingData(0, 0, false);
        private int myCurrIndex;

        private PreviewHighlighterIterator(@NotNull PreviewTextModel model2, @NotNull Document document, int startOffset) {
            if (model2 == null) {
                PreviewHighlighterIterator.$$$reportNull$$$0(0);
            }
            if (document == null) {
                PreviewHighlighterIterator.$$$reportNull$$$0(1);
            }
            this.myTextModel = model2;
            this.myDocument = document;
            this.myCurrIndex = Math.max(this.myTextModel.getIndexAtOffset(startOffset), 0);
        }

        @NotNull
        private RangeHighlightingData getData() {
            RangeHighlightingData rangeHighlightingData = (RangeHighlightingData)ObjectUtils.notNull((Object)this.myTextModel.getRangeDataAt(this.myCurrIndex), (Object)EMPTY_RANGE_DATA);
            if (rangeHighlightingData == null) {
                PreviewHighlighterIterator.$$$reportNull$$$0(2);
            }
            return rangeHighlightingData;
        }

        public TextAttributes getTextAttributes() {
            return this.getData().isBold ? BOLD_ATTRIBUTES : PLAIN_ATTRIBUTES;
        }

        public int getStart() {
            return this.getData().textRange.getStartOffset();
        }

        public int getEnd() {
            return this.getData().textRange.getEndOffset();
        }

        public IElementType getTokenType() {
            return null;
        }

        public void advance() {
            if (this.myCurrIndex < this.myTextModel.getRangeCount() - 1) {
                ++this.myCurrIndex;
            }
        }

        public void retreat() {
            if (this.myCurrIndex > 0) {
                --this.myCurrIndex;
            }
        }

        public boolean atEnd() {
            return this.myCurrIndex >= this.myTextModel.getRangeCount() - 1;
        }

        public Document getDocument() {
            return this.myDocument;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/colors/FontEditorPreview$PreviewHighlighterIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/colors/FontEditorPreview$PreviewHighlighterIterator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PreviewHighlighter
    implements EditorHighlighter {
        private final PreviewTextModel myTextModelModel;
        private final Document myDocument;

        private PreviewHighlighter(@NotNull PreviewTextModel model2, @NotNull Document document) {
            if (model2 == null) {
                PreviewHighlighter.$$$reportNull$$$0(0);
            }
            if (document == null) {
                PreviewHighlighter.$$$reportNull$$$0(1);
            }
            this.myTextModelModel = model2;
            this.myDocument = document;
        }

        @NotNull
        public HighlighterIterator createIterator(int startOffset) {
            return new PreviewHighlighterIterator(this.myTextModelModel, this.myDocument, startOffset);
        }

        public void setEditor(@NotNull HighlighterClient editor) {
            if (editor == null) {
                PreviewHighlighter.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/application/options/colors/FontEditorPreview$PreviewHighlighter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setEditor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RangeHighlightingData {
        private TextRange textRange;
        private final boolean isBold;

        private RangeHighlightingData(int startOffset, int endOffset, boolean isBold) {
            this.textRange = TextRange.create((int)startOffset, (int)endOffset);
            this.isBold = isBold;
        }

        void updateRange(@NotNull TextRange newRange) {
            if (newRange == null) {
                RangeHighlightingData.$$$reportNull$$$0(0);
            }
            this.textRange = newRange;
        }

        public String toString() {
            return "RangeHighlightingData{textRange=" + this.textRange + ", isBold=" + this.isBold + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRange", "com/intellij/application/options/colors/FontEditorPreview$RangeHighlightingData", "updateRange"));
        }
    }

    private static class PreviewTextModel
    implements DocumentListener {
        private static final String BOLD_START_MARKER = "<bold>";
        private static final String BOLD_END_MARKER = "</bold>";
        private String myText;
        private final List<RangeHighlightingData> myRanges = new ArrayList<RangeHighlightingData>();

        private PreviewTextModel(String rawPreviewText) {
            this.extractMarkersAndText(rawPreviewText);
        }

        private void extractMarkersAndText(@NotNull String rawPreviewText) {
            if (rawPreviewText == null) {
                PreviewTextModel.$$$reportNull$$$0(0);
            }
            this.myRanges.clear();
            StringBuilder output2 = new StringBuilder();
            int shift = 0;
            int searchOffset = 0;
            while (searchOffset < rawPreviewText.length()) {
                int rawBoldStart = rawPreviewText.indexOf(BOLD_START_MARKER, searchOffset);
                if (rawBoldStart >= 0) {
                    output2.append(rawPreviewText, searchOffset, rawBoldStart);
                    int boldStart = rawBoldStart - shift;
                    this.myRanges.add(new RangeHighlightingData(searchOffset - shift, boldStart, false));
                    searchOffset = rawBoldStart + BOLD_START_MARKER.length();
                    shift += BOLD_START_MARKER.length();
                    int rawBoldEnd = rawPreviewText.indexOf(BOLD_END_MARKER, searchOffset);
                    if (rawBoldEnd < 0) {
                        rawBoldEnd = rawPreviewText.length();
                    }
                    output2.append(rawPreviewText, searchOffset, rawBoldEnd);
                    int boldEnd = rawBoldEnd - shift;
                    searchOffset = rawBoldEnd + BOLD_END_MARKER.length();
                    shift += BOLD_END_MARKER.length();
                    this.myRanges.add(new RangeHighlightingData(boldStart, boldEnd, true));
                    continue;
                }
                this.myRanges.add(new RangeHighlightingData(searchOffset - shift, rawPreviewText.length() - shift, false));
                output2.append(rawPreviewText, searchOffset, rawPreviewText.length());
                break;
            }
            this.myText = output2.toString();
        }

        String getText() {
            return this.myText;
        }

        String getRawText() {
            StringBuilder builder2 = new StringBuilder();
            for (RangeHighlightingData data2 : this.myRanges) {
                if (data2.isBold) {
                    builder2.append(BOLD_START_MARKER);
                }
                builder2.append(this.myText, data2.textRange.getStartOffset(), data2.textRange.getEndOffset());
                if (!data2.isBold) continue;
                builder2.append(BOLD_END_MARKER);
            }
            return builder2.toString();
        }

        int getRangeCount() {
            return this.myRanges.size();
        }

        @Nullable
        RangeHighlightingData getRangeDataAt(int index2) {
            return this.myRanges.isEmpty() ? null : this.myRanges.get(index2);
        }

        boolean isDefault() {
            return FontEditorPreview.getIDEDemoText().equals(this.getRawText());
        }

        void resetToDefault() {
            this.extractMarkersAndText(FontEditorPreview.getIDEDemoText());
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            String docText;
            if (event == null) {
                PreviewTextModel.$$$reportNull$$$0(1);
            }
            if (this.myText.equals(docText = event.getDocument().getText())) {
                return;
            }
            if (event.isWholeTextReplaced()) {
                this.myRanges.clear();
                this.myRanges.add(new RangeHighlightingData(0, docText.length(), false));
            } else {
                int offset = event.getOffset();
                if (event.getNewLength() >= event.getOldLength()) {
                    if (this.myRanges.isEmpty()) {
                        this.myRanges.add(new RangeHighlightingData(0, 0, false));
                    }
                    int insertedLen = event.getNewLength() - event.getOldLength();
                    for (RangeHighlightingData data2 : this.myRanges) {
                        if (data2.textRange.contains(offset) || data2 == this.myRanges.get(this.myRanges.size() - 1) && data2.textRange.getEndOffset() <= offset) {
                            data2.updateRange(data2.textRange.grown(insertedLen));
                            continue;
                        }
                        if (data2.textRange.getStartOffset() <= offset) continue;
                        data2.updateRange(data2.textRange.shiftRight(insertedLen));
                    }
                } else {
                    int deletedLen = event.getOldLength() - event.getNewLength();
                    TextRange deletedRange = new TextRange(offset, offset + deletedLen);
                    int delta = 0;
                    Iterator<RangeHighlightingData> rangeIterator = this.myRanges.iterator();
                    while (rangeIterator.hasNext()) {
                        int cutoutEnd;
                        RangeHighlightingData data3 = rangeIterator.next();
                        int cutoutStart = Math.max(deletedRange.getStartOffset(), data3.textRange.getStartOffset());
                        if (cutoutStart < (cutoutEnd = Math.min(deletedRange.getEndOffset(), data3.textRange.getEndOffset()))) {
                            int shrinkSize = cutoutEnd - cutoutStart;
                            if (shrinkSize == data3.textRange.getLength()) {
                                rangeIterator.remove();
                            } else {
                                data3.updateRange(data3.textRange.grown(-shrinkSize));
                            }
                            data3.updateRange(data3.textRange.shiftLeft(delta));
                            delta += shrinkSize;
                            continue;
                        }
                        data3.updateRange(data3.textRange.shiftLeft(delta));
                    }
                }
            }
            this.myText = docText;
        }

        int getIndexAtOffset(int offset) {
            for (int i2 = 0; i2 < this.myRanges.size(); ++i2) {
                if (!this.myRanges.get((int)i2).textRange.contains(offset)) continue;
                return i2;
            }
            return -1;
        }

        void toggleBoldFont(@NotNull TextRange toggleRange) {
            if (toggleRange == null) {
                PreviewTextModel.$$$reportNull$$$0(2);
            }
            ArrayList updatedRanges = new ArrayList();
            this.myRanges.forEach(data2 -> {
                int toggleEnd;
                int toggleStart = Math.max(toggleRange.getStartOffset(), data2.textRange.getStartOffset());
                if (toggleStart < (toggleEnd = Math.min(toggleRange.getEndOffset(), data2.textRange.getEndOffset()))) {
                    PreviewTextModel.glueRange(updatedRanges, TextRange.create((int)data2.textRange.getStartOffset(), (int)toggleStart), data2.isBold);
                    PreviewTextModel.glueRange(updatedRanges, TextRange.create((int)toggleStart, (int)toggleEnd), !data2.isBold);
                    PreviewTextModel.glueRange(updatedRanges, TextRange.create((int)toggleEnd, (int)data2.textRange.getEndOffset()), data2.isBold);
                } else {
                    PreviewTextModel.glueRange(updatedRanges, data2.textRange, data2.isBold);
                }
            });
            this.myRanges.clear();
            this.myRanges.addAll(updatedRanges);
        }

        private static void glueRange(@NotNull List<RangeHighlightingData> ranges, @NotNull TextRange range2, boolean isBold) {
            if (ranges == null) {
                PreviewTextModel.$$$reportNull$$$0(3);
            }
            if (range2 == null) {
                PreviewTextModel.$$$reportNull$$$0(4);
            }
            if (!range2.isEmpty()) {
                RangeHighlightingData lastRange;
                RangeHighlightingData rangeHighlightingData = lastRange = ranges.isEmpty() ? null : ranges.get(ranges.size() - 1);
                if (lastRange != null && lastRange.isBold == isBold) {
                    lastRange.updateRange(lastRange.textRange.grown(range2.getLength()));
                } else {
                    ranges.add(new RangeHighlightingData(range2.getStartOffset(), range2.getEndOffset(), isBold));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rawPreviewText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toggleRange";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ranges";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/application/options/colors/FontEditorPreview$PreviewTextModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extractMarkersAndText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toggleBoldFont";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "glueRange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ToggleBoldFontAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleBoldFontAction.$$$reportNull$$$0(0);
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            PreviewTextModel textModel = (PreviewTextModel)ObjectUtils.doIfNotNull((Object)editor, it -> (PreviewTextModel)it.getUserData(TEXT_MODEL_KEY));
            e.getPresentation().setEnabledAndVisible(textModel != null && editor.getSelectionModel().hasSelection());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Editor editor;
            if (e == null) {
                ToggleBoldFontAction.$$$reportNull$$$0(1);
            }
            if ((editor = (Editor)e.getData(CommonDataKeys.EDITOR)) != null) {
                FontEditorPreview.toggleBoldFont((EditorEx)editor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/application/options/colors/FontEditorPreview$ToggleBoldFontAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RestorePreviewTextAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RestorePreviewTextAction.$$$reportNull$$$0(0);
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            PreviewTextModel textModel = (PreviewTextModel)ObjectUtils.doIfNotNull((Object)editor, it -> (PreviewTextModel)it.getUserData(TEXT_MODEL_KEY));
            e.getPresentation().setEnabledAndVisible(editor != null && textModel != null && !textModel.isDefault());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PreviewTextModel textModel;
            Editor editor;
            if (e == null) {
                RestorePreviewTextAction.$$$reportNull$$$0(1);
            }
            if ((editor = (Editor)e.getData(CommonDataKeys.EDITOR)) != null && (textModel = (PreviewTextModel)editor.getUserData(TEXT_MODEL_KEY)) != null) {
                textModel.resetToDefault();
                WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), null, null, () -> {
                    editor.getDocument().setText((CharSequence)textModel.getText());
                    ((EditorEx)editor).reinitSettings();
                }, (PsiFile[])new PsiFile[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/application/options/colors/FontEditorPreview$RestorePreviewTextAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DumbTrafficLightRenderer
    implements ErrorStripeRenderer {
        private DumbTrafficLightRenderer() {
        }

        @NotNull
        public AnalyzerStatus getStatus() {
            return new AnalyzerStatus(AllIcons.General.InspectionsOK, "", "", () -> AnalyzerStatus.getEmptyController());
        }
    }
}

