/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CustomizableLanguageCodeStylePanel;
import com.intellij.application.options.codeStyle.SpeedSearchHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.ui.ClickListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionTreeWithPreviewPanel
extends CustomizableLanguageCodeStylePanel {
    private static final Logger LOG = Logger.getInstance(OptionTreeWithPreviewPanel.class);
    protected JTree myOptionsTree;
    protected final ArrayList<BooleanOptionKey> myKeys = new ArrayList();
    protected final JPanel myPanel = new JPanel(new GridBagLayout());
    private boolean myShowAllStandardOptions = false;
    private final Set<String> myAllowedOptions = new HashSet<String>();
    protected MultiMap<@Nls String, CustomBooleanOptionInfo> myCustomOptions = new MultiMap();
    protected boolean isFirstUpdate = true;
    private final Map<String, @NlsContexts.Label String> myRenamedFields = new HashMap<String, String>();
    private final Map<String, @NlsContexts.Label String> myRemappedGroups = new HashMap<String, String>();
    private SpeedSearchHelper mySearchHelper;

    public OptionTreeWithPreviewPanel(CodeStyleSettings settings2) {
        super(settings2);
    }

    @Override
    protected void init() {
        super.init();
        this.initTables();
        this.myOptionsTree = this.createOptionsTree();
        JBScrollPane scrollPane = new JBScrollPane(this.myOptionsTree){

            public Dimension getMinimumSize() {
                return super.getPreferredSize();
            }
        };
        this.myPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        JPanel previewPanel = OptionTreeWithPreviewPanel.createPreviewPanel();
        this.myPanel.add((Component)previewPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        this.installPreviewPanel(previewPanel);
        this.addPanelToWatch(this.myPanel);
        this.isFirstUpdate = false;
    }

    public void showAllStandardOptions() {
        this.myShowAllStandardOptions = true;
        this.updateOptions(true, new String[0]);
    }

    public void showStandardOptions(String ... optionNames) {
        if (this.isFirstUpdate) {
            Collections.addAll(this.myAllowedOptions, optionNames);
        }
        this.updateOptions(false, optionNames);
    }

    public void showCustomOption(@NotNull Class<? extends CustomCodeStyleSettings> settingsClass, @NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String title2, @Nls @Nullable String groupName, Object ... options2) {
        if (settingsClass == null) {
            OptionTreeWithPreviewPanel.$$$reportNull$$$0(0);
        }
        if (fieldName == null) {
            OptionTreeWithPreviewPanel.$$$reportNull$$$0(1);
        }
        if (title2 == null) {
            OptionTreeWithPreviewPanel.$$$reportNull$$$0(2);
        }
        this.showCustomOption(settingsClass, fieldName, title2, groupName, null, null, options2);
    }

    public void showCustomOption(@NotNull Class<? extends CustomCodeStyleSettings> settingsClass, @NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String title2, @Nls @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @NonNls @Nullable String anchorFieldName, Object ... options2) {
        if (settingsClass == null) {
            OptionTreeWithPreviewPanel.$$$reportNull$$$0(3);
        }
        if (fieldName == null) {
            OptionTreeWithPreviewPanel.$$$reportNull$$$0(4);
        }
        if (title2 == null) {
            OptionTreeWithPreviewPanel.$$$reportNull$$$0(5);
        }
        if (this.isFirstUpdate) {
            this.myCustomOptions.putValue((Object)groupName, (Object)new CustomBooleanOptionInfo(settingsClass, fieldName, title2, groupName, anchor2, anchorFieldName));
        }
        this.enableOption(fieldName);
    }

    public void renameStandardOption(@NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String newTitle) {
        if (fieldName == null) {
            OptionTreeWithPreviewPanel.$$$reportNull$$$0(6);
        }
        if (newTitle == null) {
            OptionTreeWithPreviewPanel.$$$reportNull$$$0(7);
        }
        if (this.isFirstUpdate) {
            this.myRenamedFields.put(fieldName, newTitle);
        }
    }

    protected void updateOptions(boolean showAllStandardOptions, String ... allowedOptions) {
        block0: for (BooleanOptionKey key : this.myKeys) {
            String fieldName = key.field.getName();
            if (key instanceof CustomBooleanOptionKey) {
                key.setEnabled(false);
                continue;
            }
            if (showAllStandardOptions) {
                key.setEnabled(true);
                continue;
            }
            key.setEnabled(false);
            for (String optionName : allowedOptions) {
                if (!fieldName.equals(optionName)) continue;
                key.setEnabled(true);
                continue block0;
            }
        }
    }

    protected void enableOption(String optionName) {
        for (BooleanOptionKey key : this.myKeys) {
            if (!key.field.getName().equals(optionName)) continue;
            key.setEnabled(true);
        }
    }

    protected JTree createOptionsTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        String groupName = "";
        DefaultMutableTreeNode groupNode = null;
        List<BooleanOptionKey> result2 = this.sortOptions(this.orderByGroup(this.myKeys));
        for (BooleanOptionKey key : result2) {
            String newGroupName = key.groupName;
            if (!newGroupName.equals(groupName) || groupNode == null) {
                groupName = newGroupName;
                groupNode = new DefaultMutableTreeNode(newGroupName);
                rootNode.add(groupNode);
            }
            if (!this.isOptionVisible(key)) continue;
            groupNode.add(new MyToggleTreeNode((Object)key, key.title));
        }
        DefaultTreeModel model2 = new DefaultTreeModel(rootNode);
        final Tree optionsTree = new Tree((TreeModel)model2);
        TreeSpeedSearch speedSearch2 = new TreeSpeedSearch(optionsTree, (Convertor<? super TreePath, String>)((Convertor)path2 -> {
            Object lastPathComponent = path2.getLastPathComponent();
            return lastPathComponent instanceof MyToggleTreeNode ? ((MyToggleTreeNode)lastPathComponent).getText() : lastPathComponent.toString();
        }), true);
        this.mySearchHelper = new SpeedSearchHelper(speedSearch2);
        speedSearch2.setComparator(new SpeedSearchComparator(false));
        TreeUtil.installActions((JTree)optionsTree);
        optionsTree.setRootVisible(false);
        optionsTree.setShowsRootHandles(true);
        optionsTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!optionsTree.isEnabled()) {
                    return;
                }
                if (e.getKeyCode() == 32) {
                    TreePath treePath = optionsTree.getLeadSelectionPath();
                    OptionTreeWithPreviewPanel.this.selectCheckbox(treePath);
                    e.consume();
                }
            }
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!optionsTree.isEnabled()) {
                    return false;
                }
                TreePath treePath = optionsTree.getPathForLocation(e.getX(), e.getY());
                OptionTreeWithPreviewPanel.this.selectCheckbox(treePath);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/codeStyle/OptionTreeWithPreviewPanel$3", "onClick"));
            }
        }.installOn((Component)optionsTree);
        for (int row2 = 0; row2 < optionsTree.getRowCount(); ++row2) {
            optionsTree.expandRow(row2);
        }
        optionsTree.setCellRenderer((TreeCellRenderer)new MyTreeCellRenderer(this.mySearchHelper));
        optionsTree.setBackground(UIUtil.getPanelBackground());
        optionsTree.setBorder((Border)JBUI.Borders.emptyRight((int)10));
        return optionsTree;
    }

    private List<BooleanOptionKey> orderByGroup(List<? extends BooleanOptionKey> options2) {
        List<String> groupOrder = this.getGroupOrder(options2);
        ArrayList<BooleanOptionKey> result2 = new ArrayList<BooleanOptionKey>(options2.size());
        result2.addAll(options2);
        result2.sort((key1, key2) -> {
            String group1 = key1.groupName;
            String group2 = key2.groupName;
            if (group1 == null) {
                return group2 == null ? 0 : 1;
            }
            if (group2 == null) {
                return -1;
            }
            int index1 = groupOrder.indexOf(group1);
            int index2 = groupOrder.indexOf(group2);
            if (index1 == -1 || index2 == -1) {
                return group1.compareToIgnoreCase(group2);
            }
            return Integer.compare(index1, index2);
        });
        return result2;
    }

    protected List<String> getGroupOrder(List<? extends BooleanOptionKey> options2) {
        ArrayList<String> groupOrder = new ArrayList<String>();
        for (BooleanOptionKey booleanOptionKey : options2) {
            if (booleanOptionKey.groupName == null || groupOrder.contains(booleanOptionKey.groupName)) continue;
            groupOrder.add(booleanOptionKey.groupName);
        }
        return groupOrder;
    }

    private void selectCheckbox(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        Object o = treePath.getLastPathComponent();
        if (o instanceof MyToggleTreeNode) {
            MyToggleTreeNode node = (MyToggleTreeNode)o;
            if (!node.isEnabled()) {
                return;
            }
            node.setSelected(!node.isSelected());
            int row2 = this.myOptionsTree.getRowForPath(treePath);
            this.myOptionsTree.repaint(this.myOptionsTree.getRowBounds(row2));
            this.somethingChanged();
        }
    }

    protected abstract void initTables();

    @Override
    protected void resetImpl(CodeStyleSettings settings2) {
        TreeModel treeModel = this.myOptionsTree.getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        this.resetNode(root, settings2);
        ((DefaultTreeModel)treeModel).nodeChanged(root);
    }

    private void resetNode(TreeNode node, CodeStyleSettings settings2) {
        if (node instanceof MyToggleTreeNode) {
            this.resetMyTreeNode((MyToggleTreeNode)node, settings2);
            return;
        }
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child2 = node.getChildAt(j);
            this.resetNode(child2, settings2);
        }
    }

    private void resetMyTreeNode(MyToggleTreeNode childNode, CodeStyleSettings settings2) {
        try {
            BooleanOptionKey key = (BooleanOptionKey)childNode.getKey();
            childNode.setSelected(key.getValue(settings2));
            childNode.setEnabled(key.isEnabled());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void apply(CodeStyleSettings settings2) {
        TreeModel treeModel = this.myOptionsTree.getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        OptionTreeWithPreviewPanel.applyNode(root, settings2);
    }

    private static void applyNode(TreeNode node, CodeStyleSettings settings2) {
        if (node instanceof MyToggleTreeNode) {
            OptionTreeWithPreviewPanel.applyToggleNode((MyToggleTreeNode)node, settings2);
            return;
        }
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child2 = node.getChildAt(j);
            OptionTreeWithPreviewPanel.applyNode(child2, settings2);
        }
    }

    private static void applyToggleNode(MyToggleTreeNode childNode, CodeStyleSettings settings2) {
        BooleanOptionKey key = (BooleanOptionKey)childNode.getKey();
        key.setValue(settings2, childNode.isSelected());
    }

    @Override
    public boolean isModified(CodeStyleSettings settings2) {
        TreeModel treeModel = this.myOptionsTree.getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        return OptionTreeWithPreviewPanel.isModified(root, settings2);
    }

    private static boolean isModified(TreeNode node, CodeStyleSettings settings2) {
        if (node instanceof MyToggleTreeNode && OptionTreeWithPreviewPanel.isToggleNodeModified((MyToggleTreeNode)node, settings2)) {
            return true;
        }
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child2 = node.getChildAt(j);
            if (!OptionTreeWithPreviewPanel.isModified(child2, settings2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isToggleNodeModified(MyToggleTreeNode childNode, CodeStyleSettings settings2) {
        try {
            BooleanOptionKey key = (BooleanOptionKey)childNode.getKey();
            return childNode.isSelected() != key.getValue(settings2);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    protected void initBooleanField(@NonNls String fieldName, @NlsContexts.Label String title2, @NlsContexts.Label String groupName) {
        if (this.myShowAllStandardOptions || this.myAllowedOptions.contains(fieldName)) {
            this.doInitBooleanField(fieldName, title2, groupName);
        }
    }

    private void doInitBooleanField(@NonNls String fieldName, @NlsContexts.Label String title2, @NlsContexts.Label String groupName) {
        try {
            Class<CommonCodeStyleSettings> styleSettingsClass = CommonCodeStyleSettings.class;
            Field field = styleSettingsClass.getField(fieldName);
            String actualGroupName = this.getRemappedGroup(fieldName, groupName);
            BooleanOptionKey key = new BooleanOptionKey(fieldName, this.getRenamedTitle(actualGroupName, actualGroupName), this.getRenamedTitle(fieldName, title2), field);
            this.myKeys.add(key);
        }
        catch (NoSuchFieldException | SecurityException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void initCustomOptions(@NlsContexts.Label String groupName) {
        for (CustomBooleanOptionInfo option2 : this.myCustomOptions.get((Object)groupName)) {
            try {
                Field field = option2.settingClass.getField(option2.fieldName);
                this.myKeys.add(new CustomBooleanOptionKey<CustomCodeStyleSettings>(option2.fieldName, this.getRenamedTitle(groupName, groupName), this.getRenamedTitle(option2.fieldName, option2.title), option2.anchor, option2.anchorFieldName, option2.settingClass, field));
            }
            catch (NoSuchFieldException | SecurityException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NlsContexts.Label
    private String getRenamedTitle(String fieldName, @NlsContexts.Label String defaultTitle) {
        String renamed = this.myRenamedFields.get(fieldName);
        return renamed == null ? defaultTitle : renamed;
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    public @NotNull Set<@NlsContexts.Label String> processListOptions() {
        HashSet<String> result2 = new HashSet<String>();
        for (BooleanOptionKey key : this.myKeys) {
            result2.add(key.title);
            if (key.groupName == null) continue;
            result2.add(key.groupName);
        }
        result2.addAll(this.myRenamedFields.values());
        for (String groupName : this.myCustomOptions.keySet()) {
            result2.add(groupName);
            for (CustomBooleanOptionInfo trinity : this.myCustomOptions.get((Object)groupName)) {
                result2.add(trinity.title);
            }
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            OptionTreeWithPreviewPanel.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    protected boolean shouldHideOptions() {
        return false;
    }

    private boolean isOptionVisible(BooleanOptionKey key) {
        if (!this.shouldHideOptions()) {
            return true;
        }
        if (this.myShowAllStandardOptions || this.myAllowedOptions.contains(key.getOptionName())) {
            return true;
        }
        for (CustomBooleanOptionInfo customOption : this.myCustomOptions.get((Object)key.groupName)) {
            if (!customOption.fieldName.equals(key.getOptionName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void moveStandardOption(@NonNls @NotNull String fieldName, @NotNull @NlsContexts.Label String newGroup) {
        if (fieldName == null) {
            OptionTreeWithPreviewPanel.$$$reportNull$$$0(9);
        }
        if (newGroup == null) {
            OptionTreeWithPreviewPanel.$$$reportNull$$$0(10);
        }
        this.myRemappedGroups.put(fieldName, newGroup);
    }

    @NlsContexts.Label
    private String getRemappedGroup(String fieldName, @NlsContexts.Label String defaultName) {
        return this.myRemappedGroups.getOrDefault(fieldName, defaultName);
    }

    @Override
    public void highlightOptions(@NotNull String searchString) {
        if (searchString == null) {
            OptionTreeWithPreviewPanel.$$$reportNull$$$0(11);
        }
        this.mySearchHelper.find(searchString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsClass";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTitle";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/OptionTreeWithPreviewPanel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newGroup";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/OptionTreeWithPreviewPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "processListOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showCustomOption";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "renameStandardOption";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moveStandardOption";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "highlightOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyToggleTreeNode
    extends DefaultMutableTreeNode {
        private final Object myKey;
        private final @NlsContexts.Label String myText;
        private boolean isSelected;
        private boolean isEnabled = true;

        MyToggleTreeNode(Object key, @NlsContexts.Label String text2) {
            this.myKey = key;
            this.myText = text2;
        }

        public Object getKey() {
            return this.myKey;
        }

        @NlsContexts.Label
        public String getText() {
            return this.myText;
        }

        public void setSelected(boolean val) {
            this.isSelected = val;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setEnabled(boolean val) {
            this.isEnabled = val;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }
    }

    private class CustomBooleanOptionKey<T extends CustomCodeStyleSettings>
    extends BooleanOptionKey {
        private final Class<T> mySettingsClass;

        CustomBooleanOptionKey(@NlsContexts.Label String fieldName, @NlsContexts.Label String groupName, String title2, CodeStyleSettingsCustomizable.OptionAnchor anchor2, String anchorFieldName, Class<T> settingsClass, Field field) {
            super(fieldName, groupName, title2, anchor2, anchorFieldName, field);
            this.mySettingsClass = settingsClass;
        }

        @Override
        public void setValue(CodeStyleSettings settings2, Boolean aBoolean) {
            CustomCodeStyleSettings customSettings = settings2.getCustomSettings(this.mySettingsClass);
            try {
                this.field.set(customSettings, aBoolean);
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        public boolean getValue(CodeStyleSettings settings2) throws IllegalAccessException {
            CustomCodeStyleSettings customSettings = settings2.getCustomSettings(this.mySettingsClass);
            return this.field.getBoolean(customSettings);
        }
    }

    private static final class CustomBooleanOptionInfo {
        @NotNull
        final Class<? extends CustomCodeStyleSettings> settingClass;
        @NotNull
        final String fieldName;
        @NotNull
        final @NlsContexts.Label String title;
        @Nullable
        final @NlsContexts.Label String groupName;
        @Nullable
        final CodeStyleSettingsCustomizable.OptionAnchor anchor;
        @Nullable
        final String anchorFieldName;

        private CustomBooleanOptionInfo(@NotNull Class<? extends CustomCodeStyleSettings> settingClass, @NotNull String fieldName, @NotNull @NlsContexts.Label String title2, @Nullable @NlsContexts.Label String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @Nullable String anchorFieldName) {
            if (settingClass == null) {
                CustomBooleanOptionInfo.$$$reportNull$$$0(0);
            }
            if (fieldName == null) {
                CustomBooleanOptionInfo.$$$reportNull$$$0(1);
            }
            if (title2 == null) {
                CustomBooleanOptionInfo.$$$reportNull$$$0(2);
            }
            this.settingClass = settingClass;
            this.fieldName = fieldName;
            this.title = title2;
            this.groupName = groupName;
            this.anchor = anchor2;
            this.anchorFieldName = anchorFieldName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settingClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fieldName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
            }
            objectArray[1] = "com/intellij/application/options/codeStyle/OptionTreeWithPreviewPanel$CustomBooleanOptionInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class BooleanOptionKey
    extends CustomizableLanguageCodeStylePanel.OrderedOption {
        final @NlsContexts.Label String groupName;
        @NlsContexts.Label String title;
        final Field field;
        private boolean enabled;

        BooleanOptionKey(@NlsContexts.Label String fieldName, @NlsContexts.Label String groupName, String title2, Field field) {
            this(fieldName, groupName, title2, null, null, field);
        }

        BooleanOptionKey(@NlsContexts.Label String fieldName, @NlsContexts.Label String groupName, @Nullable String title2, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, String anchorFiledName, Field field) {
            super(fieldName, anchor2, anchorFiledName);
            this.enabled = true;
            this.groupName = groupName;
            this.title = title2;
            this.field = field;
        }

        public void setValue(CodeStyleSettings settings2, Boolean aBoolean) {
            try {
                CommonCodeStyleSettings commonSettings = settings2.getCommonSettings(OptionTreeWithPreviewPanel.this.getDefaultLanguage());
                this.field.set(commonSettings, aBoolean);
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e);
            }
        }

        public boolean getValue(CodeStyleSettings settings2) throws IllegalAccessException {
            CommonCodeStyleSettings commonSettings = settings2.getCommonSettings(OptionTreeWithPreviewPanel.this.getDefaultLanguage());
            return this.field.getBoolean(commonSettings);
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    protected static class MyTreeCellRenderer
    implements TreeCellRenderer {
        private final SimpleColoredComponent myLabel;
        private final JCheckBox myCheckBox;
        private final JPanel myCheckBoxPanel;
        private final SpeedSearchHelper mySearchStringProvider;

        public MyTreeCellRenderer() {
            this(new SpeedSearchHelper());
        }

        public MyTreeCellRenderer(@NotNull SpeedSearchHelper searchStringProvider) {
            if (searchStringProvider == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(0);
            }
            this.myCheckBox = new JCheckBox();
            this.myCheckBox.setMargin((Insets)JBUI.emptyInsets());
            this.myLabel = new SimpleColoredComponent();
            this.myCheckBoxPanel = new JPanel();
            this.myCheckBoxPanel.setLayout(new FlowLayout(0, 0, 0));
            this.myCheckBoxPanel.add(this.myCheckBox);
            this.myCheckBoxPanel.add((Component)this.myLabel);
            this.mySearchStringProvider = searchStringProvider;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean isSelected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            Color background = RenderingUtil.getBackground((JTree)tree, (boolean)isSelected);
            Color foreground = RenderingUtil.getForeground((JTree)tree, (boolean)isSelected);
            if (value2 instanceof MyToggleTreeNode) {
                MyToggleTreeNode treeNode = (MyToggleTreeNode)value2;
                JCheckBox button4 = this.myCheckBox;
                button4.setSelected(treeNode.isSelected);
                button4.setForeground(foreground);
                button4.setBackground(background);
                button4.setVisible(true);
                button4.setEnabled(tree.isEnabled() && treeNode.isEnabled());
                this.mySearchStringProvider.setLabelText(this.myLabel, treeNode.getText(), 0, foreground, background);
            } else {
                this.myCheckBox.setVisible(false);
                this.mySearchStringProvider.setLabelText(this.myLabel, value2.toString(), 1, foreground, background);
                this.myLabel.setEnabled(tree.isEnabled());
            }
            this.myCheckBoxPanel.setForeground(foreground);
            this.myCheckBoxPanel.setBackground(background);
            this.myLabel.setOpaque(true);
            return this.myCheckBoxPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchStringProvider", "com/intellij/application/options/codeStyle/OptionTreeWithPreviewPanel$MyTreeCellRenderer", "<init>"));
        }
    }
}

