/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CodeStyleSchemesModelListener;
import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CodeStyleSchemesModel
implements SchemesModel<CodeStyleScheme> {
    private static final Logger LOG = Logger.getInstance(CodeStyleSchemesModel.class);
    private final List<CodeStyleScheme> mySchemes;
    private CodeStyleScheme mySelectedScheme;
    private final CodeStyleScheme myProjectScheme;
    private final CodeStyleScheme myDefault;
    private final Map<CodeStyleScheme, CodeStyleSettings> mySettingsToClone;
    private final EventDispatcher<CodeStyleSchemesModelListener> myDispatcher;
    private final Project myProject;
    private boolean myUiEventsEnabled;
    @NotNull
    private final OverridingStatus myOverridingStatus;

    public CodeStyleSchemesModel(@NotNull Project project) {
        if (project == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(0);
        }
        this.mySchemes = new ArrayList<CodeStyleScheme>();
        this.mySettingsToClone = new HashMap<CodeStyleScheme, CodeStyleSettings>();
        this.myDispatcher = EventDispatcher.create(CodeStyleSchemesModelListener.class);
        this.myUiEventsEnabled = true;
        this.myOverridingStatus = new OverridingStatus();
        this.myProject = project;
        this.myProjectScheme = new ProjectScheme(project);
        this.myDefault = CodeStyleSchemes.getInstance().getDefaultScheme();
        this.reset();
    }

    public void selectScheme(CodeStyleScheme selected2, @Nullable Object source) {
        if (this.mySelectedScheme != selected2) {
            this.mySelectedScheme = selected2;
            ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).currentSchemeChanged(source);
        }
    }

    public void addScheme(CodeStyleScheme newScheme, boolean changeSelection) {
        this.mySchemes.add(newScheme);
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        if (changeSelection) {
            this.selectScheme(newScheme, this);
        }
    }

    @Override
    public void removeScheme(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(1);
        }
        this.mySchemes.remove(scheme2);
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        if (this.mySelectedScheme == scheme2) {
            this.selectScheme(this.myDefault, this);
        }
    }

    @NotNull
    public CodeStyleSettings getCloneSettings(CodeStyleScheme scheme2) {
        if (!this.mySettingsToClone.containsKey(scheme2)) {
            this.mySettingsToClone.put(scheme2, ModelSettings.createFrom(scheme2.getCodeStyleSettings()));
        }
        CodeStyleSettings codeStyleSettings = this.mySettingsToClone.get(scheme2);
        if (codeStyleSettings == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(2);
        }
        return codeStyleSettings;
    }

    public CodeStyleScheme getSelectedScheme() {
        return this.mySelectedScheme;
    }

    public void addListener(CodeStyleSchemesModelListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public List<CodeStyleScheme> getSchemes() {
        return Collections.unmodifiableList(this.mySchemes);
    }

    public void reset() {
        this.mySchemes.clear();
        this.mySchemes.addAll(CodeStyleSchemesImpl.getSchemeManager().getAllSchemes());
        this.mySchemes.add(this.myProjectScheme);
        this.updateClonedSettings();
        CodeStyleSettingsManager projectSettings = CodeStyleSettingsManager.getInstance((Project)this.myProject);
        this.mySelectedScheme = projectSettings.USE_PER_PROJECT_SETTINGS ? this.myProjectScheme : CodeStyleSchemes.getInstance().findPreferredScheme(projectSettings.PREFERRED_PROJECT_CODE_STYLE);
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).currentSchemeChanged(this);
        this.updateOverridingStatus();
    }

    private void updateClonedSettings() {
        Iterator<CodeStyleScheme> schemeIterator = this.mySettingsToClone.keySet().iterator();
        while (schemeIterator.hasNext()) {
            CodeStyleScheme scheme2 = schemeIterator.next();
            if (this.mySchemes.contains(scheme2)) continue;
            schemeIterator.remove();
        }
        for (CodeStyleScheme scheme2 : this.mySchemes) {
            CodeStyleSettings current2 = scheme2.getCodeStyleSettings();
            CodeStyleSettings clonedSettings = this.getCloneSettings(scheme2);
            clonedSettings.copyFrom(current2);
        }
    }

    public boolean isUsePerProjectSettings() {
        return this.mySelectedScheme instanceof ProjectScheme;
    }

    public boolean isSchemeListModified() {
        CodeStyleSchemes schemes = CodeStyleSchemes.getInstance();
        CodeStyleSettingsManager projectSettings = CodeStyleSettingsManager.getInstance((Project)this.myProject);
        if (projectSettings.USE_PER_PROJECT_SETTINGS != this.isProjectScheme(this.mySelectedScheme)) {
            return true;
        }
        if (!this.isProjectScheme(this.mySelectedScheme) && this.getSelectedScheme() != schemes.findPreferredScheme(projectSettings.PREFERRED_PROJECT_CODE_STYLE)) {
            return true;
        }
        HashSet<CodeStyleScheme> configuredSchemesSet = new HashSet<CodeStyleScheme>(this.getIdeSchemes());
        return !configuredSchemesSet.equals(new HashSet<CodeStyleScheme>(CodeStyleSchemesImpl.getSchemeManager().getAllSchemes()));
    }

    public void apply() {
        this.commitClonedSettings();
        this.commitProjectSettings();
        CodeStyleSchemesImpl.getSchemeManager().setSchemes(this.getIdeSchemes(), this.mySelectedScheme instanceof ProjectScheme ? null : this.mySelectedScheme, null);
        this.updateOverridingStatus();
    }

    private void commitProjectSettings() {
        CodeStyleSettingsManager projectSettingsManager = CodeStyleSettingsManager.getInstance((Project)this.myProject);
        projectSettingsManager.USE_PER_PROJECT_SETTINGS = this.isProjectScheme(this.mySelectedScheme);
        projectSettingsManager.PREFERRED_PROJECT_CODE_STYLE = this.mySelectedScheme instanceof ProjectScheme ? null : this.mySelectedScheme.getName();
        CodeStyleSettings projectSettings = this.myProjectScheme.getCodeStyleSettings();
        projectSettings.getModificationTracker().incModificationCount();
        projectSettingsManager.setMainProjectCodeStyle(projectSettings);
    }

    private void commitClonedSettings() {
        for (CodeStyleScheme scheme2 : this.mySettingsToClone.keySet()) {
            if (scheme2 instanceof ProjectScheme) continue;
            CodeStyleSettings settings2 = scheme2.getCodeStyleSettings();
            settings2.copyFrom(this.mySettingsToClone.get(scheme2));
            settings2.getModificationTracker().incModificationCount();
        }
    }

    @NotNull
    private List<CodeStyleScheme> getIdeSchemes() {
        List list2 = ContainerUtil.filter(this.mySchemes, scheme2 -> !(scheme2 instanceof ProjectScheme));
        if (list2 == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public void fireBeforeCurrentSettingsChanged() {
        if (this.myUiEventsEnabled) {
            ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).beforeCurrentSettingsChanged();
        }
    }

    void updateScheme(CodeStyleScheme scheme2) {
        CodeStyleSettings clonedSettings = this.getCloneSettings(scheme2);
        clonedSettings.copyFrom(scheme2.getCodeStyleSettings());
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).schemeChanged(scheme2);
    }

    public void fireSchemeListChanged() {
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).schemeListChanged();
    }

    public void fireAfterCurrentSettingsChanged() {
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).afterCurrentSettingsChanged();
    }

    public void copyToProject(CodeStyleScheme selectedScheme) {
        this.myProjectScheme.getCodeStyleSettings().copyFrom(selectedScheme.getCodeStyleSettings());
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).schemeChanged(this.myProjectScheme);
        this.commitProjectSettings();
        this.selectScheme(this.myProjectScheme, this);
    }

    public CodeStyleScheme exportProjectScheme(@NotNull String name) {
        if (name == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(4);
        }
        CodeStyleScheme newScheme = this.createNewScheme(name, this.myProjectScheme);
        ((CodeStyleSchemeImpl)newScheme).setCodeStyleSettings(CodeStyleSettingsManager.getInstance().cloneSettings(this.getCloneSettings(this.myProjectScheme)));
        this.addScheme(newScheme, false);
        return newScheme;
    }

    public CodeStyleScheme createNewScheme(String preferredName, CodeStyleScheme parentScheme) {
        boolean isProjectScheme = this.isProjectScheme(parentScheme);
        return new CodeStyleSchemeImpl(SchemeNameGenerator.getUniqueName(preferredName, (Scheme)parentScheme, name -> this.containsScheme((String)name, isProjectScheme)), false, parentScheme);
    }

    @Nullable
    private CodeStyleScheme findSchemeByName(String name, boolean isProjectScheme) {
        for (CodeStyleScheme scheme2 : this.mySchemes) {
            if (isProjectScheme != this.isProjectScheme(scheme2) || !name.equals(scheme2.getName())) continue;
            return scheme2;
        }
        return null;
    }

    public CodeStyleScheme getProjectScheme() {
        return this.myProjectScheme;
    }

    @Override
    public boolean canDuplicateScheme(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(5);
        }
        return !this.isProjectScheme(scheme2);
    }

    @Override
    public boolean canResetScheme(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(6);
        }
        return scheme2.isDefault();
    }

    @Override
    public boolean canDeleteScheme(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(7);
        }
        return !this.isProjectScheme(scheme2) && !scheme2.isDefault();
    }

    @Override
    public boolean isProjectScheme(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(8);
        }
        return scheme2 instanceof ProjectScheme;
    }

    @Override
    public boolean canRenameScheme(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(9);
        }
        return this.canDeleteScheme(scheme2);
    }

    @Override
    public boolean containsScheme(@NotNull String name, boolean isProjectScheme) {
        if (name == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(10);
        }
        return this.findSchemeByName(name, isProjectScheme) != null;
    }

    @Override
    public boolean differsFromDefault(@NotNull CodeStyleScheme scheme2) {
        CodeStyleSettings clonedSettings;
        CodeStyleSettings defaults;
        if (scheme2 == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(11);
        }
        return !(defaults = CodeStyleSettings.getDefaults()).equals((Object)(clonedSettings = this.getCloneSettings(scheme2)));
    }

    public List<CodeStyleScheme> getAllSortedSchemes() {
        ArrayList<CodeStyleScheme> schemes = new ArrayList<CodeStyleScheme>(this.getSchemes());
        schemes.sort((s1, s2) -> {
            if (this.isProjectScheme((CodeStyleScheme)s1)) {
                return -1;
            }
            if (this.isProjectScheme((CodeStyleScheme)s2)) {
                return 1;
            }
            if (s1.isDefault()) {
                return -1;
            }
            if (s2.isDefault()) {
                return 1;
            }
            return s1.getName().compareToIgnoreCase(s2.getName());
        });
        return schemes;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void restoreDefaults(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(12);
        }
        if (this.canResetScheme(scheme2)) {
            CodeStyleSettings currSettings = this.getCloneSettings(scheme2);
            currSettings.copyFrom(CodeStyleSettings.getDefaults());
            this.fireModelSettingsChanged(currSettings);
        }
    }

    void fireModelSettingsChanged(@NotNull CodeStyleSettings currSettings) {
        if (currSettings == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(13);
        }
        this.myUiEventsEnabled = false;
        try {
            ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).settingsChanged(currSettings);
        }
        finally {
            this.myUiEventsEnabled = true;
        }
    }

    public boolean containsModifiedCodeStyleSettings() {
        for (CodeStyleScheme scheme2 : this.mySchemes) {
            CodeStyleSettings originalSettings = scheme2.getCodeStyleSettings();
            CodeStyleSettings currentSettings = this.mySettingsToClone.get(scheme2);
            if (currentSettings == null || originalSettings.equals((Object)currentSettings)) continue;
            return true;
        }
        return false;
    }

    public void updateOverridingStatus() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.myOverridingStatus.getLock().lock();
                List<CodeStyleSettingsModifier> modifiers = this.getOverridingModifiers();
                if (modifiers.size() > 0) {
                    this.myOverridingStatus.update(modifiers);
                } else {
                    this.myOverridingStatus.reset();
                }
            }
            finally {
                this.myOverridingStatus.getLock().unlock();
            }
            ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).overridingStatusChanged();
        });
    }

    @Nullable
    public OverridingStatus getOverridingStatus() {
        if (this.myOverridingStatus.getLock().tryLock()) {
            try {
                OverridingStatus overridingStatus = !this.myOverridingStatus.isEmpty() ? this.myOverridingStatus : null;
                return overridingStatus;
            }
            finally {
                this.myOverridingStatus.getLock().unlock();
            }
        }
        return null;
    }

    private List<CodeStyleSettingsModifier> getOverridingModifiers() {
        return ContainerUtil.filter((Collection)CodeStyleSettingsModifier.EP_NAME.getExtensionList(), modifier -> CodeStyleSchemesModel.safeGetOverridingStatus(modifier, this.getProject()));
    }

    private static boolean safeGetOverridingStatus(@NotNull CodeStyleSettingsModifier modifier, @NotNull Project project) {
        if (modifier == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(14);
        }
        if (project == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(15);
        }
        try {
            return modifier.mayOverrideSettingsOf(project);
        }
        catch (Throwable t) {
            LOG.error(t);
            return false;
        }
    }

    public void setUiEventsEnabled(boolean enabled) {
        this.myUiEventsEnabled = enabled;
    }

    public boolean isUiEventsEnabled() {
        return this.myUiEventsEnabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/CodeStyleSchemesModel";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currSettings";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/CodeStyleSchemesModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloneSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeSchemes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeScheme";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "exportProjectScheme";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canDuplicateScheme";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canResetScheme";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteScheme";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isProjectScheme";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canRenameScheme";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "containsScheme";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "differsFromDefault";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "restoreDefaults";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fireModelSettingsChanged";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "safeGetOverridingStatus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class OverridingStatus {
        private final Lock myLock = new ReentrantLock();
        private static final CodeStyleSettingsModifier[] EMPTY_MODIFIER_ARRAY = new CodeStyleSettingsModifier[0];
        @Nullable
        private List<CodeStyleSettingsModifier> myModifiers;

        @NotNull
        public Lock getLock() {
            Lock lock2 = this.myLock;
            if (lock2 == null) {
                OverridingStatus.$$$reportNull$$$0(0);
            }
            return lock2;
        }

        private void update(@NotNull List<CodeStyleSettingsModifier> modifiers) {
            if (modifiers == null) {
                OverridingStatus.$$$reportNull$$$0(1);
            }
            this.myModifiers = modifiers;
        }

        public CodeStyleSettingsModifier @NotNull [] getModifiers() {
            CodeStyleSettingsModifier[] codeStyleSettingsModifierArray = this.myModifiers != null && !this.myModifiers.isEmpty() ? this.myModifiers.toArray(new CodeStyleSettingsModifier[0]) : EMPTY_MODIFIER_ARRAY;
            if (codeStyleSettingsModifierArray == null) {
                OverridingStatus.$$$reportNull$$$0(2);
            }
            return codeStyleSettingsModifierArray;
        }

        private boolean isEmpty() {
            return this.myModifiers == null || this.myModifiers.isEmpty();
        }

        private void reset() {
            this.myModifiers = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/codeStyle/CodeStyleSchemesModel$OverridingStatus";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifiers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLock";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/codeStyle/CodeStyleSchemesModel$OverridingStatus";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModifiers";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ModelSettings
    extends CodeStyleSettings {
        private volatile boolean myLocked;

        public ModelSettings() {
            super(true, true);
        }

        public static ModelSettings createFrom(@NotNull CodeStyleSettings settings2) {
            if (settings2 == null) {
                ModelSettings.$$$reportNull$$$0(0);
            }
            ModelSettings modelSettings = new ModelSettings();
            modelSettings.copyFrom(settings2);
            return modelSettings;
        }

        public void doWithLockedSettings(@NotNull Runnable runnable2) {
            if (runnable2 == null) {
                ModelSettings.$$$reportNull$$$0(1);
            }
            this.myLocked = true;
            runnable2.run();
            this.myLocked = false;
        }

        public boolean isLocked() {
            return this.myLocked;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/application/options/codeStyle/CodeStyleSchemesModel$ModelSettings";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFrom";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doWithLockedSettings";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ProjectScheme
    extends CodeStyleSchemeImpl {
        ProjectScheme(@NotNull Project project) {
            if (project == null) {
                ProjectScheme.$$$reportNull$$$0(0);
            }
            super("Project", false, CodeStyleSchemes.getInstance().getDefaultScheme());
            CodeStyleSettings perProjectSettings = CodeStyleSettingsManager.getInstance((Project)project).getMainProjectCodeStyle();
            if (perProjectSettings != null) {
                this.setCodeStyleSettings(perProjectSettings);
            }
        }

        @Override
        @NotNull
        @Nls
        public String getDisplayName() {
            String string = ApplicationBundle.message((String)"code.style.scheme.project", (Object[])new Object[0]);
            if (string == null) {
                ProjectScheme.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/codeStyle/CodeStyleSchemesModel$ProjectScheme";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/codeStyle/CodeStyleSchemesModel$ProjectScheme";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

