/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CustomizableLanguageCodeStylePanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import com.intellij.ui.OptionGroup;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleBlankLinesPanel
extends CustomizableLanguageCodeStylePanel {
    private static final Logger LOG = Logger.getInstance(CodeStyleBlankLinesPanel.class);
    private final List<IntOption> myOptions = new ArrayList<IntOption>();
    private final Set<String> myAllowedOptions = new HashSet<String>();
    private boolean myAllOptionsAllowed = false;
    private boolean myIsFirstUpdate = true;
    private final Map<String, @NlsContexts.Label String> myRenamedFields = new HashMap<String, String>();
    private final MultiMap<String, IntOption> myCustomOptions = new MultiMap();
    private final JPanel myPanel = new JPanel(new GridBagLayout());

    public CodeStyleBlankLinesPanel(CodeStyleSettings settings2) {
        super(settings2);
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        Map settings2 = CodeStyleSettingPresentation.getStandardSettings((LanguageCodeStyleSettingsProvider.SettingsType)this.getSettingsType());
        OptionGroup keepBlankLinesOptionsGroup = this.createOptionsGroup(CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES_KEEP, (List)settings2.get(new CodeStyleSettingPresentation.SettingsGroup(CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES_KEEP)));
        OptionGroup blankLinesOptionsGroup = this.createOptionsGroup(CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, (List)settings2.get(new CodeStyleSettingPresentation.SettingsGroup(CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES)));
        if (keepBlankLinesOptionsGroup != null) {
            keepBlankLinesOptionsGroup.setAnchor(keepBlankLinesOptionsGroup.findAnchor());
            optionsPanel.add((Component)keepBlankLinesOptionsGroup.createPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        }
        if (blankLinesOptionsGroup != null) {
            blankLinesOptionsGroup.setAnchor(blankLinesOptionsGroup.findAnchor());
            optionsPanel.add((Component)blankLinesOptionsGroup.createPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        }
        UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{keepBlankLinesOptionsGroup, blankLinesOptionsGroup});
        optionsPanel.add((Component)new JPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 11, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        optionsPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        JScrollPane scroll = ScrollPaneFactory.createScrollPane((Component)optionsPanel, (boolean)true);
        scroll.setMinimumSize(new Dimension(optionsPanel.getPreferredSize().width + scroll.getVerticalScrollBar().getPreferredSize().width + 5, -1));
        scroll.setPreferredSize(scroll.getMinimumSize());
        this.myPanel.add((Component)scroll, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 11, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        JPanel previewPanel = CodeStyleBlankLinesPanel.createPreviewPanel();
        this.myPanel.add((Component)previewPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        this.installPreviewPanel(previewPanel);
        this.addPanelToWatch(this.myPanel);
        this.myIsFirstUpdate = false;
    }

    @Override
    public LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
        return LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS;
    }

    @Nullable
    private OptionGroup createOptionsGroup(@NotNull @NlsContexts.BorderTitle String groupName, @NotNull List<? extends CodeStyleSettingPresentation> settings2) {
        if (groupName == null) {
            CodeStyleBlankLinesPanel.$$$reportNull$$$0(0);
        }
        if (settings2 == null) {
            CodeStyleBlankLinesPanel.$$$reportNull$$$0(1);
        }
        OptionGroup optionGroup = new OptionGroup(groupName);
        SmartList groupOptions = new SmartList();
        for (CodeStyleSettingPresentation codeStyleSettingPresentation : settings2) {
            if (!this.myAllOptionsAllowed && !this.myAllowedOptions.contains(codeStyleSettingPresentation.getFieldName())) continue;
            groupOptions.add(new IntOption(this, codeStyleSettingPresentation.getUiName(), codeStyleSettingPresentation.getFieldName()));
        }
        groupOptions.addAll(this.myCustomOptions.get((Object)groupName));
        this.sortOptions(groupOptions).forEach(option2 -> this.addToOptionGroup(optionGroup, (IntOption)option2));
        this.myOptions.addAll((Collection<IntOption>)groupOptions);
        if (optionGroup.getComponents().length == 0) {
            return null;
        }
        return optionGroup;
    }

    private void addToOptionGroup(OptionGroup optionGroup, IntOption option2) {
        String label2 = this.myRenamedFields.getOrDefault(option2.getOptionName(), option2.myLabel);
        optionGroup.add((JComponent)new JBLabel(label2), (JComponent)option2.myIntField);
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings2) {
        for (IntOption option2 : this.myOptions) {
            option2.setValue(option2.getFieldValue(settings2));
        }
    }

    @Override
    public void apply(CodeStyleSettings settings2) throws ConfigurationException {
        for (IntOption option2 : this.myOptions) {
            option2.myIntField.validateContent();
        }
        for (IntOption option2 : this.myOptions) {
            option2.setFieldValue(settings2, option2.getValue());
        }
    }

    @Override
    public boolean isModified(CodeStyleSettings settings2) {
        for (IntOption option2 : this.myOptions) {
            if (option2.getFieldValue(settings2) == option2.getValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    public void showAllStandardOptions() {
        this.myAllOptionsAllowed = true;
        for (IntOption option2 : this.myOptions) {
            option2.myIntField.setEnabled(true);
        }
    }

    public void showStandardOptions(String ... optionNames) {
        if (this.myIsFirstUpdate) {
            Collections.addAll(this.myAllowedOptions, optionNames);
        }
        block0: for (IntOption option2 : this.myOptions) {
            option2.myIntField.setEnabled(false);
            for (String optionName : optionNames) {
                if (!option2.myTarget.getName().equals(optionName)) continue;
                option2.myIntField.setEnabled(true);
                continue block0;
            }
        }
    }

    public void showCustomOption(@NotNull Class<? extends CustomCodeStyleSettings> settingsClass, @NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String title2, @Nls @Nullable String groupName, Object ... options2) {
        if (settingsClass == null) {
            CodeStyleBlankLinesPanel.$$$reportNull$$$0(2);
        }
        if (fieldName == null) {
            CodeStyleBlankLinesPanel.$$$reportNull$$$0(3);
        }
        if (title2 == null) {
            CodeStyleBlankLinesPanel.$$$reportNull$$$0(4);
        }
        this.showCustomOption(settingsClass, fieldName, title2, groupName, null, null, options2);
    }

    public void showCustomOption(@NotNull Class<? extends CustomCodeStyleSettings> settingsClass, @NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String title2, @Nls @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @NonNls @Nullable String anchorFieldName, Object ... options2) {
        if (settingsClass == null) {
            CodeStyleBlankLinesPanel.$$$reportNull$$$0(5);
        }
        if (fieldName == null) {
            CodeStyleBlankLinesPanel.$$$reportNull$$$0(6);
        }
        if (title2 == null) {
            CodeStyleBlankLinesPanel.$$$reportNull$$$0(7);
        }
        if (this.myIsFirstUpdate) {
            this.myCustomOptions.putValue((Object)groupName, (Object)new IntOption(this, title2, settingsClass, fieldName, anchor2, anchorFieldName));
        }
        for (IntOption option2 : this.myOptions) {
            if (!option2.myTarget.getName().equals(fieldName)) continue;
            option2.myIntField.setEnabled(true);
        }
    }

    public void renameStandardOption(@NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String newTitle) {
        if (fieldName == null) {
            CodeStyleBlankLinesPanel.$$$reportNull$$$0(8);
        }
        if (newTitle == null) {
            CodeStyleBlankLinesPanel.$$$reportNull$$$0(9);
        }
        if (this.myIsFirstUpdate) {
            this.myRenamedFields.put(fieldName, newTitle);
        }
        for (IntOption option2 : this.myOptions) {
            option2.myIntField.invalidate();
        }
    }

    @Override
    @NlsContexts.TabTitle
    @NotNull
    protected String getTabTitle() {
        String string = ApplicationBundle.message((String)"title.blank.lines", (Object[])new Object[0]);
        if (string == null) {
            CodeStyleBlankLinesPanel.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsClass";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTitle";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/CodeStyleBlankLinesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/CodeStyleBlankLinesPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createOptionsGroup";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showCustomOption";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "renameStandardOption";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class IntOption
    extends CustomizableLanguageCodeStylePanel.OrderedOption {
        private final @NlsContexts.Label String myLabel;
        private final IntegerField myIntField;
        private final Field myTarget;
        private Class<? extends CustomCodeStyleSettings> myTargetClass;
        private int myCurrValue;
        final /* synthetic */ CodeStyleBlankLinesPanel this$0;

        private IntOption(@NlsContexts.Label @NotNull CodeStyleBlankLinesPanel codeStyleBlankLinesPanel, String label2, String fieldName) {
            if (label2 == null) {
                IntOption.$$$reportNull$$$0(0);
            }
            this(codeStyleBlankLinesPanel, label2, CommonCodeStyleSettings.class, fieldName, false);
        }

        private IntOption(@NlsContexts.Label @NotNull CodeStyleBlankLinesPanel codeStyleBlankLinesPanel, String label2, Class<? extends CustomCodeStyleSettings> targetClass, @Nullable String fieldName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, String anchorOptionName) {
            if (label2 == null) {
                IntOption.$$$reportNull$$$0(1);
            }
            this(codeStyleBlankLinesPanel, label2, targetClass, fieldName, false, anchor2, anchorOptionName);
            this.myTargetClass = targetClass;
        }

        private IntOption(@NlsContexts.Label @NotNull CodeStyleBlankLinesPanel codeStyleBlankLinesPanel, String label2, Class<?> fieldClass, String fieldName, boolean dummy) {
            if (label2 == null) {
                IntOption.$$$reportNull$$$0(2);
            }
            this(codeStyleBlankLinesPanel, label2, fieldClass, fieldName, dummy, null, null);
        }

        private IntOption(@NlsContexts.Label @NotNull CodeStyleBlankLinesPanel codeStyleBlankLinesPanel, String label2, Class<?> fieldClass, String fieldName, @Nullable boolean dummy, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, String anchorOptionName) {
            if (label2 == null) {
                IntOption.$$$reportNull$$$0(3);
            }
            this.this$0 = codeStyleBlankLinesPanel;
            super(fieldName, anchor2, anchorOptionName);
            this.myCurrValue = Integer.MAX_VALUE;
            this.myLabel = label2;
            try {
                this.myTarget = fieldClass.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            this.myIntField = new IntegerField(null, 0, 10);
            this.myIntField.setColumns(6);
            this.myIntField.setMinimumSize(new Dimension(30, this.myIntField.getMinimumSize().height));
        }

        private int getFieldValue(CodeStyleSettings settings2) {
            try {
                if (this.myTargetClass != null) {
                    return this.myTarget.getInt(settings2.getCustomSettings(this.myTargetClass));
                }
                CommonCodeStyleSettings commonSettings = settings2.getCommonSettings(this.this$0.getDefaultLanguage());
                return this.myTarget.getInt(commonSettings);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public void setFieldValue(CodeStyleSettings settings2, int value2) {
            try {
                if (this.myTargetClass != null) {
                    this.myTarget.setInt(settings2.getCustomSettings(this.myTargetClass), value2);
                } else {
                    CommonCodeStyleSettings commonSettings = settings2.getCommonSettings(this.this$0.getDefaultLanguage());
                    this.myTarget.setInt(commonSettings, value2);
                }
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e);
            }
        }

        private int getValue() {
            try {
                this.myCurrValue = Integer.parseInt(this.myIntField.getText());
                if (this.myCurrValue < 0) {
                    this.myCurrValue = 0;
                }
                if (this.myCurrValue > 10) {
                    this.myCurrValue = 10;
                }
            }
            catch (NumberFormatException e) {
                this.myCurrValue = 0;
            }
            return this.myCurrValue;
        }

        public void setValue(int fieldValue) {
            if (fieldValue != this.myCurrValue) {
                this.myCurrValue = fieldValue;
                this.myIntField.setText(String.valueOf(fieldValue));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/application/options/codeStyle/CodeStyleBlankLinesPanel$IntOption", "<init>"));
        }
    }
}

