/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.pipenv;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.packaging.pipenv.PyPipEnvPackageManagementService;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.sdk.PyInterpreterInspectionQuickFixData;
import com.jetbrains.python.sdk.PySdkProvider;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.add.PyAddNewEnvPanel;
import com.jetbrains.python.sdk.pipenv.PipEnvInstallQuickFix;
import com.jetbrains.python.sdk.pipenv.PipenvKt;
import com.jetbrains.python.sdk.pipenv.PyAddPipEnvPanel;
import com.jetbrains.python.sdk.pipenv.PyPipEnvSdkAdditionalData;
import com.jetbrains.python.sdk.pipenv.UsePipEnvQuickFix;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J<\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006!"}, d2={"Lcom/jetbrains/python/sdk/pipenv/PyPipEnvSdkProvider;", "Lcom/jetbrains/python/sdk/PySdkProvider;", "()V", "createEnvironmentAssociationFix", "Lcom/jetbrains/python/sdk/PyInterpreterInspectionQuickFixData;", "module", "Lcom/intellij/openapi/module/Module;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "isPyCharm", "", "associatedModulePath", "", "createInstallPackagesQuickFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "createNewEnvironmentPanel", "Lcom/jetbrains/python/sdk/add/PyAddNewEnvPanel;", "project", "Lcom/intellij/openapi/project/Project;", "existingSdks", "", "newProjectPath", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "getSdkAdditionalText", "getSdkIcon", "Ljavax/swing/Icon;", "loadAdditionalDataForSdk", "Lcom/intellij/openapi/projectRoots/SdkAdditionalData;", "element", "Lorg/jdom/Element;", "tryCreatePackageManagementServiceForSdk", "Lcom/jetbrains/python/packaging/ui/PyPackageManagementService;", "intellij.python.community.impl"})
public final class PyPipEnvSdkProvider
implements PySdkProvider {
    @Override
    @Nullable
    public String getSdkAdditionalText(@NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        return PipenvKt.isPipEnv(sdk) ? sdk.getVersionString() : null;
    }

    @Override
    @Nullable
    public Icon getSdkIcon(@NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        return PipenvKt.isPipEnv(sdk) ? PipenvKt.getPIPENV_ICON() : null;
    }

    @Override
    @Nullable
    public SdkAdditionalData loadAdditionalDataForSdk(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return PyPipEnvSdkAdditionalData.Companion.load(element);
    }

    @Override
    @Nullable
    public PyPackageManagementService tryCreatePackageManagementServiceForSdk(@NotNull Project project, @NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        return PipenvKt.isPipEnv(sdk) ? (PyPackageManagementService)new PyPipEnvPackageManagementService(project, sdk) : null;
    }

    @Override
    @Nullable
    public PyInterpreterInspectionQuickFixData createEnvironmentAssociationFix(@NotNull Module module, @NotNull Sdk sdk, boolean isPyCharm, @Nullable String associatedModulePath) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        if (PipenvKt.isPipEnv(sdk)) {
            String string = associatedModulePath != null ? (isPyCharm ? PyPsiBundle.message("INSP.interpreter.pipenv.interpreter.associated.with.another.project", associatedModulePath) : PyPsiBundle.message("INSP.interpreter.pipenv.interpreter.associated.with.another.module", associatedModulePath)) : (isPyCharm ? PyPsiBundle.message("INSP.interpreter.pipenv.interpreter.not.associated.with.any.project", new Object[0]) : PyPsiBundle.message("INSP.interpreter.pipenv.interpreter.not.associated.with.any.module", new Object[0]));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when {\n        associate\u2026odule\")\n        }\n      }");
            String message = string;
            return new PyInterpreterInspectionQuickFixData(new UsePipEnvQuickFix(sdk, module), message);
        }
        return null;
    }

    @Override
    @Nullable
    public LocalQuickFix createInstallPackagesQuickFix(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Sdk sdk = PythonSdkUtil.findPythonSdk(module);
        if (sdk == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"PythonSdkUtil.findPythonSdk(module) ?: return null");
        Sdk sdk2 = sdk;
        return PipenvKt.isPipEnv(sdk2) ? (LocalQuickFix)new PipEnvInstallQuickFix() : null;
    }

    @Override
    @NotNull
    public PyAddNewEnvPanel createNewEnvironmentPanel(@Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath, @NotNull UserDataHolder context) {
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new PyAddPipEnvPanel(null, null, existingSdks, newProjectPath, context);
    }
}

