/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkToInstall;
import com.jetbrains.python.sdk.PySdkToInstallOnWindows;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\b\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a,\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0007\u001a4\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getPy38ToInstallOnWindows", "Lcom/jetbrains/python/sdk/PySdkToInstallOnWindows;", "getPy39ToInstallOnWindows", "getSdksToInstall", "", "Lcom/jetbrains/python/sdk/PySdkToInstall;", "installSdkIfNeeded", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdk", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "intellij.python.community.impl"})
public final class PySdkToInstallKt {
    private static final Logger LOGGER;

    @NotNull
    public static final List<PySdkToInstall> getSdksToInstall() {
        return SystemInfo.isWindows ? CollectionsKt.listOf((Object[])new PySdkToInstallOnWindows[]{PySdkToInstallKt.getPy39ToInstallOnWindows(), PySdkToInstallKt.getPy38ToInstallOnWindows()}) : CollectionsKt.emptyList();
    }

    @RequiresEdt
    @Nullable
    public static final Sdk installSdkIfNeeded(@Nullable Sdk sdk, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks) {
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        Sdk sdk2 = sdk;
        boolean bl = false;
        boolean bl2 = false;
        Sdk it = sdk2;
        boolean bl3 = false;
        return it instanceof PySdkToInstall ? (Sdk)((PySdkToInstall)it).install(module, (Function0<? extends List<? extends PyDetectedSdk>>)((Function0)new Function0<List<? extends PyDetectedSdk>>(module, existingSdks){
            final /* synthetic */ Module $module$inlined;
            final /* synthetic */ List $existingSdks$inlined;
            {
                this.$module$inlined = module;
                this.$existingSdks$inlined = list;
                super(0);
            }

            @NotNull
            public final List<PyDetectedSdk> invoke() {
                return PySdkExtKt.detectSystemWideSdks$default(this.$module$inlined, this.$existingSdks$inlined, null, 4, null);
            }
        })) : it;
    }

    @RequiresEdt
    @Nullable
    public static final Sdk installSdkIfNeeded(@Nullable Sdk sdk, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @NotNull UserDataHolder context) {
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Sdk sdk2 = sdk;
        boolean bl = false;
        boolean bl2 = false;
        Sdk it = sdk2;
        boolean bl3 = false;
        return it instanceof PySdkToInstall ? (Sdk)((PySdkToInstall)it).install(module, (Function0<? extends List<? extends PyDetectedSdk>>)((Function0)new Function0<List<? extends PyDetectedSdk>>(module, existingSdks, context){
            final /* synthetic */ Module $module$inlined;
            final /* synthetic */ List $existingSdks$inlined;
            final /* synthetic */ UserDataHolder $context$inlined;
            {
                this.$module$inlined = module;
                this.$existingSdks$inlined = list;
                this.$context$inlined = userDataHolder;
                super(0);
            }

            @NotNull
            public final List<PyDetectedSdk> invoke() {
                return PySdkExtKt.detectSystemWideSdks(this.$module$inlined, this.$existingSdks$inlined, this.$context$inlined);
            }
        })) : it;
    }

    private static final PySdkToInstallOnWindows getPy39ToInstallOnWindows() {
        HashFunction hashFunction;
        String version = "3.9";
        String name = "Python " + version;
        HashFunction hashFunction2 = hashFunction = Hashing.md5();
        Intrinsics.checkNotNullExpressionValue((Object)hashFunction2, (String)"hashFunction");
        return new PySdkToInstallOnWindows(name, version, "https://www.python.org/ftp/python/3.9.5/python-3.9.5-amd64.exe", 0x1B100B0L, "53a354a15baed952ea9519a7f4d87c3f", hashFunction2, "python-3.9.5-amd64.exe");
    }

    private static final PySdkToInstallOnWindows getPy38ToInstallOnWindows() {
        HashFunction hashFunction;
        String version = "3.8";
        String name = "Python " + version;
        HashFunction hashFunction2 = hashFunction = Hashing.md5();
        Intrinsics.checkNotNullExpressionValue((Object)hashFunction2, (String)"hashFunction");
        return new PySdkToInstallOnWindows(name, version, "https://www.python.org/ftp/python/3.8.10/python-3.8.10-amd64.exe", 28296784L, "62cf1a12a5276b0259e8761d4cf4fe42", hashFunction2, "python-3.8.10-amd64.exe");
    }

    static {
        Logger logger = Logger.getInstance(PySdkToInstall.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(PySdkToInstall::class.java)");
        LOGGER = logger;
    }

    public static final /* synthetic */ Logger access$getLOGGER$p() {
        return LOGGER;
    }
}

