/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.introduce.constant;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import com.jetbrains.python.refactoring.introduce.IntroduceHandler;
import com.jetbrains.python.refactoring.introduce.IntroduceOperation;
import com.jetbrains.python.refactoring.introduce.constant.ConstantValidator;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class PyIntroduceConstantHandler
extends IntroduceHandler {
    public PyIntroduceConstantHandler() {
        super(new ConstantValidator(), PyBundle.message("refactoring.introduce.constant.dialog.title", new Object[0]));
    }

    @Override
    protected PsiElement replaceExpression(PsiElement expression, PyExpression newExpression, IntroduceOperation operation) {
        if (PsiTreeUtil.getParentOfType((PsiElement)expression, ScopeOwner.class) instanceof PyFile) {
            return super.replaceExpression(expression, newExpression, operation);
        }
        return PyReplaceExpressionUtil.replaceExpression(expression, (PsiElement)newExpression);
    }

    @Override
    protected PsiElement addDeclaration(@NotNull PsiElement expression, @NotNull PsiElement declaration, @NotNull IntroduceOperation operation) {
        if (expression == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(0);
        }
        if (declaration == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(1);
        }
        if (operation == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(2);
        }
        PsiFile anchor = expression.getContainingFile();
        assert (anchor instanceof PyFile);
        return anchor.addBefore(declaration, AddImportHelper.getFileInsertPosition((PyFile)anchor));
    }

    @Override
    protected Collection<String> generateSuggestedNames(@NotNull PyExpression expression) {
        if (expression == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(3);
        }
        HashSet<String> names2 = new HashSet<String>();
        for (String name : super.generateSuggestedNames(expression)) {
            names2.add(StringUtil.toUpperCase((String)name));
        }
        return names2;
    }

    @Override
    protected boolean isValidIntroduceContext(PsiElement element) {
        return super.isValidIntroduceContext(element) || PsiTreeUtil.getParentOfType((PsiElement)element, PyParameterList.class) != null;
    }

    @Override
    protected String getHelpId() {
        return "python.reference.introduceConstant";
    }

    @Override
    protected String getRefactoringId() {
        return "refactoring.python.introduce.constant";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/introduce/constant/PyIntroduceConstantHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addDeclaration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "generateSuggestedNames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

