/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.refactoring.PyDefUseUtil;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyInlineLocalHandler
extends InlineActionHandler {
    private static final Logger LOG = Logger.getInstance((String)PyInlineLocalHandler.class.getName());
    private static final Pair<PyStatement, Boolean> EMPTY_DEF_RESULT = Pair.create(null, (Object)false);
    private static final String HELP_ID = "refactoring.inlineVariable";

    public static PyInlineLocalHandler getInstance() {
        return (PyInlineLocalHandler)((Object)EP_NAME.findExtensionOrFail(PyInlineLocalHandler.class));
    }

    public boolean isEnabledForLanguage(Language l) {
        return l instanceof PythonLanguage;
    }

    public boolean canInlineElement(PsiElement element) {
        return element instanceof PyTargetExpression;
    }

    public void inlineElement(Project project, Editor editor2, PsiElement element) {
        PsiElement refElement;
        if (editor2 == null) {
            return;
        }
        PsiReference psiReference = TargetElementUtil.findReference((Editor)editor2);
        PyReferenceExpression refExpr = null;
        if (psiReference != null && (refElement = psiReference.getElement()) instanceof PyReferenceExpression) {
            refExpr = (PyReferenceExpression)refElement;
        }
        PyInlineLocalHandler.invoke(project, editor2, (PyTargetExpression)element, refExpr);
    }

    private static void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PyTargetExpression local, @Nullable PyReferenceExpression refExpr) {
        if (project == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(1);
        }
        if (local == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(2);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)local)) {
            return;
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        String localName = local.getName();
        ScopeOwner containerBlock = PyInlineLocalHandler.getContext(local);
        LOG.assertTrue(containerBlock != null);
        Pair<PyStatement, Boolean> defPair = PyInlineLocalHandler.getAssignmentToInline(containerBlock, refExpr, local, project);
        PyStatement def = (PyStatement)defPair.first;
        if (def == null || PyInlineLocalHandler.getValue(def) == null) {
            String key = (Boolean)defPair.second != false ? "variable.has.no.dominating.definition" : "variable.has.no.initializer";
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)key, (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)message, (String)PyInlineLocalHandler.getRefactoringName(), (String)HELP_ID);
            return;
        }
        if (def instanceof PyAssignmentStatement && ((PyAssignmentStatement)def).getTargets().length > 1) {
            highlightManager.addOccurrenceHighlights(editor2, new PsiElement[]{def}, EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES, true, null);
            String message = RefactoringBundle.getCannotRefactorMessage((String)PyBundle.message("refactoring.inline.local.multiassignment", localName));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)message, (String)PyInlineLocalHandler.getRefactoringName(), (String)HELP_ID);
            return;
        }
        PsiElement[] refsToInline = PyDefUseUtil.getPostRefs(containerBlock, local, PyInlineLocalHandler.getObject(def));
        if (refsToInline.length == 0) {
            String message = RefactoringBundle.message((String)"variable.is.never.used", (Object[])new Object[]{localName});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)message, (String)PyInlineLocalHandler.getRefactoringName(), (String)HELP_ID);
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            highlightManager.addOccurrenceHighlights(editor2, refsToInline, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
            int occurrencesCount = refsToInline.length;
            String occurrencesString = RefactoringBundle.message((String)"occurrences.string", (Object[])new Object[]{occurrencesCount});
            String question = RefactoringBundle.message((String)"inline.local.variable.prompt", (Object[])new Object[]{localName}) + " " + occurrencesString;
            RefactoringMessageDialog dialog2 = new RefactoringMessageDialog(PyInlineLocalHandler.getRefactoringName(), question, HELP_ID, "OptionPane.questionIcon", true, project);
            if (!dialog2.showAndGet()) {
                WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                return;
            }
        }
        PsiFile workingFile = local.getContainingFile();
        for (PsiElement ref : refsToInline) {
            PsiFile otherFile = ref.getContainingFile();
            if (otherFile.equals(workingFile)) continue;
            String message = RefactoringBundle.message((String)"variable.is.referenced.in.multiple.files", (Object[])new Object[]{localName});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)message, (String)PyInlineLocalHandler.getRefactoringName(), (String)HELP_ID);
            return;
        }
        for (PsiElement ref : refsToInline) {
            ArrayList<PsiElement> elems = new ArrayList<PsiElement>();
            List<Instruction> latestDefs = PyDefUseUtil.getLatestDefs(containerBlock, local.getName(), ref, false, false);
            for (Instruction i : latestDefs) {
                elems.add(i.getElement());
            }
            PsiElement[] defs = elems.toArray(PsiElement.EMPTY_ARRAY);
            boolean isSameDefinition = true;
            for (PsiElement otherDef : defs) {
                isSameDefinition &= PyInlineLocalHandler.isSameDefinition(def, otherDef);
            }
            if (isSameDefinition) continue;
            highlightManager.addOccurrenceHighlights(editor2, defs, EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES, true, null);
            highlightManager.addOccurrenceHighlights(editor2, new PsiElement[]{ref}, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.accessed.for.writing.and.used.with.inlined", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)message, (String)PyInlineLocalHandler.getRefactoringName(), (String)HELP_ID);
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            RefactoringEventData afterData;
            try {
                PsiElement parent;
                afterData = new RefactoringEventData();
                afterData.addElement((PsiElement)local);
                ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(PyInlineLocalHandler.getRefactoringId(), afterData);
                Object[] exprs = new PsiElement[refsToInline.length];
                PyExpression value = PyInlineLocalHandler.prepareValue(def, localName, project);
                LanguageLevel level = LanguageLevel.forElement((PsiElement)value);
                PyExpression withParenthesis = PyElementGenerator.getInstance(project).createExpressionFromText(level, "(" + value.getText() + ")");
                PsiElement lastChild = def.getLastChild();
                if (lastChild != null && lastChild.getNode().getElementType() == PyTokenTypes.END_OF_LINE_COMMENT && (parent = def.getParent()) != null) {
                    parent.addBefore(lastChild, (PsiElement)def);
                }
                for (PsiElement element2 : refsToInline) {
                    exprs[i] = PyReplaceExpressionUtil.isNeedParenthesis((PyExpression)element2, value) ? element2.replace((PsiElement)withParenthesis) : element2.replace((PsiElement)value);
                }
                PsiElement next = def.getNextSibling();
                if (next instanceof PsiWhiteSpace) {
                    PyPsiUtils.removeElements(next);
                }
                PyPsiUtils.removeElements(new PsiElement[]{def});
                List ranges = ContainerUtil.mapNotNull((Object[])exprs, element -> {
                    PyStatement parentalStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyStatement.class, (boolean)false);
                    return parentalStatement != null ? parentalStatement.getTextRange() : null;
                });
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor2.getDocument());
                CodeStyleManager.getInstance((Project)project).reformatText(workingFile, (Collection)ranges);
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    highlightManager.addOccurrenceHighlights(editor2, (PsiElement[])exprs, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
                    WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                }
            }
            finally {
                afterData = new RefactoringEventData();
                afterData.addElement((PsiElement)local);
                ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(PyInlineLocalHandler.getRefactoringId(), afterData);
            }
        }), RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{localName}), null);
    }

    private static boolean isSameDefinition(PyStatement def, PsiElement otherDef) {
        if (otherDef instanceof PyTargetExpression) {
            otherDef = otherDef.getParent();
        }
        return otherDef == def;
    }

    private static ScopeOwner getContext(PyTargetExpression local) {
        ScopeOwner context = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)local, PyFunction.class);
        if (context == null) {
            context = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)local, PyClass.class);
        }
        if (context == null) {
            context = (PyFile)local.getContainingFile();
        }
        return context;
    }

    private static Pair<PyStatement, Boolean> getAssignmentToInline(ScopeOwner containerBlock, PyReferenceExpression expr, PyTargetExpression local, Project project) {
        Query query;
        PsiReference first;
        if (expr != null) {
            try {
                List<Instruction> candidates = PyDefUseUtil.getLatestDefs(containerBlock, local.getName(), (PsiElement)expr, true, true);
                if (candidates.size() == 1) {
                    PyStatement expression = PyInlineLocalHandler.getAssignmentByLeftPart((PyElement)candidates.get(0).getElement());
                    return Pair.create((Object)expression, (Object)false);
                }
                return Pair.create(null, (Object)(candidates.size() > 0 ? 1 : 0));
            }
            catch (PyDefUseUtil.InstructionNotFoundException candidates) {
                // empty catch block
            }
        }
        PyElement lValue = (first = (PsiReference)(query = ReferencesSearch.search((PsiElement)local, (SearchScope)GlobalSearchScope.allScope((Project)project), (boolean)false)).findFirst()) != null ? (PyElement)first.resolve() : null;
        return lValue != null ? Pair.create((Object)PyInlineLocalHandler.getAssignmentByLeftPart(lValue), (Object)false) : EMPTY_DEF_RESULT;
    }

    @Nullable
    private static PyStatement getAssignmentByLeftPart(PyElement candidate) {
        PsiElement parent = candidate.getParent();
        return parent instanceof PyAssignmentStatement || parent instanceof PyAugAssignmentStatement ? (PyStatement)parent : null;
    }

    @Nullable
    private static PyExpression getValue(@Nullable PyStatement def) {
        if (def == null) {
            return null;
        }
        if (def instanceof PyAssignmentStatement) {
            return ((PyAssignmentStatement)def).getAssignedValue();
        }
        return ((PyAugAssignmentStatement)def).getValue();
    }

    @Nullable
    private static PyExpression getObject(@Nullable PyStatement def) {
        if (def == null) {
            return null;
        }
        if (def instanceof PyAssignmentStatement) {
            return ((PyAssignmentStatement)def).getTargets()[0];
        }
        return ((PyAugAssignmentStatement)def).getTarget();
    }

    @NotNull
    private static PyExpression prepareValue(@NotNull PyStatement def, @NotNull String localName, @NotNull Project project) {
        if (def == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(3);
        }
        if (localName == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(4);
        }
        if (project == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(5);
        }
        PyExpression value = PyInlineLocalHandler.getValue(def);
        assert (value != null);
        if (def instanceof PyAugAssignmentStatement) {
            PyAugAssignmentStatement expression = (PyAugAssignmentStatement)def;
            PsiElement operation = expression.getOperation();
            assert (operation != null);
            String op = operation.getText().replace('=', ' ');
            LanguageLevel level = LanguageLevel.forElement((PsiElement)value);
            PyExpression pyExpression = PyElementGenerator.getInstance(project).createExpressionFromText(level, localName + " " + op + value.getText() + ")");
            if (pyExpression == null) {
                PyInlineLocalHandler.$$$reportNull$$$0(6);
            }
            return pyExpression;
        }
        PyExpression pyExpression = value;
        if (pyExpression == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(7);
        }
        return pyExpression;
    }

    public static String getRefactoringId() {
        return "refactoring.python.inline.local";
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    private static String getRefactoringName() {
        return RefactoringBundle.message((String)"inline.variable.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/inline/PyInlineLocalHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/inline/PyInlineLocalHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepareValue";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

