/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.intellij.navigation.NavigationItem;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.classes.membersManager.FieldsManager;
import com.jetbrains.python.refactoring.classes.membersManager.NamePredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ClassFieldsManager
extends FieldsManager {
    ClassFieldsManager() {
        super(true);
    }

    @Override
    public boolean hasConflict(@NotNull PyTargetExpression member, @NotNull PyClass aClass) {
        if (member == null) {
            ClassFieldsManager.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            ClassFieldsManager.$$$reportNull$$$0(1);
        }
        return NamePredicate.hasElementWithSameName((NavigationItem)member, aClass.getClassAttributes());
    }

    @Override
    protected Collection<PyElement> moveAssignments(@NotNull PyClass from, @NotNull Collection<PyAssignmentStatement> statements, PyClass ... to) {
        if (from == null) {
            ClassFieldsManager.$$$reportNull$$$0(2);
        }
        if (statements == null) {
            ClassFieldsManager.$$$reportNull$$$0(3);
        }
        if (to == null) {
            ClassFieldsManager.$$$reportNull$$$0(4);
        }
        return ClassFieldsManager.moveAssignmentsImpl(from, statements, to);
    }

    static Collection<PyElement> moveAssignmentsImpl(@NotNull PyClass from, @NotNull Collection<? extends PyAssignmentStatement> statements, PyClass ... to) {
        if (from == null) {
            ClassFieldsManager.$$$reportNull$$$0(5);
        }
        if (statements == null) {
            ClassFieldsManager.$$$reportNull$$$0(6);
        }
        if (to == null) {
            ClassFieldsManager.$$$reportNull$$$0(7);
        }
        ArrayList<PyElement> result = new ArrayList<PyElement>();
        for (PyClass destClass : to) {
            result.addAll(PyClassRefactoringUtil.copyFieldDeclarationToStatement(statements, destClass.getStatementList(), destClass));
        }
        ClassFieldsManager.deleteElements(statements);
        return result;
    }

    @Override
    protected boolean classHasField(@NotNull PyClass pyClass, @NotNull String fieldName) {
        if (pyClass == null) {
            ClassFieldsManager.$$$reportNull$$$0(8);
        }
        if (fieldName == null) {
            ClassFieldsManager.$$$reportNull$$$0(9);
        }
        return pyClass.findClassAttribute(fieldName, true, null) != null;
    }

    @NotNull
    protected List<PyTargetExpression> getFieldsByClass(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            ClassFieldsManager.$$$reportNull$$$0(10);
        }
        ImmutableList immutableList = FluentIterable.from(pyClass.getClassAttributes()).filter((Predicate)new NoMetaAndProperties(pyClass)).toList();
        if (immutableList == null) {
            ClassFieldsManager.$$$reportNull$$$0(11);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/membersManager/ClassFieldsManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/membersManager/ClassFieldsManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsByClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasConflict";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "moveAssignments";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "moveAssignmentsImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "classHasField";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsByClass";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class NoMetaAndProperties
    extends NotNullPredicate<PyTargetExpression> {
        @NotNull
        private final PyClass myClass;

        private NoMetaAndProperties(@NotNull PyClass aClass) {
            if (aClass == null) {
                NoMetaAndProperties.$$$reportNull$$$0(0);
            }
            this.myClass = aClass;
        }

        @Override
        public boolean applyNotNull(@NotNull PyTargetExpression input) {
            PyExpression callee;
            String name;
            if (input == null) {
                NoMetaAndProperties.$$$reportNull$$$0(1);
            }
            if ((name = input.getName()) == null) {
                return false;
            }
            if (name.equals("__metaclass__")) {
                return false;
            }
            PyExpression assignedValue = input.findAssignedValue();
            return !(assignedValue instanceof PyCallExpression) || (callee = ((PyCallExpression)assignedValue).getCallee()) == null || !"property".equals(callee.getName()) || this.myClass.findProperty(name, false, null) == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/refactoring/classes/membersManager/ClassFieldsManager$NoMetaAndProperties";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

